/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.cache.index.AbstractIndexingCommonTest;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.logger.NullLogger;
import org.apache.ignite.testframework.GridTestUtils;
import org.junit.Test;

public class MemLeakOnSqlWithClientReconnectTest
extends AbstractIndexingCommonTest {
    private static final int KEY_CNT = 10;
    private static final int ITERS = 2000;
    private static final String REPL_SCHEMA = "REPL";
    private static final String PART_SCHEMA = "PART";

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        if (igniteInstanceName.startsWith("cli")) {
            cfg.setClientMode(true).setGridLogger((IgniteLogger)new NullLogger());
        }
        return cfg;
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.startGrid();
        IgniteCache partCache = this.grid().createCache(new CacheConfiguration().setName("part").setSqlSchema(PART_SCHEMA).setQueryEntities(Collections.singleton(new QueryEntity(Long.class, Long.class).setTableName("test").addQueryField("id", Long.class.getName(), null).addQueryField("val", Long.class.getName(), null).setKeyFieldName("id").setValueFieldName("val"))).setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 10)));
        IgniteCache replCache = this.grid().createCache(new CacheConfiguration().setName("repl").setSqlSchema(REPL_SCHEMA).setQueryEntities(Collections.singleton(new QueryEntity(Long.class, Long.class).setTableName("test").addQueryField("id", Long.class.getName(), null).addQueryField("val", Long.class.getName(), null).setKeyFieldName("id").setValueFieldName("val"))).setCacheMode(CacheMode.REPLICATED));
        for (long i = 0L; i < 10L; ++i) {
            partCache.put((Object)i, (Object)i);
            replCache.put((Object)i, (Object)i);
        }
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
        super.afterTest();
    }

    @Test
    public void testPartitioned() throws Exception {
        this.checkReservationLeak(false);
    }

    @Test
    public void testReplicated() throws Exception {
        this.checkReservationLeak(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkReservationLeak(boolean replicated) throws Exception {
        AtomicInteger cliNum = new AtomicInteger();
        AtomicBoolean end = new AtomicBoolean();
        IgniteInternalFuture fut = GridTestUtils.runMultiThreadedAsync(() -> {
            String name = "cli_" + cliNum.getAndIncrement();
            while (!end.get()) {
                try {
                    this.startGrid(name);
                    U.sleep((long)10L);
                    this.stopGrid(name);
                }
                catch (Exception e) {
                    MemLeakOnSqlWithClientReconnectTest.fail((String)"Unexpected exception on start test client node");
                }
            }
        }, (int)10, (String)"cli-restart");
        try {
            String mainCliName = "cli-main";
            IgniteEx cli = this.startGrid(mainCliName);
            this.runQuery(cli, 2000, replicated);
            int baseReservations = MemLeakOnSqlWithClientReconnectTest.reservationCount(this.grid());
            this.runQuery(cli, 20000, replicated);
            int curReservations = MemLeakOnSqlWithClientReconnectTest.reservationCount(this.grid());
            MemLeakOnSqlWithClientReconnectTest.assertTrue((String)("Reservations leaks: [base=" + baseReservations + ", cur=" + curReservations + ']'), (curReservations < baseReservations * 2 ? 1 : 0) != 0);
            log.info("Reservations OK: [base=" + baseReservations + ", cur=" + curReservations + ']');
        }
        finally {
            end.set(true);
        }
        fut.get();
    }

    private void runQuery(IgniteEx ign, int iters, boolean repl) {
        for (int i = 0; i < iters; ++i) {
            this.sql(ign, repl ? REPL_SCHEMA : PART_SCHEMA, "SELECT * FROM test", new Object[0]).getAll();
        }
    }

    private FieldsQueryCursor<List<?>> sql(IgniteEx ign, String schema, String sql, Object ... args) {
        return ign.context().query().querySqlFields(new SqlFieldsQuery(sql).setSchema(schema).setArgs(args), false);
    }

    private static int reservationCount(IgniteEx ign) {
        IgniteH2Indexing idx = (IgniteH2Indexing)ign.context().query().getIndexing();
        Map reservations = (Map)GridTestUtils.getFieldValue((Object)idx.partitionReservationManager(), (String[])new String[]{"reservations"});
        return reservations.size();
    }
}

