/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.QueryRetryException;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.failure.FailureHandler;
import org.apache.ignite.failure.StopNodeFailureHandler;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.index.AbstractIndexingCommonTest;
import org.apache.ignite.testframework.GridTestUtils;
import org.gridgain.internal.h2.result.LazyResult;
import org.gridgain.internal.h2.result.ResultInterface;
import org.junit.Test;

public class LocalQueryLazyTest
extends AbstractIndexingCommonTest {
    private static final int KEY_CNT = 10;
    private static final int QRY_CNT = 10;

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        return super.getConfiguration(igniteInstanceName).setFailureHandler((FailureHandler)new StopNodeFailureHandler());
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.startGrid();
        IgniteCache c = this.grid().createCache(new CacheConfiguration().setName("test").setSqlSchema("TEST").setQueryEntities(Collections.singleton(new QueryEntity(Long.class, Long.class).setTableName("test").addQueryField("id", Long.class.getName(), null).addQueryField("val", Long.class.getName(), null).setKeyFieldName("id").setValueFieldName("val"))).setBackups(1).setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 10)));
        for (long i = 0L; i < 10L; ++i) {
            c.put((Object)i, (Object)i);
        }
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
        super.afterTest();
    }

    @Test
    public void testLocalLazyQuery() {
        int i;
        Iterator[] iters = new Iterator[10];
        for (i = 0; i < 10; ++i) {
            iters[i] = this.sql("SELECT * FROM test", new Object[0]).iterator();
            ResultInterface res = (ResultInterface)GridTestUtils.getFieldValueHierarchy((Object)iters[i], (String[])new String[]{"iter", "delegateIt", "delegate", "iter", "res"});
            LocalQueryLazyTest.assertTrue((String)("Unexpected result type " + res.getClass()), (boolean)(res instanceof LazyResult));
        }
        for (i = 9; i >= 0; --i) {
            while (iters[i].hasNext()) {
                iters[i].next();
            }
        }
    }

    @Test
    public void testDuplicates() throws Exception {
        IgniteEx g0 = this.grid();
        IgniteEx g1 = this.startGrid(0);
        this.awaitPartitionMapExchange(true, true, null);
        int r0 = this.sql(g0, "SELECT * FROM test", new Object[0]).getAll().size();
        int r1 = this.sql(g1, "SELECT * FROM test", new Object[0]).getAll().size();
        LocalQueryLazyTest.assertTrue((r0 < 10 ? 1 : 0) != 0);
        LocalQueryLazyTest.assertTrue((r1 < 10 ? 1 : 0) != 0);
        LocalQueryLazyTest.assertEquals((int)10, (int)(r0 + r1));
    }

    @Test
    public void testTableUnlockOnNotFinishedQuery() throws Exception {
        IgniteEx g0 = this.grid();
        IgniteEx g1 = this.startGrid(0);
        this.awaitPartitionMapExchange(true, true, null);
        try (FieldsQueryCursor<List<?>> cur = this.sql(g0, "SELECT * FROM test", new Object[0]);){
            Iterator it = cur.iterator();
            it.next();
            this.sqlDistrubuted(g1, "CREATE INDEX IDX_VAL ON TEST(VAL)", new Object[0]);
        }
    }

    @Test
    public void testDropTableWithOpenCursor() throws Exception {
        this.startGrid(0);
        this.awaitPartitionMapExchange(true, true, null);
        this.sqlDistrubuted(this.grid(), "CREATE TABLE TBL0 (id INT PRIMARY KEY, name VARCHAR)", new Object[0]);
        for (int i = 0; i < 100; ++i) {
            this.sqlDistrubuted(this.grid(), "INSERT INTO TBL0 (id, name) VALUES (?, ?)", i, "val0_" + i);
        }
        Iterator it = this.grid().context().query().querySqlFields(new SqlFieldsQuery("SELECT * FROM TBL0").setLocal(true).setLazy(true).setSchema("TEST").setPageSize(1), false).iterator();
        it.next();
        this.sqlDistrubuted(this.grid(), "DROP TABLE TBL0", new Object[0]);
        GridTestUtils.assertThrows((IgniteLogger)log, () -> {
            it.next();
            return null;
        }, QueryRetryException.class, (String)"Table was modified concurrently (please retry the query)");
    }

    @Test
    public void testDeactivateWithOpenCursor() throws Exception {
        this.startGrid(0);
        this.awaitPartitionMapExchange(true, true, null);
        Iterator it = this.grid().context().query().querySqlFields(new SqlFieldsQuery("SELECT * FROM test").setLocal(true).setLazy(true).setSchema("TEST").setPageSize(1), false).iterator();
        it.next();
        this.grid(0).cluster().active(false);
        LocalQueryLazyTest.assertFalse((boolean)this.grid().cluster().active());
    }

    private FieldsQueryCursor<List<?>> sql(String sql, Object ... args) {
        return this.sql(this.grid(), sql, args);
    }

    private FieldsQueryCursor<List<?>> sql(IgniteEx ign, String sql, Object ... args) {
        return ign.context().query().querySqlFields(new SqlFieldsQuery(sql).setLocal(true).setLazy(true).setSchema("TEST").setArgs(args), false);
    }

    private FieldsQueryCursor<List<?>> sqlDistrubuted(IgniteEx ign, String sql, Object ... args) {
        return ign.context().query().querySqlFields(new SqlFieldsQuery(sql).setLazy(true).setSchema("TEST").setArgs(args), false);
    }
}

