/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query;

import java.util.List;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.binary.BinaryObjectBuilder;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.processors.cache.index.AbstractIndexingCommonTest;
import org.apache.ignite.testframework.ListeningTestLogger;
import org.apache.ignite.testframework.LogListener;
import org.junit.Test;

public class CheckIndexConsistencyOnRemoveTest
extends AbstractIndexingCommonTest {
    private static ListeningTestLogger srvLog;

    @Override
    protected void afterTestsStopped() throws Exception {
        this.stopAllGrids();
        super.afterTestsStopped();
    }

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        return super.getConfiguration(igniteInstanceName).setGridLogger((IgniteLogger)srvLog);
    }

    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        srvLog = new ListeningTestLogger(log);
        this.startGrids(1);
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
    }

    protected void afterTest() throws Exception {
        super.afterTest();
        for (String cacheName : this.grid(0).cacheNames()) {
            this.grid(0).cache(cacheName).destroy();
        }
    }

    @Test
    public void checkWarningMessage() {
        this.sql("CREATE TABLE TEST (ID0 INTEGER, ID1 INTEGER, VAL VARCHAR(100), PRIMARY KEY(ID0, ID1))WITH \"KEY_TYPE=TEST_KEY,CACHE_NAME=test,VALUE_TYPE=TEST_VAL\"", new Object[0]);
        this.sql("CREATE INDEX IDX_VAL ON TEST (VAL)", new Object[0]);
        IgniteCache cache = this.grid(0).cache("test");
        BinaryObjectBuilder bobKey = this.grid(0).binary().builder("TEST_KEY");
        bobKey.setField("ID0", (Object)0);
        bobKey.setField("ID1", (Object)0);
        BinaryObjectBuilder bobVal = this.grid(0).binary().builder("TEST_VAL");
        bobVal.setField("VAL", (Object)"val0");
        BinaryObject key0 = bobKey.build();
        cache.put((Object)key0, (Object)bobVal.build());
        bobKey = this.grid(0).binary().builder("TEST_KEY");
        bobKey.setField("ID1", (Object)0);
        bobKey.setField("ID0", (Object)0);
        bobVal = this.grid(0).binary().builder("TEST_VAL");
        bobVal.setField("VAL", (Object)"val1");
        BinaryObject key1 = bobKey.build();
        cache.put((Object)key1, (Object)bobVal.build());
        CheckIndexConsistencyOnRemoveTest.assertEquals((int)2, (int)cache.size(new CachePeekMode[0]));
        CheckIndexConsistencyOnRemoveTest.assertEquals((int)1, (int)this.sql("SELECT * from TEST USE INDEX (\"_key_PK\")", new Object[0]).getAll().size());
        cache.remove((Object)key1);
        LogListener lsnr = LogListener.matches((String)"SQL index inconsistency detected").andMatches("secIdxName=IDX_VAL").build();
        srvLog.registerListener(lsnr);
        cache.remove((Object)key0);
        CheckIndexConsistencyOnRemoveTest.assertTrue((boolean)lsnr.check());
        CheckIndexConsistencyOnRemoveTest.assertEquals((int)0, (int)this.sql("SELECT * from TEST USE INDEX (IDX_VAL)", new Object[0]).getAll().size());
    }

    private FieldsQueryCursor<List<?>> sql(String sql, Object ... args) {
        return this.grid(0).context().query().querySqlFields(new SqlFieldsQuery(sql).setArgs(args), false);
    }
}

