/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.database;

import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.QueryIndex;
import org.apache.ignite.cache.QueryIndexType;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.cache.eviction.EvictionPolicy;
import org.apache.ignite.cache.eviction.fifo.FifoEvictionPolicy;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.managers.communication.GridIoMessage;
import org.apache.ignite.internal.processors.cache.GridCacheGroupIdMessage;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionSupplyMessage;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.verify.ValidateIndexesClosure;
import org.apache.ignite.internal.visor.verify.VisorValidateIndexesJobResult;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.spi.IgniteSpiException;
import org.apache.ignite.spi.communication.CommunicationSpi;
import org.apache.ignite.spi.communication.tcp.TcpCommunicationSpi;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.ListeningTestLogger;
import org.apache.ignite.testframework.LogListener;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;

public class RebuildIndexWithHistoricalRebalanceTest
extends GridCommonAbstractTest {
    private static final String CACHE_NAME = "cache_name";
    private static final AtomicReference<CountDownLatch> SUPPLY_MESSAGE_LATCH = new AtomicReference();
    private final ListeningTestLogger log = new ListeningTestLogger(false, GridCommonAbstractTest.log);

    protected IgniteConfiguration getConfiguration(String gridName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(gridName);
        cfg.setConsistentId((Serializable)((Object)gridName));
        cfg.setGridLogger((IgniteLogger)this.log);
        QueryEntity qryEntity = new QueryEntity();
        qryEntity.setKeyType(UserKey.class.getName());
        qryEntity.setValueType(UserValue.class.getName());
        qryEntity.setKeyFields(new HashSet<String>(Arrays.asList("account")));
        LinkedHashMap<String, String> fields = new LinkedHashMap<String, String>();
        fields.put("account", "java.lang.Integer");
        fields.put("balance", "java.lang.Integer");
        qryEntity.setFields(fields);
        QueryIndex idx1 = new QueryIndex();
        idx1.setName("IDX_1");
        idx1.setIndexType(QueryIndexType.SORTED);
        LinkedHashMap<String, Boolean> idxFields = new LinkedHashMap<String, Boolean>();
        idxFields.put("account", false);
        idxFields.put("balance", false);
        idx1.setFields(idxFields);
        QueryIndex idx2 = new QueryIndex();
        idx2.setName("IDX_2");
        idx2.setIndexType(QueryIndexType.SORTED);
        idxFields = new LinkedHashMap();
        idxFields.put("balance", false);
        idx2.setFields(idxFields);
        qryEntity.setIndexes(Arrays.asList(idx1, idx2));
        cfg.setCacheConfiguration(new CacheConfiguration[]{new CacheConfiguration().setName(CACHE_NAME).setBackups(2).setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL).setCacheMode(CacheMode.REPLICATED).setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC).setOnheapCacheEnabled(true).setEvictionPolicy((EvictionPolicy)new FifoEvictionPolicy(1000)).setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 1)).setQueryEntities(Collections.singleton(qryEntity))});
        cfg.setDataStorageConfiguration(new DataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setPersistenceEnabled(true).setInitialSize(0xC800000L).setMaxSize(0xC800000L)));
        cfg.setCommunicationSpi((CommunicationSpi)new RebalanceBlockingSPI());
        return cfg;
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.log.clearListeners();
        System.setProperty("IGNITE_PDS_WAL_REBALANCE_THRESHOLD", "0");
        this.cleanPersistenceDir();
    }

    protected void afterTest() throws Exception {
        super.afterTest();
        this.stopAllGrids();
        System.clearProperty("IGNITE_PDS_WAL_REBALANCE_THRESHOLD");
        this.cleanPersistenceDir();
    }

    @Test
    public void shouldRebuldIndexForMovingPartitionWithHistoricalRebalance() throws Exception {
        IgniteEx node1 = this.startGrid(0);
        this.startGrid(1);
        node1.cluster().active(true);
        IgniteCache cache = node1.getOrCreateCache(CACHE_NAME);
        cache.put((Object)new UserKey(1), (Object)new UserValue(333));
        this.stopGrid(1);
        cache.put((Object)new UserKey(2), (Object)new UserValue(555));
        SUPPLY_MESSAGE_LATCH.set(new CountDownLatch(1));
        this.removeIndexBin(1);
        LogListener rebuildLsnr = this.finishIndexRebuildLsnr(CACHE_NAME);
        IgniteEx node2 = this.startGrid(1);
        RebuildIndexWithHistoricalRebalanceTest.assertTrue((boolean)GridTestUtils.waitForCondition(() -> ((LogListener)rebuildLsnr).check(), (long)10000L));
        SUPPLY_MESSAGE_LATCH.get().countDown();
        this.awaitPartitionMapExchange();
        ValidateIndexesClosure clo = new ValidateIndexesClosure(() -> false, Collections.singleton(CACHE_NAME), 0, 0, false, true);
        node2.context().resource().injectGeneric((Object)clo);
        VisorValidateIndexesJobResult res = clo.call();
        RebuildIndexWithHistoricalRebalanceTest.assertFalse((boolean)res.hasIssues());
    }

    private LogListener finishIndexRebuildLsnr(String cacheName) {
        LogListener lsnr = LogListener.matches(s -> s.startsWith("Finished indexes rebuilding for cache [name=" + cacheName)).times(1).build();
        this.log.registerListener(lsnr);
        return lsnr;
    }

    private void removeIndexBin(int nodeId) throws IgniteCheckedException {
        U.delete((File)U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)("db/" + U.maskForFileName((CharSequence)this.getTestIgniteInstanceName(nodeId)) + "/cache-" + CACHE_NAME + "/" + "index.bin"), (boolean)false));
    }

    private static class RebalanceBlockingSPI
    extends TcpCommunicationSpi {
        private RebalanceBlockingSPI() {
        }

        public void sendMessage(ClusterNode node, Message msg) throws IgniteSpiException {
            CountDownLatch latch0;
            int grpId;
            if (msg instanceof GridIoMessage && ((GridIoMessage)msg).message() instanceof GridDhtPartitionSupplyMessage && (grpId = ((GridCacheGroupIdMessage)((GridIoMessage)msg).message()).groupId()) == CU.cacheId((String)RebuildIndexWithHistoricalRebalanceTest.CACHE_NAME) && (latch0 = (CountDownLatch)SUPPLY_MESSAGE_LATCH.get()) != null) {
                try {
                    latch0.await();
                }
                catch (InterruptedException ex) {
                    throw new IgniteException((Throwable)ex);
                }
            }
            super.sendMessage(node, msg);
        }

        public void sendMessage(ClusterNode node, Message msg, IgniteInClosure<IgniteException> ackC) throws IgniteSpiException {
            CountDownLatch latch0;
            int grpId;
            if (msg instanceof GridIoMessage && ((GridIoMessage)msg).message() instanceof GridDhtPartitionSupplyMessage && (grpId = ((GridCacheGroupIdMessage)((GridIoMessage)msg).message()).groupId()) == CU.cacheId((String)RebuildIndexWithHistoricalRebalanceTest.CACHE_NAME) && (latch0 = (CountDownLatch)SUPPLY_MESSAGE_LATCH.get()) != null) {
                try {
                    latch0.await();
                }
                catch (InterruptedException ex) {
                    throw new IgniteException((Throwable)ex);
                }
            }
            super.sendMessage(node, msg, ackC);
        }
    }

    private static class UserValue {
        private int balance;

        public UserValue(int balance) {
            this.balance = balance;
        }

        public String toString() {
            return "UserValue{balance=" + this.balance + '}';
        }
    }

    private static class UserKey {
        private int account;

        public UserKey(int account) {
            this.account = account;
        }

        public String toString() {
            return "UserKey{account=" + this.account + '}';
        }
    }
}

