/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.database;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheRebalanceMode;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.persistence.GridCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.CheckpointListener;
import org.apache.ignite.internal.processors.query.QueryUtils;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.testframework.junits.WithSystemProperty;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;

@WithSystemProperty(key="IGNITE_SKIP_CONFIGURATION_CONSISTENCY_CHECK", value="true")
public class IgnitePersistentStoreSchemaLoadTest
extends GridCommonAbstractTest {
    private static final String TMPL_NAME = "test_cache*";
    private static final String TBL_NAME = Person.class.getSimpleName();
    private static final String SQL_CACHE_NAME = QueryUtils.createTableCacheName((String)"PUBLIC", (String)TBL_NAME);
    private static final String STATIC_CACHE_NAME = TBL_NAME;

    protected IgniteConfiguration getConfiguration(String gridName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(gridName);
        cfg.setCacheConfiguration(new CacheConfiguration[]{this.cacheCfg(TMPL_NAME)});
        DataStorageConfiguration pCfg = new DataStorageConfiguration();
        pCfg.setDefaultDataRegionConfiguration(new DataRegionConfiguration().setPersistenceEnabled(true).setMaxSize(0x6400000L));
        pCfg.setCheckpointFrequency(1000L);
        cfg.setDataStorageConfiguration(pCfg);
        return cfg;
    }

    private IgniteConfiguration getConfigurationWithStaticCache(String gridName) throws Exception {
        IgniteConfiguration cfg = this.getConfiguration(gridName);
        CacheConfiguration ccfg = this.cacheCfg(STATIC_CACHE_NAME);
        ccfg.setIndexedTypes(new Class[]{Integer.class, Person.class});
        ccfg.setSqlEscapeAll(true);
        cfg.setCacheConfiguration(new CacheConfiguration[]{ccfg});
        return this.optimize(cfg);
    }

    private CacheConfiguration cacheCfg(String name) {
        CacheConfiguration cfg = new CacheConfiguration();
        cfg.setName(name);
        cfg.setRebalanceMode(CacheRebalanceMode.NONE);
        cfg.setAtomicityMode(CacheAtomicityMode.ATOMIC);
        return cfg;
    }

    protected void beforeTest() throws Exception {
        this.stopAllGrids();
        this.cleanPersistenceDir();
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
        this.cleanPersistenceDir();
    }

    @Test
    public void testDynamicSchemaChangesPersistence() throws Exception {
        this.checkSchemaStateAfterNodeRestart(false);
    }

    @Test
    public void testDynamicSchemaChangesPersistenceWithAliveCluster() throws Exception {
        this.checkSchemaStateAfterNodeRestart(true);
    }

    @Test
    public void testDynamicSchemaChangesPersistenceWithStaticCache() throws Exception {
        IgniteEx node = this.startGrid(this.getConfigurationWithStaticCache(this.getTestIgniteInstanceName(0)));
        node.active(true);
        IgniteCache cache = node.cache(STATIC_CACHE_NAME);
        IgnitePersistentStoreSchemaLoadTest.assertNotNull((Object)cache);
        CountDownLatch cnt = this.checkpointLatch(node);
        this.checkOriginalSchema(node, STATIC_CACHE_NAME, Collections.emptyList());
        this.makeDynamicSchemaChanges(node, STATIC_CACHE_NAME);
        this.checkModifiedSchema(node, STATIC_CACHE_NAME);
        cnt.await();
        this.stopGrid(0);
        node = this.startGrid(0);
        node.active(true);
        this.checkModifiedSchema(node, STATIC_CACHE_NAME);
    }

    private void checkSchemaStateAfterNodeRestart(boolean aliveCluster) throws Exception {
        IgniteEx node = this.startGrid(0);
        node.active(true);
        if (aliveCluster) {
            this.startGrid(1);
        }
        CountDownLatch cnt = this.checkpointLatch(node);
        this.runSql("create table \"Person\" (\"id\" int primary key,\"name\" varchar,\"city\" int,\"str1\" varchar,\"str2\" char(10) not null default '1',\"num1\" decimal,\"num2\" decimal(10, 2) not null default 1)", node, "PUBLIC");
        this.checkOriginalSchema(node, SQL_CACHE_NAME, F.asList((Object[])new String[]{"str2", "num2"}));
        this.makeDynamicSchemaChanges(node, "PUBLIC");
        this.checkModifiedSchema(node, SQL_CACHE_NAME);
        cnt.await();
        this.stopGrid(0);
        node = this.startGrid(0);
        node.active(true);
        this.checkModifiedSchema(node, SQL_CACHE_NAME);
        node.context().query().querySqlFields(new SqlFieldsQuery("drop table \"Person\""), false).getAll();
    }

    private CountDownLatch checkpointLatch(IgniteEx node) {
        final CountDownLatch cnt = new CountDownLatch(1);
        GridCacheDatabaseSharedManager db = (GridCacheDatabaseSharedManager)node.context().cache().context().database();
        db.addCheckpointListener(new CheckpointListener(){

            public void onMarkCheckpointBegin(CheckpointListener.Context ctx) {
                cnt.countDown();
            }

            public void beforeCheckpointBegin(CheckpointListener.Context ctx) throws IgniteCheckedException {
            }

            public void onCheckpointBegin(CheckpointListener.Context ctx) {
            }
        });
        return cnt;
    }

    private void makeDynamicSchemaChanges(IgniteEx node, String schema) {
        this.runSql("create index \"my_idx\" on \"Person\" (\"id\", \"name\")", node, schema);
        this.runSql("alter table \"Person\" drop column \"city\", \"str1\", \"str2\", \"num1\", \"num2\"", node, schema);
        this.runSql("alter table \"Person\" add column (\"rate\" decimal(10, 2) not null,\"str1\" char(10) not null,\"str2\" varchar,\"num1\" decimal(10, 2) not null,\"num2\" decimal)", node, schema);
    }

    private List<List<?>> runSql(String sql, IgniteEx node, String schema) {
        return node.context().query().querySqlFields(new SqlFieldsQuery(sql).setSchema(schema), false).getAll();
    }

    private void checkOriginalSchema(IgniteEx node, String cacheName, List<String> expDfltFields) {
        Collection entities = node.context().cache().cacheDescriptor(cacheName).schema().entities();
        IgnitePersistentStoreSchemaLoadTest.assertEquals((int)1, (int)entities.size());
        QueryEntity e = (QueryEntity)F.first((Iterable)entities);
        IgnitePersistentStoreSchemaLoadTest.assertEquals((int)0, (int)e.getIndexes().size());
        this.assertEqualsUnordered(F.asList((Object[])new String[]{"id", "name", "city", "str1", "str2", "num1", "num2"}), e.getFields().keySet());
        this.assertEqualsUnordered(F.asList((Object[])new String[]{"str2", "num2"}), e.getNotNullFields());
        this.assertEqualsUnordered(F.asList((Object)"num2"), e.getFieldsScale().keySet());
        this.assertEqualsUnordered(F.asList((Object[])new String[]{"str2", "num2"}), e.getFieldsPrecision().keySet());
        this.assertEqualsUnordered(expDfltFields, e.getDefaultFieldValues().keySet());
    }

    private void checkModifiedSchema(IgniteEx node, String cacheName) {
        Collection entities = node.context().cache().cacheDescriptor(cacheName).schema().entities();
        IgnitePersistentStoreSchemaLoadTest.assertEquals((int)1, (int)entities.size());
        QueryEntity e = (QueryEntity)F.first((Iterable)entities);
        IgnitePersistentStoreSchemaLoadTest.assertEquals((int)1, (int)e.getIndexes().size());
        IgnitePersistentStoreSchemaLoadTest.assertEquals((int)0, (int)e.getDefaultFieldValues().size());
        this.assertEqualsUnordered(F.asList((Object[])new String[]{"id", "name", "rate", "str1", "str2", "num1", "num2"}), e.getFields().keySet());
        this.assertEqualsUnordered(F.asList((Object[])new String[]{"rate", "str1", "num1"}), e.getNotNullFields());
        this.assertEqualsUnordered(F.asList((Object[])new String[]{"rate", "num1"}), e.getFieldsScale().keySet());
        this.assertEqualsUnordered(F.asList((Object[])new String[]{"rate", "str1", "num1"}), e.getFieldsPrecision().keySet());
    }

    private void assertEqualsUnordered(List<String> expected, Set<String> actual) {
        String msg = "expected=" + expected + ", actual=" + actual;
        IgnitePersistentStoreSchemaLoadTest.assertEquals((String)msg, (int)expected.size(), (int)actual.size());
        IgnitePersistentStoreSchemaLoadTest.assertTrue((String)msg, (boolean)actual.containsAll(expected));
    }

    protected static class Person
    implements Serializable {
        private static final long serialVersionUID = 0L;
        @QuerySqlField
        protected int id;
        @QuerySqlField
        protected String name;
        @QuerySqlField
        protected int city;
        @QuerySqlField
        protected String str1;
        @QuerySqlField(precision=10, notNull=true)
        protected String str2;
        @QuerySqlField
        protected BigDecimal num1;
        @QuerySqlField(precision=10, scale=2, notNull=true)
        protected BigDecimal num2;

        private Person() {
        }

        public Person(int id) {
            this.id = id;
        }
    }
}

