/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.transaction;

import javax.cache.CacheException;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.WithSystemProperty;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.apache.ignite.transactions.Transaction;
import org.junit.Test;

public class DmlInsideTransactionTest
extends GridCommonAbstractTest {
    private static final String CACHE_PERSON = "PersonCache";
    private static final String[] DML_QUERIES = new String[]{"MERGE INTO TEST.Person(id, name, orgId) VALUES(111,'NAME',111)", "INSERT INTO TEST.Person(id, name, orgId) VALUES(222,'NAME',111)", "UPDATE TEST.Person SET name='new name'", "DELETE TEST.Person WHERE id=1", "INSERT INTO TEST.Person(id, name, orgId) SELECT id+1000, name, orgId FROM TEST.Person"};

    protected void afterTest() throws Exception {
        super.afterTest();
        this.stopAllGrids();
    }

    @Test
    public void testDmlInTransactionByDefault() throws Exception {
        this.prepareIgnite();
        for (String dmlQuery : DML_QUERIES) {
            this.runDmlSqlFieldsQueryInTransactionTest(dmlQuery, false, false);
            this.runDmlSqlFieldsQueryInTransactionTest(dmlQuery, true, false);
        }
    }

    @Test
    @WithSystemProperty(key="IGNITE_ALLOW_DML_INSIDE_TRANSACTION", value="false")
    public void testDmlInTransactionInDisabledCompatibilityMode() throws Exception {
        this.prepareIgnite();
        for (String dmlQuery : DML_QUERIES) {
            this.runDmlSqlFieldsQueryInTransactionTest(dmlQuery, false, false);
            this.runDmlSqlFieldsQueryInTransactionTest(dmlQuery, true, false);
        }
    }

    @Test
    @WithSystemProperty(key="IGNITE_ALLOW_DML_INSIDE_TRANSACTION", value="true")
    public void testDmlInTransactionInCompatibilityMode() throws Exception {
        this.prepareIgnite();
        for (String dmlQuery : DML_QUERIES) {
            this.runDmlSqlFieldsQueryInTransactionTest(dmlQuery, false, true);
            this.runDmlSqlFieldsQueryInTransactionTest(dmlQuery, true, true);
        }
    }

    @Test
    public void testDmlNotInTransaction() throws Exception {
        this.prepareIgnite();
        for (String dmlQuery : DML_QUERIES) {
            this.grid(0).cache(CACHE_PERSON).query(new SqlFieldsQuery(dmlQuery));
            this.grid(0).cache(CACHE_PERSON).clear();
            this.grid(0).cache(CACHE_PERSON).query(new SqlFieldsQuery(dmlQuery).setLocal(true));
        }
    }

    private void prepareIgnite() throws Exception {
        IgniteEx ignite = this.startGrid(0);
        ignite.createCache(new CacheConfiguration().setName(CACHE_PERSON).setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL).setSqlSchema("TEST").setIndexedTypes(new Class[]{PersonKey.class, Person.class}));
    }

    private void runDmlSqlFieldsQueryInTransactionTest(String dmlQry, boolean isLocal, boolean isAllowed) {
        SqlFieldsQuery query = new SqlFieldsQuery(dmlQry).setLocal(isLocal);
        this.runDmlInTransactionTest((Query)query, isAllowed);
    }

    private void runDmlInTransactionTest(Query query, boolean isAllowed) {
        IgniteEx ignite = this.grid(0);
        IgniteCache cache = ignite.cache(CACHE_PERSON);
        cache.removeAll();
        DmlInsideTransactionTest.assertEquals((int)0, (int)cache.query(new SqlFieldsQuery("SELECT * FROM TEST.Person")).getAll().size());
        try (Transaction tx = ignite.transactions().txStart();){
            cache.put((Object)new PersonKey(1L), (Object)new Person("person", 2L));
            if (isAllowed) {
                cache.query(query);
            } else {
                GridTestUtils.assertThrows((IgniteLogger)log, () -> {
                    cache.query(query);
                    return null;
                }, CacheException.class, (String)"DML statements are not allowed inside a transaction over cache(s) with TRANSACTIONAL atomicity");
            }
            tx.commit();
        }
        DmlInsideTransactionTest.assertTrue((!cache.query(new SqlFieldsQuery("SELECT * FROM TEST.Person")).getAll().isEmpty() ? 1 : 0) != 0);
    }

    public static class Person {
        @QuerySqlField
        public String name;
        @QuerySqlField(index=true)
        public long orgId;

        public Person(String name, long orgId) {
            this.name = name;
            this.orgId = orgId;
        }
    }

    public static class PersonKey {
        @QuerySqlField
        public long id;

        PersonKey(long id) {
            this.id = id;
        }

        public int hashCode() {
            return (int)this.id;
        }

        public boolean equals(Object obj) {
            return obj instanceof PersonKey && F.eq((Object)this.id, (Object)((PersonKey)obj).id);
        }
    }
}

