/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.mvcc;

import java.util.concurrent.CyclicBarrier;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.TransactionConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.transactions.IgniteTxRollbackCheckedException;
import org.apache.ignite.internal.transactions.IgniteTxTimeoutCheckedException;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.apache.ignite.transactions.Transaction;
import org.apache.ignite.transactions.TransactionConcurrency;
import org.apache.ignite.transactions.TransactionIsolation;
import org.junit.After;
import org.junit.Test;

public class MvccDeadlockDetectionConfigTest
extends GridCommonAbstractTest {
    private boolean deadlockDetectionEnabled;

    @After
    public void stopCluster() {
        this.stopAllGrids();
    }

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        int timeout = this.deadlockDetectionEnabled ? 1 : 0;
        return super.getConfiguration(igniteInstanceName).setTransactionConfiguration(new TransactionConfiguration().setDeadlockTimeout((long)timeout));
    }

    @Test
    public void deadlockDetectionDisabled() throws Exception {
        this.deadlockDetectionEnabled = false;
        IgniteEx ign = this.startGrid();
        IgniteCache cache = ign.createCache(new CacheConfiguration("default").setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL_SNAPSHOT));
        CyclicBarrier b = new CyclicBarrier(2);
        int txTimeout = 3000;
        IgniteInternalFuture futA = GridTestUtils.runAsync(() -> MvccDeadlockDetectionConfigTest.lambda$deadlockDetectionDisabled$0((Ignite)ign, txTimeout, cache, b));
        IgniteInternalFuture futB = GridTestUtils.runAsync(() -> MvccDeadlockDetectionConfigTest.lambda$deadlockDetectionDisabled$1((Ignite)ign, txTimeout, cache, b));
        IgniteCheckedException e = this.awaitCompletion(futA, futB);
        MvccDeadlockDetectionConfigTest.assertTrue((String)e.toString(), (boolean)e.hasCause(new Class[]{IgniteTxTimeoutCheckedException.class}));
    }

    @Test
    public void deadlockDetectionEnabled() throws Exception {
        this.deadlockDetectionEnabled = true;
        IgniteEx ign = this.startGrid();
        IgniteCache cache = ign.createCache(new CacheConfiguration("default").setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL_SNAPSHOT));
        CyclicBarrier b = new CyclicBarrier(2);
        IgniteInternalFuture futA = GridTestUtils.runAsync(() -> MvccDeadlockDetectionConfigTest.lambda$deadlockDetectionEnabled$2((Ignite)ign, cache, b));
        IgniteInternalFuture futB = GridTestUtils.runAsync(() -> MvccDeadlockDetectionConfigTest.lambda$deadlockDetectionEnabled$3((Ignite)ign, cache, b));
        IgniteCheckedException e = this.awaitCompletion(futA, futB);
        MvccDeadlockDetectionConfigTest.assertTrue((String)e.toString(), (boolean)X.hasCause((Throwable)e, (String)"Deadlock", (Class[])new Class[]{IgniteTxRollbackCheckedException.class}));
    }

    private IgniteCheckedException awaitCompletion(IgniteInternalFuture<?> fut1, IgniteInternalFuture<?> fut2) {
        IgniteCheckedException e = null;
        try {
            fut1.get(10000L);
        }
        catch (IgniteCheckedException e1) {
            e = e1;
        }
        try {
            fut2.get(10000L);
        }
        catch (IgniteCheckedException e1) {
            e = e1;
        }
        return e;
    }

    private static /* synthetic */ Object lambda$deadlockDetectionEnabled$3(Ignite ign, IgniteCache cache, CyclicBarrier b) throws Exception {
        try (Transaction tx = ign.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
            cache.put((Object)2, (Object)Character.valueOf('b'));
            b.await();
            cache.put((Object)1, (Object)Character.valueOf('b'));
        }
        return null;
    }

    private static /* synthetic */ Object lambda$deadlockDetectionEnabled$2(Ignite ign, IgniteCache cache, CyclicBarrier b) throws Exception {
        try (Transaction tx = ign.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
            cache.put((Object)1, (Object)Character.valueOf('a'));
            b.await();
            cache.put((Object)2, (Object)Character.valueOf('a'));
        }
        return null;
    }

    private static /* synthetic */ Object lambda$deadlockDetectionDisabled$1(Ignite ign, int txTimeout, IgniteCache cache, CyclicBarrier b) throws Exception {
        try (Transaction tx = ign.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ, (long)txTimeout, 0);){
            cache.put((Object)2, (Object)Character.valueOf('b'));
            b.await();
            cache.put((Object)1, (Object)Character.valueOf('b'));
        }
        return null;
    }

    private static /* synthetic */ Object lambda$deadlockDetectionDisabled$0(Ignite ign, int txTimeout, IgniteCache cache, CyclicBarrier b) throws Exception {
        try (Transaction tx = ign.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ, (long)txTimeout, 0);){
            cache.put((Object)1, (Object)Character.valueOf('a'));
            b.await();
            cache.put((Object)2, (Object)Character.valueOf('a'));
        }
        return null;
    }
}

