/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.index;

import java.util.Collections;
import java.util.Map;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteClientDisconnectedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.Ignition;
import org.apache.ignite.cache.QueryIndex;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteClientReconnectAbstractTest;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.GridCacheAdapter;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.index.AbstractSchemaSelfTest;
import org.apache.ignite.internal.processors.query.QueryTypeDescriptorImpl;
import org.apache.ignite.internal.processors.query.QueryUtils;
import org.apache.ignite.internal.util.lang.GridAbsPredicate;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.testframework.GridTestUtils;
import org.junit.Test;

public class SchemaExchangeSelfTest
extends AbstractSchemaSelfTest {
    private static String filterNodeName;

    protected void afterTest() throws Exception {
        this.stopAllGrids();
        filterNodeName = null;
        super.afterTest();
    }

    @Test
    public void testEmptyStatic() throws Exception {
        this.checkEmpty(false);
    }

    @Test
    public void testEmptyDynamic() throws Exception {
        this.checkEmpty(true);
    }

    private void checkEmpty(boolean dynamic) throws Exception {
        IgniteEx node1;
        if (dynamic) {
            node1 = this.startNoCache(1);
            node1.getOrCreateCache(SchemaExchangeSelfTest.cacheConfiguration(new Class[0]));
        } else {
            node1 = this.start(1, new Class[0]);
        }
        SchemaExchangeSelfTest.assertTypes(node1, new Class[0]);
        IgniteEx node2 = this.start(2, AbstractSchemaSelfTest.KeyClass.class, AbstractSchemaSelfTest.ValueClass.class);
        SchemaExchangeSelfTest.assertTypes(node1, new Class[0]);
        SchemaExchangeSelfTest.assertTypes(node2, new Class[0]);
        IgniteEx node3 = this.start(3, AbstractSchemaSelfTest.KeyClass.class, AbstractSchemaSelfTest.ValueClass.class, KeyClass2.class, ValueClass2.class);
        SchemaExchangeSelfTest.assertTypes(node1, new Class[0]);
        SchemaExchangeSelfTest.assertTypes(node2, new Class[0]);
        SchemaExchangeSelfTest.assertTypes(node3, new Class[0]);
    }

    @Test
    public void testNonEmptyStatic() throws Exception {
        this.checkNonEmpty(false);
    }

    @Test
    public void testNonEmptyDynamic() throws Exception {
        this.checkNonEmpty(true);
    }

    private void checkNonEmpty(boolean dynamic) throws Exception {
        IgniteEx node1;
        if (dynamic) {
            node1 = this.startNoCache(1);
            node1.getOrCreateCache(SchemaExchangeSelfTest.cacheConfiguration(AbstractSchemaSelfTest.KeyClass.class, AbstractSchemaSelfTest.ValueClass.class));
        } else {
            node1 = this.start(1, AbstractSchemaSelfTest.KeyClass.class, AbstractSchemaSelfTest.ValueClass.class);
        }
        SchemaExchangeSelfTest.assertTypes(node1, AbstractSchemaSelfTest.ValueClass.class);
        IgniteEx node2 = this.start(2, new Class[0]);
        SchemaExchangeSelfTest.assertTypes(node1, AbstractSchemaSelfTest.ValueClass.class);
        SchemaExchangeSelfTest.assertTypes(node2, AbstractSchemaSelfTest.ValueClass.class);
        IgniteEx node3 = this.start(3, AbstractSchemaSelfTest.KeyClass.class, AbstractSchemaSelfTest.ValueClass.class, KeyClass2.class, ValueClass2.class);
        SchemaExchangeSelfTest.assertTypes(node1, AbstractSchemaSelfTest.ValueClass.class);
        SchemaExchangeSelfTest.assertTypes(node2, AbstractSchemaSelfTest.ValueClass.class);
        SchemaExchangeSelfTest.assertTypes(node3, AbstractSchemaSelfTest.ValueClass.class);
    }

    @Test
    public void testDynamicRestarts() throws Exception {
        IgniteEx node1 = this.start(1, AbstractSchemaSelfTest.KeyClass.class, AbstractSchemaSelfTest.ValueClass.class);
        IgniteEx node2 = this.startNoCache(2);
        IgniteEx node3 = this.startClientNoCache(3);
        IgniteEx node4 = this.startClientNoCache(4);
        SchemaExchangeSelfTest.assertTypes(node1, AbstractSchemaSelfTest.ValueClass.class);
        SchemaExchangeSelfTest.assertTypes(node2, AbstractSchemaSelfTest.ValueClass.class);
        this.assertCacheStarted("cache", node1, node2);
        SchemaExchangeSelfTest.assertTypes(node3, AbstractSchemaSelfTest.ValueClass.class);
        this.assertCacheNotStarted("cache", node3);
        node3.cache("cache");
        this.assertCacheStarted("cache", node3);
        this.destroySqlCache((Ignite)node1);
        node1.getOrCreateCache(SchemaExchangeSelfTest.cacheConfiguration(new Class[0]));
        SchemaExchangeSelfTest.assertTypes(node1, new Class[0]);
        SchemaExchangeSelfTest.assertTypes(node2, new Class[0]);
        SchemaExchangeSelfTest.assertTypes(node3, new Class[0]);
        node1.destroyCache("cache");
        node1.getOrCreateCache(SchemaExchangeSelfTest.cacheConfiguration(AbstractSchemaSelfTest.KeyClass.class, AbstractSchemaSelfTest.ValueClass.class, KeyClass2.class, ValueClass2.class));
        SchemaExchangeSelfTest.assertTypes(node1, AbstractSchemaSelfTest.ValueClass.class, ValueClass2.class);
        SchemaExchangeSelfTest.assertTypes(node2, AbstractSchemaSelfTest.ValueClass.class, ValueClass2.class);
        SchemaExchangeSelfTest.assertTypes(node3, AbstractSchemaSelfTest.ValueClass.class, ValueClass2.class);
        this.assertCacheStarted("cache", node1, node2);
        this.assertCacheNotStarted("cache", node3);
        node3.cache("cache");
        this.assertCacheStarted("cache", node3);
        node2.destroyCache("cache");
        node2.getOrCreateCache(SchemaExchangeSelfTest.cacheConfiguration(new Class[0]));
        SchemaExchangeSelfTest.assertTypes(node1, new Class[0]);
        SchemaExchangeSelfTest.assertTypes(node2, new Class[0]);
        SchemaExchangeSelfTest.assertTypes(node3, new Class[0]);
        node2.destroyCache("cache");
        node2.getOrCreateCache(SchemaExchangeSelfTest.cacheConfiguration(AbstractSchemaSelfTest.KeyClass.class, AbstractSchemaSelfTest.ValueClass.class, KeyClass2.class, ValueClass2.class));
        SchemaExchangeSelfTest.assertTypes(node1, AbstractSchemaSelfTest.ValueClass.class, ValueClass2.class);
        SchemaExchangeSelfTest.assertTypes(node2, AbstractSchemaSelfTest.ValueClass.class, ValueClass2.class);
        SchemaExchangeSelfTest.assertTypes(node3, AbstractSchemaSelfTest.ValueClass.class, ValueClass2.class);
        SchemaExchangeSelfTest.assertTypes(node4, AbstractSchemaSelfTest.ValueClass.class, ValueClass2.class);
        this.assertCacheStarted("cache", node1, node2);
        this.assertCacheNotStarted("cache", node3);
        node3.cache("cache");
        this.assertCacheStarted("cache", node3);
        this.assertCacheNotStarted("cache", node4);
        node4.cache("cache");
        this.assertCacheStarted("cache", node4);
        SchemaExchangeSelfTest.assertTypes(this.start(5, new Class[0]), AbstractSchemaSelfTest.ValueClass.class, ValueClass2.class);
        SchemaExchangeSelfTest.assertTypes(this.startNoCache(6), AbstractSchemaSelfTest.ValueClass.class, ValueClass2.class);
        SchemaExchangeSelfTest.assertTypes(this.startClient(7, new Class[0]), AbstractSchemaSelfTest.ValueClass.class, ValueClass2.class);
        IgniteEx node8 = this.startClientNoCache(8);
        SchemaExchangeSelfTest.assertTypes(node8, AbstractSchemaSelfTest.ValueClass.class, ValueClass2.class);
        this.assertCacheNotStarted("cache", node8);
        node8.cache("cache");
        this.assertCacheStarted("cache", node8);
    }

    @Test
    public void testClientJoinStatic() throws Exception {
        this.checkClientJoin(false);
    }

    @Test
    public void testClientJoinDynamic() throws Exception {
        this.checkClientJoin(true);
    }

    private void checkClientJoin(boolean dynamic) throws Exception {
        IgniteEx node1;
        if (dynamic) {
            node1 = this.startNoCache(1);
            node1.getOrCreateCache(SchemaExchangeSelfTest.cacheConfiguration(AbstractSchemaSelfTest.KeyClass.class, AbstractSchemaSelfTest.ValueClass.class));
        } else {
            node1 = this.start(1, AbstractSchemaSelfTest.KeyClass.class, AbstractSchemaSelfTest.ValueClass.class);
        }
        IgniteEx node2 = this.startClient(2, new Class[0]);
        SchemaExchangeSelfTest.assertTypes(node1, AbstractSchemaSelfTest.ValueClass.class);
        SchemaExchangeSelfTest.assertTypes(node2, AbstractSchemaSelfTest.ValueClass.class);
        IgniteEx node3 = this.startClient(3, AbstractSchemaSelfTest.KeyClass.class, AbstractSchemaSelfTest.ValueClass.class, KeyClass2.class, ValueClass2.class);
        SchemaExchangeSelfTest.assertTypes(node1, AbstractSchemaSelfTest.ValueClass.class);
        SchemaExchangeSelfTest.assertTypes(node2, AbstractSchemaSelfTest.ValueClass.class);
        SchemaExchangeSelfTest.assertTypes(node3, AbstractSchemaSelfTest.ValueClass.class);
        IgniteEx node4 = this.startClientNoCache(4);
        SchemaExchangeSelfTest.assertTypes(node1, AbstractSchemaSelfTest.ValueClass.class);
        SchemaExchangeSelfTest.assertTypes(node2, AbstractSchemaSelfTest.ValueClass.class);
        SchemaExchangeSelfTest.assertTypes(node3, AbstractSchemaSelfTest.ValueClass.class);
        SchemaExchangeSelfTest.assertTypes(node4, AbstractSchemaSelfTest.ValueClass.class);
        this.assertCacheStarted("cache", node1, node2, node3);
        this.assertCacheNotStarted("cache", node4);
        node4.cache("cache");
        this.assertCacheStarted("cache", node4);
    }

    @Test
    public void testClientCacheStartStatic() throws Exception {
        this.checkClientCacheStart(false);
    }

    @Test
    public void testClientCacheStartDynamic() throws Exception {
        this.checkClientCacheStart(true);
    }

    private void checkClientCacheStart(boolean dynamic) throws Exception {
        IgniteEx node2;
        IgniteEx node1 = this.startNoCache(1);
        if (dynamic) {
            node2 = this.startClientNoCache(2);
            this.createSqlCache((Ignite)node2, SchemaExchangeSelfTest.cacheConfiguration(AbstractSchemaSelfTest.KeyClass.class, AbstractSchemaSelfTest.ValueClass.class));
        } else {
            node2 = this.startClient(2, AbstractSchemaSelfTest.KeyClass.class, AbstractSchemaSelfTest.ValueClass.class);
        }
        SchemaExchangeSelfTest.assertTypes(node1, AbstractSchemaSelfTest.ValueClass.class);
        SchemaExchangeSelfTest.assertTypes(node2, AbstractSchemaSelfTest.ValueClass.class);
        IgniteEx node3 = this.start(3, new Class[0]);
        IgniteEx node4 = this.start(4, AbstractSchemaSelfTest.KeyClass.class, AbstractSchemaSelfTest.ValueClass.class, KeyClass2.class, ValueClass2.class);
        IgniteEx node5 = this.startNoCache(5);
        IgniteEx node6 = this.startClient(6, new Class[0]);
        IgniteEx node7 = this.startClient(7, AbstractSchemaSelfTest.KeyClass.class, AbstractSchemaSelfTest.ValueClass.class, KeyClass2.class, ValueClass2.class);
        IgniteEx node8 = this.startClientNoCache(8);
        this.assertCacheStarted("cache", node1, node2, node3, node4, node5, node6, node7);
        this.assertCacheNotStarted("cache", node8);
        SchemaExchangeSelfTest.assertTypes(node8, AbstractSchemaSelfTest.ValueClass.class);
        node8.cache("cache");
        this.assertCacheStarted("cache", node8);
        this.destroySqlCache((Ignite)node2);
        node2.getOrCreateCache(SchemaExchangeSelfTest.cacheConfiguration(AbstractSchemaSelfTest.KeyClass.class, AbstractSchemaSelfTest.ValueClass.class, KeyClass2.class, ValueClass2.class));
        this.assertCacheStarted("cache", node1, node2, node3, node4, node5);
        this.assertCacheNotStarted("cache", node6, node7, node8);
        SchemaExchangeSelfTest.assertTypes(node6, AbstractSchemaSelfTest.ValueClass.class, ValueClass2.class);
        SchemaExchangeSelfTest.assertTypes(node7, AbstractSchemaSelfTest.ValueClass.class, ValueClass2.class);
        SchemaExchangeSelfTest.assertTypes(node8, AbstractSchemaSelfTest.ValueClass.class, ValueClass2.class);
        node6.cache("cache");
        node7.cache("cache");
        node8.cache("cache");
        this.assertCacheStarted("cache", node6, node7, node8);
    }

    @Test
    public void testNodeFilter() throws Exception {
        filterNodeName = this.getTestIgniteInstanceName(1);
        IgniteEx node1 = this.start(1, AbstractSchemaSelfTest.KeyClass.class, AbstractSchemaSelfTest.ValueClass.class);
        SchemaExchangeSelfTest.assertTypes(node1, AbstractSchemaSelfTest.ValueClass.class);
        IgniteEx node2 = this.start(2, AbstractSchemaSelfTest.KeyClass.class, AbstractSchemaSelfTest.ValueClass.class);
        SchemaExchangeSelfTest.assertTypes(node1, AbstractSchemaSelfTest.ValueClass.class);
        SchemaExchangeSelfTest.assertTypes(node2, AbstractSchemaSelfTest.ValueClass.class);
        IgniteEx node3 = this.startNoCache(3);
        SchemaExchangeSelfTest.assertTypes(node1, AbstractSchemaSelfTest.ValueClass.class);
        SchemaExchangeSelfTest.assertTypes(node2, AbstractSchemaSelfTest.ValueClass.class);
        SchemaExchangeSelfTest.assertTypes(node3, AbstractSchemaSelfTest.ValueClass.class);
        this.assertCacheStarted("cache", node1, node2);
        this.assertCacheNotStarted("cache", node3);
        node3.cache("cache");
        this.assertCacheStarted("cache", node1, node3);
    }

    @Test
    public void testServerRestartWithNewTypes() throws Exception {
        IgniteEx node1 = this.start(1, AbstractSchemaSelfTest.KeyClass.class, AbstractSchemaSelfTest.ValueClass.class);
        SchemaExchangeSelfTest.assertTypes(node1, AbstractSchemaSelfTest.ValueClass.class);
        IgniteEx node2 = this.startClientNoCache(2);
        GridCacheContext context0 = node2.context().cache().context().cacheContext(CU.cacheId((String)"cache"));
        node2.cache("cache");
        GridCacheContext context = node2.context().cache().context().cacheContext(CU.cacheId((String)"cache"));
        GridCacheAdapter entries = node2.context().cache().internalCache("cache");
        SchemaExchangeSelfTest.assertTrue((boolean)entries.active());
        node2.cache("cache");
        SchemaExchangeSelfTest.assertTypes(node2, AbstractSchemaSelfTest.ValueClass.class);
        this.stopGrid(1);
        SchemaExchangeSelfTest.assertTrue((boolean)GridTestUtils.waitForCondition((GridAbsPredicate)new GridAbsPredicate(){

            public boolean apply() {
                return SchemaExchangeSelfTest.this.grid(2).context().clientDisconnected();
            }
        }, (long)10000L));
        IgniteFuture reconnFut = null;
        try {
            node2.cache("cache");
            SchemaExchangeSelfTest.fail();
        }
        catch (IgniteClientDisconnectedException e) {
            reconnFut = e.reconnectFuture();
        }
        node1 = this.start(1, AbstractSchemaSelfTest.KeyClass.class, AbstractSchemaSelfTest.ValueClass.class, KeyClass2.class, ValueClass2.class);
        SchemaExchangeSelfTest.assertTypes(node1, AbstractSchemaSelfTest.ValueClass.class, ValueClass2.class);
        this.assertCacheStarted("cache", node1);
        reconnFut.get();
        this.assertCacheNotStarted("cache", node2);
        node2.cache("cache");
        this.assertCacheStarted("cache", node2);
        SchemaExchangeSelfTest.assertTypes(node2, AbstractSchemaSelfTest.ValueClass.class, ValueClass2.class);
    }

    @Test
    public void testClientReconnect() throws Exception {
        final IgniteEx node1 = this.start(1, AbstractSchemaSelfTest.KeyClass.class, AbstractSchemaSelfTest.ValueClass.class);
        SchemaExchangeSelfTest.assertTypes(node1, AbstractSchemaSelfTest.ValueClass.class);
        final IgniteEx node2 = this.startClientNoCache(2);
        SchemaExchangeSelfTest.assertTypes(node2, AbstractSchemaSelfTest.ValueClass.class);
        this.assertCacheNotStarted("cache", node2);
        node2.cache("cache");
        this.assertCacheStarted("cache", node2);
        IgniteClientReconnectAbstractTest.reconnectClientNode((IgniteLogger)log, (Ignite)node2, (Ignite)node1, (Runnable)new Runnable(){

            @Override
            public void run() {
                SchemaExchangeSelfTest.assertTrue((boolean)node2.context().clientDisconnected());
                QueryIndex idx = AbstractSchemaSelfTest.index("IDX_1", AbstractSchemaSelfTest.field("field1"));
                try {
                    SchemaExchangeSelfTest.this.dynamicIndexCreate((Ignite)node1, "cache", AbstractSchemaSelfTest.TBL_NAME, idx, false, 0);
                }
                catch (Exception e) {
                    throw new IgniteException((Throwable)e);
                }
            }
        });
        SchemaExchangeSelfTest.assertIndex("cache", QueryUtils.normalizeObjectName((String)TBL_NAME, (boolean)true), QueryUtils.normalizeObjectName((String)"IDX_1", (boolean)false), -1, SchemaExchangeSelfTest.field(QueryUtils.normalizeObjectName((String)"field1", (boolean)false)));
    }

    private boolean isCacheStarted(String cacheName, IgniteEx node) {
        GridCacheContext cacheCtx = node.context().cache().context().cacheContext(CU.cacheId((String)cacheName));
        return cacheCtx != null;
    }

    private void assertCacheStarted(String cacheName, IgniteEx ... nodes) throws AssertionError {
        for (IgniteEx node : nodes) {
            SchemaExchangeSelfTest.assertTrue((boolean)this.isCacheStarted(cacheName, node));
        }
    }

    private void assertCacheNotStarted(String cacheName, IgniteEx ... nodes) throws AssertionError {
        for (IgniteEx node : nodes) {
            SchemaExchangeSelfTest.assertFalse((boolean)this.isCacheStarted(cacheName, node));
        }
    }

    private static void assertTypes(IgniteEx node, Class ... clss) {
        Map<String, QueryTypeDescriptorImpl> types = SchemaExchangeSelfTest.types(node, "cache");
        if (F.isEmpty((Object[])clss)) {
            SchemaExchangeSelfTest.assertTrue((boolean)types.isEmpty());
        } else {
            SchemaExchangeSelfTest.assertEquals((int)clss.length, (int)types.size());
            for (Class cls : clss) {
                String tblName = SchemaExchangeSelfTest.tableName(cls);
                SchemaExchangeSelfTest.assertTrue((boolean)types.containsKey(tblName));
            }
        }
    }

    private IgniteEx start(int idx, Class ... clss) throws Exception {
        return this.start(idx, false, clss);
    }

    private IgniteEx startClient(int idx, Class ... clss) throws Exception {
        return this.start(idx, true, clss);
    }

    private IgniteEx start(int idx, boolean client, Class ... clss) throws Exception {
        String name = this.getTestIgniteInstanceName(idx);
        IgniteConfiguration cfg = this.getConfiguration(name);
        cfg.setClientMode(client);
        cfg.setLocalHost("127.0.0.1");
        if (filterNodeName != null && F.eq((Object)name, (Object)filterNodeName)) {
            cfg.setUserAttributes(Collections.singletonMap("AFF_NODE", true));
        }
        IgniteEx res = (IgniteEx)Ignition.start((IgniteConfiguration)cfg);
        this.createSqlCache((Ignite)res, SchemaExchangeSelfTest.cacheConfiguration(clss));
        return res;
    }

    private IgniteEx startNoCache(int idx) throws Exception {
        return this.startNoCache(idx, false);
    }

    private IgniteEx startClientNoCache(int idx) throws Exception {
        return this.startNoCache(idx, true);
    }

    private IgniteEx startNoCache(int idx, boolean client) throws Exception {
        String name = this.getTestIgniteInstanceName(idx);
        IgniteConfiguration cfg = this.getConfiguration(name);
        cfg.setClientMode(client);
        cfg.setLocalHost("127.0.0.1");
        return (IgniteEx)Ignition.start((IgniteConfiguration)cfg);
    }

    private static CacheConfiguration cacheConfiguration(Class ... clss) {
        CacheConfiguration ccfg = new CacheConfiguration().setName("cache").setIndexedTypes(clss);
        if (filterNodeName != null) {
            ccfg.setNodeFilter((IgnitePredicate)new IgnitePredicate<ClusterNode>(){

                public boolean apply(ClusterNode node) {
                    return node.attribute("AFF_NODE") != null;
                }
            });
        }
        return ccfg;
    }

    private static class ValueClass2 {
        @QuerySqlField
        private String valField2;

        private ValueClass2() {
        }
    }

    private static class KeyClass2 {
        @QuerySqlField
        private String keyField2;

        private KeyClass2() {
        }
    }
}

