/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.index;

import java.io.Externalizable;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;
import java.util.UUID;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.NearCacheConfiguration;
import org.apache.ignite.configuration.WALMode;
import org.apache.ignite.internal.marshaller.optimized.OptimizedMarshaller;
import org.apache.ignite.internal.processors.cache.index.AbstractIndexingCommonTest;
import org.apache.ignite.internal.processors.cache.query.SqlFieldsQueryEx;
import org.apache.ignite.internal.processors.query.QueryUtils;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.testframework.junits.IgniteTestResources;
import org.jetbrains.annotations.NotNull;
import org.junit.Test;

public class OptimizedMarshallerIndexNameTest
extends AbstractIndexingCommonTest {
    private static final String TEST_NAME1 = "Name1";
    private static final String TEST_NAME2 = "Name2";

    protected IgniteConfiguration getConfiguration(String igniteInstanceName, IgniteTestResources rsrcs) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName, rsrcs);
        DataStorageConfiguration memCfg = new DataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setMaxSize(314572800L).setPersistenceEnabled(true)).setStoragePath(this.workSubdir() + "/db").setWalArchivePath(this.workSubdir() + "/db/wal/archive").setWalPath(this.workSubdir() + "/db/wal").setWalMode(WALMode.LOG_ONLY);
        cfg.setDataStorageConfiguration(memCfg);
        cfg.setMarshaller((Marshaller)new OptimizedMarshaller());
        return cfg;
    }

    protected static CacheConfiguration<Object, Object> cacheConfiguration(String name) {
        CacheConfiguration cfg = new CacheConfiguration(name);
        cfg.setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL);
        cfg.setNearConfiguration(new NearCacheConfiguration());
        cfg.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        cfg.setEvictionPolicy(null);
        cfg.setIndexedTypes(new Class[]{UUID.class, Person.class, UUID.class, FalsePerson.class});
        return cfg;
    }

    protected void beforeTestsStarted() throws Exception {
        U.delete((File)U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)this.workSubdir(), (boolean)true));
        this.startGrid(this.getTestIgniteInstanceName());
        this.grid().active(true);
    }

    @Test
    public void testOptimizedMarshallerIndex() {
        CacheConfiguration<Object, Object> ccfg = OptimizedMarshallerIndexNameTest.cacheConfiguration("PersonEn");
        IgniteCache cache = this.grid().getOrCreateCache(ccfg);
        cache.put((Object)UUID.randomUUID(), (Object)new Person(TEST_NAME1, 42));
        cache.put((Object)UUID.randomUUID(), (Object)new FalsePerson(32, TEST_NAME2));
        SqlFieldsQueryEx qry = new SqlFieldsQueryEx("select * from " + QueryUtils.typeName(FalsePerson.class), Boolean.valueOf(true));
        List res = cache.query((SqlFieldsQuery)qry).getAll();
        OptimizedMarshallerIndexNameTest.assertEquals((int)1, (int)res.size());
    }

    @NotNull
    private String workSubdir() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    public static class FalsePerson
    implements Externalizable {
        @QuerySqlField(index=true, inlineSize=0)
        private int name;
        @QuerySqlField(index=true, inlineSize=0)
        private String age;

        public FalsePerson() {
        }

        public FalsePerson(int name, String age) {
            this.name = name;
            this.age = age;
        }

        public int getName() {
            return this.name;
        }

        public String getAge() {
            return this.age;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.name);
            out.writeUTF(this.age);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException {
            this.name = in.readInt();
            this.age = in.readUTF();
        }
    }

    public static class Person
    implements Externalizable {
        @QuerySqlField(index=true, inlineSize=0)
        private String name;
        @QuerySqlField(index=true, inlineSize=0)
        private int age;

        public Person() {
        }

        public Person(String name, int age) {
            this.name = name;
            this.age = age;
        }

        public String getName() {
            return this.name;
        }

        public int getAge() {
            return this.age;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeUTF(this.name);
            out.writeInt(this.age);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException {
            this.name = in.readUTF();
            this.age = in.readInt();
        }
    }
}

