/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.index;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.metric.IoStatisticsHolder;
import org.apache.ignite.internal.processors.cache.persistence.tree.BPlusTree;
import org.apache.ignite.internal.processors.cache.persistence.tree.CorruptedTreeException;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.util.PageHandler;
import org.apache.ignite.internal.processors.query.h2.database.H2Tree;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.testframework.ListeningTestLogger;
import org.apache.ignite.testframework.LogListener;
import org.apache.ignite.testframework.MessageOrderLogListener;
import org.apache.ignite.testframework.junits.WithSystemProperty;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;

public class H2TreeCorruptedTreeExceptionTest
extends GridCommonAbstractTest {
    private static final String IDX_NAME = "A_IDX";
    private static final String GRP_NAME = "cacheGrp";
    private static final String VERY_SENS_STR_DATA = "here_comes_very_sensitive_data@#123#321#@";
    private final AtomicBoolean failWithCorruptTree = new AtomicBoolean(false);
    private final LogListener logListener = new MessageOrderLogListener(new String[]{String.format(".*?Tree is corrupted.*?cacheId=65, cacheName=A, indexName=%s, groupName=%s, msg=Runtime failure on row: Row@.*?key: 1, val: .*?%s.*", "A_IDX", "cacheGrp", "IGNITE_SENSITIVE_DATA_LOGGING")});
    private final LogListener logSensListener = new MessageOrderLogListener(new String[]{String.format(".*%s.*", "here_comes_very_sensitive_data@#123#321#@")});

    protected IgniteConfiguration getConfiguration(String gridName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(gridName);
        cfg.setConsistentId((Serializable)((Object)gridName));
        cfg.setCacheConfiguration(new CacheConfiguration[]{new CacheConfiguration().setName("default").setAffinity((AffinityFunction)new RendezvousAffinityFunction().setPartitions(1)).setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL)});
        ListeningTestLogger listeningTestLog = new ListeningTestLogger(false, log);
        listeningTestLog.registerListener(this.logListener);
        listeningTestLog.registerListener(this.logSensListener);
        cfg.setGridLogger((IgniteLogger)listeningTestLog);
        return cfg;
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.stopAllGrids();
        this.cleanPersistenceDir();
        BPlusTree.testHndWrapper = (tree, hnd) -> {
            if (hnd instanceof BPlusTree.Insert) {
                final PageHandler delegate = hnd;
                return new PageHandler<Object, BPlusTree.Result>(){

                    public BPlusTree.Result run(int cacheId, long pageId, long page, long pageAddr, PageIO io, Boolean walPlc, Object arg, int intArg, IoStatisticsHolder statHolder) throws IgniteCheckedException {
                        BPlusTree.Result res = (BPlusTree.Result)delegate.run(cacheId, pageId, page, pageAddr, io, walPlc, arg, intArg, statHolder);
                        if (H2TreeCorruptedTreeExceptionTest.this.failWithCorruptTree.get() && tree instanceof H2Tree && tree.name().contains(H2TreeCorruptedTreeExceptionTest.IDX_NAME)) {
                            throw new RuntimeException("test exception");
                        }
                        return res;
                    }
                };
            }
            return hnd;
        };
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
        this.cleanPersistenceDir();
        this.clearGridToStringClassCache();
        BPlusTree.testHndWrapper = null;
        super.afterTest();
    }

    @WithSystemProperty(key="IGNITE_SENSITIVE_DATA_LOGGING", value="none")
    @Test
    public void testCorruptedTree() throws Exception {
        IgniteEx srv = this.startGrid(0);
        srv.cluster().active(true);
        IgniteCache cache = srv.getOrCreateCache("default");
        cache.query(new SqlFieldsQuery("create table a (col1 varchar primary key, col2 varchar) with \"CACHE_GROUP=cacheGrp\""));
        cache.query(new SqlFieldsQuery("create index A_IDX on a(col2)"));
        this.failWithCorruptTree.set(true);
        try {
            cache.query(new SqlFieldsQuery("insert into a(col1, col2) values (1, ?1)").setArgs(new Object[]{VERY_SENS_STR_DATA}));
            H2TreeCorruptedTreeExceptionTest.fail((String)"Cache operations are expected to fail");
        }
        catch (Throwable e) {
            H2TreeCorruptedTreeExceptionTest.assertTrue((boolean)X.hasCause((Throwable)e, (Class[])new Class[]{CorruptedTreeException.class}));
        }
        H2TreeCorruptedTreeExceptionTest.assertTrue((boolean)this.logListener.check());
        H2TreeCorruptedTreeExceptionTest.assertFalse((boolean)this.logSensListener.check());
        System.setProperty("IGNITE_SENSITIVE_DATA_LOGGING", "plain");
        this.clearGridToStringClassCache();
        this.logListener.reset();
        this.logSensListener.reset();
        try {
            cache.query(new SqlFieldsQuery("insert into a(col1, col2) values (2, ?1)").setArgs(new Object[]{VERY_SENS_STR_DATA}));
        }
        catch (Throwable e) {
            H2TreeCorruptedTreeExceptionTest.assertTrue((boolean)X.hasCause((Throwable)e, (Class[])new Class[]{CorruptedTreeException.class}));
        }
        H2TreeCorruptedTreeExceptionTest.assertFalse((boolean)this.logListener.check());
        H2TreeCorruptedTreeExceptionTest.assertTrue((boolean)this.logSensListener.check());
    }
}

