/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.index;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.codec.binary.Hex;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.index.AbstractIndexingCommonTest;
import org.apache.ignite.internal.processors.query.GridQueryProcessor;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class ArrayIndexTest
extends AbstractIndexingCommonTest {
    @After
    public void tearDown() throws Exception {
        this.stopAllGrids();
        this.cleanPersistenceDir();
    }

    @Before
    public void setUp() throws Exception {
        this.cleanPersistenceDir();
    }

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        cfg.setConsistentId((Serializable)((Object)igniteInstanceName));
        cfg.setDataStorageConfiguration(new DataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setPersistenceEnabled(true)));
        cfg.setCacheConfiguration(new CacheConfiguration[]{new CacheConfiguration("default").setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC).setQueryEntities(Collections.singleton(new QueryEntity().setKeyType(byte[].class.getName()).setValueType(Integer.class.getName())))});
        return cfg;
    }

    @Test
    public void shouldSelectAllRows() throws Exception {
        IgniteEx ex = this.startGrid(0);
        ex.cluster().active(true);
        IgniteCache cache = ex.getOrCreateCache("default");
        cache.put((Object)new byte[]{8, 9, 10}, (Object)3);
        cache.put((Object)new byte[]{1, 2, 3}, (Object)1);
        cache.put((Object)new byte[]{5, 6, 7}, (Object)2);
        List sorted = cache.query(new SqlFieldsQuery("select _key, _val from Integer")).getAll();
        ArrayIndexTest.assertEquals((int)3, (int)sorted.size());
        List first = (List)sorted.get(0);
        ArrayIndexTest.assertTrue((boolean)Objects.deepEquals(first.get(0), new byte[]{1, 2, 3}));
        ArrayIndexTest.assertTrue((boolean)Objects.deepEquals(first.get(1), 1));
        List second = (List)sorted.get(1);
        ArrayIndexTest.assertTrue((boolean)Objects.deepEquals(second.get(0), new byte[]{5, 6, 7}));
        ArrayIndexTest.assertTrue((boolean)Objects.deepEquals(second.get(1), 2));
        List third = (List)sorted.get(2);
        ArrayIndexTest.assertTrue((boolean)Objects.deepEquals(third.get(0), new byte[]{8, 9, 10}));
        ArrayIndexTest.assertTrue((boolean)Objects.deepEquals(third.get(1), 3));
    }

    @Test
    public void shouldSelectParticularValue() throws Exception {
        IgniteEx ex = this.startGrid(0);
        ex.cluster().active(true);
        IgniteCache cache = ex.getOrCreateCache("default");
        cache.put((Object)new byte[]{1, 2, 3}, (Object)1);
        cache.put((Object)new byte[]{5, 6, 7}, (Object)2);
        cache.put((Object)new byte[]{8, 9, 10}, (Object)3);
        List res = cache.query(new SqlFieldsQuery("select _key, _val from Integer where _key = ?").setArgs(new Object[]{new byte[]{5, 6, 7}})).getAll();
        ArrayIndexTest.assertEquals((int)1, (int)res.size());
        List row = (List)res.get(0);
        ArrayIndexTest.assertTrue((boolean)Objects.deepEquals(row.get(0), new byte[]{5, 6, 7}));
        ArrayIndexTest.assertTrue((boolean)Objects.deepEquals(row.get(1), 2));
    }

    @Test
    public void shouldCreateTableWithBinaryKey() throws Exception {
        byte[] key = new byte[]{1, 2, 3, 4};
        IgniteEx ex = this.startGrid(0);
        ex.cluster().active(true);
        this.executeSql(ex, "CREATE TABLE Binary_Entries (key binary(16) not null, val binary(16), PRIMARY KEY(key))");
        this.executeSql(ex, "INSERT INTO Binary_Entries(key, val) VALUES (x'" + Hex.encodeHexString((byte[])key) + "', x'01020304')");
        ArrayIndexTest.assertEquals((int)ex.cache("SQL_PUBLIC_BINARY_ENTRIES").size(new CachePeekMode[0]), (int)1);
        ArrayIndexTest.assertTrue((boolean)ex.cache("SQL_PUBLIC_BINARY_ENTRIES").containsKey((Object)key));
    }

    private List<List<?>> executeSql(IgniteEx node, String sqlText) throws Exception {
        GridQueryProcessor qryProc = node.context().query();
        return qryProc.querySqlFields(new SqlFieldsQuery(sqlText), true).getAll();
    }
}

