/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.near;

import java.util.Arrays;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;

public class IgniteCacheDistributedPartitionQueryConfigurationSelfTest
extends GridCommonAbstractTest {
    @Test
    public void testPartitions() {
        final SqlFieldsQuery qry = new SqlFieldsQuery("select 1");
        this.failIfNotThrown(new Runnable(){

            @Override
            public void run() {
                qry.setPartitions(new int[0]);
            }
        });
        this.failIfNotThrown(new Runnable(){

            @Override
            public void run() {
                qry.setPartitions(new int[]{0, 1, 2, 1});
            }
        });
        this.failIfNotThrown(new Runnable(){

            @Override
            public void run() {
                qry.setPartitions(new int[]{-1, 0, 1});
            }
        });
        this.failIfNotThrown(new Runnable(){

            @Override
            public void run() {
                qry.setPartitions(new int[]{3, 2, 2});
            }
        });
        this.failIfNotThrown(new Runnable(){

            @Override
            public void run() {
                qry.setPartitions(new int[]{-1, 0, 1});
            }
        });
        int[] tmp = new int[]{6, 2, 3};
        qry.setPartitions(tmp);
        IgniteCacheDistributedPartitionQueryConfigurationSelfTest.assertTrue((boolean)Arrays.equals(new int[]{2, 3, 6}, tmp));
        tmp = new int[]{0, 1, 2};
        qry.setPartitions(tmp);
        IgniteCacheDistributedPartitionQueryConfigurationSelfTest.assertTrue((tmp == qry.getPartitions() ? 1 : 0) != 0);
    }

    private void failIfNotThrown(Runnable r) {
        try {
            r.run();
            IgniteCacheDistributedPartitionQueryConfigurationSelfTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

