/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.distributed.CacheBlockOnGetAllTest;
import org.apache.ignite.internal.processors.cache.distributed.CacheBlockOnReadAbstractTest;
import org.apache.ignite.internal.processors.cache.distributed.CacheBlockOnScanTest;
import org.apache.ignite.internal.processors.cache.distributed.CacheBlockOnSingleGetTest;
import org.apache.ignite.internal.processors.cache.distributed.CacheBlockOnSqlQueryTest;
import org.apache.ignite.internal.processors.query.schema.message.SchemaOperationStatusMessage;
import org.apache.ignite.internal.util.typedef.T3;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Test;

public class CacheBlockOnCreateDestoryIndexTest
extends GridCommonAbstractTest {
    private final List<? extends CacheBlockOnReadAbstractTest> tests = Arrays.asList(new CacheBlockOnReadAbstractTest[]{new CacheBlockOnSingleGetTest(){

        @Nullable
        protected <A extends Annotation> A currentTestAnnotation(Class<A> annotationCls) {
            return (A)CacheBlockOnCreateDestoryIndexTest.this.currentTestAnnotation(annotationCls);
        }
    }, new CacheBlockOnGetAllTest(){

        @Nullable
        protected <A extends Annotation> A currentTestAnnotation(Class<A> annotationCls) {
            return (A)CacheBlockOnCreateDestoryIndexTest.this.currentTestAnnotation(annotationCls);
        }
    }, new CacheBlockOnScanTest(){

        @Nullable
        protected <A extends Annotation> A currentTestAnnotation(Class<A> annotationCls) {
            return (A)CacheBlockOnCreateDestoryIndexTest.this.currentTestAnnotation(annotationCls);
        }
    }, new CacheBlockOnSqlQueryTest(){

        @Nullable
        protected <A extends Annotation> A currentTestAnnotation(Class<A> annotationCls) {
            return (A)CacheBlockOnCreateDestoryIndexTest.this.currentTestAnnotation(annotationCls);
        }
    }});

    protected void beforeTest() throws Exception {
        this.currentTest().beforeTest();
    }

    protected void afterTest() throws Exception {
        this.currentTest().afterTest();
    }

    @TestIndex(value=0)
    @CacheBlockOnReadAbstractTest.Params(atomicityMode=CacheAtomicityMode.ATOMIC, cacheMode=CacheMode.PARTITIONED)
    @Test
    public void testCreateIndexAtomicPartitionedGet() throws Exception {
        this.doTestCreateIndex();
    }

    @TestIndex(value=0)
    @CacheBlockOnReadAbstractTest.Params(atomicityMode=CacheAtomicityMode.ATOMIC, cacheMode=CacheMode.REPLICATED)
    @Test
    public void testCreateIndexAtomicReplicatedGet() throws Exception {
        this.doTestCreateIndex();
    }

    @TestIndex(value=0)
    @CacheBlockOnReadAbstractTest.Params(atomicityMode=CacheAtomicityMode.TRANSACTIONAL, cacheMode=CacheMode.PARTITIONED)
    @Test
    public void testCreateIndexTransactionalPartitionedGet() throws Exception {
        this.doTestCreateIndex();
    }

    @TestIndex(value=0)
    @CacheBlockOnReadAbstractTest.Params(atomicityMode=CacheAtomicityMode.TRANSACTIONAL, cacheMode=CacheMode.REPLICATED)
    @Test
    public void testCreateIndexTransactionalReplicatedGet() throws Exception {
        this.doTestCreateIndex();
    }

    @TestIndex(value=1)
    @CacheBlockOnReadAbstractTest.Params(atomicityMode=CacheAtomicityMode.ATOMIC, cacheMode=CacheMode.PARTITIONED)
    @Test
    public void testCreateIndexAtomicPartitionedGetAll() throws Exception {
        this.doTestCreateIndex();
    }

    @TestIndex(value=1)
    @CacheBlockOnReadAbstractTest.Params(atomicityMode=CacheAtomicityMode.ATOMIC, cacheMode=CacheMode.REPLICATED)
    @Test
    public void testCreateIndexAtomicReplicatedGetAll() throws Exception {
        this.doTestCreateIndex();
    }

    @TestIndex(value=1)
    @CacheBlockOnReadAbstractTest.Params(atomicityMode=CacheAtomicityMode.TRANSACTIONAL, cacheMode=CacheMode.PARTITIONED)
    @Test
    public void testCreateIndexTransactionalPartitionedGetAll() throws Exception {
        this.doTestCreateIndex();
    }

    @TestIndex(value=1)
    @CacheBlockOnReadAbstractTest.Params(atomicityMode=CacheAtomicityMode.TRANSACTIONAL, cacheMode=CacheMode.REPLICATED)
    @Test
    public void testCreateIndexTransactionalReplicatedGetAll() throws Exception {
        this.doTestCreateIndex();
    }

    @TestIndex(value=2)
    @CacheBlockOnReadAbstractTest.Params(atomicityMode=CacheAtomicityMode.ATOMIC, cacheMode=CacheMode.PARTITIONED)
    @Test
    public void testCreateIndexAtomicPartitionedScan() throws Exception {
        this.doTestCreateIndex();
    }

    @TestIndex(value=2)
    @CacheBlockOnReadAbstractTest.Params(atomicityMode=CacheAtomicityMode.ATOMIC, cacheMode=CacheMode.REPLICATED)
    @Test
    public void testCreateIndexAtomicReplicatedScan() throws Exception {
        this.doTestCreateIndex();
    }

    @TestIndex(value=2)
    @CacheBlockOnReadAbstractTest.Params(atomicityMode=CacheAtomicityMode.TRANSACTIONAL, cacheMode=CacheMode.PARTITIONED)
    @Test
    public void testCreateIndexTransactionalPartitionedScan() throws Exception {
        this.doTestCreateIndex();
    }

    @TestIndex(value=2)
    @CacheBlockOnReadAbstractTest.Params(atomicityMode=CacheAtomicityMode.TRANSACTIONAL, cacheMode=CacheMode.REPLICATED)
    @Test
    public void testCreateIndexTransactionalReplicatedScan() throws Exception {
        this.doTestCreateIndex();
    }

    @TestIndex(value=3)
    @CacheBlockOnReadAbstractTest.Params(atomicityMode=CacheAtomicityMode.ATOMIC, cacheMode=CacheMode.PARTITIONED)
    @Test
    public void testCreateIndexAtomicPartitionedSqlQuery() throws Exception {
        this.doTestCreateIndex();
    }

    @TestIndex(value=3)
    @CacheBlockOnReadAbstractTest.Params(atomicityMode=CacheAtomicityMode.ATOMIC, cacheMode=CacheMode.REPLICATED)
    @Test
    public void testCreateIndexAtomicReplicatedSqlQuery() throws Exception {
        this.doTestCreateIndex();
    }

    @TestIndex(value=3)
    @CacheBlockOnReadAbstractTest.Params(atomicityMode=CacheAtomicityMode.TRANSACTIONAL, cacheMode=CacheMode.PARTITIONED)
    @Test
    public void testCreateIndexTransactionalPartitionedSqlQuery() throws Exception {
        this.doTestCreateIndex();
    }

    @TestIndex(value=3)
    @CacheBlockOnReadAbstractTest.Params(atomicityMode=CacheAtomicityMode.TRANSACTIONAL, cacheMode=CacheMode.REPLICATED)
    @Test
    public void testCreateIndexTransactionalReplicatedSqlQuery() throws Exception {
        this.doTestCreateIndex();
    }

    @TestIndex(value=0)
    @CacheBlockOnReadAbstractTest.Params(atomicityMode=CacheAtomicityMode.ATOMIC, cacheMode=CacheMode.PARTITIONED)
    @Test
    public void testDestroyIndexAtomicPartitionedGet() throws Exception {
        this.doTestDestroyIndex();
    }

    @TestIndex(value=0)
    @CacheBlockOnReadAbstractTest.Params(atomicityMode=CacheAtomicityMode.ATOMIC, cacheMode=CacheMode.REPLICATED)
    @Test
    public void testDestroyIndexAtomicReplicatedGet() throws Exception {
        this.doTestDestroyIndex();
    }

    @TestIndex(value=0)
    @CacheBlockOnReadAbstractTest.Params(atomicityMode=CacheAtomicityMode.TRANSACTIONAL, cacheMode=CacheMode.PARTITIONED)
    @Test
    public void testDestroyIndexTransactionalPartitionedGet() throws Exception {
        this.doTestDestroyIndex();
    }

    @TestIndex(value=0)
    @CacheBlockOnReadAbstractTest.Params(atomicityMode=CacheAtomicityMode.TRANSACTIONAL, cacheMode=CacheMode.REPLICATED)
    @Test
    public void testDestroyIndexTransactionalReplicatedGet() throws Exception {
        this.doTestDestroyIndex();
    }

    @TestIndex(value=1)
    @CacheBlockOnReadAbstractTest.Params(atomicityMode=CacheAtomicityMode.ATOMIC, cacheMode=CacheMode.PARTITIONED)
    @Test
    public void testDestroyIndexAtomicPartitionedGetAll() throws Exception {
        this.doTestDestroyIndex();
    }

    @TestIndex(value=1)
    @CacheBlockOnReadAbstractTest.Params(atomicityMode=CacheAtomicityMode.ATOMIC, cacheMode=CacheMode.REPLICATED)
    @Test
    public void testDestroyIndexAtomicReplicatedGetAll() throws Exception {
        this.doTestDestroyIndex();
    }

    @TestIndex(value=1)
    @CacheBlockOnReadAbstractTest.Params(atomicityMode=CacheAtomicityMode.TRANSACTIONAL, cacheMode=CacheMode.PARTITIONED)
    @Test
    public void testDestroyIndexTransactionalPartitionedGetAll() throws Exception {
        this.doTestDestroyIndex();
    }

    @TestIndex(value=1)
    @CacheBlockOnReadAbstractTest.Params(atomicityMode=CacheAtomicityMode.TRANSACTIONAL, cacheMode=CacheMode.REPLICATED)
    @Test
    public void testDestroyIndexTransactionalReplicatedGetAll() throws Exception {
        this.doTestDestroyIndex();
    }

    @TestIndex(value=2)
    @CacheBlockOnReadAbstractTest.Params(atomicityMode=CacheAtomicityMode.ATOMIC, cacheMode=CacheMode.PARTITIONED)
    @Test
    public void testDestroyIndexAtomicPartitionedScan() throws Exception {
        this.doTestDestroyIndex();
    }

    @TestIndex(value=2)
    @CacheBlockOnReadAbstractTest.Params(atomicityMode=CacheAtomicityMode.ATOMIC, cacheMode=CacheMode.REPLICATED)
    @Test
    public void testDestroyIndexAtomicReplicatedScan() throws Exception {
        this.doTestDestroyIndex();
    }

    @TestIndex(value=2)
    @CacheBlockOnReadAbstractTest.Params(atomicityMode=CacheAtomicityMode.TRANSACTIONAL, cacheMode=CacheMode.PARTITIONED)
    @Test
    public void testDestroyIndexTransactionalPartitionedScan() throws Exception {
        this.doTestDestroyIndex();
    }

    @TestIndex(value=2)
    @CacheBlockOnReadAbstractTest.Params(atomicityMode=CacheAtomicityMode.TRANSACTIONAL, cacheMode=CacheMode.REPLICATED)
    @Test
    public void testDestroyIndexTransactionalReplicatedScan() throws Exception {
        this.doTestDestroyIndex();
    }

    @TestIndex(value=3)
    @CacheBlockOnReadAbstractTest.Params(atomicityMode=CacheAtomicityMode.ATOMIC, cacheMode=CacheMode.PARTITIONED)
    @Test
    public void testDestroyIndexAtomicPartitionedSqlQuery() throws Exception {
        this.doTestDestroyIndex();
    }

    @TestIndex(value=3)
    @CacheBlockOnReadAbstractTest.Params(atomicityMode=CacheAtomicityMode.ATOMIC, cacheMode=CacheMode.REPLICATED)
    @Test
    public void testDestroyIndexAtomicReplicatedSqlQuery() throws Exception {
        this.doTestDestroyIndex();
    }

    @TestIndex(value=3)
    @CacheBlockOnReadAbstractTest.Params(atomicityMode=CacheAtomicityMode.TRANSACTIONAL, cacheMode=CacheMode.PARTITIONED)
    @Test
    public void testDestroyIndexTransactionalPartitionedSqlQuery() throws Exception {
        this.doTestDestroyIndex();
    }

    @TestIndex(value=3)
    @CacheBlockOnReadAbstractTest.Params(atomicityMode=CacheAtomicityMode.TRANSACTIONAL, cacheMode=CacheMode.REPLICATED)
    @Test
    public void testDestroyIndexTransactionalReplicatedSqlQuery() throws Exception {
        this.doTestDestroyIndex();
    }

    private void doTestCreateIndex() throws Exception {
        IgniteEx ignite = (IgniteEx)this.currentTest().baseline().get(0);
        List<T3<String, String, String>> caches = this.createCaches(ignite);
        this.currentTest().doTest(msg -> msg instanceof SchemaOperationStatusMessage, () -> this.createIndex(ignite, (T3<String, String, String>)((T3)caches.remove(caches.size() - 1))));
    }

    private void doTestDestroyIndex() throws Exception {
        IgniteEx ignite = (IgniteEx)this.currentTest().baseline().get(0);
        List<T3<String, String, String>> caches = this.createCaches(ignite);
        for (T3<String, String, String> pair : caches) {
            this.createIndex(ignite, pair);
        }
        this.currentTest().doTest(msg -> msg instanceof SchemaOperationStatusMessage, () -> this.destroyIndex(ignite, (T3<String, String, String>)((T3)caches.remove(caches.size() - 1))));
    }

    @NotNull
    private List<T3<String, String, String>> createCaches(IgniteEx ignite) {
        ArrayList<T3<String, String, String>> caches = new ArrayList<T3<String, String, String>>();
        for (int i = 0; i < 3; ++i) {
            String tblName = "TABLE_" + UUID.randomUUID().toString().replace('-', '_');
            String cacheName = "CACHE_" + tblName;
            CacheConfiguration ccfg = new CacheConfiguration(cacheName).setSqlSchema("PUBLIC");
            IgniteCache cache = ignite.createCache(ccfg);
            String createTblQryStr = String.format("CREATE TABLE %s (id LONG, name VARCHAR, city_id LONG, PRIMARY KEY (id, city_id)) WITH \"backups=1, affinityKey=city_id\"", tblName);
            cache.query(new SqlFieldsQuery(createTblQryStr)).getAll();
            String idxName = "IDX_" + tblName;
            caches.add((T3<String, String, String>)new T3((Object)cacheName, (Object)tblName, (Object)idxName));
        }
        return caches;
    }

    private void createIndex(IgniteEx ignite, T3<String, String, String> pair) {
        IgniteCache cache = ignite.getOrCreateCache((String)pair.get1());
        String createIdxQryStr = String.format("CREATE INDEX %S on %s (city_id)", pair.get3(), pair.get2());
        cache.query(new SqlFieldsQuery(createIdxQryStr)).getAll();
    }

    private void destroyIndex(IgniteEx ignite, T3<String, String, String> pair) {
        IgniteCache cache = ignite.getOrCreateCache((String)pair.get1());
        String createIdxQryStr = String.format("DROP INDEX %s", pair.get3());
        cache.query(new SqlFieldsQuery(createIdxQryStr)).getAll();
    }

    private CacheBlockOnReadAbstractTest currentTest() {
        return this.tests.get(((TestIndex)this.currentTestAnnotation(TestIndex.class)).value());
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    protected static @interface TestIndex {
        public int value();
    }
}

