/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.io.Serializable;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.cache.Cache;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.SqlQuery;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.util.GridRandom;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;

public class IgniteCacheSqlQueryMultiThreadedSelfTest
extends GridCommonAbstractTest {
    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration c = super.getConfiguration(igniteInstanceName);
        CacheConfiguration ccfg = new CacheConfiguration("default");
        ccfg.setCacheMode(CacheMode.PARTITIONED);
        ccfg.setNearConfiguration(null);
        ccfg.setBackups(1);
        ccfg.setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL);
        ccfg.setIndexedTypes(new Class[]{Integer.class, Person.class});
        c.setCacheConfiguration(new CacheConfiguration[]{ccfg});
        return c;
    }

    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        this.startGrids(2);
        this.awaitPartitionMapExchange();
    }

    @Test
    public void testQuery() throws Exception {
        final IgniteCache cache = this.grid(0).cache("default");
        cache.clear();
        for (int i = 0; i < 2000; ++i) {
            cache.put((Object)i, (Object)new Person(i));
        }
        GridTestUtils.runMultiThreaded((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                for (int i = 0; i < 100; ++i) {
                    QueryCursor qry = cache.query((Query)new SqlQuery("Person", "age >= 0"));
                    int cnt = 0;
                    for (Cache.Entry e : qry) {
                        ++cnt;
                    }
                    IgniteCacheSqlQueryMultiThreadedSelfTest.assertEquals((int)2000, (int)cnt);
                }
                return null;
            }
        }, (int)16, (String)"test");
    }

    @Test
    public void testQueryPut() throws Exception {
        final IgniteCache cache = this.grid(0).cache("default");
        cache.clear();
        final AtomicBoolean stop = new AtomicBoolean();
        IgniteInternalFuture fut1 = this.multithreadedAsync(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                GridRandom rnd = new GridRandom();
                while (!stop.get()) {
                    List res = cache.query(new SqlFieldsQuery("select avg(age) from Person where age > 0")).getAll();
                    IgniteCacheSqlQueryMultiThreadedSelfTest.assertEquals((int)1, (int)res.size());
                    if (((List)res.get(0)).get(0) == null) continue;
                    int avgAge = ((Number)((List)res.get(0)).get(0)).intValue();
                    if (rnd.nextInt(300) != 0) continue;
                    X.println((String)("__ " + avgAge), (Object[])new Object[0]);
                }
                return null;
            }
        }, 20);
        IgniteInternalFuture fut2 = this.multithreadedAsync(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                GridRandom rnd = new GridRandom();
                GridRandom age = new GridRandom();
                while (!stop.get()) {
                    cache.put((Object)rnd.nextInt(2000), (Object)new Person(age.nextInt(3000) - 1000));
                }
                return null;
            }
        }, 20);
        Thread.sleep(30000L);
        stop.set(true);
        fut2.get(10000L);
        fut1.get(10000L);
    }

    private static class Person
    implements Serializable {
        @QuerySqlField(index=true)
        private int age;

        Person(int age) {
            this.age = age;
        }

        public int age() {
            return this.age;
        }
    }
}

