/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.QueryIndex;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;

public class IgniteCacheMultipleIndexedTypesTest
extends GridCommonAbstractTest {
    protected void beforeTest() throws Exception {
        this.startGrid(0);
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
        super.afterTest();
    }

    @Test
    public void testMultipleIndexedTypes() throws Exception {
        CacheConfiguration ccfg = new CacheConfiguration("default");
        ArrayList<QueryEntity> qryEntities = new ArrayList<QueryEntity>();
        QueryEntity qryEntity = new QueryEntity();
        qryEntity.setKeyType(Integer.class.getName());
        qryEntity.setValueType(Person.class.getName());
        LinkedHashMap<String, String> fields = new LinkedHashMap<String, String>();
        fields.put("name", String.class.getName());
        qryEntity.setFields(fields);
        qryEntity.setIndexes((Collection)F.asList((Object)new QueryIndex("name")));
        qryEntities.add(qryEntity);
        qryEntity = new QueryEntity();
        qryEntity.setKeyType(Integer.class.getName());
        qryEntity.setValueType(Organization.class.getName());
        fields = new LinkedHashMap();
        fields.put("name", String.class.getName());
        qryEntity.setFields(fields);
        qryEntity.setIndexes((Collection)F.asList((Object)new QueryIndex("name")));
        qryEntities.add(qryEntity);
        ccfg.setQueryEntities(qryEntities);
        IgniteEx ignite = this.ignite(0);
        IgniteCache cache = ignite.createCache(ccfg);
        this.checkCount(cache, Person.class, 0L);
        cache.put((Object)1, (Object)new Person("a"));
        this.checkCount(cache, Person.class, 1L);
        cache.remove((Object)1);
        this.checkCount(cache, Person.class, 0L);
        cache.put((Object)1, (Object)new Person("a"));
        this.checkCount(cache, Person.class, 1L);
        cache.put((Object)1, (Object)new Organization("a"));
        this.checkCount(cache, Person.class, 0L);
        this.checkCount(cache, Organization.class, 1L);
        cache.put((Object)1, (Object)new Person("a"));
        this.checkCount(cache, Person.class, 1L);
        this.checkCount(cache, Organization.class, 0L);
        cache.put((Object)2, (Object)new Person("a"));
        this.checkCount(cache, Person.class, 2L);
        this.checkCount(cache, Organization.class, 0L);
        cache.put((Object)1, (Object)new Organization("a"));
        this.checkCount(cache, Person.class, 1L);
        this.checkCount(cache, Organization.class, 1L);
    }

    private void checkCount(IgniteCache cache, Class type, long expCnt) {
        this.checkCount1(cache, type, expCnt);
        this.checkCount2(cache, type, expCnt);
    }

    private void checkCount1(IgniteCache cache, Class type, long expCnt) {
        SqlFieldsQuery qry = new SqlFieldsQuery("select _key, _val from " + type.getSimpleName());
        List res = cache.query(qry).getAll();
        IgniteCacheMultipleIndexedTypesTest.assertEquals((long)expCnt, (long)res.size());
        for (List res0 : res) {
            IgniteCacheMultipleIndexedTypesTest.assertEquals((Object)type, res0.get(1).getClass());
        }
    }

    private void checkCount2(IgniteCache cache, Class type, long expCnt) {
        SqlFieldsQuery qry = new SqlFieldsQuery("select _key, _val from " + type.getSimpleName() + " where name='a'");
        List res = cache.query(qry).getAll();
        IgniteCacheMultipleIndexedTypesTest.assertEquals((long)expCnt, (long)res.size());
        for (List res0 : res) {
            IgniteCacheMultipleIndexedTypesTest.assertEquals((Object)type, res0.get(1).getClass());
        }
    }

    static class Organization
    implements Serializable {
        private String name;

        public Organization(String name) {
            this.name = name;
        }
    }

    static class Person
    implements Serializable {
        private String name;

        public Person(String name) {
            this.name = name;
        }
    }
}

