/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.mxbean;

import java.util.concurrent.TimeUnit;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.SqlConfiguration;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.metric.SqlStatisticsAbstractTest;
import org.junit.After;
import org.junit.Test;

public class SqlQueryMXBeanImplSqlFreeMemTest
extends SqlStatisticsAbstractTest {
    @After
    public void stopAll() {
        this.stopAllGrids();
    }

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        cfg.setSqlConfiguration(new SqlConfiguration().setSqlGlobalMemoryQuota("20m").setSqlQueryMemoryQuota("10m").setLongQueryWarningTimeout(30000L).setSqlOffloadingEnabled(true));
        return cfg;
    }

    @Test
    public void testFreeMemoryJMXWhenLocalQueryIsRunningAndReleasedOnFinish() throws Exception {
        this.startGrids(2);
        int connNodeIdx = 1;
        int otherNodeIdx = 0;
        IgniteCache cache = this.createCacheFrom((Ignite)this.grid(connNodeIdx));
        String scanQry = "SELECT * FROM TAB WHERE ID <> suspendHook(5)";
        IgniteInternalFuture locQryIsDone = this.runAsyncX(() -> cache.query(new SqlFieldsQuery("SELECT * FROM TAB WHERE ID <> suspendHook(5)").setLocal(true).setLazy(false)).getAll());
        SqlStatisticsAbstractTest.SuspendQuerySqlFunctions.awaitQueryStopsInTheMiddle();
        this.validateMemoryUsageOn(connNodeIdx, MEMORY_IS_USED);
        this.validateMemoryUsageOn(otherNodeIdx, MEMORY_IS_FREE);
        SqlStatisticsAbstractTest.SuspendQuerySqlFunctions.resumeQueryExecution();
        locQryIsDone.get(15L, TimeUnit.SECONDS);
        this.validateMemoryUsageOn(connNodeIdx, MEMORY_IS_FREE);
        this.validateMemoryUsageOn(otherNodeIdx, MEMORY_IS_FREE);
    }

    private void validateMemoryUsageOn(int nodeIdx, SqlStatisticsAbstractTest.MemValidator validator) throws Exception {
        long maxMem;
        long free = this.getValue("mxbean.SqlQueryMXBeanImplSqlFreeMemTest" + nodeIdx, "SQL Query", "SqlQueryMXBeanImpl", "SqlFreeMemoryBytes");
        if (free > (maxMem = this.getValue("mxbean.SqlQueryMXBeanImplSqlFreeMemTest" + nodeIdx, "SQL Query", "SqlQueryMXBeanImpl", "SqlGlobalMemoryQuotaBytes"))) {
            SqlQueryMXBeanImplSqlFreeMemTest.fail((String)String.format("Illegal state: there's more free memory (%s) than maximum available for sql (%s) on the node %d", free, maxMem, nodeIdx));
        }
        validator.validate(free, maxMem);
    }
}

