/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.metric;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.query.QueryCancelledException;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.metric.SqlStatisticsAbstractTest;
import org.apache.ignite.internal.processors.metric.MetricRegistry;
import org.apache.ignite.internal.processors.query.GridRunningQueryInfo;
import org.apache.ignite.spi.metric.LongMetric;
import org.apache.ignite.spi.metric.Metric;
import org.apache.ignite.testframework.GridTestUtils;
import org.junit.Assert;

public class UserQueriesTestBase
extends SqlStatisticsAbstractTest {
    protected static final int WAIT_FOR_KILL_SEC = 1;
    private static final String[] ALL_METRICS = new String[]{"success", "failed", "canceled", "failedByOOM"};
    protected static final int REDUCER_IDX = 0;
    protected static final int MAPPER_IDX = 1;

    protected void assertMetricsRemainTheSame(Runnable act) {
        this.assertMetricsAre(this.fetchAllMetrics(0), this.fetchAllMetrics(1), act);
    }

    protected void assertMetricsIncrementedOnlyOnReducer(Runnable act, String ... incrementedMetrics) {
        Map<String, Long> expValuesMapper = this.fetchAllMetrics(1);
        Map<String, Long> expValuesReducer = this.fetchAllMetrics(0);
        for (String incMet : incrementedMetrics) {
            expValuesReducer.compute(incMet, (name, val) -> val + 1L);
        }
        this.assertMetricsAre(expValuesReducer, expValuesMapper, act);
    }

    private Map<String, Long> fetchAllMetrics(int nodeIdx) {
        return Stream.of(ALL_METRICS).collect(Collectors.toMap(mName -> mName, mName -> this.longMetricValue(nodeIdx, (String)mName)));
    }

    private void assertMetricsAre(Map<String, Long> expMetricsReducer, Map<String, Long> expMetricsMapper, Runnable act) {
        act.run();
        expMetricsReducer.forEach((mName, expVal) -> {
            long actVal = this.longMetricValue(0, (String)mName);
            Assert.assertEquals((String)("Unexpected value for metric " + mName), (long)expVal, (long)actVal);
        });
        expMetricsMapper.forEach((mName, expVal) -> {
            long actVal = this.longMetricValue(1, (String)mName);
            Assert.assertEquals((String)("Unexpected value for metric " + mName), (long)expVal, (long)actVal);
        });
    }

    protected long longMetricValue(int gridIdx, String metricName) {
        MetricRegistry sqlMemReg = this.grid(gridIdx).context().metric().registry("sql.queries.user");
        Metric metric = sqlMemReg.findMetric(metricName);
        Assert.assertNotNull((String)("Didn't find metric " + metricName), (Object)metric);
        Assert.assertTrue((String)("Expected long metric, but got " + metric.getClass()), (boolean)(metric instanceof LongMetric));
        return ((LongMetric)metric).value();
    }

    protected void startAndKillQuery(SqlFieldsQuery query) {
        IgniteInternalFuture qryCanceled = this.runAsyncX(() -> GridTestUtils.assertThrowsAnyCause((IgniteLogger)log, () -> this.jcache(0).query(query).getAll(), QueryCancelledException.class, null));
        try {
            SqlStatisticsAbstractTest.SuspendQuerySqlFunctions.awaitQueryStopsInTheMiddle();
            this.killAsyncAllQueriesOn(0);
            TimeUnit.SECONDS.sleep(1L);
            SqlStatisticsAbstractTest.SuspendQuerySqlFunctions.resumeQueryExecution();
            qryCanceled.get(15L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void killAsyncAllQueriesOn(int nodeIdx) {
        IgniteEx node = this.grid(nodeIdx);
        Collection queries = node.context().query().getIndexing().runningQueries(-1L);
        for (GridRunningQueryInfo queryInfo : queries) {
            String killId = queryInfo.globalQueryId();
            node.context().query().querySqlFields(new SqlFieldsQuery("KILL QUERY ASYNC '" + killId + "'").setSchema("PUBLIC"), false);
        }
    }
}

