/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.query;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.TreeSet;
import javax.cache.Cache;
import javax.cache.CacheException;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.cache.query.IndexQuery;
import org.apache.ignite.cache.query.IndexQueryCriteriaBuilder;
import org.apache.ignite.cache.query.IndexQueryCriterion;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class IndexQuerySqlIndexTest
extends GridCommonAbstractTest {
    private static final String CACHE = "TEST_CACHE";
    private static final String CACHE_TABLE = "TEST_CACHE_TABLE";
    private static final String TABLE = "TEST_TABLE";
    private static final String VALUE_TYPE = "MY_VALUE_TYPE";
    private static final String DESC_ID_IDX = "DESC_ID_IDX";
    private static final int CNT = 10000;
    @Parameterized.Parameter
    public String qryDescIdxName;
    private IgniteCache<Object, Object> cache;
    private IgniteCache<Object, Object> tblCache;
    private Ignite crd;

    @Parameterized.Parameters(name="qryIdxName={0}")
    public static Collection<?> testParams() {
        return Arrays.asList(null, DESC_ID_IDX);
    }

    protected void beforeTest() throws Exception {
        this.crd = this.startGrids(2);
        this.cache = this.crd.createCache(new CacheConfiguration().setName(CACHE));
    }

    protected void afterTest() {
        this.stopAllGrids();
    }

    @Test
    public void testEmptyCache() {
        this.prepareTable(Person.class.getName(), DESC_ID_IDX, "descId", false);
        this.tblCache = this.crd.cache(CACHE_TABLE);
        IndexQuery qry = new IndexQuery(Person.class.getSimpleName(), this.qryDescIdxName).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.lte((String)"descId", (Object)Integer.MAX_VALUE)});
        IndexQuerySqlIndexTest.assertTrue((boolean)this.tblCache.query((Query)qry).getAll().isEmpty());
        qry = new IndexQuery(Person.class.getSimpleName(), this.qryDescIdxName);
        IndexQuerySqlIndexTest.assertTrue((boolean)this.tblCache.query((Query)qry).getAll().isEmpty());
    }

    @Test
    public void testWrongCache() {
        this.prepareTable(Person.class.getName(), DESC_ID_IDX, "descId", false);
        this.tblCache = this.crd.cache(CACHE_TABLE);
        GridTestUtils.assertThrowsAnyCause(null, () -> {
            IndexQuery wrongQry = new IndexQuery(Person.class.getSimpleName(), this.qryDescIdxName).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.lt((String)"descId", (Object)Integer.MAX_VALUE)});
            return this.cache.query((Query)wrongQry).getAll();
        }, CacheException.class, (String)"Indexing is disabled for cache: TEST_CACHE");
    }

    @Test
    public void testRangeQueries() {
        this.prepareTable(Person.class.getName(), DESC_ID_IDX, "descId", true);
        int pivot = new Random().nextInt(10000);
        this.tblCache = this.crd.cache(CACHE_TABLE);
        IndexQuery qry = new IndexQuery(Person.class.getSimpleName(), this.qryDescIdxName).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.lt((String)"descId", (Object)pivot)});
        this.check((IndexQuery<Long, Person>)qry, 0, pivot);
        qry = new IndexQuery(Person.class.getSimpleName(), this.qryDescIdxName).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.lt((String)"DESCID", (Object)pivot)});
        this.check((IndexQuery<Long, Person>)qry, 0, pivot);
        qry = new IndexQuery(Person.class.getSimpleName(), "_key_PK");
        this.check((IndexQuery<Long, Person>)qry, 0, 10000);
    }

    @Test
    public void testEscapedColumnName() {
        this.prepareTable(Person.class.getName(), DESC_ID_IDX, "\"descId\"", true);
        int pivot = new Random().nextInt(10000);
        this.tblCache = this.crd.cache(CACHE_TABLE);
        IndexQuery qry = new IndexQuery(Person.class.getSimpleName(), this.qryDescIdxName).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.lt((String)"descId", (Object)pivot)});
        this.check((IndexQuery<Long, Person>)qry, 0, pivot);
        GridTestUtils.assertThrowsAnyCause(null, () -> {
            IndexQuery wrongQry = new IndexQuery(Person.class, this.qryDescIdxName).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.lt((String)"DESCID", (Object)Integer.MAX_VALUE)});
            return this.tblCache.query((Query)wrongQry).getAll();
        }, CacheException.class, (String)"Column \"DESCID\" not found");
    }

    @Test
    public void testEscapedIndexName() {
        this.prepareTable(Person.class.getName(), "\"" + DESC_ID_IDX.toLowerCase() + "\"", "descId", true);
        int pivot = new Random().nextInt(10000);
        this.tblCache = this.crd.cache(CACHE_TABLE);
        String idx = this.qryDescIdxName == null ? this.qryDescIdxName : this.qryDescIdxName.toLowerCase();
        IndexQuery qry = new IndexQuery(Person.class.getSimpleName(), idx).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.lt((String)"descId", (Object)pivot)});
        this.check((IndexQuery<Long, Person>)qry, 0, pivot);
        if (this.qryDescIdxName != null) {
            GridTestUtils.assertThrowsAnyCause(null, () -> {
                IndexQuery wrongQry = new IndexQuery(Person.class, this.qryDescIdxName).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.lt((String)"descId", (Object)Integer.MAX_VALUE)});
                return this.tblCache.query((Query)wrongQry).getAll();
            }, CacheException.class, (String)"Index \"DESC_ID_IDX\" not found");
        }
    }

    @Test
    public void testRangeQueriesWithKeepBinary() {
        this.prepareTable(Person.class.getName(), DESC_ID_IDX, "descId", true);
        int pivot = new Random().nextInt(10000);
        this.tblCache = this.crd.cache(CACHE_TABLE).withKeepBinary();
        IndexQuery qry = new IndexQuery(Person.class.getSimpleName(), this.qryDescIdxName).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.lt((String)"descId", (Object)pivot)});
        this.checkBinary((QueryCursor<Cache.Entry<Long, BinaryObject>>)this.tblCache.query((Query)qry), 0, pivot);
    }

    @Test
    public void testRangeQueriesWithValueType() {
        this.prepareTable(VALUE_TYPE, DESC_ID_IDX, "descId", true);
        int pivot = new Random().nextInt(10000);
        this.tblCache = this.crd.cache(CACHE_TABLE).withKeepBinary();
        IndexQuery qry = new IndexQuery(VALUE_TYPE, this.qryDescIdxName).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.lt((String)"descId", (Object)pivot)});
        this.checkBinary((QueryCursor<Cache.Entry<Long, BinaryObject>>)this.tblCache.query((Query)qry), 0, pivot);
    }

    @Test
    public void testReverseFieldOrder() {
        this.prepareTable(Person.class.getName(), DESC_ID_IDX, "descId", true);
        int pivot = new Random().nextInt(10000);
        this.tblCache = this.crd.cache(CACHE_TABLE);
        IndexQuery qry = new IndexQuery(Person.class.getSimpleName(), this.qryDescIdxName).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.eq((String)"_KEY", (Object)pivot), IndexQueryCriteriaBuilder.lte((String)"descId", (Object)pivot)});
        this.check((IndexQuery<Long, Person>)qry, pivot, pivot + 1);
    }

    private void check(IndexQuery<Long, Person> qry, int left, int right) {
        List all = this.tblCache.query(qry).getAll();
        if (qry.getIndexName() == null) {
            all.sort((o1, o2) -> Long.compare((Long)o2.getKey(), (Long)o1.getKey()));
        }
        boolean pk = "_key_PK".equals(qry.getIndexName());
        IndexQuerySqlIndexTest.assertEquals((int)(right - left), (int)all.size());
        for (int i = 0; i < all.size(); ++i) {
            Cache.Entry entry = (Cache.Entry)all.get(i);
            int exp = pk ? left + i : right - i - 1;
            IndexQuerySqlIndexTest.assertEquals((int)exp, (int)((Long)entry.getKey()).intValue());
            IndexQuerySqlIndexTest.assertEquals((Object)new Person(((Long)entry.getKey()).intValue()), (Object)((Cache.Entry)all.get(i)).getValue());
        }
    }

    private void checkBinary(QueryCursor<Cache.Entry<Long, BinaryObject>> cursor, int left, int right) {
        List all = cursor.getAll();
        IndexQuerySqlIndexTest.assertEquals((int)(right - left), (int)all.size());
        if (this.qryDescIdxName == null) {
            TreeSet<Integer> expected = new TreeSet<Integer>();
            TreeSet<Integer> actual = new TreeSet<Integer>();
            for (int i = 0; i < all.size(); ++i) {
                Cache.Entry entry = (Cache.Entry)all.get(i);
                expected.add(right - 1 - i);
                actual.add(((Long)entry.getKey()).intValue());
                IndexQuerySqlIndexTest.assertEquals((int)((Long)entry.getKey()).intValue(), (int)((Integer)((BinaryObject)entry.getValue()).field("id")));
                IndexQuerySqlIndexTest.assertEquals((int)((Long)entry.getKey()).intValue(), (int)((Integer)((BinaryObject)entry.getValue()).field("descId")));
            }
            IndexQuerySqlIndexTest.assertEqualsCollections(expected, actual);
            return;
        }
        for (int i = 0; i < all.size(); ++i) {
            Cache.Entry entry = (Cache.Entry)all.get(i);
            IndexQuerySqlIndexTest.assertEquals((int)(right - 1 - i), (int)((Long)entry.getKey()).intValue());
            IndexQuerySqlIndexTest.assertEquals((int)((Long)entry.getKey()).intValue(), (int)((Integer)((BinaryObject)entry.getValue()).field("id")));
            IndexQuerySqlIndexTest.assertEquals((int)((Long)entry.getKey()).intValue(), (int)((Integer)((BinaryObject)entry.getValue()).field("descId")));
        }
    }

    private void prepareTable(String valType, String idxName, String descIdFld, boolean insert) {
        SqlFieldsQuery qry = new SqlFieldsQuery("create table TEST_TABLE (prim_id long PRIMARY KEY, id int, " + descIdFld + " int) with \"VALUE_TYPE=" + valType + ",CACHE_NAME=" + CACHE_TABLE + "\";");
        this.cache.query(qry);
        qry = new SqlFieldsQuery("create index " + idxName + " on " + TABLE + " (" + descIdFld + " DESC);");
        this.cache.query(qry);
        if (insert) {
            qry = new SqlFieldsQuery("insert into TEST_TABLE (prim_id, id, " + descIdFld + ") values(?, ?, ?);");
            for (int i = 0; i < 10000; ++i) {
                qry.setArgs(new Object[]{(long)i, i, i});
                this.cache.query(qry);
            }
        }
    }

    private static class Person {
        final int id;
        final int descId;

        Person(int id) {
            this.id = id;
            this.descId = id;
        }

        public String toString() {
            return "Person[id=" + this.id + "]";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Person person = (Person)o;
            return Objects.equals(this.id, person.id) && Objects.equals(this.descId, person.descId);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.descId);
        }
    }
}

