/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.query;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import javax.cache.Cache;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.QueryIndex;
import org.apache.ignite.cache.query.IndexQuery;
import org.apache.ignite.cache.query.IndexQueryCriteriaBuilder;
import org.apache.ignite.cache.query.IndexQueryCriterion;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class IndexQueryQueryEntityTest
extends GridCommonAbstractTest {
    private static final String CACHE = "TEST_CACHE";
    private static final String CACHE_TBL_NAME = "TEST_CACHE_TBL_NAME";
    private static final String TABLE = "TEST_TABLE";
    private static final String ID_IDX = "ID_IDX";
    private static final String DESC_ID_IDX = "DESC_ID_IDX";
    private static final int CNT = 10000;
    @Parameterized.Parameter
    public String qryIdx;
    @Parameterized.Parameter(value=1)
    public String qryDescIdx;
    private static IgniteCache<Long, Person> cache;
    private static IgniteCache<Long, Person> cacheTblName;

    @Parameterized.Parameters(name="qryIdx={0}, qryDescIdx={1}")
    public static List<Object[]> params() {
        return F.asList((Object[])new Object[][]{{null, null}, {ID_IDX, DESC_ID_IDX}});
    }

    protected void beforeTestsStarted() throws Exception {
        IgniteEx crd = this.startGrids(4);
        cache = crd.cache(CACHE);
        cacheTblName = crd.cache(CACHE_TBL_NAME);
    }

    protected void afterTest() throws Exception {
        cache.clear();
        cacheTblName.clear();
    }

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        QueryIndex idIdx = new QueryIndex("id", true, ID_IDX);
        QueryIndex descIdIdx = new QueryIndex("descId", false, DESC_ID_IDX);
        QueryEntity e = new QueryEntity(Long.class.getName(), Person.class.getName()).setFields(new LinkedHashMap(F.asMap((Object)"id", (Object)Integer.class.getName(), (Object)"descId", (Object)Integer.class.getName()))).setIndexes(Arrays.asList(idIdx, descIdIdx));
        CacheConfiguration ccfg1 = new CacheConfiguration().setName(CACHE).setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL).setQueryEntities(Collections.singletonList(e));
        QueryEntity entTableName = new QueryEntity(e);
        entTableName.setTableName(TABLE);
        CacheConfiguration ccfg2 = new CacheConfiguration().setName(CACHE_TBL_NAME).setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL).setQueryEntities(Collections.singletonList(entTableName));
        cfg.setCacheConfiguration(new CacheConfiguration[]{ccfg1, ccfg2});
        return cfg;
    }

    @Test
    public void testEmptyCache() {
        IndexQuery qry = new IndexQuery(Person.class, this.qryIdx).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.lt((String)"id", (Object)Integer.MAX_VALUE)});
        IndexQueryQueryEntityTest.assertTrue((boolean)cache.query((Query)qry).getAll().isEmpty());
        qry = new IndexQuery(Person.class, this.qryDescIdx).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.lt((String)"descId", (Object)Integer.MAX_VALUE)});
        IndexQueryQueryEntityTest.assertTrue((boolean)cache.query((Query)qry).getAll().isEmpty());
    }

    @Test
    public void testEmptyCacheTableName() {
        IndexQuery qry = new IndexQuery(Person.class, this.qryIdx).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.lt((String)"id", (Object)Integer.MAX_VALUE)});
        IndexQueryQueryEntityTest.assertTrue((boolean)cacheTblName.query((Query)qry).getAll().isEmpty());
        qry = new IndexQuery(Person.class, this.qryDescIdx).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.lt((String)"descId", (Object)Integer.MAX_VALUE)});
        IndexQueryQueryEntityTest.assertTrue((boolean)cacheTblName.query((Query)qry).getAll().isEmpty());
        qry = new IndexQuery(Person.class, this.qryIdx).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.lt((String)"id", (Object)Integer.MAX_VALUE)});
        IndexQueryQueryEntityTest.assertTrue((boolean)cacheTblName.query((Query)qry).getAll().isEmpty());
        qry = new IndexQuery(Person.class, this.qryDescIdx).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.lt((String)"descId", (Object)Integer.MAX_VALUE)});
        IndexQueryQueryEntityTest.assertTrue((boolean)cacheTblName.query((Query)qry).getAll().isEmpty());
    }

    @Test
    public void testRangeQueries() {
        this.insertData(cache);
        int pivot = new Random().nextInt(10000);
        IndexQuery qry = new IndexQuery(Person.class, this.qryIdx).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.lt((String)"id", (Object)pivot)});
        this.check((QueryCursor<Cache.Entry<Long, Person>>)cache.query((Query)qry), 0, pivot, false);
        IndexQuery descQry = new IndexQuery(Person.class, this.qryDescIdx).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.lt((String)"descId", (Object)pivot)});
        this.check((QueryCursor<Cache.Entry<Long, Person>>)cache.query((Query)descQry), 0, pivot, true);
    }

    @Test
    public void testRangeQueriesCacheTableName() {
        this.insertData(cacheTblName);
        int pivot = new Random().nextInt(10000);
        IndexQuery qry = new IndexQuery(Person.class, this.qryIdx).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.lt((String)"id", (Object)pivot)});
        this.check((QueryCursor<Cache.Entry<Long, Person>>)cacheTblName.query((Query)qry), 0, pivot, false);
        IndexQuery descQry = new IndexQuery(Person.class, this.qryDescIdx).setCriteria(new IndexQueryCriterion[]{IndexQueryCriteriaBuilder.lt((String)"descId", (Object)pivot)});
        this.check((QueryCursor<Cache.Entry<Long, Person>>)cacheTblName.query((Query)descQry), 0, pivot, true);
    }

    private void check(QueryCursor<Cache.Entry<Long, Person>> cursor, int left, int right, boolean desc) {
        List all = cursor.getAll();
        if (this.qryIdx == null) {
            all.sort((e1, e2) -> desc ? Long.compare((Long)e2.getKey(), (Long)e1.getKey()) : Long.compare((Long)e1.getKey(), (Long)e2.getKey()));
        }
        IndexQueryQueryEntityTest.assertEquals((int)(right - left), (int)all.size());
        for (int i = 0; i < all.size(); ++i) {
            Cache.Entry entry = (Cache.Entry)all.get(i);
            int exp = desc ? right - i - 1 : left + i;
            IndexQueryQueryEntityTest.assertEquals((int)exp, (int)((Long)entry.getKey()).intValue());
            IndexQueryQueryEntityTest.assertEquals((Object)new Person(((Long)entry.getKey()).intValue()), (Object)((Cache.Entry)all.get(i)).getValue());
        }
    }

    private void insertData(IgniteCache<Long, Person> cache) {
        for (int i = 0; i < 10000; ++i) {
            cache.put((Object)i, (Object)new Person(i));
        }
    }

    private static class Person {
        final int id;
        final int descId;

        Person(int id) {
            this.id = id;
            this.descId = id;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Person person = (Person)o;
            return Objects.equals(this.id, person.id) && Objects.equals(this.descId, person.descId);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.descId);
        }
    }
}

