/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.opt.join;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.cache.CacheException;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.apache.ignite.internal.processors.query.h2.opt.join.CollocationModelAffinity;
import org.apache.ignite.internal.processors.query.h2.opt.join.CollocationModelMultiplier;
import org.apache.ignite.internal.processors.query.h2.opt.join.CollocationModelType;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlQueryParser;
import org.apache.ignite.internal.processors.query.h2.sql.SplitterContext;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.gridgain.internal.h2.command.dml.Query;
import org.gridgain.internal.h2.command.dml.Select;
import org.gridgain.internal.h2.command.dml.SelectUnion;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.expression.Expression;
import org.gridgain.internal.h2.expression.ExpressionColumn;
import org.gridgain.internal.h2.index.IndexCondition;
import org.gridgain.internal.h2.index.ViewIndex;
import org.gridgain.internal.h2.table.Column;
import org.gridgain.internal.h2.table.IndexColumn;
import org.gridgain.internal.h2.table.SubQueryInfo;
import org.gridgain.internal.h2.table.Table;
import org.gridgain.internal.h2.table.TableFilter;
import org.gridgain.internal.h2.table.TableView;

public final class CollocationModel {
    private static final TableFilter[] EMPTY_FILTERS = new TableFilter[0];
    private final CollocationModel upper;
    private final int filter;
    private final boolean view;
    private CollocationModelMultiplier multiplier;
    private CollocationModelType type;
    private CollocationModel[] children;
    private TableFilter[] childFilters;
    private List<CollocationModel> unions;
    private Select select;
    private final boolean validate;

    private CollocationModel(CollocationModel upper, int filter, boolean view, boolean validate) {
        this.upper = upper;
        this.filter = filter;
        this.view = view;
        this.validate = validate;
    }

    private TableFilter filter() {
        return this.upper == null ? null : this.upper.childFilters[this.filter];
    }

    public String toString() {
        this.calculate();
        SB b = new SB();
        for (int lvl = 0; lvl < 20 && this.toString(b, lvl); ++lvl) {
            b.a('\n');
        }
        return b.toString();
    }

    private boolean toString(SB b, int lvl) {
        boolean res = false;
        if (lvl == 0) {
            TableFilter f = this.filter();
            String tblAlias = f == null ? "^" : f.getTableAlias();
            b.a("[tbl=").a(tblAlias).a(", type=").a((Object)this.type).a(", mul=").a((Object)this.multiplier).a("]");
            res = true;
        } else if (this.childFilters != null) {
            assert (lvl > 0);
            --lvl;
            for (int i = 0; i < this.childFilters.length; ++i) {
                if (lvl == 0) {
                    b.a(" | ");
                }
                res |= this.child(i, true).toString(b, lvl);
            }
            if (lvl == 0) {
                b.a(" | ");
            }
        }
        return res;
    }

    private static CollocationModel createChildModel(CollocationModel upper, int filter, List<CollocationModel> unions, boolean view, boolean validate) {
        CollocationModel child = new CollocationModel(upper, filter, view, validate);
        if (unions != null) {
            assert (upper == null || upper.child(filter, false) != null || unions.isEmpty());
            if (upper != null && unions.isEmpty()) {
                assert (upper.child(filter, false) == null);
                upper.children[filter] = child;
            }
            unions.add(child);
            child.unions = unions;
        } else if (upper != null) {
            assert (upper.child(filter, false) == null);
            upper.children[filter] = child;
        }
        return child;
    }

    private boolean childFilters(TableFilter[] childFilters) {
        assert (childFilters != null);
        assert (this.view);
        Select select = childFilters[0].getSelect();
        assert (this.select == null || this.select == select);
        if (this.select == null) {
            this.select = select;
            assert (this.childFilters == null);
        } else if (Arrays.equals(this.childFilters, childFilters)) {
            return false;
        }
        if (this.childFilters == null || this.childFilters.length != childFilters.length) {
            this.childFilters = (TableFilter[])childFilters.clone();
            this.children = new CollocationModel[childFilters.length];
        } else {
            System.arraycopy(childFilters, 0, this.childFilters, 0, childFilters.length);
            Arrays.fill(this.children, null);
        }
        this.type = null;
        this.multiplier = null;
        return true;
    }

    private void calculate() {
        if (this.type != null) {
            return;
        }
        if (this.view) {
            assert (this.childFilters != null);
            boolean collocated = true;
            boolean partitioned = false;
            CollocationModelMultiplier maxMultiplier = CollocationModelMultiplier.COLLOCATED;
            for (int i = 0; i < this.childFilters.length; ++i) {
                CollocationModel child = this.child(i, true);
                CollocationModelType t = child.type(true);
                if (child.multiplier == CollocationModelMultiplier.REPLICATED_NOT_LAST) {
                    maxMultiplier = child.multiplier;
                }
                if (!t.isPartitioned()) continue;
                partitioned = true;
                if (t.isCollocated()) continue;
                collocated = false;
                CollocationModelMultiplier m = child.multiplier(true);
                if (m.multiplier() > maxMultiplier.multiplier() && (maxMultiplier = m) == CollocationModelMultiplier.REPLICATED_NOT_LAST) break;
            }
            this.type = CollocationModelType.of(partitioned, collocated);
            this.multiplier = maxMultiplier;
        } else {
            assert (this.upper != null);
            assert (this.childFilters == null);
            Table tbl = this.filter().getTable();
            if (!(tbl instanceof GridH2Table) || !((GridH2Table)tbl).isPartitioned()) {
                this.type = CollocationModelType.REPLICATED;
                this.multiplier = CollocationModelMultiplier.COLLOCATED;
                return;
            }
            if (!this.upper.isPartitionedTableBeforeExists(this.filter)) {
                this.type = CollocationModelType.PARTITIONED_COLLOCATED;
                this.multiplier = CollocationModelMultiplier.COLLOCATED;
            } else {
                switch (this.upper.joinedWithCollocated(this.filter)) {
                    case COLLOCATED_JOIN: {
                        this.type = CollocationModelType.PARTITIONED_COLLOCATED;
                        this.multiplier = CollocationModelMultiplier.COLLOCATED;
                        break;
                    }
                    case HAS_AFFINITY_CONDITION: {
                        this.type = CollocationModelType.PARTITIONED_NOT_COLLOCATED;
                        this.multiplier = CollocationModelMultiplier.UNICAST;
                        break;
                    }
                    case NONE: {
                        this.type = CollocationModelType.PARTITIONED_NOT_COLLOCATED;
                        this.multiplier = CollocationModelMultiplier.BROADCAST;
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
            if (this.upper.isPreviousTableReplicated(this.filter)) {
                this.multiplier = CollocationModelMultiplier.REPLICATED_NOT_LAST;
            }
        }
    }

    private boolean isPartitionedTableBeforeExists(int filterIdx) {
        for (int idx = 0; idx < filterIdx; ++idx) {
            CollocationModel child = this.child(idx, false);
            if (child == null || !child.type(true).isPartitioned()) continue;
            return true;
        }
        return this.upper != null && this.upper.isPartitionedTableBeforeExists(this.filter);
    }

    private boolean isPreviousTableReplicated(int filterIdx) {
        if (filterIdx == 0) {
            return false;
        }
        CollocationModel child = this.child(filterIdx - 1, false);
        if (child != null && child.type(true) == CollocationModelType.REPLICATED) {
            return true;
        }
        return this.upper != null && this.upper.isPreviousTableReplicated(this.filter);
    }

    private CollocationModelAffinity joinedWithCollocated(int f) {
        TableFilter tf = this.childFilters[f];
        GridH2Table tbl = (GridH2Table)tf.getTable();
        if (this.validate) {
            if (tbl.isCustomAffinityMapper()) {
                throw CollocationModel.customAffinityError(tbl.cacheName());
            }
            if (F.isEmpty((Collection)tf.getIndexConditions())) {
                throw new CacheException("Failed to prepare distributed join query: join condition does not use index [joinedCache=" + tbl.cacheName() + ", plan=" + tf.getSelect().getPlanSQL(false) + ']');
            }
        }
        IndexColumn affCol = tbl.getAffinityKeyColumn();
        boolean affKeyCondFound = false;
        if (affCol != null) {
            ArrayList idxConditions = tf.getIndexConditions();
            int affColId = affCol.column.getColumnId();
            for (int i = 0; i < idxConditions.size(); ++i) {
                CollocationModelType t;
                CollocationModel cm;
                ExpressionColumn expCol;
                TableFilter prevJoin;
                int colId;
                IndexCondition c = (IndexCondition)idxConditions.get(i);
                int cmpType = c.getCompareType();
                if (cmpType != 0 && cmpType != 16 || (colId = c.getColumn().getColumnId()) != affColId && !tbl.rowDescriptor().isKeyColumn(colId) || !c.isEvaluatable()) continue;
                affKeyCondFound = true;
                Expression exp = c.getExpression();
                if (!((exp = exp.getNonAliasExpression()) instanceof ExpressionColumn) || (prevJoin = (expCol = (ExpressionColumn)exp).getTableFilter()) == null || (cm = this.child(this.indexOf(prevJoin), true)) == null || cm.view || !(t = cm.type(true)).isPartitioned() || !t.isCollocated() || !CollocationModel.isAffinityColumn(prevJoin, expCol, this.validate)) continue;
                return CollocationModelAffinity.COLLOCATED_JOIN;
            }
        }
        return affKeyCondFound ? CollocationModelAffinity.HAS_AFFINITY_CONDITION : CollocationModelAffinity.NONE;
    }

    private int indexOf(TableFilter f) {
        for (int i = 0; i < this.childFilters.length; ++i) {
            if (this.childFilters[i] != f) continue;
            return i;
        }
        throw new IllegalStateException();
    }

    private static boolean isAffinityColumn(TableFilter f, ExpressionColumn expCol, boolean validate) {
        Column col = expCol.getColumn();
        if (col == null) {
            return false;
        }
        Table t = col.getTable();
        if (t.isView()) {
            Query qry = f.getIndex() != null ? CollocationModel.getSubQuery(f) : GridSqlQueryParser.VIEW_QUERY.get((TableView)t);
            return CollocationModel.isAffinityColumn(qry, expCol, validate);
        }
        if (t instanceof GridH2Table) {
            GridH2Table t0 = (GridH2Table)t;
            if (validate && t0.isCustomAffinityMapper()) {
                throw CollocationModel.customAffinityError(t0.cacheName());
            }
            IndexColumn affCol = t0.getAffinityKeyColumn();
            return affCol != null && col.getColumnId() == affCol.column.getColumnId();
        }
        return false;
    }

    private static boolean isAffinityColumn(Query qry, ExpressionColumn expCol, boolean validate) {
        if (qry.isUnion()) {
            SelectUnion union = (SelectUnion)qry;
            return CollocationModel.isAffinityColumn(union.getLeft(), expCol, validate) && CollocationModel.isAffinityColumn(union.getRight(), expCol, validate);
        }
        Expression exp = ((Expression)qry.getExpressions().get(expCol.getColumn().getColumnId())).getNonAliasExpression();
        if (exp instanceof ExpressionColumn) {
            expCol = (ExpressionColumn)exp;
            return CollocationModel.isAffinityColumn(expCol.getTableFilter(), expCol, validate);
        }
        return false;
    }

    private CollocationModelMultiplier multiplier(boolean withUnion) {
        this.calculate();
        assert (this.multiplier != null);
        if (withUnion && this.unions != null) {
            CollocationModelMultiplier maxMultiplier = null;
            for (int i = 0; i < this.unions.size(); ++i) {
                CollocationModelMultiplier m = this.unions.get(i).multiplier(false);
                if (maxMultiplier != null && m.multiplier() <= maxMultiplier.multiplier()) continue;
                maxMultiplier = m;
            }
            assert (maxMultiplier != null);
            return maxMultiplier;
        }
        return this.multiplier;
    }

    private CollocationModelType type(boolean withUnion) {
        this.calculate();
        assert (this.type != null);
        if (withUnion && this.unions != null) {
            CollocationModelType left = this.unions.get(0).type(false);
            for (int i = 1; i < this.unions.size(); ++i) {
                CollocationModelType right = this.unions.get(i).type(false);
                if (!left.isCollocated() || !right.isCollocated()) {
                    left = CollocationModelType.PARTITIONED_NOT_COLLOCATED;
                    break;
                }
                left = !left.isPartitioned() && !right.isPartitioned() ? CollocationModelType.REPLICATED : CollocationModelType.PARTITIONED_COLLOCATED;
            }
            return left;
        }
        return this.type;
    }

    private CollocationModel child(int i, boolean create) {
        CollocationModel child = this.children[i];
        if (child == null && create) {
            TableFilter f = this.childFilters[i];
            child = f.getTable().isView() ? (f.getIndex() == null ? CollocationModel.createChildModel(this, i, null, true, this.validate) : CollocationModel.buildCollocationModel(this, i, CollocationModel.getSubQuery(f), null, this.validate)) : CollocationModel.createChildModel(this, i, null, false, this.validate);
            assert (child != null);
            assert (this.children[i] == child);
        }
        return child;
    }

    private static Query getSubQuery(TableFilter f) {
        return ((ViewIndex)f.getIndex()).getQuery();
    }

    private List<CollocationModel> getOrCreateUnions() {
        if (this.unions == null) {
            this.unions = new ArrayList<CollocationModel>(4);
            this.unions.add(this);
        }
        return this.unions;
    }

    public static CollocationModelMultiplier distributedMultiplier(Session ses, TableFilter[] filters, int filter) {
        SplitterContext ctx = SplitterContext.get();
        if (!ctx.distributedJoins() || !ses.isJoinBatchEnabled() || ses.isPreparingQueryExpression()) {
            return CollocationModelMultiplier.COLLOCATED;
        }
        assert (filters != null);
        CollocationModel.clearViewIndexCache(ses);
        CollocationModel model = CollocationModel.buildCollocationModel(ctx, ses.getSubQueryInfo(), filters, filter, false);
        return model.multiplier(false);
    }

    private static CollocationModel buildCollocationModel(SplitterContext ctx, SubQueryInfo info, TableFilter[] filters, int filter, boolean validate) {
        CollocationModel cm;
        if (info != null) {
            cm = CollocationModel.buildCollocationModel(ctx, info.getUpper(), info.getFilters(), info.getFilter(), validate);
        } else {
            cm = ctx.collocationModel();
            if (cm == null) {
                cm = CollocationModel.createChildModel(null, -1, null, true, validate);
                ctx.collocationModel(cm);
            }
        }
        if (filters == null) {
            return cm;
        }
        assert (cm.view);
        Select select = filters[0].getSelect();
        if (cm.select != null && cm.select != select) {
            List<CollocationModel> unions = cm.getOrCreateUnions();
            for (int i = 1; i < unions.size(); ++i) {
                CollocationModel u = unions.get(i);
                if (u.select != select) continue;
                cm = u;
                break;
            }
            if (cm.select != select) {
                cm = CollocationModel.createChildModel(cm.upper, cm.filter, unions, true, validate);
            }
        }
        cm.childFilters(filters);
        return cm.child(filter, true);
    }

    public static boolean isCollocated(Query qry) {
        CollocationModel mdl = CollocationModel.buildCollocationModel(null, -1, qry, null, true);
        CollocationModelType type = mdl.type(true);
        if (!type.isCollocated() && mdl.multiplier == CollocationModelMultiplier.REPLICATED_NOT_LAST) {
            throw new CacheException("Failed to execute query: for distributed join all REPLICATED caches must be at the end of the joined tables list.");
        }
        return type.isCollocated();
    }

    private static CollocationModel buildCollocationModel(CollocationModel upper, int filter, Query qry, List<CollocationModel> unions, boolean validate) {
        if (qry.isUnion()) {
            if (unions == null) {
                unions = new ArrayList<CollocationModel>();
            }
            SelectUnion union = (SelectUnion)qry;
            CollocationModel left = CollocationModel.buildCollocationModel(upper, filter, union.getLeft(), unions, validate);
            CollocationModel right = CollocationModel.buildCollocationModel(upper, filter, union.getRight(), unions, validate);
            assert (left != null);
            assert (right != null);
            return upper != null ? upper : left;
        }
        Select select = (Select)qry;
        ArrayList<TableFilter> list = new ArrayList<TableFilter>();
        for (TableFilter f = select.getTopTableFilter(); f != null; f = f.getJoin()) {
            list.add(f);
        }
        TableFilter[] filters = list.toArray(EMPTY_FILTERS);
        CollocationModel cm = CollocationModel.createChildModel(upper, filter, unions, true, validate);
        cm.childFilters(filters);
        for (int i = 0; i < filters.length; ++i) {
            TableFilter f = filters[i];
            if (f.getTable().isView()) {
                CollocationModel.buildCollocationModel(cm, i, CollocationModel.getSubQuery(f), null, validate);
                continue;
            }
            if (!(f.getTable() instanceof GridH2Table)) continue;
            CollocationModel.createChildModel(cm, i, null, false, validate);
        }
        return upper != null ? upper : cm;
    }

    private static CacheException customAffinityError(String cacheName) {
        return new CacheException("Failed to prepare distributed join query: can not use distributed joins for cache with custom AffinityKeyMapper configured. Please use AffinityKeyMapped annotation instead [cache=" + cacheName + ']');
    }

    private static void clearViewIndexCache(Session ses) {
        Map viewIdxCache = ses.getViewIndexCache(true);
        if (!viewIdxCache.isEmpty()) {
            viewIdxCache.clear();
        }
    }
}

