/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRow;
import org.apache.ignite.internal.processors.query.GridQueryProcessor;
import org.apache.ignite.internal.processors.query.QueryTypeDescriptorImpl;
import org.apache.ignite.internal.processors.query.h2.H2TableDescriptor;
import org.apache.ignite.internal.processors.query.h2.opt.GridLuceneIndex;
import org.apache.ignite.internal.processors.query.schema.SchemaIndexCacheVisitorClosure;
import org.apache.ignite.internal.util.typedef.F;
import org.jetbrains.annotations.Nullable;

public class TextIndexRebuildClosure
implements SchemaIndexCacheVisitorClosure {
    private final GridQueryProcessor qryProc;
    private final GridCacheContext cctx;
    private final Map<String, GridLuceneIndex> luceneIdxByTblName;
    private final GridLuceneIndex luceneIdx;

    public TextIndexRebuildClosure(GridQueryProcessor qryProc, GridCacheContext cctx, Collection<H2TableDescriptor> descriptors) {
        this.qryProc = qryProc;
        this.cctx = cctx;
        assert (descriptors != null);
        if (descriptors.size() == 1) {
            this.luceneIdx = ((H2TableDescriptor)F.first(descriptors)).luceneIndex();
            this.luceneIdxByTblName = null;
        } else {
            this.luceneIdx = null;
            this.luceneIdxByTblName = Collections.unmodifiableMap(descriptors.stream().collect(Collectors.toMap(H2TableDescriptor::tableName, H2TableDescriptor::luceneIndex)));
        }
    }

    public void apply(CacheDataRow row) throws IgniteCheckedException {
        GridLuceneIndex luceneIndex0;
        if (this.luceneIdx != null) {
            luceneIndex0 = this.luceneIdx;
        } else {
            @Nullable QueryTypeDescriptorImpl type = this.qryProc.typeByValue(this.cctx.name(), this.cctx.cacheObjectContext(), row.key(), row.value(), false);
            if (type == null) {
                return;
            }
            luceneIndex0 = this.luceneIdxByTblName.get(type.tableName());
        }
        if (luceneIndex0 == null) {
            return;
        }
        long expireTime = row.expireTime();
        if (expireTime == 0L) {
            expireTime = Long.MAX_VALUE;
        }
        luceneIndex0.store((CacheObject)row.key(), row.value(), row.version(), expireTime);
    }
}

