/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import javax.cache.CacheException;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.cache.query.annotations.QuerySqlFunction;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.CacheObjectValueContext;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.QueryCursorImpl;
import org.apache.ignite.internal.processors.cache.mvcc.MvccUtils;
import org.apache.ignite.internal.processors.cache.query.QueryTable;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcParameterMeta;
import org.apache.ignite.internal.processors.query.GridQueryFieldMetadata;
import org.apache.ignite.internal.processors.query.GridQueryIndexing;
import org.apache.ignite.internal.processors.query.GridQueryProperty;
import org.apache.ignite.internal.processors.query.GridQueryTypeDescriptor;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.processors.query.QueryUtils;
import org.apache.ignite.internal.processors.query.h2.ConnectionManager;
import org.apache.ignite.internal.processors.query.h2.H2DatabaseType;
import org.apache.ignite.internal.processors.query.h2.H2MemoryTracker;
import org.apache.ignite.internal.processors.query.h2.H2PooledConnection;
import org.apache.ignite.internal.processors.query.h2.H2QueryContext;
import org.apache.ignite.internal.processors.query.h2.H2SqlFieldMetadata;
import org.apache.ignite.internal.processors.query.h2.H2TableDescriptor;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2IndexBase;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2RetryException;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2RowDescriptor;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2ValueCacheObject;
import org.apache.ignite.internal.processors.query.h2.opt.QueryContext;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2RowMessage;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2ValueMessage;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2ValueMessageFactory;
import org.apache.ignite.internal.util.GridStringBuilder;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.gridgain.internal.h2.api.AggregateFunction;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.expression.aggregate.AggregateData;
import org.gridgain.internal.h2.jdbc.JdbcConnection;
import org.gridgain.internal.h2.result.Row;
import org.gridgain.internal.h2.store.DataHandler;
import org.gridgain.internal.h2.table.Column;
import org.gridgain.internal.h2.table.IndexColumn;
import org.gridgain.internal.h2.util.JdbcUtils;
import org.gridgain.internal.h2.util.LocalDateTimeUtils;
import org.gridgain.internal.h2.util.Utils;
import org.gridgain.internal.h2.value.DataType;
import org.gridgain.internal.h2.value.Value;
import org.gridgain.internal.h2.value.ValueArray;
import org.gridgain.internal.h2.value.ValueBoolean;
import org.gridgain.internal.h2.value.ValueByte;
import org.gridgain.internal.h2.value.ValueBytes;
import org.gridgain.internal.h2.value.ValueDate;
import org.gridgain.internal.h2.value.ValueDecimal;
import org.gridgain.internal.h2.value.ValueDouble;
import org.gridgain.internal.h2.value.ValueFloat;
import org.gridgain.internal.h2.value.ValueGeometry;
import org.gridgain.internal.h2.value.ValueInt;
import org.gridgain.internal.h2.value.ValueJavaObject;
import org.gridgain.internal.h2.value.ValueLong;
import org.gridgain.internal.h2.value.ValueNull;
import org.gridgain.internal.h2.value.ValueRow;
import org.gridgain.internal.h2.value.ValueShort;
import org.gridgain.internal.h2.value.ValueString;
import org.gridgain.internal.h2.value.ValueTime;
import org.gridgain.internal.h2.value.ValueTimestamp;
import org.gridgain.internal.h2.value.ValueUuid;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class H2Utils {
    public static final int DFLT_HASH_JOIN_MAX_TABLE_SIZE = 100000;
    public static final String IGNITE_SQL_ALLOW_IMPLICIT_PK = "IGNITE_SQL_ALLOW_IMPLICIT_PK";
    public static final int STRING_DEFAULT_PRECISION = Integer.MAX_VALUE;
    public static final int BINARY_DEFAULT_PRECISION = Integer.MAX_VALUE;
    public static final int GEOMETRY_DEFAULT_PRECISION = Integer.MAX_VALUE;
    public static final int DECIMAL_DEFAULT_PRECISION = 65535;
    public static final int DECIMAL_DEFAULT_SCALE = Short.MAX_VALUE;
    public static final int BOOLEAN_DEFAULT_PRECISION = 1;
    public static final int BYTE_DEFAULT_PRECISION = 3;
    public static final int SHORT_DEFAULT_PRECISION = 5;
    public static final int INTEGER_DEFAULT_PRECISION = 10;
    public static final int LONG_DEFAULT_PRECISION = 19;
    public static final int DOUBLE_DEFAULT_PRECISION = 17;
    public static final int REAL_DEFAULT_PRECISION = 7;
    public static final int UUID_DEFAULT_PRECISION = 16;
    public static final int TIME_DEFAULT_PRECISION = 8;
    public static final int DATE_DEFAULT_PRECISION = 10;
    public static final int TIMESTAMP_DEFAULT_PRECISION = 26;
    public static final int TIMESTAMP_DEFAULT_SCALE = 6;
    public static final List<GridQueryFieldMetadata> UPDATE_RESULT_META = Collections.singletonList(new H2SqlFieldMetadata(null, null, "UPDATED", Long.class.getName(), -1, -1, 2));
    public static final IndexColumn[] EMPTY_COLUMNS = new IndexColumn[0];
    private static final String SPATIAL_IDX_CLS = "org.apache.ignite.internal.processors.query.h2.opt.GridH2SpatialIndex";
    private static final char ESC_CH = '\"';
    private static int hashJoinMaxTableSize = IgniteSystemProperties.getInteger((String)"IGNITE_HASH_JOIN_MAX_TABLE_SIZE", (int)100000);
    private static boolean enableHashJoin = IgniteSystemProperties.getBoolean((String)"IGNITE_ENABLE_HASH_JOIN", (boolean)false);
    private static final Map<Class<?>, Integer> defaultPrecisionsByType = H2Utils.knownDefaultPrecisions();
    private static final Map<Class<?>, Integer> defaultScalesByType = H2Utils.knownDefaultScales();
    private static final Map<Integer, Set<Class<?>>> CONVERTABLE_TYPES = new HashMap<Integer, Set<Class<?>>>(){
        {
            this.put(11, new HashSet<Class<?>>(){
                {
                    this.add(LocalDateTime.class);
                    this.add(Date.class);
                    this.add(java.sql.Date.class);
                }
            });
            this.put(9, Collections.singleton(LocalTime.class));
            this.put(10, Collections.singleton(LocalDate.class));
        }
    };

    public static boolean equals(IndexColumn c1, IndexColumn c2) {
        return c1.column.getColumnId() == c2.column.getColumnId();
    }

    public static boolean containsColumn(List<IndexColumn> cols, IndexColumn col) {
        for (int i = cols.size() - 1; i >= 0; --i) {
            if (!H2Utils.equals(cols.get(i), col)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsKeyColumn(GridH2RowDescriptor desc, List<IndexColumn> cols) {
        for (int i = cols.size() - 1; i >= 0; --i) {
            if (!desc.isKeyColumn(cols.get((int)i).column.getColumnId())) continue;
            return true;
        }
        return false;
    }

    public static String tableCreateSql(H2TableDescriptor tbl) {
        String keyFieldName = tbl.type().keyFieldName();
        GridQueryProperty keyByNameProp = keyFieldName == null ? null : tbl.type().property(keyFieldName);
        GridQueryProperty keyProp = keyByNameProp == null ? tbl.type().property("_KEY") : keyByNameProp;
        GridQueryProperty valProp = tbl.type().property("_VAL");
        String keyType = H2Utils.dbTypeFromClass(tbl.type().keyClass(), keyProp == null ? -1 : keyProp.precision(), keyProp == null ? -1 : keyProp.scale());
        String valTypeStr = H2Utils.dbTypeFromClass(tbl.type().valueClass(), valProp == null ? -1 : valProp.precision(), valProp == null ? -1 : valProp.scale());
        SB sql = new SB();
        String keyValVisibility = tbl.type().fields().isEmpty() ? " VISIBLE" : " INVISIBLE";
        sql.a("CREATE TABLE ").a(tbl.fullTableName()).a(" (").a("_KEY").a(' ').a(keyType).a(keyValVisibility).a(" NOT NULL");
        sql.a(',').a("_VAL").a(' ').a(valTypeStr).a(keyValVisibility);
        for (Map.Entry e : tbl.type().fields().entrySet()) {
            GridQueryProperty prop = tbl.type().property((String)e.getKey());
            sql.a(',').a(H2Utils.withQuotes((String)e.getKey())).a(' ').a(H2Utils.dbTypeFromClass((Class)e.getValue(), prop.precision(), prop.scale())).a(prop.notNull() ? " NOT NULL" : "");
        }
        sql.a(')');
        return sql.toString();
    }

    public static String indexCreateSql(String fullTblName, GridH2IndexBase h2Idx, boolean ifNotExists) {
        boolean spatial = F.eq((Object)SPATIAL_IDX_CLS, (Object)((Object)((Object)h2Idx)).getClass().getName());
        GridStringBuilder sb = new SB("CREATE ").a(spatial ? "SPATIAL " : "").a("INDEX ").a(ifNotExists ? "IF NOT EXISTS " : "").a(H2Utils.withQuotes(h2Idx.getName())).a(" ON ").a(fullTblName).a(" (");
        sb.a(H2Utils.indexColumnsSql(h2Idx.getIndexColumns()));
        sb.a(')');
        return sb.toString();
    }

    public static String indexColumnsSql(IndexColumn[] idxCols) {
        SB sb = new SB();
        boolean first = true;
        for (IndexColumn col : idxCols) {
            if (first) {
                first = false;
            } else {
                sb.a(", ");
            }
            sb.a(H2Utils.withQuotes(col.columnName)).a(" ").a(col.sortType == 0 ? "ASC" : "DESC");
        }
        return sb.toString();
    }

    public static String indexDropSql(String schemaName, String idxName, boolean ifExists) {
        return "DROP INDEX " + (ifExists ? "IF EXISTS " : "") + H2Utils.withQuotes(schemaName) + '.' + H2Utils.withQuotes(idxName);
    }

    public static List<IndexColumn> treeIndexColumns(GridH2RowDescriptor desc, List<IndexColumn> cols, IndexColumn keyCol, IndexColumn affCol) {
        assert (keyCol != null);
        if (!H2Utils.containsKeyColumn(desc, cols)) {
            cols.add(keyCol);
        }
        if (affCol != null && !H2Utils.containsColumn(cols, affCol)) {
            cols.add(affCol);
        }
        return cols;
    }

    public static GridH2IndexBase createSpatialIndex(GridH2Table tbl, String idxName, IndexColumn[] cols) {
        try {
            Class<?> cls = Class.forName(SPATIAL_IDX_CLS);
            Constructor<?> ctor = cls.getConstructor(GridH2Table.class, String.class, Integer.TYPE, IndexColumn[].class);
            if (!ctor.isAccessible()) {
                ctor.setAccessible(true);
            }
            int segments = tbl.rowDescriptor().cacheInfo().config().getQueryParallelism();
            return (GridH2IndexBase)((Object)ctor.newInstance(new Object[]{tbl, idxName, segments, cols}));
        }
        catch (Exception e) {
            throw new IgniteException("Failed to instantiate: org.apache.ignite.internal.processors.query.h2.opt.GridH2SpatialIndex", (Throwable)e);
        }
    }

    public static String withQuotes(String str) {
        return '\"' + str + '\"';
    }

    public static List<GridQueryFieldMetadata> meta(ResultSetMetaData rsMeta) throws SQLException {
        ArrayList<GridQueryFieldMetadata> meta = new ArrayList<GridQueryFieldMetadata>(rsMeta.getColumnCount());
        for (int i = 1; i <= rsMeta.getColumnCount(); ++i) {
            String schemaName = rsMeta.getSchemaName(i);
            String typeName = rsMeta.getTableName(i);
            String name = rsMeta.getColumnLabel(i);
            String type = rsMeta.getColumnClassName(i);
            int precision = rsMeta.getPrecision(i);
            int scale = rsMeta.getScale(i);
            int nullability = rsMeta.isNullable(i);
            if (type == null) {
                type = Void.class.getName();
            }
            meta.add(new H2SqlFieldMetadata(schemaName, typeName, name, type, precision, scale, nullability));
        }
        return meta;
    }

    public static List<JdbcParameterMeta> parametersMeta(ParameterMetaData h2ParamsMeta) throws IgniteCheckedException {
        try {
            int paramsSize = h2ParamsMeta.getParameterCount();
            if (paramsSize == 0) {
                return Collections.emptyList();
            }
            ArrayList<JdbcParameterMeta> params = new ArrayList<JdbcParameterMeta>(paramsSize);
            for (int i = 1; i <= paramsSize; ++i) {
                params.add(new JdbcParameterMeta(h2ParamsMeta, i));
            }
            return params;
        }
        catch (SQLException e) {
            throw new IgniteCheckedException("Failed to get parameters metadata", (Throwable)e);
        }
    }

    public static Session session(H2PooledConnection c) {
        return H2Utils.session(c.connection());
    }

    public static Session session(Connection c) {
        return (Session)((JdbcConnection)c).getSession();
    }

    public static void setupConnection(H2PooledConnection conn, QueryContext qctx, boolean distributedJoins, boolean enforceJoinOrder) {
        assert (qctx != null);
        H2Utils.setupConnection(conn, qctx, distributedJoins, enforceJoinOrder, false);
    }

    public static void setupConnection(H2PooledConnection conn, H2QueryContext qctx, boolean distributedJoins, boolean enforceJoinOrder, boolean lazy) {
        Session s = H2Utils.session(conn);
        s.setForceJoinOrder(enforceJoinOrder);
        s.setJoinBatchEnabled(distributedJoins);
        s.setLazyQueryExecution(lazy);
        s.setHashJoinMaxTableSize(hashJoinMaxTableSize);
        s.setHashJoinEnabled(enableHashJoin && !distributedJoins);
        H2QueryContext oldCtx = s.getQueryContext();
        assert (oldCtx == null || oldCtx == qctx || s.memoryTracker() == null) : oldCtx;
        s.setQueryContext(qctx);
    }

    public static void initializeCatalog(H2PooledConnection conn) {
        try {
            conn.connection().getCatalog();
        }
        catch (Throwable e) {
            throw new IgniteSQLException("Failed to setup connection", e);
        }
    }

    public static void resetSession(H2PooledConnection conn) {
        Session s = H2Utils.session(conn);
        if (s == null) {
            return;
        }
        H2MemoryTracker tracker = s.memoryTracker();
        if (tracker != null) {
            tracker.close();
        }
        s.memoryTracker(null);
        s.setQueryContext(null);
    }

    public static Object convert(Object val, IgniteH2Indexing idx, int type) throws IgniteCheckedException {
        if (val == null) {
            return null;
        }
        int objType = H2Utils.getTypeFromClass(val.getClass());
        if (objType == type) {
            return val;
        }
        Value h2Val = H2Utils.wrap(idx.objectContext(), val, objType);
        return h2Val.convertTo(type).getObject();
    }

    private H2Utils() {
    }

    public static boolean isNullValue(Value v) {
        return v == null || v.getType().getValueType() == 0;
    }

    public static QueryCursorImpl<List<?>> zeroCursor() {
        QueryCursorImpl resCur = new QueryCursorImpl(Collections.singletonList(Collections.singletonList(0L)), null, false, false);
        resCur.fieldsMeta(UPDATE_RESULT_META);
        return resCur;
    }

    public static void addUniqueColumns(List<IndexColumn> dest, List<IndexColumn> src) {
        for (IndexColumn col : src) {
            if (H2Utils.containsColumn(dest, col)) continue;
            dest.add(col);
        }
    }

    public static boolean checkAndStartNotStartedCache(GridKernalContext ctx, GridH2Table tbl) {
        if (tbl != null && tbl.isCacheLazy()) {
            String cacheName = tbl.cacheInfo().config().getName();
            try {
                Boolean res = (Boolean)ctx.cache().dynamicStartCache(null, cacheName, null, false, true, true).get();
                return (Boolean)U.firstNotNull((Object[])new Boolean[]{res, Boolean.FALSE});
            }
            catch (IgniteCheckedException ex) {
                throw U.convertException((IgniteCheckedException)ex);
            }
        }
        return false;
    }

    public static boolean isConvertableToColumnType(Class<?> cls, int colType) {
        assert (cls != null);
        if (DataType.getTypeClassName((int)colType, (boolean)false).equals(cls.getName())) {
            return true;
        }
        Set<Class<?>> types = CONVERTABLE_TYPES.get(colType);
        return types != null && types.contains(cls);
    }

    public static Value wrap(CacheObjectValueContext coCtx, Object obj, int type) throws IgniteCheckedException {
        assert (obj != null);
        if (obj instanceof CacheObject) {
            CacheObject co = (CacheObject)obj;
            if (type == 19) {
                return new GridH2ValueCacheObject(co, coCtx);
            }
            obj = co.value(coCtx, false);
        }
        switch (type) {
            case 1: {
                return ValueBoolean.get((boolean)((Boolean)obj));
            }
            case 2: {
                return ValueByte.get((byte)((Byte)obj));
            }
            case 3: {
                return ValueShort.get((short)((Short)obj));
            }
            case 4: {
                return ValueInt.get((int)((Integer)obj));
            }
            case 8: {
                return ValueFloat.get((float)((Float)obj).floatValue());
            }
            case 5: {
                return ValueLong.get((long)((Long)obj));
            }
            case 7: {
                return ValueDouble.get((double)((Double)obj));
            }
            case 20: {
                UUID uuid = (UUID)obj;
                return ValueUuid.get((long)uuid.getMostSignificantBits(), (long)uuid.getLeastSignificantBits());
            }
            case 10: {
                if (LocalDateTimeUtils.LOCAL_DATE == obj.getClass()) {
                    return LocalDateTimeUtils.localDateToDateValue((Object)obj);
                }
                return ValueDate.get((java.sql.Date)((java.sql.Date)obj));
            }
            case 9: {
                if (LocalDateTimeUtils.LOCAL_TIME == obj.getClass()) {
                    return LocalDateTimeUtils.localTimeToTimeValue((Object)obj);
                }
                return ValueTime.get((Time)((Time)obj));
            }
            case 11: {
                if (obj instanceof Date && !(obj instanceof Timestamp)) {
                    obj = new Timestamp(((Date)obj).getTime());
                }
                if (LocalDateTimeUtils.LOCAL_DATE_TIME == obj.getClass()) {
                    return LocalDateTimeUtils.localDateTimeToValue((Object)obj);
                }
                return ValueTimestamp.get((Timestamp)((Timestamp)obj));
            }
            case 6: {
                return ValueDecimal.get((BigDecimal)((BigDecimal)obj));
            }
            case 13: {
                return ValueString.get((String)obj.toString());
            }
            case 12: {
                return ValueBytes.get((byte[])((byte[])obj));
            }
            case 19: {
                return ValueJavaObject.getNoCopy((Object)obj, null, (DataHandler)H2Utils.getHandler(coCtx.kernalContext()));
            }
            case 17: {
                Object[] arr = (Object[])obj;
                Value[] valArr = new Value[arr.length];
                for (int i = 0; i < arr.length; ++i) {
                    Object o = arr[i];
                    valArr[i] = o == null ? ValueNull.INSTANCE : H2Utils.wrap(coCtx, o, H2Utils.getTypeFromClass(o.getClass()));
                }
                return ValueArray.get((Value[])valArr);
            }
            case 22: {
                return ValueGeometry.getFromGeometry((Object)obj);
            }
        }
        throw new IgniteCheckedException("Failed to wrap value[type=" + type + ", value=" + obj + "]");
    }

    public static int getTypeFromClass(Class<?> x) {
        if (x == null || Void.TYPE == x) {
            return 0;
        }
        if (String.class == (x = Utils.getNonPrimitiveClass(x))) {
            return 13;
        }
        if (Integer.class == x) {
            return 4;
        }
        if (Long.class == x) {
            return 5;
        }
        if (Boolean.class == x) {
            return 1;
        }
        if (Double.class == x) {
            return 7;
        }
        if (Byte.class == x) {
            return 2;
        }
        if (Short.class == x) {
            return 3;
        }
        if (Character.class == x) {
            throw new IgniteSQLException("Character type is not supported.", 1002);
        }
        if (Float.class == x) {
            return 8;
        }
        if (byte[].class == x) {
            return 12;
        }
        if (UUID.class == x) {
            return 20;
        }
        if (Void.class == x) {
            return 0;
        }
        if (BigDecimal.class.isAssignableFrom(x)) {
            return 6;
        }
        if (java.sql.Date.class.isAssignableFrom(x)) {
            return 10;
        }
        if (Time.class.isAssignableFrom(x)) {
            return 9;
        }
        if (Timestamp.class.isAssignableFrom(x)) {
            return 11;
        }
        if (Date.class.isAssignableFrom(x)) {
            return 11;
        }
        if (Object[].class.isAssignableFrom(x)) {
            return 17;
        }
        if (QueryUtils.isGeometryClass((Class)x)) {
            return 22;
        }
        if (LocalDateTimeUtils.LOCAL_DATE == x) {
            return 10;
        }
        if (LocalDateTimeUtils.LOCAL_TIME == x) {
            return 9;
        }
        if (LocalDateTimeUtils.LOCAL_DATE_TIME == x) {
            return 11;
        }
        if (JdbcUtils.customDataTypesHandler != null) {
            return JdbcUtils.customDataTypesHandler.getTypeIdFromClass(x);
        }
        return 19;
    }

    public static int resolveDefaultPrecisionIfUndefined(GridQueryProperty prop) {
        if (prop == null) {
            return -1;
        }
        int precision = prop.precision();
        if (precision != -1) {
            return precision;
        }
        return defaultPrecisionsByType.getOrDefault(prop.type(), precision);
    }

    public static int resolveDefaultScaleIfUndefined(GridQueryProperty prop) {
        if (prop == null) {
            return -1;
        }
        int scale = prop.scale();
        if (scale != -1) {
            return scale;
        }
        return defaultScalesByType.getOrDefault(prop.type(), 0);
    }

    public static void validateTypeDescriptor(GridQueryTypeDescriptor type) throws IgniteCheckedException {
        assert (type != null);
        HashSet names = new HashSet();
        names.addAll(type.fields().keySet());
        if (names.size() < type.fields().size()) {
            throw new IgniteCheckedException("Found duplicated properties with the same name [keyType=" + type.keyClass().getName() + ", valueType=" + type.valueClass().getName() + "]");
        }
        String ptrn = "Name ''{0}'' is reserved and cannot be used as a field name [type=" + type.name() + "]";
        for (String name : names) {
            if (!name.equalsIgnoreCase("_KEY") && !name.equalsIgnoreCase("_VAL")) continue;
            throw new IgniteCheckedException(MessageFormat.format(ptrn, name));
        }
    }

    private static String dbTypeFromClass(Class<?> cls, int precision, int scale) {
        String dbType = H2DatabaseType.fromClass(cls).dBTypeAsString();
        if (precision != -1 && scale != -1 && dbType.equalsIgnoreCase(H2DatabaseType.DECIMAL.dBTypeAsString())) {
            return dbType + "(" + precision + ", " + scale + ')';
        }
        if (precision != -1 && (dbType.equalsIgnoreCase(H2DatabaseType.VARCHAR.dBTypeAsString()) || dbType.equalsIgnoreCase(H2DatabaseType.DECIMAL.dBTypeAsString()))) {
            return dbType + '(' + precision + ')';
        }
        return dbType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String generateFieldsQueryString(String qry, String tableAlias, H2TableDescriptor tbl) throws IgniteCheckedException {
        assert (tbl != null);
        String qry0 = qry;
        String t = tbl.fullTableName();
        String from = " ";
        String upper = (qry = qry.trim()).toUpperCase();
        if (upper.startsWith("SELECT")) {
            int star = (qry = qry.substring(6).trim()).indexOf(42);
            if (star == 0) {
                qry = qry.substring(1).trim();
            } else {
                if (star <= 0) throw new IgniteCheckedException("Only queries starting with 'SELECT *' and 'SELECT alias.*' are supported (rewrite your query or use SqlFieldsQuery instead): " + qry0);
                if (!F.eq((Object)Character.valueOf('.'), (Object)Character.valueOf(qry.charAt(star - 1)))) throw new IgniteCheckedException("Invalid query (missing alias before asterisk): " + qry0);
                t = qry.substring(0, star - 1);
                qry = qry.substring(star + 1).trim();
            }
            upper = qry.toUpperCase();
        }
        if (!upper.startsWith("FROM")) {
            from = " FROM " + t + (tableAlias != null ? " as " + tableAlias : "") + (upper.startsWith("WHERE") || upper.startsWith("ORDER") || upper.startsWith("LIMIT") ? " " : " WHERE ");
        }
        if (tableAlias == null) return "SELECT " + t + "." + "_KEY" + ", " + t + "." + "_VAL" + from + qry;
        t = tableAlias;
        return "SELECT " + t + "." + "_KEY" + ", " + t + "." + "_VAL" + from + qry;
    }

    public static GridH2RowMessage toRowMessage(Row row) {
        if (row == null) {
            return null;
        }
        int cols = row.getColumnCount();
        assert (cols > 0) : cols;
        ArrayList<GridH2ValueMessage> vals = new ArrayList<GridH2ValueMessage>(cols);
        for (int i = 0; i < cols; ++i) {
            try {
                vals.add(GridH2ValueMessageFactory.toMessage(row.getValue(i)));
                continue;
            }
            catch (IgniteCheckedException e) {
                throw new CacheException((Throwable)e);
            }
        }
        GridH2RowMessage res = new GridH2RowMessage();
        res.values(vals);
        return res;
    }

    public static GridH2RetryException retryException(String msg) {
        return new GridH2RetryException(msg);
    }

    public static void bindParameters(PreparedStatement stmt, @Nullable Collection<Object> params) throws IgniteCheckedException {
        if (!F.isEmpty(params)) {
            int idx = 1;
            for (Object arg : params) {
                H2Utils.bindObject(stmt, idx++, arg);
            }
        }
    }

    private static void bindObject(PreparedStatement stmt, int idx, @Nullable Object obj) throws IgniteCheckedException {
        try {
            if (obj == null) {
                stmt.setNull(idx, 12);
            } else if (obj instanceof BigInteger) {
                stmt.setObject(idx, obj, 2000);
            } else if (obj instanceof BigDecimal) {
                stmt.setObject(idx, obj, 3);
            } else if (obj.getClass() == Instant.class) {
                stmt.setObject(idx, obj, 2000);
            } else {
                stmt.setObject(idx, obj);
            }
        }
        catch (SQLException e) {
            throw new IgniteCheckedException("Failed to bind parameter [idx=" + idx + ", obj=" + obj + ", stmt=" + stmt + ']', (Throwable)e);
        }
    }

    public static <Z> void bubbleUp(Z[] arr, int off, Comparator<Z> cmp) {
        int last = arr.length - 1;
        for (int i = off; i < last && cmp.compare(arr[i], arr[i + 1]) > 0; ++i) {
            U.swap((Object[])arr, (int)i, (int)(i + 1));
        }
    }

    public static List<Integer> collectCacheIds(IgniteH2Indexing idx, @Nullable Integer mainCacheId, Collection<QueryTable> tbls) {
        LinkedHashSet<Integer> caches0 = new LinkedHashSet<Integer>();
        if (mainCacheId != null) {
            caches0.add(mainCacheId);
        }
        if (!F.isEmpty(tbls)) {
            for (QueryTable tblKey : tbls) {
                GridH2Table tbl = idx.schemaManager().dataTable(tblKey.schema(), tblKey.table());
                if (tbl == null) continue;
                H2Utils.checkAndStartNotStartedCache(idx.kernalContext(), tbl);
                caches0.add(tbl.cacheId());
            }
        }
        return caches0.isEmpty() ? Collections.emptyList() : new ArrayList(caches0);
    }

    public static boolean collectMvccEnabled(IgniteH2Indexing idx, List<Integer> cacheIds) {
        if (cacheIds.isEmpty()) {
            return false;
        }
        GridCacheSharedContext sharedCtx = idx.kernalContext().cache().context();
        GridCacheContext cctx0 = null;
        boolean mvccEnabled = false;
        for (int i = 0; i < cacheIds.size(); ++i) {
            Integer cacheId = cacheIds.get(i);
            GridCacheContext cctx = sharedCtx.cacheContext(cacheId.intValue());
            if (cctx == null) {
                throw new IgniteSQLException("Failed to find cache [cacheId=" + cacheId + ']', 3001);
            }
            if (i == 0) {
                mvccEnabled = cctx.mvccEnabled();
                cctx0 = cctx;
                continue;
            }
            if (cctx.mvccEnabled() == mvccEnabled) continue;
            MvccUtils.throwAtomicityModesMismatchException((CacheConfiguration)cctx0.config(), (CacheConfiguration)cctx.config());
        }
        return mvccEnabled;
    }

    public static void checkQuery(IgniteH2Indexing idx, List<Integer> cacheIds, Collection<QueryTable> tbls) {
        GridCacheSharedContext sharedCtx = idx.kernalContext().cache().context();
        int expectedParallelism = 0;
        for (int i = 0; i < cacheIds.size(); ++i) {
            Integer cacheId = cacheIds.get(i);
            GridCacheContext cctx = sharedCtx.cacheContext(cacheId.intValue());
            if (cctx == null) {
                throw new IgniteSQLException("Failed to find cache [cacheId=" + cacheId + ']', 3001);
            }
            if (!cctx.isPartitioned()) continue;
            if (expectedParallelism == 0) {
                expectedParallelism = cctx.config().getQueryParallelism();
                continue;
            }
            if (cctx.config().getQueryParallelism() == expectedParallelism) continue;
            throw new IllegalStateException("Using indexes with different parallelism levels in same query is forbidden.");
        }
        if (!F.isEmpty(tbls)) {
            for (QueryTable tbl : tbls) {
                if (!QueryUtils.sysSchemaName().equals(tbl.schema())) continue;
                if (!F.isEmpty(cacheIds)) {
                    throw new IgniteSQLException("Normal tables and system views cannot be used in the same query.", 1002);
                }
                return;
            }
        }
    }

    @NotNull
    public static IndexColumn[] unwrapKeyColumns(GridH2Table tbl, IndexColumn[] idxCols) {
        ArrayList<IndexColumn> keyCols = new ArrayList<IndexColumn>();
        boolean isSql = tbl.rowDescriptor().tableDescriptor().sql();
        if (!isSql) {
            return idxCols;
        }
        GridQueryTypeDescriptor type = tbl.rowDescriptor().type();
        for (IndexColumn idxCol : idxCols) {
            if (idxCol.column.getColumnId() == 0) {
                if (QueryUtils.isSqlType((Class)type.keyClass())) {
                    int altKeyColId = tbl.rowDescriptor().getAlternativeColumnId(0);
                    IndexColumn idxKeyCol = new IndexColumn();
                    idxKeyCol.column = tbl.getColumn(altKeyColId);
                    idxKeyCol.columnName = idxKeyCol.column.getName();
                    idxKeyCol.sortType = idxCol.sortType;
                    keyCols.add(idxKeyCol);
                    continue;
                }
                boolean added = false;
                for (String propName : type.fields().keySet()) {
                    GridQueryProperty prop = type.property(propName);
                    if (!prop.key()) continue;
                    added = true;
                    Column col = tbl.getColumn(propName);
                    keyCols.add(tbl.indexColumn(col.getColumnId(), 0));
                }
                if (added) continue;
                keyCols.add(idxCol);
                continue;
            }
            keyCols.add(idxCol);
        }
        return keyCols.toArray(EMPTY_COLUMNS);
    }

    public static QueryContext context(Session ses) {
        assert (ses != null);
        return (QueryContext)ses.getQueryContext();
    }

    public static QueryContext context(Connection c) {
        return (QueryContext)((Session)((JdbcConnection)c).getSession()).getQueryContext();
    }

    public static long rowSizeInBytes(Object[] row) {
        if (row == null) {
            return 0L;
        }
        long rowSize = 24 + row.length * 8;
        for (int i = 0; i < row.length; ++i) {
            Object o = row[i];
            if (o instanceof Value) {
                rowSize += (long)((Value)row[i]).getMemory();
                continue;
            }
            if (o instanceof AggregateData) {
                rowSize += ((AggregateData)row[i]).getMemory();
                continue;
            }
            rowSize += 40L;
        }
        return rowSize;
    }

    public static long calculateMemoryDelta(ValueRow distinctRowKey, Object[] oldRow, Object[] newRow) {
        long oldRowSize = H2Utils.rowSizeInBytes(oldRow);
        long newRowSize = H2Utils.rowSizeInBytes(newRow);
        long memory = newRowSize - oldRowSize;
        if (distinctRowKey != null && (oldRow == null || newRow == null)) {
            memory = oldRow == null ? (memory += (long)distinctRowKey.getMemory()) : (memory -= (long)distinctRowKey.getMemory());
        }
        return memory;
    }

    public static DataHandler getHandler(GridKernalContext ctx) {
        GridQueryIndexing indexing = ctx.query().getIndexing();
        return indexing instanceof IgniteH2Indexing ? ((IgniteH2Indexing)indexing).dataHandler() : null;
    }

    private static Map<Class<?>, Integer> knownDefaultPrecisions() {
        HashMap dfltPrecisions = new HashMap();
        dfltPrecisions.put(Boolean.class, 1);
        dfltPrecisions.put(Byte.class, 3);
        dfltPrecisions.put(Short.class, 5);
        dfltPrecisions.put(Integer.class, 10);
        dfltPrecisions.put(Long.class, 19);
        dfltPrecisions.put(BigDecimal.class, 65535);
        dfltPrecisions.put(Double.class, 17);
        dfltPrecisions.put(Float.class, 7);
        dfltPrecisions.put(Time.class, 8);
        dfltPrecisions.put(java.sql.Date.class, 10);
        dfltPrecisions.put(Timestamp.class, 26);
        dfltPrecisions.put(String.class, Integer.MAX_VALUE);
        dfltPrecisions.put(byte[].class, Integer.MAX_VALUE);
        dfltPrecisions.put(UUID.class, 16);
        Class geometryCls = U.classForName((String)"org.locationtech.jts.geom.Geometry", null);
        if (geometryCls != null) {
            dfltPrecisions.put(geometryCls, Integer.MAX_VALUE);
        }
        return dfltPrecisions;
    }

    private static Map<Class<?>, Integer> knownDefaultScales() {
        HashMap dfltScales = new HashMap();
        dfltScales.put(BigDecimal.class, Short.MAX_VALUE);
        dfltScales.put(Timestamp.class, 6);
        return dfltScales;
    }

    public static void registerSqlFunctions(IgniteLogger log, ConnectionManager connMgr, String schema, Class<?>[] clss) throws IgniteCheckedException {
        if (F.isEmpty((Object[])clss)) {
            return;
        }
        for (Class<?> cls : clss) {
            for (Method m : cls.getDeclaredMethods()) {
                QuerySqlFunction ann = m.getAnnotation(QuerySqlFunction.class);
                if (ann == null) continue;
                int modifiers = m.getModifiers();
                if (!Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers)) {
                    throw new IgniteCheckedException("Method " + m.getName() + " must be public static.");
                }
                String alias = ann.alias().isEmpty() ? m.getName() : ann.alias();
                String clause = "CREATE ALIAS IF NOT EXISTS " + alias + (ann.deterministic() ? " DETERMINISTIC FOR \"" : " FOR \"") + cls.getName() + '.' + m.getName() + '\"';
                connMgr.executeStatement(schema, clause);
                if (log == null || !log.isDebugEnabled()) continue;
                log.debug("Sql function " + alias + "(" + cls.getName() + ") has been registered.");
            }
        }
    }

    public static void registerAggregateFunction(IgniteLogger log, ConnectionManager connMgr, String fnName, Class<? extends AggregateFunction> cls) throws IgniteCheckedException {
        Objects.requireNonNull(fnName, "Function name can't be null");
        Objects.requireNonNull(cls, "Class name can't be null");
        if (!AggregateFunction.class.isAssignableFrom(cls)) {
            throw new IgniteSQLException("Aggregate function '" + cls.getName() + "' should implement '" + AggregateFunction.class.getName() + "'");
        }
        connMgr.executeStatement(null, "CREATE AGGREGATE " + fnName + " FOR \"" + cls.getName() + "\"");
        if (log != null && log.isDebugEnabled()) {
            log.debug("Aggregation function " + fnName + "(" + cls.getName() + ") has been registered.");
        }
    }

    public static void clearStatmentParametersQuietly(PreparedStatement statement, @Nullable Throwable parentThrowable) {
        block3: {
            try {
                if (!statement.isClosed()) {
                    statement.clearParameters();
                }
            }
            catch (SQLException e) {
                if (parentThrowable == null) break block3;
                parentThrowable.addSuppressed(e);
            }
        }
    }
}

