/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.sqltests;

import java.io.Serializable;
import javax.cache.CacheException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.sqltests.ReplicatedSqlTest;
import org.apache.ignite.testframework.GridTestUtils;
import org.junit.Test;

public class ReplicatedSqlCustomPartitionsTest
extends ReplicatedSqlTest {
    static final int NUM_OF_PARTITIONS = 509;
    static final String DEP_PART_TAB_DIFF = "DepartmentPartDiff";
    static final String DEP_PART_TAB_DIFF_NF = "DepartmentPartDiffNf";

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        return super.getConfiguration(igniteInstanceName).setCacheConfiguration(new CacheConfiguration[]{new CacheConfiguration("partitioned509*").setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 509)), new CacheConfiguration("partitioned509_DIFF*").setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 510)), new CacheConfiguration("partitioned509_DIFF_NF*").setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 509)).setNodeFilter((IgnitePredicate & Serializable)clusterNode -> true), new CacheConfiguration("replicated509*").setCacheMode(CacheMode.REPLICATED).setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 509))});
    }

    @Override
    protected void setupData() {
        this.createTables("template=replicated509");
        this.fillCommonData();
        this.createDepartmentTable("DepartmentPart", "template=partitioned509");
        this.fillDepartmentTable("DepartmentPart");
        this.createDepartmentTable(DEP_PART_TAB_DIFF, "template=partitioned509_DIFF");
        this.fillDepartmentTable(DEP_PART_TAB_DIFF);
        this.createDepartmentTable(DEP_PART_TAB_DIFF_NF, "template=partitioned509_DIFF_NF");
        this.fillDepartmentTable(DEP_PART_TAB_DIFF_NF);
    }

    @Test
    public void testLeftJoinReplicatedPartitioned() {
        this.checkLeftJoinEmployeeDepartment("DepartmentPart");
    }

    @Test
    public void testRightJoinPartitionedReplicated() {
        this.checkRightJoinDepartmentEmployee("DepartmentPart");
    }

    @Test
    public void testLeftJoinReplicatedPartitionedDiffPartitionsErr() {
        GridTestUtils.assertThrows((IgniteLogger)log, () -> this.checkLeftJoinEmployeeDepartment(DEP_PART_TAB_DIFF), CacheException.class, (String)"only with the same partitions number configuration");
    }

    @Test
    public void testRightJoinPartitionedReplicatedDiffPartitionsErr() {
        GridTestUtils.assertThrows((IgniteLogger)log, () -> this.checkRightJoinDepartmentEmployee(DEP_PART_TAB_DIFF), CacheException.class, (String)"only with the same partitions number configuration");
    }

    @Test
    public void testLeftJoinReplicatedPartitionedDiffNodeFilterErr() {
        GridTestUtils.assertThrows((IgniteLogger)log, () -> this.checkLeftJoinEmployeeDepartment(DEP_PART_TAB_DIFF_NF), CacheException.class, (String)"due to different node filters configuration");
    }

    @Test
    public void testRightJoinPartitionedReplicatedDiffNodeFilterErr() {
        GridTestUtils.assertThrows((IgniteLogger)log, () -> this.checkRightJoinDepartmentEmployee(DEP_PART_TAB_DIFF_NF), CacheException.class, (String)"due to different node filters configuration");
    }
}

