/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.sqltests;

import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashMap;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.AffinityKeyMapped;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.TestRecordingCommunicationSpi;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionSupplyMessage;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.spi.communication.CommunicationSpi;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;

public class DeletionDuringRebalanceTest
extends GridCommonAbstractTest {
    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        return super.getConfiguration(igniteInstanceName).setConsistentId((Serializable)((Object)igniteInstanceName)).setCommunicationSpi((CommunicationSpi)new TestRecordingCommunicationSpi()).setDataStorageConfiguration(new DataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setPersistenceEnabled(true))).setCacheConfiguration(new CacheConfiguration[]{this.simpleCacheConfiguration()});
    }

    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        this.cleanPersistenceDir();
    }

    private CacheConfiguration simpleCacheConfiguration() {
        CacheConfiguration cfg = new CacheConfiguration().setName("default").setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 16)).setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL).setBackups(1);
        QueryEntity entity = new QueryEntity().setKeyType(Integer.class.getName()).setValueType("org.apache.ignite.sqltests.DeletionDuringRebalanceTest$Subscription");
        LinkedHashMap<String, String> fields = new LinkedHashMap<String, String>();
        fields.put("id", Integer.class.getName());
        fields.put("surname", String.class.getName());
        fields.put("orgId", Integer.class.getName());
        entity.setFields(fields);
        cfg.setQueryEntities(Collections.singleton(entity));
        return cfg;
    }

    @Test
    public void testSimple() throws Exception {
        int i;
        IgniteEx ignite = this.startGrids(2);
        ignite.cluster().state(ClusterState.ACTIVE);
        IgniteCache cache = ignite.cache("default");
        for (i = 0; i < 20; ++i) {
            cache.put((Object)i, (Object)new Subscription(i, "Ivanov", i % 10));
        }
        this.forceCheckpoint();
        this.stopGrid(1);
        for (i = 2000; i < 2010; ++i) {
            cache.put((Object)i, (Object)new Subscription(i, "Ivanov", i % 10));
        }
        this.forceCheckpoint();
        TestRecordingCommunicationSpi.spi((Ignite)ignite).blockMessages((IgniteBiPredicate & Serializable)(node, message) -> message instanceof GridDhtPartitionSupplyMessage && ((GridDhtPartitionSupplyMessage)message).groupId() == CU.cacheId((String)"default"));
        IgniteEx ignite1 = this.startGrid(1);
        cache.query(new SqlFieldsQuery("delete from Subscription where id = 8"));
        TestRecordingCommunicationSpi.spi((Ignite)ignite).stopBlock();
        this.awaitPartitionMapExchange();
        this.assertPartitionsSame(this.idleVerify((Ignite)ignite1, new String[]{"default"}));
    }

    private class Subscription {
        @QuerySqlField
        private Integer id;
        @QuerySqlField
        private String surname;
        @QuerySqlField
        @AffinityKeyMapped
        private Integer orgId;

        Subscription(Integer id, String surname, Integer orgId) {
            this.id = id;
            this.surname = surname;
            this.orgId = orgId;
        }

        public Integer getId() {
            return this.id;
        }

        public void setId(Integer id) {
            this.id = id;
        }

        public String getSurname() {
            return this.surname;
        }

        public void setSurname(String surname) {
            this.surname = surname;
        }

        public Integer getOrgId() {
            return this.orgId;
        }

        public void setOrgId(Integer orgId) {
            this.orgId = orgId;
        }
    }
}

