/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.sqllogic;

import java.io.BufferedReader;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.internal.processors.query.GridQueryProcessor;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.gridgain.internal.h2.util.StringUtils;
import org.jetbrains.annotations.NotNull;

public class SqlScriptRunner {
    static final Charset UTF_8 = StandardCharsets.UTF_8;
    private static final Pattern HASHING_PTRN = Pattern.compile("([0-9]+) values hashing to ([0-9a-fA-F]+)");
    private static final String NULL = "NULL";
    private static final String schemaPublic = "PUBLIC";
    private final Comparator<List<?>> ROW_COMPARATOR = (r1, r2) -> {
        int rows = r1.size();
        for (int i = 0; i < rows; ++i) {
            String s2;
            String s1 = this.toString(r1.get(i));
            int comp = s1.compareTo(s2 = this.toString(r2.get(i)));
            if (comp == 0) continue;
            return comp;
        }
        return 0;
    };
    private static final Comparator<Object> ITM_COMPARATOR = (r1, r2) -> {
        String s1 = String.valueOf(r1);
        String s2 = String.valueOf(r2);
        return s1.compareTo(s2);
    };
    private final Path test;
    private final GridQueryProcessor sqlProc;
    private final Map<String, Integer> loopVars = new HashMap<String, Integer>();
    private final IgniteLogger log;
    private Script script;
    private String nullLbl = "NULL";
    private static final byte[] NL_BYTES = "\n".getBytes();
    private Map<String, Collection<String>> eqResStorage = new HashMap<String, Collection<String>>();
    MessageDigest messageDigest;

    public SqlScriptRunner(Path test, GridQueryProcessor sqlProc, IgniteLogger log) {
        this.test = test;
        this.sqlProc = sqlProc;
        this.log = log;
        try {
            this.messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IgniteException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws Exception {
        try (Script s = new Script(this.test);){
            this.script = s;
            this.nullLbl = NULL;
            for (Command cmd : this.script) {
                try {
                    cmd.execute();
                }
                finally {
                    this.loopVars.clear();
                }
            }
        }
    }

    private List<List<?>> sql(String sql) {
        if (!this.loopVars.isEmpty()) {
            for (Map.Entry<String, Integer> loopVar : this.loopVars.entrySet()) {
                sql = sql.replaceAll("\\$\\{" + loopVar.getKey() + "\\}", loopVar.getValue().toString());
            }
        }
        this.log.info("Execute: " + sql);
        List curs = this.sqlProc.querySqlFields(new SqlFieldsQuery(sql).setSchema(schemaPublic), false, false);
        assert (curs.size() == 1) : "Unexpected results [cursorsCount=" + curs.size() + ']';
        try (QueryCursor cur = (QueryCursor)curs.get(0);){
            List list = cur.getAll();
            return list;
        }
    }

    private String toString(Object res) {
        if (res == null) {
            return this.nullLbl;
        }
        if (res instanceof byte[]) {
            return StringUtils.convertBytesToHex((byte[])((byte[])res), (int)((byte[])res).length);
        }
        if (res instanceof Map) {
            return this.mapToString((Map)res);
        }
        if (res instanceof List) {
            return this.listToString((List)res);
        }
        if (res instanceof Object[]) {
            return Arrays.toString((Object[])res);
        }
        return String.valueOf(res);
    }

    private String listToString(List<?> list) {
        return "[" + list.stream().map(this::toString).collect(Collectors.joining(", ")) + "]";
    }

    private String mapToString(Map<?, ?> map) {
        if (map == null) {
            return this.nullLbl;
        }
        List entries = new TreeMap(map).entrySet().stream().map(e -> this.toString(e.getKey()) + ":" + this.toString(e.getValue())).collect(Collectors.toList());
        return "{" + String.join((CharSequence)", ", entries) + "}";
    }

    private static enum SortType {
        ROWSORT,
        VALUESORT,
        NOSORT;

    }

    private static enum ColumnType {
        I,
        T,
        R;

    }

    private static enum ExpectedStatementStatus {
        OK,
        ERROR;

    }

    private class Query
    extends Command {
        @GridToStringInclude
        List<ColumnType> resTypes;
        @GridToStringInclude
        StringBuilder sql;
        @GridToStringInclude
        List<List<String>> expectedRes;
        String expectedHash;
        int expectedRows;
        SortType sortType;
        String eqLabel;

        Query(String[] cmd) throws IOException {
            String s;
            this.resTypes = new ArrayList<ColumnType>();
            this.sql = new StringBuilder();
            this.sortType = SortType.NOSORT;
            String resTypesChars = cmd[1];
            if (cmd.length > 2) {
                this.sortType = SortType.valueOf(cmd[2].toUpperCase());
            }
            if (cmd.length > 3) {
                this.eqLabel = cmd[3].toLowerCase();
            }
            block7: for (int i = 0; i < resTypesChars.length(); ++i) {
                switch (resTypesChars.charAt(i)) {
                    case 'I': {
                        this.resTypes.add(ColumnType.I);
                        continue block7;
                    }
                    case 'R': {
                        this.resTypes.add(ColumnType.R);
                        continue block7;
                    }
                    case 'T': {
                        this.resTypes.add(ColumnType.T);
                        continue block7;
                    }
                    default: {
                        throw new IgniteException("Unknown type character '" + resTypesChars.charAt(i) + "' at: " + SqlScriptRunner.this.script.positionDescription() + "[cmd=" + Arrays.toString(cmd) + ']');
                    }
                }
            }
            if (F.isEmpty(this.resTypes)) {
                throw new IgniteException("Missing type string at: " + SqlScriptRunner.this.script.positionDescription() + "[cmd=" + Arrays.toString(cmd) + ']');
            }
            while (SqlScriptRunner.this.script.ready() && !(s = SqlScriptRunner.this.script.nextLine()).equals("----")) {
                if (this.sql.length() > 0) {
                    this.sql.append(U.nl());
                }
                this.sql.append(s);
            }
            s = SqlScriptRunner.this.script.nextLineWithoutTrim();
            Matcher m = HASHING_PTRN.matcher(s);
            if (m.matches()) {
                this.expectedRows = Integer.parseInt(m.group(1));
                this.expectedHash = m.group(2);
            } else {
                this.expectedRes = new ArrayList<List<String>>();
                boolean singleValOnLine = false;
                ArrayList<String> row = new ArrayList<String>();
                while (!F.isEmpty((String)s)) {
                    String[] vals = s.split("\\t");
                    if (!singleValOnLine && vals.length == 1 && vals.length != this.resTypes.size()) {
                        singleValOnLine = true;
                    }
                    if (vals.length != this.resTypes.size() && !singleValOnLine) {
                        throw new IgniteException("Invalid columns count at the result at: " + SqlScriptRunner.this.script.positionDescription() + " [row=\"" + s + "\", types=" + this.resTypes + ']');
                    }
                    try {
                        if (singleValOnLine) {
                            row.add(SqlScriptRunner.this.nullLbl.equals(vals[0]) ? null : vals[0]);
                            if (row.size() == this.resTypes.size()) {
                                this.expectedRes.add(row);
                                row = new ArrayList();
                            }
                        } else {
                            for (String val : vals) {
                                row.add(SqlScriptRunner.this.nullLbl.equals(val) ? null : val);
                            }
                            this.expectedRes.add(row);
                            row = new ArrayList();
                        }
                    }
                    catch (Exception e) {
                        throw new IgniteException("Cannot parse expected results at: " + SqlScriptRunner.this.script.positionDescription() + "[row=\"" + s + "\", types=" + this.resTypes + ']', (Throwable)e);
                    }
                    s = SqlScriptRunner.this.script.nextLineWithoutTrim();
                }
            }
        }

        @Override
        void execute() {
            try {
                List res = SqlScriptRunner.this.sql(this.sql.toString());
                this.checkResult(res);
            }
            catch (Throwable e) {
                throw new IgniteException("Error at: " + this.posDesc + ". sql: " + this.sql, e);
            }
        }

        void checkResult(List<List<?>> res) {
            if (this.sortType == SortType.ROWSORT) {
                res.sort(SqlScriptRunner.this.ROW_COMPARATOR);
                if (this.expectedRes != null) {
                    this.expectedRes.sort(SqlScriptRunner.this.ROW_COMPARATOR);
                }
            } else if (this.sortType == SortType.VALUESORT) {
                ArrayList flattenRes = new ArrayList();
                res.forEach(flattenRes::addAll);
                flattenRes.sort(ITM_COMPARATOR);
                ArrayList resSizeAware = new ArrayList();
                int rowLen = this.resTypes.size();
                ArrayList rowRes = new ArrayList(rowLen);
                for (Object item : flattenRes) {
                    rowRes.add(item);
                    if (--rowLen != 0) continue;
                    resSizeAware.add(rowRes);
                    rowRes = new ArrayList(rowLen);
                    rowLen = this.resTypes.size();
                }
                res = resSizeAware;
            }
            if (this.expectedHash != null) {
                this.checkResultsHashed(res);
            } else {
                this.checkResultTuples(res);
            }
        }

        private void checkResultTuples(List<List<?>> res) {
            if (this.expectedRes.size() != res.size()) {
                throw new AssertionError((Object)("Invalid results rows count at: " + this.posDesc + ". [expectedRows=" + this.expectedRes.size() + ", actualRows=" + res.size() + ", expected=" + this.expectedRes + ", actual=" + res + ']'));
            }
            for (int i = 0; i < this.expectedRes.size(); ++i) {
                List<String> expectedRow = this.expectedRes.get(i);
                List<?> row = res.get(i);
                if (row.size() != expectedRow.size()) {
                    throw new AssertionError((Object)("Invalid columns count at: " + this.posDesc + ". [expected=" + this.expectedRes + ", actual=" + res + ']'));
                }
                for (int j = 0; j < expectedRow.size(); ++j) {
                    this.checkEquals("Not expected result at: " + this.posDesc + ". [row=" + i + ", col=" + j + ", expected=" + expectedRow.get(j) + ", actual=" + SqlScriptRunner.this.toString(row.get(j)) + ']', expectedRow.get(j), row.get(j));
                }
            }
        }

        private void checkEquals(String msg, String expectedStr, Object actual) {
            String actualStr;
            BigDecimal expDec;
            BigDecimal actDec;
            if (actual == null && (expectedStr == null || SqlScriptRunner.this.nullLbl.equalsIgnoreCase(expectedStr))) {
                return;
            }
            if (actual != null ^ expectedStr != null) {
                throw new AssertionError((Object)msg);
            }
            if (actual instanceof Boolean && expectedStr.equals((Boolean)actual != false ? "1" : "0")) {
                return;
            }
            if (actual instanceof Number ? ("NaN".equals(expectedStr) || expectedStr.endsWith("Infinity") ? !expectedStr.equals(String.valueOf(actual)) : (actDec = new BigDecimal(String.valueOf(actual))).compareTo(expDec = new BigDecimal(expectedStr)) != 0) : (actual instanceof Map ? !expectedStr.equals(actualStr = SqlScriptRunner.this.mapToString((Map)actual)) : !expectedStr.equals(SqlScriptRunner.this.toString(actual)) && (!"(empty)".equals(expectedStr) || !SqlScriptRunner.this.toString(actual).isEmpty()))) {
                throw new AssertionError((Object)msg);
            }
        }

        private void checkResultsHashed(List<List<?>> res) {
            Objects.requireNonNull(res, "empty result set");
            SqlScriptRunner.this.messageDigest.reset();
            for (List<?> row : res) {
                for (Object col : row) {
                    SqlScriptRunner.this.messageDigest.update(SqlScriptRunner.this.toString(col).getBytes(Charset.forName(UTF_8.name())));
                    SqlScriptRunner.this.messageDigest.update(NL_BYTES);
                }
            }
            String res0 = IgniteUtils.byteArray2HexString((byte[])SqlScriptRunner.this.messageDigest.digest());
            if (this.eqLabel != null) {
                if (res0.equals(this.expectedHash)) {
                    SqlScriptRunner.this.eqResStorage.computeIfAbsent(this.eqLabel, k -> new ArrayList()).add(this.sql.toString());
                } else {
                    Collection eq = (Collection)SqlScriptRunner.this.eqResStorage.get(this.eqLabel);
                    if (eq != null) {
                        throw new AssertionError((Object)("Results of queries need to be equal: " + eq + U.nl() + " and " + U.nl() + this.sql));
                    }
                }
            }
            if (!this.expectedHash.equalsIgnoreCase(res0)) {
                throw new AssertionError((Object)("Unexpected hash result, error at: " + this.posDesc + ", expected=" + this.expectedHash + ", calculated=" + res0 + ", expectedRows=" + this.expectedRows + ", returnedRows=" + res.size() * res.get(0).size()));
            }
        }

        public String toString() {
            return S.toString(Query.class, (Object)this);
        }
    }

    private class Statement
    extends Command {
        @GridToStringInclude
        List<String> queries;
        @GridToStringInclude
        ExpectedStatementStatus expected;

        Statement(String[] cmd) throws IOException {
            String s;
            switch (cmd[1]) {
                case "ok": {
                    this.expected = ExpectedStatementStatus.OK;
                    break;
                }
                case "error": {
                    this.expected = ExpectedStatementStatus.ERROR;
                    break;
                }
                default: {
                    throw new IgniteException("Statement argument should be 'ok' or 'error'. " + SqlScriptRunner.this.script.positionDescription() + "[cmd=" + Arrays.toString(cmd) + ']');
                }
            }
            this.queries = new ArrayList<String>();
            while (SqlScriptRunner.this.script.ready() && !F.isEmpty((String)(s = SqlScriptRunner.this.script.nextLine()))) {
                this.queries.add(s);
            }
        }

        @Override
        void execute() {
            for (String qry : this.queries) {
                IgniteException err;
                block6: {
                    String[] toks = qry.split("\\s+");
                    if ("PRAGMA".equals(toks[0])) {
                        String[] pragmaParams = toks[1].split("=");
                        if ("null".equals(pragmaParams[0])) {
                            SqlScriptRunner.this.nullLbl = pragmaParams[1];
                            continue;
                        }
                        SqlScriptRunner.this.log.info("Ignore: " + this.toString());
                        continue;
                    }
                    err = null;
                    try {
                        SqlScriptRunner.this.sql(qry);
                        if (this.expected != ExpectedStatementStatus.OK) {
                            err = new IgniteException("Error expected at: " + this.posDesc + ". Statement: " + this);
                        }
                    }
                    catch (Throwable e) {
                        if (this.expected == ExpectedStatementStatus.ERROR) break block6;
                        err = new IgniteException("Error at: " + this.posDesc + ". Statement: " + this, e);
                    }
                }
                if (err == null) continue;
                throw err;
            }
        }

        public String toString() {
            return S.toString(Statement.class, (Object)this);
        }
    }

    private class EndLoop
    extends Command {
        private EndLoop() {
        }

        @Override
        void execute() {
        }
    }

    private class Loop
    extends Command {
        List<Command> cmds;
        int begin;
        int end;
        String var;

        Loop(String[] cmdTokens) throws IOException {
            Command cmd;
            this.cmds = new ArrayList<Command>();
            try {
                this.var = cmdTokens[1];
                this.begin = Integer.parseInt(cmdTokens[2]);
                this.end = Integer.parseInt(cmdTokens[3]);
            }
            catch (Exception e) {
                throw new IgniteException("Unexpected loop syntax. " + SqlScriptRunner.this.script.positionDescription() + ". [cmd=" + cmdTokens + ']');
            }
            while (SqlScriptRunner.this.script.ready() && !((cmd = SqlScriptRunner.this.script.nextCommand()) instanceof EndLoop)) {
                this.cmds.add(cmd);
            }
        }

        @Override
        void execute() {
            for (int i = this.begin; i < this.end; ++i) {
                SqlScriptRunner.this.loopVars.put(this.var, i);
                for (Command c : this.cmds) {
                    c.execute();
                }
            }
        }
    }

    private abstract class Command {
        protected final String posDesc;

        Command() {
            this.posDesc = SqlScriptRunner.this.script.positionDescription();
        }

        abstract void execute();
    }

    private class Script
    implements Iterable<Command>,
    AutoCloseable {
        private final String fileName;
        private final BufferedReader r;
        private int lineNum;

        Script(Path test) throws IOException {
            this.fileName = test.getFileName().toString();
            this.r = Files.newBufferedReader(test);
        }

        String nextLine() throws IOException {
            return this.nextLineWithoutTrim();
        }

        String nextLineWithoutTrim() throws IOException {
            String s = this.r.readLine();
            ++this.lineNum;
            return s;
        }

        boolean ready() throws IOException {
            return this.r.ready();
        }

        String positionDescription() {
            return '(' + this.fileName + ':' + this.lineNum + ')';
        }

        @Override
        public void close() throws Exception {
            this.r.close();
        }

        private Command nextCommand() {
            try {
                while (SqlScriptRunner.this.script.ready()) {
                    String s = SqlScriptRunner.this.script.nextLine();
                    if (F.isEmpty((String)s) || s.startsWith("#")) continue;
                    Object[] tokens = s.split("\\s+");
                    assert (!F.isEmpty((Object[])tokens)) : "Invalid command line. " + SqlScriptRunner.access$000(SqlScriptRunner.this).positionDescription() + ". [cmd=" + s + ']';
                    Command cmd = null;
                    switch (tokens[0]) {
                        case "statement": {
                            cmd = new Statement((String[])tokens);
                            break;
                        }
                        case "query": {
                            cmd = new Query((String[])tokens);
                            break;
                        }
                        case "loop": {
                            cmd = new Loop((String[])tokens);
                            break;
                        }
                        case "endloop": {
                            cmd = new EndLoop();
                            break;
                        }
                        case "mode": {
                            break;
                        }
                        default: {
                            throw new IgniteException("Unexpected command. " + SqlScriptRunner.this.script.positionDescription() + ". [cmd=" + s + ']');
                        }
                    }
                    if (cmd == null) continue;
                    return cmd;
                }
                return null;
            }
            catch (IOException e) {
                throw new RuntimeException("Cannot read next command", e);
            }
        }

        @Override
        @NotNull
        public Iterator<Command> iterator() {
            final Command cmd0 = this.nextCommand();
            return new Iterator<Command>(){
                private Command cmd;
                {
                    this.cmd = cmd0;
                }

                @Override
                public boolean hasNext() {
                    return this.cmd != null;
                }

                @Override
                public Command next() {
                    if (this.cmd == null) {
                        throw new NoSuchElementException();
                    }
                    Command ret = this.cmd;
                    this.cmd = Script.this.nextCommand();
                    return ret;
                }
            };
        }
    }
}

