/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor;

import java.util.UUID;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.visor.VisorEither;
import org.apache.ignite.internal.visor.VisorTaskArgument;
import org.apache.ignite.internal.visor.query.VisorQueryFetchFirstPageTask;
import org.apache.ignite.internal.visor.query.VisorQueryNextPageTaskArg;
import org.apache.ignite.internal.visor.query.VisorQueryResult;
import org.apache.ignite.internal.visor.query.VisorQueryTask;
import org.apache.ignite.internal.visor.query.VisorQueryTaskArg;
import org.apache.ignite.logger.NullLogger;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;

public class VisorQueryTaskSelfTest
extends GridCommonAbstractTest {
    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.stopAllGrids();
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
        super.afterTest();
    }

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        cfg.setGridLogger((IgniteLogger)new TestLogger());
        return cfg;
    }

    private VisorEither<VisorQueryResult> executeTask(IgniteEx ignite, UUID nid) {
        VisorQueryTaskArg args = new VisorQueryTaskArg(null, "create table test", false, false, false, false, 10);
        return (VisorEither)ignite.compute().execute(VisorQueryTask.class, (Object)new VisorTaskArgument(nid, (Object)args, false));
    }

    @Test
    public void testLogDebug() throws Exception {
        IgniteEx ignite = this.startGrids(1);
        ignite.cluster().active(true);
        UUID nid = ignite.localNode().id();
        VisorEither taskRes = (VisorEither)ignite.compute().execute(VisorQueryTask.class, (Object)new VisorTaskArgument(nid, (Object)new VisorQueryTaskArg(null, "CREATE TABLE TEST(K INTEGER PRIMARY KEY, V INTEGER)", false, false, false, false, 10), false));
        VisorQueryTaskSelfTest.assertNotNull((Object)taskRes);
        VisorQueryTaskSelfTest.assertNotNull((Object)taskRes.getResult());
        taskRes = (VisorEither)ignite.compute().execute(VisorQueryFetchFirstPageTask.class, (Object)new VisorTaskArgument(nid, (Object)new VisorQueryNextPageTaskArg(((VisorQueryResult)taskRes.getResult()).getQueryId(), 10), false));
        VisorQueryTaskSelfTest.assertNotNull((Object)taskRes);
        VisorQueryTaskSelfTest.assertNull((Object)taskRes.getError());
    }

    private static class TestLogger
    extends NullLogger {
        private TestLogger() {
        }

        public boolean isDebugEnabled() {
            return true;
        }
    }
}

