/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.timeout;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.Callable;
import org.apache.ignite.Ignite;
import org.apache.ignite.internal.jdbc.thin.JdbcThinStatement;
import org.apache.ignite.internal.processors.query.timeout.AbstractDefaultQueryTimeoutTest;
import org.apache.ignite.internal.processors.query.timeout.TimedQueryHelper;
import org.apache.ignite.internal.util.typedef.X;
import org.junit.Test;

public class DefaultQueryTimeoutThinJdbcTest
extends AbstractDefaultQueryTimeoutTest {
    @Override
    protected void executeQuery(String sql) throws Exception {
        try (Connection conn = DriverManager.getConnection("jdbc:ignite:thin://127.0.0.1");){
            conn.createStatement().executeQuery(sql);
        }
    }

    @Override
    protected void executeQuery(String sql, int timeout) throws Exception {
        try (Connection conn = DriverManager.getConnection("jdbc:ignite:thin://127.0.0.1");){
            JdbcThinStatement stmt = (JdbcThinStatement)conn.createStatement();
            stmt.timeout(timeout);
            stmt.executeQuery(sql);
        }
    }

    @Test
    public void testExplicitTimeoutMoreThenMaxValue() throws Exception {
        this.startGrid(0);
        this.setDefaultQueryTimeout(500);
        TimedQueryHelper helper = new TimedQueryHelper(1000L, "default");
        helper.createCache((Ignite)this.grid(0));
        String sql = helper.buildTimedQuery();
        int[] hugeTimeouts = new int[]{2147484, Integer.MAX_VALUE};
        try (Connection conn = DriverManager.getConnection("jdbc:ignite:thin://127.0.0.1");){
            for (int timeout : hugeTimeouts) {
                try (Statement stmt = conn.createStatement();){
                    stmt.setQueryTimeout(timeout);
                    ResultSet rs = stmt.executeQuery(sql);
                    int cnt = 0;
                    while (rs.next()) {
                        ++cnt;
                    }
                    DefaultQueryTimeoutThinJdbcTest.assertTrue((cnt > 0 ? 1 : 0) != 0);
                }
            }
        }
    }

    @Override
    protected void assertQueryCancelled(Callable<?> c) {
        try {
            c.call();
            DefaultQueryTimeoutThinJdbcTest.fail((String)"Exception is expected");
        }
        catch (Exception e) {
            DefaultQueryTimeoutThinJdbcTest.assertTrue((boolean)X.hasCause((Throwable)e, (String)"The query was cancelled while executing", (Class[])new Class[]{SQLException.class}));
        }
    }
}

