/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.timeout;

import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.client.IgniteClient;
import org.apache.ignite.configuration.ClientConfiguration;
import org.apache.ignite.internal.client.thin.ClientServerError;
import org.apache.ignite.internal.processors.query.timeout.AbstractDefaultQueryTimeoutTest;
import org.apache.ignite.internal.util.typedef.G;
import org.apache.ignite.internal.util.typedef.X;

public class DefaultQueryTimeoutThinJavaTest
extends AbstractDefaultQueryTimeoutTest {
    @Override
    protected void executeQuery(String sql) throws Exception {
        try (IgniteClient cli = G.startClient((ClientConfiguration)new ClientConfiguration().setAddresses(new String[]{"127.0.0.1"}));){
            cli.query(new SqlFieldsQuery(sql)).getAll();
        }
    }

    @Override
    protected void executeQuery(String sql, int timeout) throws Exception {
        try (IgniteClient cli = G.startClient((ClientConfiguration)new ClientConfiguration().setAddresses(new String[]{"127.0.0.1"}));){
            cli.query(new SqlFieldsQuery(sql).setTimeout(timeout, TimeUnit.MILLISECONDS)).getAll();
        }
    }

    @Override
    protected void assertQueryCancelled(Callable<?> c) {
        try {
            c.call();
            DefaultQueryTimeoutThinJavaTest.fail((String)"Exception is expected");
        }
        catch (Exception e) {
            DefaultQueryTimeoutThinJavaTest.assertTrue((boolean)X.hasCause((Throwable)e, (String)"The query was cancelled while executing", (Class[])new Class[]{ClientServerError.class}));
        }
    }
}

