/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.stat;

import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.query.stat.ObjectStatisticsImpl;
import org.apache.ignite.internal.processors.query.stat.StatisticsStorageAbstractTest;
import org.apache.ignite.internal.processors.query.stat.StatisticsTarget;
import org.apache.ignite.testframework.GridTestUtils;
import org.junit.Test;

public class PSUStatisticsStorageTest
extends StatisticsStorageAbstractTest {
    private static final String SQL = "select * from SMALL i1 where b < 2 and c < 2";
    private static final String[][] NO_HINTS = new String[1][];

    @Test
    public void testPartialDeletionCollection() throws Exception {
        this.collectStatistics(SMALL_TARGET);
        IgniteEx ign = this.grid(0);
        this.checkOptimalPlanChosenForDifferentIndexes(ign, new String[]{"SMALL_B"}, SQL, NO_HINTS);
        this.statisticsMgr(0).dropStatistics(new StatisticsTarget[]{new StatisticsTarget("PUBLIC", "SMALL", new String[]{"A"})});
        PSUStatisticsStorageTest.assertTrue((boolean)GridTestUtils.waitForCondition(() -> ((ObjectStatisticsImpl)this.statisticsMgr(0).getLocalStatistics(SMALL_KEY)).columnStatistics("A") == null, (long)3000L));
        this.checkOptimalPlanChosenForDifferentIndexes(ign, new String[]{"SMALL_B"}, SQL, NO_HINTS);
        this.statisticsMgr(0).dropStatistics(new StatisticsTarget[]{new StatisticsTarget("PUBLIC", "SMALL", new String[]{"B"})});
        PSUStatisticsStorageTest.assertTrue((boolean)GridTestUtils.waitForCondition(() -> ((ObjectStatisticsImpl)this.statisticsMgr(0).getLocalStatistics(SMALL_KEY)).columnStatistics("B") == null, (long)3000L));
        PSUStatisticsStorageTest.assertTrue((boolean)GridTestUtils.waitForCondition(() -> {
            try {
                this.checkOptimalPlanChosenForDifferentIndexes(ign, new String[]{"SMALL_C"}, SQL, NO_HINTS);
                return true;
            }
            catch (AssertionError e) {
                return false;
            }
        }, (long)3000L));
        this.collectStatistics(new StatisticsTarget("PUBLIC", "SMALL", new String[]{"A"}));
        this.checkOptimalPlanChosenForDifferentIndexes(ign, new String[]{"SMALL_C"}, SQL, NO_HINTS);
        this.collectStatistics(new StatisticsTarget("PUBLIC", "SMALL", new String[]{"B"}));
        this.checkOptimalPlanChosenForDifferentIndexes(ign, new String[]{"SMALL_B"}, SQL, NO_HINTS);
    }
}

