/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.oom;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.SqlConfiguration;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.query.GridQueryMemoryMetricProvider;
import org.apache.ignite.internal.processors.query.h2.QueryMemoryManager;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;

public class QueryMemoryManagerConfigurationSelfTest
extends GridCommonAbstractTest {
    private static final long DFLT_GLOBAL_QUOTA = U.parseBytes((String)"60%");
    private static final long DFLT_QUERY_QUOTA = U.parseBytes((String)"0");

    protected void afterTest() throws Exception {
        System.clearProperty("IGNITE_SQL_MEMORY_RESERVATION_BLOCK_SIZE");
    }

    @Test
    public void testQuotaDefaults() throws IgniteCheckedException {
        QueryMemoryManager memMgr = new QueryMemoryManager((GridKernalContext)this.newContext());
        QueryMemoryManagerConfigurationSelfTest.assertManagerState(memMgr, DFLT_GLOBAL_QUOTA, DFLT_QUERY_QUOTA, false, 524288L);
        GridQueryMemoryMetricProvider tracker = memMgr.createQueryMemoryTracker(0L);
        QueryMemoryManagerConfigurationSelfTest.assertTrackerState(tracker, 0L, false, 524288L);
    }

    @Test
    public void testQuotaNonDefaults() throws IgniteCheckedException {
        IgniteConfiguration cfg = new IgniteConfiguration().setSqlConfiguration(new SqlConfiguration().setSqlGlobalMemoryQuota("20k").setSqlQueryMemoryQuota("10K").setSqlOffloadingEnabled(true));
        System.setProperty("IGNITE_SQL_MEMORY_RESERVATION_BLOCK_SIZE", "5000");
        QueryMemoryManager memMgr = new QueryMemoryManager((GridKernalContext)this.newContext(cfg));
        QueryMemoryManagerConfigurationSelfTest.assertManagerState(memMgr, 20480L, 10240L, true, 5000L);
        GridQueryMemoryMetricProvider tracker = memMgr.createQueryMemoryTracker(0L);
        QueryMemoryManagerConfigurationSelfTest.assertTrackerState(tracker, 10240L, true, 5000L);
        tracker = memMgr.createQueryMemoryTracker(1000L);
        QueryMemoryManagerConfigurationSelfTest.assertTrackerState(tracker, 1000L, true, 1000L);
    }

    @Test
    public void testIllegalSettings() throws IgniteCheckedException {
        GridTestUtils.assertThrows((IgniteLogger)log, () -> {
            IgniteConfiguration cfg = new IgniteConfiguration().setSqlConfiguration(new SqlConfiguration().setSqlGlobalMemoryQuota("-1"));
            QueryMemoryManager memoryMgr = new QueryMemoryManager((GridKernalContext)this.newContext(cfg));
        }, IllegalArgumentException.class, (String)"Ouch! Argument is invalid: Sql global memory quota must be >= 0: quotaSize=-1");
        GridTestUtils.assertThrows((IgniteLogger)log, () -> {
            IgniteConfiguration cfg = new IgniteConfiguration().setSqlConfiguration(new SqlConfiguration().setSqlQueryMemoryQuota("-1"));
            QueryMemoryManager memoryMgr = new QueryMemoryManager((GridKernalContext)this.newContext(cfg));
        }, IllegalArgumentException.class, (String)"Ouch! Argument is invalid: Sql query memory quota must be >= 0: quotaSize=-1");
        System.setProperty("IGNITE_SQL_MEMORY_RESERVATION_BLOCK_SIZE", "0");
        GridTestUtils.assertThrows((IgniteLogger)log, () -> {
            IgniteConfiguration cfg = new IgniteConfiguration();
            QueryMemoryManager memoryMgr = new QueryMemoryManager((GridKernalContext)this.newContext(cfg));
        }, IllegalArgumentException.class, (String)"Ouch! Argument is invalid: Block size must be > 0: blockSize=0");
        System.setProperty("IGNITE_SQL_MEMORY_RESERVATION_BLOCK_SIZE", "-1");
        GridTestUtils.assertThrows((IgniteLogger)log, () -> {
            IgniteConfiguration cfg = new IgniteConfiguration();
            QueryMemoryManager memoryMgr = new QueryMemoryManager((GridKernalContext)this.newContext(cfg));
        }, IllegalArgumentException.class, (String)"Ouch! Argument is invalid: Block size must be > 0: blockSize=-1");
    }

    @Test
    public void testGlobalQuotaDisabled() throws IgniteCheckedException {
        IgniteConfiguration cfg = new IgniteConfiguration().setSqlConfiguration(new SqlConfiguration().setSqlGlobalMemoryQuota("0"));
        QueryMemoryManager memMgr = new QueryMemoryManager((GridKernalContext)this.newContext(cfg));
        QueryMemoryManagerConfigurationSelfTest.assertManagerState(memMgr, 0L, DFLT_QUERY_QUOTA, false, 524288L);
        GridQueryMemoryMetricProvider tracker = memMgr.createQueryMemoryTracker(0L);
        QueryMemoryManagerConfigurationSelfTest.assertTrackerState(tracker, 0L, false, 524288L);
        tracker = memMgr.createQueryMemoryTracker(10L);
        QueryMemoryManagerConfigurationSelfTest.assertTrackerState(tracker, 10L, false, 10L);
    }

    @Test
    public void testGlobalQuotaDisabledDefaultPerQueryQuotaEnabled() throws IgniteCheckedException {
        IgniteConfiguration cfg = new IgniteConfiguration().setSqlConfiguration(new SqlConfiguration().setSqlGlobalMemoryQuota("0").setSqlQueryMemoryQuota("33"));
        QueryMemoryManager memMgr = new QueryMemoryManager((GridKernalContext)this.newContext(cfg));
        QueryMemoryManagerConfigurationSelfTest.assertManagerState(memMgr, 0L, 33L, false, 524288L);
        GridQueryMemoryMetricProvider tracker = memMgr.createQueryMemoryTracker(0L);
        QueryMemoryManagerConfigurationSelfTest.assertTrackerState(tracker, 33L, false, 33L);
    }

    @Test
    public void testQuotaParser() {
        QueryMemoryManagerConfigurationSelfTest.assertEquals((long)0L, (long)U.parseBytes((String)"0"));
        QueryMemoryManagerConfigurationSelfTest.assertEquals((long)1L, (long)U.parseBytes((String)"1"));
        QueryMemoryManagerConfigurationSelfTest.assertEquals((long)-1L, (long)U.parseBytes((String)"-1 "));
        QueryMemoryManagerConfigurationSelfTest.assertEquals((long)1001L, (long)U.parseBytes((String)"1001"));
        QueryMemoryManagerConfigurationSelfTest.assertEquals((long)-5050L, (long)U.parseBytes((String)" -5050"));
        QueryMemoryManagerConfigurationSelfTest.assertEquals((long)0L, (long)U.parseBytes((String)"0k"));
        QueryMemoryManagerConfigurationSelfTest.assertEquals((long)1024L, (long)U.parseBytes((String)"1K"));
        QueryMemoryManagerConfigurationSelfTest.assertEquals((long)-1024L, (long)U.parseBytes((String)"-1k"));
        QueryMemoryManagerConfigurationSelfTest.assertEquals((long)10250240L, (long)U.parseBytes((String)" 10010k "));
        QueryMemoryManagerConfigurationSelfTest.assertEquals((long)-51720192L, (long)U.parseBytes((String)"-50508K"));
        QueryMemoryManagerConfigurationSelfTest.assertEquals((long)0L, (long)U.parseBytes((String)"0M"));
        QueryMemoryManagerConfigurationSelfTest.assertEquals((long)0x100000L, (long)U.parseBytes((String)"1m"));
        QueryMemoryManagerConfigurationSelfTest.assertEquals((long)-1048576L, (long)U.parseBytes((String)"-1M"));
        QueryMemoryManagerConfigurationSelfTest.assertEquals((long)0x6E00000L, (long)U.parseBytes((String)"110M"));
        QueryMemoryManagerConfigurationSelfTest.assertEquals((long)-52961476608L, (long)U.parseBytes((String)"-50508m"));
        QueryMemoryManagerConfigurationSelfTest.assertEquals((long)0L, (long)U.parseBytes((String)"0G"));
        QueryMemoryManagerConfigurationSelfTest.assertEquals((long)0x40000000L, (long)U.parseBytes((String)"  1g"));
        QueryMemoryManagerConfigurationSelfTest.assertEquals((long)-1073741824L, (long)U.parseBytes((String)"  -1G  "));
        QueryMemoryManagerConfigurationSelfTest.assertEquals((long)118111600640L, (long)U.parseBytes((String)"110g    "));
        QueryMemoryManagerConfigurationSelfTest.assertEquals((long)-62277025792L, (long)U.parseBytes((String)"-58G    "));
        long curMaxHeap = Runtime.getRuntime().maxMemory();
        double delta = (double)curMaxHeap * 0.001;
        QueryMemoryManagerConfigurationSelfTest.assertEquals((double)0.0, (double)U.parseBytes((String)"0%"), (double)delta);
        QueryMemoryManagerConfigurationSelfTest.assertEquals((double)((double)curMaxHeap * 0.01), (double)U.parseBytes((String)"  1%"), (double)delta);
        QueryMemoryManagerConfigurationSelfTest.assertEquals((double)((double)curMaxHeap * 0.2), (double)U.parseBytes((String)"  20%"), (double)delta);
        QueryMemoryManagerConfigurationSelfTest.assertEquals((double)curMaxHeap, (double)U.parseBytes((String)"100%    "), (double)delta);
        this.assertThrows("");
        this.assertThrows("-");
        this.assertThrows("o");
        this.assertThrows("- 1");
        this.assertThrows("k");
        this.assertThrows("K");
        this.assertThrows("m");
        this.assertThrows("M");
        this.assertThrows("g");
        this.assertThrows("G");
        this.assertThrows("1 g");
        this.assertThrows("2 m");
        this.assertThrows("3 g");
        this.assertThrows("4kk");
        this.assertThrows("5kg");
        this.assertThrows("6 %");
        this.assertThrows("5k5");
        GridTestUtils.assertThrows((IgniteLogger)log, () -> U.parseBytes((String)"-1%"), IllegalArgumentException.class, (String)"The percentage should be in the range from 0 to 100, but was: -1");
        GridTestUtils.assertThrows((IgniteLogger)log, () -> U.parseBytes((String)"101%"), IllegalArgumentException.class, (String)"The percentage should be in the range from 0 to 100, but was: 101");
    }

    private void assertThrows(String s) {
        GridTestUtils.assertThrows((IgniteLogger)log, () -> U.parseBytes((String)s), IllegalArgumentException.class, (String)("Wrong format of bytes string. It is expected to be a number or a number followed by one of the symbols: 'k', 'm', 'g', '%'.\n For example: '10000', '10k', '33m', '2G'. But was: " + s));
    }

    private static void assertManagerState(QueryMemoryManager memMgr, long expGlobalQuota, long expQryQuota, boolean expOffloadingEnabled, long expBlockSize) {
        if (expGlobalQuota > 0L) {
            QueryMemoryManagerConfigurationSelfTest.assertEquals((double)1.0, (double)((double)memMgr.memoryLimit() / (double)expGlobalQuota), (double)0.01);
        } else {
            QueryMemoryManagerConfigurationSelfTest.assertEquals((long)0L, (long)memMgr.memoryLimit());
        }
        QueryMemoryManagerConfigurationSelfTest.assertEquals((long)expQryQuota, (long)((Long)GridTestUtils.getFieldValue((Object)memMgr, (String[])new String[]{"qryQuota"})));
        QueryMemoryManagerConfigurationSelfTest.assertEquals((boolean)expOffloadingEnabled, (boolean)((Boolean)GridTestUtils.getFieldValue((Object)memMgr, (String[])new String[]{"offloadingEnabled"})));
        QueryMemoryManagerConfigurationSelfTest.assertEquals((long)expBlockSize, (long)((Long)GridTestUtils.getFieldValue((Object)memMgr, (String[])new String[]{"blockSize"})));
    }

    private static void assertTrackerState(GridQueryMemoryMetricProvider memTracker, long expQuota, boolean expOffloadingEnabled, long expBlockSize) {
        QueryMemoryManagerConfigurationSelfTest.assertEquals((long)expQuota, (long)((Long)GridTestUtils.getFieldValue((Object)memTracker, (String[])new String[]{"quota"})));
        QueryMemoryManagerConfigurationSelfTest.assertEquals((boolean)expOffloadingEnabled, (boolean)((Boolean)GridTestUtils.getFieldValue((Object)memTracker, (String[])new String[]{"offloadingEnabled"})));
        QueryMemoryManagerConfigurationSelfTest.assertEquals((long)expBlockSize, (long)((Long)GridTestUtils.getFieldValue((Object)memTracker, (String[])new String[]{"blockSize"})));
    }
}

