/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.oom;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.cache.CacheException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.internal.processors.query.h2.H2ManagedLocalResult;
import org.apache.ignite.internal.processors.query.h2.H2Utils;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.processors.query.oom.AbstractQueryMemoryTrackerSelfTest;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.testframework.GridTestUtils;
import org.junit.Test;

public abstract class BasicQueryMemoryTrackerSelfTest
extends AbstractQueryMemoryTrackerSelfTest {
    @Test
    public void testSimpleQuerySmallResult() throws Exception {
        this.execQuery("select * from T", false);
        BasicQueryMemoryTrackerSelfTest.assertEquals((int)1, (int)localResults.size());
        BasicQueryMemoryTrackerSelfTest.assertEquals((int)1000, (int)((H2ManagedLocalResult)localResults.get(0)).getRowCount());
    }

    @Test
    public void testLazyQueryLargeResult() throws Exception {
        this.execQuery("select * from K", true);
        BasicQueryMemoryTrackerSelfTest.assertEquals((int)0, (int)localResults.size());
    }

    @Test
    public void testSimpleQueryLargeResult() throws Exception {
        this.checkQueryExpectOOM("select * from K", false);
        BasicQueryMemoryTrackerSelfTest.assertEquals((int)1, (int)localResults.size());
        BasicQueryMemoryTrackerSelfTest.assertTrue((10000 > ((H2ManagedLocalResult)localResults.get(0)).getRowCount() ? 1 : 0) != 0);
    }

    @Test
    public void testQueryWithLimit() throws Exception {
        this.execQuery("select * from K LIMIT 500", false);
        BasicQueryMemoryTrackerSelfTest.assertEquals((int)1, (int)localResults.size());
        BasicQueryMemoryTrackerSelfTest.assertEquals((int)500, (int)((H2ManagedLocalResult)localResults.get(0)).getRowCount());
    }

    @Test
    public void testLazyQueryWithHighLimit() throws Exception {
        this.execQuery("select * from K LIMIT 8000", true);
        BasicQueryMemoryTrackerSelfTest.assertEquals((int)0, (int)localResults.size());
    }

    @Test
    public void testQueryWithHighLimit() {
        this.checkQueryExpectOOM("select * from K LIMIT 8000", false);
        BasicQueryMemoryTrackerSelfTest.assertEquals((int)1, (int)localResults.size());
        BasicQueryMemoryTrackerSelfTest.assertTrue((this.maxMem > ((H2ManagedLocalResult)localResults.get(0)).memoryReserved() ? 1 : 0) != 0);
        BasicQueryMemoryTrackerSelfTest.assertTrue((8000 > ((H2ManagedLocalResult)localResults.get(0)).getRowCount() ? 1 : 0) != 0);
    }

    @Test
    public void testLazyQueryWithSortByIndexedCol() throws Exception {
        this.execQuery("select * from K ORDER BY K.indexed", true);
        BasicQueryMemoryTrackerSelfTest.assertEquals((int)0, (int)localResults.size());
    }

    @Test
    public void testQueryWithSortByIndexedCol() {
        this.checkQueryExpectOOM("select * from K ORDER BY K.indexed", false);
        BasicQueryMemoryTrackerSelfTest.assertEquals((int)1, (int)localResults.size());
        BasicQueryMemoryTrackerSelfTest.assertTrue((10000 > ((H2ManagedLocalResult)localResults.get(0)).getRowCount() ? 1 : 0) != 0);
    }

    @Test
    public void testLazyQueryWithSort() {
        this.checkQueryExpectOOM("select * from K ORDER BY K.grp", true);
        BasicQueryMemoryTrackerSelfTest.assertEquals((int)1, (int)localResults.size());
        BasicQueryMemoryTrackerSelfTest.assertTrue((10000 > ((H2ManagedLocalResult)localResults.get(0)).getRowCount() ? 1 : 0) != 0);
    }

    @Test
    public void testQueryWithSort() {
        this.checkQueryExpectOOM("select * from K ORDER BY K.grp", false);
        BasicQueryMemoryTrackerSelfTest.assertEquals((int)1, (int)localResults.size());
        BasicQueryMemoryTrackerSelfTest.assertTrue((10000 > ((H2ManagedLocalResult)localResults.get(0)).getRowCount() ? 1 : 0) != 0);
    }

    @Test
    public void testUnionSimple() throws Exception {
        this.maxMem = 0xB00000L;
        assert (localResults.isEmpty());
        this.execQuery("select * from T as T0, T as T1 where T0.id < 3 UNION select * from T as T2, T as T3 where T2.id > 1 AND T2.id < 4", true);
        BasicQueryMemoryTrackerSelfTest.assertEquals((int)3, (int)localResults.size());
        BasicQueryMemoryTrackerSelfTest.assertTrue((this.maxMem > ((H2ManagedLocalResult)localResults.get(1)).memoryReserved() + ((H2ManagedLocalResult)localResults.get(2)).memoryReserved() ? 1 : 0) != 0);
        BasicQueryMemoryTrackerSelfTest.assertEquals((int)3000, (int)((H2ManagedLocalResult)localResults.get(1)).getRowCount());
        BasicQueryMemoryTrackerSelfTest.assertEquals((int)2000, (int)((H2ManagedLocalResult)localResults.get(2)).getRowCount());
        BasicQueryMemoryTrackerSelfTest.assertEquals((int)4000, (int)((H2ManagedLocalResult)localResults.get(0)).getRowCount());
    }

    @Test
    public void testUnionLargeDataSets() {
        this.checkQueryExpectOOM("select * from T as T0, T as T1 where T0.id < 4 UNION select * from T as T2, T as T3 where T2.id >= 2 AND T2.id < 6", true);
        BasicQueryMemoryTrackerSelfTest.assertEquals((int)2, (int)localResults.size());
        BasicQueryMemoryTrackerSelfTest.assertTrue((this.maxMem > ((H2ManagedLocalResult)localResults.get(1)).memoryReserved() ? 1 : 0) != 0);
        BasicQueryMemoryTrackerSelfTest.assertTrue((4000 > ((H2ManagedLocalResult)localResults.get(0)).getRowCount() ? 1 : 0) != 0);
        BasicQueryMemoryTrackerSelfTest.assertTrue((4000 > ((H2ManagedLocalResult)localResults.get(1)).getRowCount() ? 1 : 0) != 0);
    }

    @Test
    public void testUnionOfSmallDataSetsWithLargeResult() {
        this.maxMem = 0x300000L;
        this.checkQueryExpectOOM("select * from T as T0, T as T1 where T0.id < 2 UNION select * from T as T2, T as T3 where T2.id > 2 AND T2.id < 4", false);
        BasicQueryMemoryTrackerSelfTest.assertEquals((int)3, (int)localResults.size());
        BasicQueryMemoryTrackerSelfTest.assertTrue((this.maxMem > ((H2ManagedLocalResult)localResults.get(1)).memoryReserved() + ((H2ManagedLocalResult)localResults.get(2)).memoryReserved() ? 1 : 0) != 0);
        BasicQueryMemoryTrackerSelfTest.assertEquals((int)2000, (int)((H2ManagedLocalResult)localResults.get(1)).getRowCount());
        BasicQueryMemoryTrackerSelfTest.assertEquals((int)1000, (int)((H2ManagedLocalResult)localResults.get(2)).getRowCount());
        BasicQueryMemoryTrackerSelfTest.assertTrue((3000 > ((H2ManagedLocalResult)localResults.get(0)).getRowCount() ? 1 : 0) != 0);
    }

    @Test
    public void testSimpleJoins() throws Exception {
        this.checkQueryExpectOOM("select * from K ORDER BY K.grp", true);
        this.execQuery("select * from T as T0, T as T1 where T0.id < 2", false);
        this.execQuery("select * from T as T0, T as T1 where T0.id >= 2 AND T0.id < 4", false);
        this.execQuery("select * from T as T0, T as T1", true);
    }

    @Test
    public void testSimpleJoinsHugeResult() {
        this.checkQueryExpectOOM("select * from T as T0, T as T1", false);
        BasicQueryMemoryTrackerSelfTest.assertEquals((int)1, (int)localResults.size());
        BasicQueryMemoryTrackerSelfTest.assertTrue((this.maxMem >= ((H2ManagedLocalResult)localResults.get(0)).memoryReserved() ? 1 : 0) != 0);
    }

    @Test
    public void testLazyQueryWithJoinAndSort() {
        this.checkQueryExpectOOM("select * from T as T0, T as T1 ORDER BY T1.id", true);
        BasicQueryMemoryTrackerSelfTest.assertEquals((int)1, (int)localResults.size());
        BasicQueryMemoryTrackerSelfTest.assertTrue((this.maxMem >= ((H2ManagedLocalResult)localResults.get(0)).memoryReserved() ? 1 : 0) != 0);
    }

    @Test
    public void testQueryWithGroupsSmallResult() throws Exception {
        this.execQuery("select K.grp, avg(K.id), min(K.id), sum(K.id) from K GROUP BY K.grp", false);
        BasicQueryMemoryTrackerSelfTest.assertEquals((int)1, (int)localResults.size());
        BasicQueryMemoryTrackerSelfTest.assertEquals((int)100, (int)((H2ManagedLocalResult)localResults.get(0)).getRowCount());
    }

    @Test
    public void testQueryWithGroupByIndexedCol() throws Exception {
        this.execQuery("select K.indexed, sum(K.grp) from K GROUP BY K.indexed", true);
        BasicQueryMemoryTrackerSelfTest.assertEquals((int)0, (int)localResults.size());
    }

    @Test
    public void testQueryWithGroupByPrimaryKey() throws Exception {
        this.execQuery("select K.indexed, sum(K.id) from K GROUP BY K.indexed", true);
        BasicQueryMemoryTrackerSelfTest.assertEquals((int)0, (int)localResults.size());
    }

    @Test
    public void testQueryWithGroupThenSort() throws Exception {
        this.execQuery("select K.grp_indexed, sum(K.id) as s from K GROUP BY K.grp_indexed ORDER BY s", false);
        BasicQueryMemoryTrackerSelfTest.assertEquals((int)1, (int)localResults.size());
        BasicQueryMemoryTrackerSelfTest.assertEquals((int)100, (int)((H2ManagedLocalResult)localResults.get(0)).getRowCount());
    }

    @Test
    public void testQueryWithGroupBy() {
        this.checkQueryExpectOOM("select K.name, count(K.id), sum(K.grp) from K GROUP BY K.name", true);
        BasicQueryMemoryTrackerSelfTest.assertEquals((int)1, (int)localResults.size());
        BasicQueryMemoryTrackerSelfTest.assertTrue((this.maxMem > ((H2ManagedLocalResult)localResults.get(0)).memoryReserved() + 1000L ? 1 : 0) != 0);
        BasicQueryMemoryTrackerSelfTest.assertTrue((10000 > ((H2ManagedLocalResult)localResults.get(0)).getRowCount() ? 1 : 0) != 0);
    }

    @Test
    public void testQueryWithGroupByNonIndexedColAndDistinctAggregates() {
        this.checkQueryExpectOOM("select K.grp, count(DISTINCT k.name) from K GROUP BY K.grp", true);
        BasicQueryMemoryTrackerSelfTest.assertEquals((int)1, (int)localResults.size());
        BasicQueryMemoryTrackerSelfTest.assertTrue((this.maxMem > ((H2ManagedLocalResult)localResults.get(0)).memoryReserved() + 1000L ? 1 : 0) != 0);
        BasicQueryMemoryTrackerSelfTest.assertTrue((100 > ((H2ManagedLocalResult)localResults.get(0)).getRowCount() ? 1 : 0) != 0);
    }

    @Test
    public void testLazyQueryWithGroupByIndexedColAndDistinctAggregates() throws Exception {
        this.execQuery("select K.grp_indexed, count(DISTINCT k.name) from K  USE INDEX (K_GRP_IDX) GROUP BY K.grp_indexed", true);
        BasicQueryMemoryTrackerSelfTest.assertEquals((int)0, (int)localResults.size());
    }

    @Test
    public void testLazyQueryWithGroupByThenSort() throws Exception {
        this.maxMem = 524288L;
        this.checkQueryExpectOOM("select K.indexed, sum(K.grp) as a from K GROUP BY K.indexed ORDER BY a DESC", true);
        BasicQueryMemoryTrackerSelfTest.assertEquals((int)1, (int)localResults.size());
        BasicQueryMemoryTrackerSelfTest.assertTrue((this.maxMem > ((H2ManagedLocalResult)localResults.get(0)).memoryReserved() ? 1 : 0) != 0);
        BasicQueryMemoryTrackerSelfTest.assertTrue((10000 > ((H2ManagedLocalResult)localResults.get(0)).getRowCount() ? 1 : 0) != 0);
    }

    @Test
    public void testQueryWithDistinctAndGroupBy() throws Exception {
        this.checkQueryExpectOOM("select DISTINCT K.name from K GROUP BY K.id", true);
        BasicQueryMemoryTrackerSelfTest.assertEquals((int)1, (int)localResults.size());
        BasicQueryMemoryTrackerSelfTest.assertTrue((this.maxMem > ((H2ManagedLocalResult)localResults.get(0)).memoryReserved() ? 1 : 0) != 0);
        BasicQueryMemoryTrackerSelfTest.assertTrue((10000 > ((H2ManagedLocalResult)localResults.get(0)).getRowCount() ? 1 : 0) != 0);
    }

    @Test
    public void testQueryWithDistinctAndLowCardinality() throws Exception {
        this.execQuery("select DISTINCT K.grp_indexed from K", false);
        BasicQueryMemoryTrackerSelfTest.assertEquals((int)1, (int)localResults.size());
        BasicQueryMemoryTrackerSelfTest.assertEquals((int)100, (int)((H2ManagedLocalResult)localResults.get(0)).getRowCount());
    }

    @Test
    public void testQueryWithDistinctAndHighCardinality() throws Exception {
        this.checkQueryExpectOOM("select DISTINCT K.id from K", true);
        BasicQueryMemoryTrackerSelfTest.assertEquals((int)1, (int)localResults.size());
        BasicQueryMemoryTrackerSelfTest.assertTrue((10000 > ((H2ManagedLocalResult)localResults.get(0)).getRowCount() ? 1 : 0) != 0);
    }

    @Test
    public void testHashJoinWithLargeTable() {
        this.maxMem = 524288L;
        GridTestUtils.setFieldValue(H2Utils.class, (String)"enableHashJoin", (Object)true);
        try {
            this.checkQueryExpectOOM("select * from T, K USE INDEX(HASH_JOIN_IDX) where T.id = K.grp_indexed", true);
            BasicQueryMemoryTrackerSelfTest.assertEquals((int)0, (int)localResults.size());
        }
        finally {
            GridTestUtils.setFieldValue(H2Utils.class, (String)"enableHashJoin", (Object)false);
        }
    }

    @Test
    public void testJoinWithLargeTable() throws Exception {
        this.maxMem = 524288L;
        this.execQuery("select * from T, K where T.id = K.grp_indexed", true);
        BasicQueryMemoryTrackerSelfTest.assertEquals((int)0, (int)localResults.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGlobalQuota() throws Exception {
        ArrayList cursors = new ArrayList();
        IgniteH2Indexing h2 = (IgniteH2Indexing)this.grid(0).context().query().getIndexing();
        BasicQueryMemoryTrackerSelfTest.assertEquals((long)0xA00000L, (long)h2.memoryManager().memoryLimit());
        try {
            CacheException ex = (CacheException)GridTestUtils.assertThrows((IgniteLogger)log, () -> {
                for (int i = 0; i < 100; ++i) {
                    FieldsQueryCursor<List<?>> cur = this.query("select T.name, avg(T.id), sum(T.ref_key) from T GROUP BY T.name", true);
                    cursors.add(cur);
                    Iterator iter = cur.iterator();
                    iter.next();
                }
                return null;
            }, CacheException.class, (String)"SQL query ran out of memory: Global quota was exceeded.");
            if (this.isLocal()) {
                BasicQueryMemoryTrackerSelfTest.assertEquals((int)18, (int)localResults.size());
            } else {
                BasicQueryMemoryTrackerSelfTest.assertEquals((int)34, (int)localResults.size());
            }
            BasicQueryMemoryTrackerSelfTest.assertEquals((int)18, (int)cursors.size());
            long globallyReserved = h2.memoryManager().reserved();
            BasicQueryMemoryTrackerSelfTest.assertTrue((h2.memoryManager().memoryLimit() < globallyReserved + 0x100000L ? 1 : 0) != 0);
        }
        finally {
            for (QueryCursor c : cursors) {
                IgniteUtils.closeQuiet((AutoCloseable)c);
            }
        }
    }
}

