/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.oom;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.exceptions.SqlMemoryQuotaExceededException;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.SqlConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.query.IgniteQueryErrorCode;
import org.apache.ignite.internal.processors.cache.query.SqlFieldsQueryEx;
import org.apache.ignite.internal.processors.query.h2.H2LocalResultFactory;
import org.apache.ignite.internal.processors.query.h2.H2ManagedLocalResult;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.processors.query.h2.QueryMemoryManager;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.WithSystemProperty;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.expression.Expression;
import org.gridgain.internal.h2.result.LocalResult;
import org.gridgain.internal.h2.result.LocalResultImpl;
import sun.reflect.generics.reflectiveObjects.NotImplementedException;

@WithSystemProperty(key="IGNITE_SQL_ENABLE_CONNECTION_MEMORY_QUOTA", value="true")
public abstract class AbstractQueryMemoryTrackerSelfTest
extends GridCommonAbstractTest {
    static final int SMALL_TABLE_SIZE = 1000;
    static final int BIG_TABLE_SIZE = 10000;
    static final long RESERVATION_BLOCK_SIZE = 1024L;
    protected static final List<H2ManagedLocalResult> localResults = Collections.synchronizedList(new ArrayList());
    protected long maxMem;
    private boolean client;
    protected boolean useJdbcV2GlobalQuotaCfg;

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        return super.getConfiguration(igniteInstanceName).setClientMode(this.client).setSqlConfiguration(new SqlConfiguration().setSqlOffloadingEnabled(false).setSqlGlobalMemoryQuota(Long.toString(this.globalQuotaSize())));
    }

    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        System.setProperty("IGNITE_H2_LOCAL_RESULT_FACTORY", this.localResultFactory().getName());
        System.setProperty("IGNITE_SQL_MEMORY_RESERVATION_BLOCK_SIZE", Long.toString(1024L));
        this.startGrid(0);
        if (this.startClient()) {
            this.client = true;
            this.startGrid(1);
        }
        this.createSchema();
        this.populateData();
    }

    protected void afterTestsStopped() throws Exception {
        this.stopAllGrids();
        System.clearProperty("IGNITE_SQL_MEMORY_RESERVATION_BLOCK_SIZE");
        System.clearProperty("IGNITE_H2_LOCAL_RESULT_FACTORY");
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.maxMem = 0x100000L;
        this.useJdbcV2GlobalQuotaCfg = false;
        for (H2ManagedLocalResult res : localResults) {
            if (res.memoryTracker() == null) continue;
            res.memoryTracker().close();
        }
        localResults.clear();
        this.resetMemoryManagerState(this.grid(0));
        if (this.startClient()) {
            this.resetMemoryManagerState(this.grid(1));
        }
    }

    protected void afterTest() throws Exception {
        for (H2ManagedLocalResult res : localResults) {
            if (res.memoryTracker() == null) continue;
            res.memoryTracker().close();
        }
        this.checkMemoryManagerState(this.grid(0));
        if (this.startClient()) {
            this.checkMemoryManagerState(this.grid(1));
        }
        super.afterTest();
    }

    private void checkMemoryManagerState(IgniteEx node) throws Exception {
        QueryMemoryManager memMgr = this.memoryManager(node);
        GridTestUtils.waitForCondition(() -> memMgr.reserved() == 0L, (long)5000L);
        long memReserved = memMgr.reserved();
        AbstractQueryMemoryTrackerSelfTest.assertEquals((String)("Potential memory leak in SQL engine: reserved=" + memReserved), (long)0L, (long)memReserved);
    }

    private void resetMemoryManagerState(IgniteEx grid) {
        QueryMemoryManager memoryManager = this.memoryManager(grid);
        if (memoryManager.reserved() > 0L) {
            memoryManager.release(memoryManager.reserved());
        }
    }

    private QueryMemoryManager memoryManager(IgniteEx node) {
        IgniteH2Indexing h2 = (IgniteH2Indexing)node.context().query().getIndexing();
        return h2.memoryManager();
    }

    protected long globalQuotaSize() {
        return 0xA00000L;
    }

    private void populateData() {
        int i;
        for (i = 0; i < 1000; ++i) {
            this.execSql("insert into T VALUES (?, ?, ?)", i, i, UUID.randomUUID().toString());
        }
        for (i = 0; i < 10000; ++i) {
            this.execSql("insert into K VALUES (?, ?, ?, ?, ?)", i, i, i % 100, i % 100, UUID.randomUUID().toString());
        }
    }

    protected void createSchema() {
        this.execSql("create table T (id int primary key, ref_key int, name varchar)", new Object[0]);
        this.execSql("create table K (id int primary key, indexed int, grp int, grp_indexed int, name varchar)", new Object[0]);
        this.execSql("create index K_IDX on K(indexed)", new Object[0]);
        this.execSql("create index K_GRP_IDX on K(grp_indexed)", new Object[0]);
    }

    protected List<List<?>> execQuery(String sql, boolean lazy) throws Exception {
        try (FieldsQueryCursor<List<?>> cursor = this.query(sql, lazy);){
            List list = cursor.getAll();
            return list;
        }
    }

    FieldsQueryCursor<List<?>> query(String sql, boolean lazy) throws Exception {
        boolean localQry = this.isLocal();
        return this.grid(this.startClient() ? 1 : 0).context().query().querySqlFields(new SqlFieldsQueryEx(sql, null).setLocal(localQry).setMaxMemory(this.maxMem).setLazy(lazy).setEnforceJoinOrder(true).setPageSize(100), false);
    }

    protected abstract boolean isLocal();

    protected boolean startClient() {
        return !this.isLocal();
    }

    protected void execSql(String sql, Object ... args) {
        this.grid(0).context().query().querySqlFields(new SqlFieldsQuery(sql).setArgs(args), false).getAll();
    }

    protected void checkQueryExpectOOM(String sql, boolean lazy) {
        try {
            this.execQuery(sql, lazy);
            AbstractQueryMemoryTrackerSelfTest.fail((String)"Exception is not thrown.");
        }
        catch (SqlMemoryQuotaExceededException e) {
            AbstractQueryMemoryTrackerSelfTest.assertTrue((boolean)e.getMessage().contains("SQL query ran out of memory: Query quota was exceeded."));
            AbstractQueryMemoryTrackerSelfTest.assertEquals((int)3015, (int)e.statusCode());
            AbstractQueryMemoryTrackerSelfTest.assertEquals((String)IgniteQueryErrorCode.codeToSqlState((int)3015), (String)e.sqlState());
        }
        catch (Exception e) {
            AbstractQueryMemoryTrackerSelfTest.fail((String)("Wrong exception: " + X.getFullStackTrace((Throwable)e)));
        }
    }

    protected Class<?> localResultFactory() {
        return TestH2LocalResultFactory.class;
    }

    protected void clearResults() {
        for (LocalResult localResult : localResults) {
            U.closeQuiet((AutoCloseable)localResult);
        }
        localResults.clear();
    }

    public static class TestH2LocalResultFactory
    extends H2LocalResultFactory {
        public LocalResult create(Session ses, Expression[] expressions, int visibleColCnt, boolean system) {
            if (system) {
                return new LocalResultImpl(ses, expressions, visibleColCnt);
            }
            if (ses.memoryTracker() != null) {
                H2ManagedLocalResult res = new H2ManagedLocalResult(ses, expressions, visibleColCnt){

                    public void onClose() {
                    }
                };
                localResults.add(res);
                return res;
            }
            return new H2ManagedLocalResult(ses, expressions, visibleColCnt);
        }

        public LocalResult create() {
            throw new NotImplementedException();
        }
    }
}

