/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.opt;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.ignite.internal.processors.query.h2.opt.GridLuceneDirectory;
import org.apache.ignite.internal.util.offheap.unsafe.GridUnsafeMemory;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexOutput;
import org.junit.Before;
import org.junit.Test;

public class GridLuceneDirectoryTest
extends GridCommonAbstractTest {
    private GridLuceneDirectory dir;

    @Before
    public void setUp() throws Exception {
        this.dir = new GridLuceneDirectory(new GridUnsafeMemory(0L));
    }

    @Test
    public void testPendingDeletion() throws IOException {
        String fileName = "foo";
        this.assertNoFilenames();
        IndexOutput indexOutput = this.dir.createOutput("foo", IOContext.DEFAULT);
        GridLuceneDirectoryTest.assertTrue((String)"Missing created file: foo", (boolean)this.dirFileNames().contains("foo"));
        this.dir.deleteFile("foo");
        this.assertNoFilenames();
        GridLuceneDirectoryTest.assertTrue((boolean)this.dir.getPendingDeletions().contains("foo"));
        indexOutput.close();
        this.assertNoFilenames();
        this.assertNoPendingDeletions();
    }

    private List<String> dirFileNames() {
        return Arrays.asList(this.dir.listAll());
    }

    private void assertNoFilenames() {
        GridLuceneDirectoryTest.assertTrue((String)"Lucene Directory is not empty", (boolean)this.dirFileNames().isEmpty());
    }

    private void assertNoPendingDeletions() throws IOException {
        GridLuceneDirectoryTest.assertTrue((String)"Pending deletions is not empty", (boolean)this.dir.getPendingDeletions().isEmpty());
    }
}

