/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.TextQuery;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.processors.cache.index.AbstractIndexingCommonTest;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryType;
import org.apache.ignite.internal.processors.query.GridQueryFinishedInfo;
import org.apache.ignite.internal.processors.query.GridQueryStartedInfo;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.processors.query.QueryUtils;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.testframework.GridTestUtils;
import org.hamcrest.CustomMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsEqual;
import org.hamcrest.core.IsNull;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class IgniteSqlQueryStartFinishListenerTest
extends AbstractIndexingCommonTest {
    private static final String CLIENT_NODE_NAME = "CLIENT_NODE";
    private static final String SERVER_NODE_NAME = "SERVER_NODE";
    private final List<Object> lsnrs = new ArrayList<Object>();

    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        this.startGrid(SERVER_NODE_NAME);
        this.startClientGrid(CLIENT_NODE_NAME);
    }

    @Override
    protected void afterTestsStopped() throws Exception {
        super.afterTestsStopped();
        this.stopAllGrids();
    }

    @After
    public void unregisterListeners() {
        this.lsnrs.forEach(arg_0 -> ((IgniteH2Indexing)this.indexing()).unregisterQueryFinishedListener(arg_0));
        this.lsnrs.forEach(arg_0 -> ((IgniteH2Indexing)this.indexing()).unregisterQueryStartedListener(arg_0));
        this.lsnrs.clear();
    }

    protected IgniteConfiguration getConfiguration(String gridName) throws Exception {
        return super.getConfiguration(gridName).setSqlSchemas(new String[]{"TEST1"}).setCacheConfiguration(new CacheConfiguration[]{new CacheConfiguration("default").setQueryEntities(Collections.singleton(new QueryEntity(String.class, String.class))).setSqlFunctionClasses(new Class[]{GridTestUtils.SqlTestFunctions.class})});
    }

    @Test
    public void testRegisterUnregisterQueryListeners() throws Exception {
        AtomicInteger qryStarted = new AtomicInteger();
        AtomicInteger qryFinished = new AtomicInteger();
        Consumer<GridQueryStartedInfo> qryStartedLsnr = this.registerQueryStartedListener(info -> qryStarted.incrementAndGet());
        Consumer<GridQueryFinishedInfo> qryFinishedLsnr = this.registerQueryFinishedListener(info -> qryFinished.incrementAndGet());
        this.execSql(QueryUtils.sysSchemaName(), "select * from caches", new Object[0]);
        this.assertWithTimeout(qryStarted::get, Is.is((Matcher)IsEqual.equalTo((Object)1)), 1000L);
        this.assertWithTimeout(qryFinished::get, Is.is((Matcher)IsEqual.equalTo((Object)1)), 1000L);
        IgniteSqlQueryStartFinishListenerTest.assertTrue((boolean)this.indexing().unregisterQueryStartedListener(qryStartedLsnr));
        this.execSql(QueryUtils.sysSchemaName(), "select * from caches", new Object[0]);
        this.assertWithTimeout(qryFinished::get, Is.is((Matcher)IsEqual.equalTo((Object)2)), 1000L);
        this.assertWithTimeout(qryStarted::get, Is.is((Matcher)IsEqual.equalTo((Object)1)), 1000L);
        IgniteSqlQueryStartFinishListenerTest.assertTrue((boolean)this.indexing().unregisterQueryFinishedListener(qryFinishedLsnr));
        CountDownLatch latch = new CountDownLatch(1);
        this.registerQueryFinishedListener(info -> latch.countDown());
        this.execSql(QueryUtils.sysSchemaName(), "select * from caches", new Object[0]);
        latch.await(1L, TimeUnit.SECONDS);
        this.assertWithTimeout(qryFinished::get, Is.is((Matcher)IsEqual.equalTo((Object)2)), 1000L);
        this.assertWithTimeout(qryStarted::get, Is.is((Matcher)IsEqual.equalTo((Object)1)), 1000L);
    }

    @Test
    public void testVerifyQueryInfoPassedToListeners() throws Exception {
        AtomicReference qryStarted = new AtomicReference();
        AtomicReference qryFinished = new AtomicReference();
        this.registerQueryStartedListener(qryStarted::set);
        this.registerQueryFinishedListener(qryFinished::set);
        long delay = 100L;
        String qry = "select * from caches where ? = \"default\".delay(?) limit 1";
        this.execSql(QueryUtils.sysSchemaName(), "select * from caches where ? = \"default\".delay(?) limit 1", 100L, 100L);
        this.assertWithTimeout(qryStarted::get, Is.is((Matcher)IsNull.notNullValue()), 1000L);
        GridQueryStartedInfo startedInfo = (GridQueryStartedInfo)qryStarted.get();
        IgniteSqlQueryStartFinishListenerTest.assertEquals((String)QueryUtils.sysSchemaName(), (String)startedInfo.schemaName());
        IgniteSqlQueryStartFinishListenerTest.assertEquals((String)"select * from caches where ? = \"default\".delay(?) limit 1", (String)startedInfo.query());
        IgniteSqlQueryStartFinishListenerTest.assertEquals((Object)this.grid(SERVER_NODE_NAME).localNode().id(), (Object)startedInfo.nodeId());
        IgniteSqlQueryStartFinishListenerTest.assertEquals((boolean)false, (boolean)startedInfo.local());
        IgniteSqlQueryStartFinishListenerTest.assertEquals((Object)GridCacheQueryType.SQL_FIELDS, (Object)startedInfo.queryType());
        IgniteSqlQueryStartFinishListenerTest.assertEquals((boolean)true, (boolean)startedInfo.cancellable());
        IgniteSqlQueryStartFinishListenerTest.assertEquals((boolean)false, (boolean)startedInfo.lazy());
        IgniteSqlQueryStartFinishListenerTest.assertEquals((boolean)false, (boolean)startedInfo.enforceJoinOrder());
        IgniteSqlQueryStartFinishListenerTest.assertEquals((boolean)false, (boolean)startedInfo.distributedJoins());
        IgniteSqlQueryStartFinishListenerTest.assertNull((Object)startedInfo.queryInitiatorId());
        this.assertWithTimeout(qryFinished::get, Is.is((Matcher)IsNull.notNullValue()), 1000L);
        GridQueryFinishedInfo finishedInfo = (GridQueryFinishedInfo)qryFinished.get();
        IgniteSqlQueryStartFinishListenerTest.assertEquals((String)QueryUtils.sysSchemaName(), (String)finishedInfo.schemaName());
        IgniteSqlQueryStartFinishListenerTest.assertEquals((String)"select * from caches where ? = \"default\".delay(?) limit 1", (String)finishedInfo.query());
        IgniteSqlQueryStartFinishListenerTest.assertEquals((Object)this.grid(SERVER_NODE_NAME).localNode().id(), (Object)startedInfo.nodeId());
        IgniteSqlQueryStartFinishListenerTest.assertEquals((boolean)false, (boolean)finishedInfo.local());
        IgniteSqlQueryStartFinishListenerTest.assertEquals((Object)GridCacheQueryType.SQL_FIELDS, (Object)finishedInfo.queryType());
        IgniteSqlQueryStartFinishListenerTest.assertEquals((boolean)false, (boolean)finishedInfo.failed());
        Assert.assertThat((Object)(finishedInfo.finishTime() - finishedInfo.startTime()), (Matcher)Is.is(IgniteSqlQueryStartFinishListenerTest.greaterOrEqualTo(100L)));
        IgniteSqlQueryStartFinishListenerTest.assertEquals((boolean)false, (boolean)finishedInfo.lazy());
        IgniteSqlQueryStartFinishListenerTest.assertEquals((boolean)false, (boolean)finishedInfo.enforceJoinOrder());
        IgniteSqlQueryStartFinishListenerTest.assertEquals((boolean)false, (boolean)finishedInfo.distributedJoins());
        IgniteSqlQueryStartFinishListenerTest.assertNull((Object)finishedInfo.queryInitiatorId());
        qryStarted.set(null);
        qryFinished.set(null);
        String schema = "TEST1";
        String qry2 = "select \"default\".can_fail() from " + QueryUtils.sysSchemaName() + ".caches where ? = ? limit 1";
        GridTestUtils.SqlTestFunctions.fail = true;
        GridTestUtils.assertThrowsWithCause(() -> this.execSqlLocal("TEST1", qry2, 1, 1), IgniteSQLException.class);
        this.assertWithTimeout(qryStarted::get, Is.is((Matcher)IsNull.notNullValue()), 1000L);
        GridQueryStartedInfo startedInfo2 = (GridQueryStartedInfo)qryStarted.get();
        IgniteSqlQueryStartFinishListenerTest.assertEquals((String)"TEST1", (String)startedInfo2.schemaName());
        IgniteSqlQueryStartFinishListenerTest.assertEquals((String)qry2, (String)startedInfo2.query());
        IgniteSqlQueryStartFinishListenerTest.assertEquals((Object)this.grid(SERVER_NODE_NAME).localNode().id(), (Object)startedInfo2.nodeId());
        IgniteSqlQueryStartFinishListenerTest.assertEquals((boolean)true, (boolean)startedInfo2.local());
        IgniteSqlQueryStartFinishListenerTest.assertEquals((Object)GridCacheQueryType.SQL_FIELDS, (Object)startedInfo2.queryType());
        this.assertWithTimeout(qryFinished::get, Is.is((Matcher)IsNull.notNullValue()), 1000L);
        GridQueryFinishedInfo finishedInfo2 = (GridQueryFinishedInfo)qryFinished.get();
        IgniteSqlQueryStartFinishListenerTest.assertEquals((String)"TEST1", (String)finishedInfo2.schemaName());
        IgniteSqlQueryStartFinishListenerTest.assertEquals((String)qry2, (String)finishedInfo2.query());
        IgniteSqlQueryStartFinishListenerTest.assertEquals((Object)this.grid(SERVER_NODE_NAME).localNode().id(), (Object)startedInfo2.nodeId());
        IgniteSqlQueryStartFinishListenerTest.assertEquals((boolean)true, (boolean)finishedInfo2.local());
        IgniteSqlQueryStartFinishListenerTest.assertEquals((Object)GridCacheQueryType.SQL_FIELDS, (Object)finishedInfo2.queryType());
        IgniteSqlQueryStartFinishListenerTest.assertEquals((boolean)true, (boolean)finishedInfo2.failed());
        Assert.assertThat((Object)finishedInfo2.finishTime(), (Matcher)Is.is(IgniteSqlQueryStartFinishListenerTest.greaterOrEqualTo(finishedInfo2.startTime())));
        qryStarted.set(null);
        qryFinished.set(null);
        String qry3 = "text query";
        IgniteCache cache = this.grid(CLIENT_NODE_NAME).cache("default");
        cache.query((Query)new TextQuery(String.class, "text query"));
        this.assertWithTimeout(qryStarted::get, Is.is((Matcher)IsNull.notNullValue()), 1000L);
        startedInfo2 = (GridQueryStartedInfo)qryStarted.get();
        IgniteSqlQueryStartFinishListenerTest.assertEquals((String)cache.getName(), (String)startedInfo2.schemaName());
        IgniteSqlQueryStartFinishListenerTest.assertEquals((String)"text query", (String)startedInfo2.query());
        IgniteSqlQueryStartFinishListenerTest.assertEquals((Object)this.grid(SERVER_NODE_NAME).localNode().id(), (Object)startedInfo2.nodeId());
        IgniteSqlQueryStartFinishListenerTest.assertEquals((boolean)true, (boolean)startedInfo2.local());
        IgniteSqlQueryStartFinishListenerTest.assertEquals((Object)GridCacheQueryType.TEXT, (Object)startedInfo2.queryType());
        this.assertWithTimeout(qryFinished::get, Is.is((Matcher)IsNull.notNullValue()), 1000L);
        finishedInfo2 = (GridQueryFinishedInfo)qryFinished.get();
        IgniteSqlQueryStartFinishListenerTest.assertEquals((String)cache.getName(), (String)finishedInfo2.schemaName());
        IgniteSqlQueryStartFinishListenerTest.assertEquals((String)"text query", (String)finishedInfo2.query());
        IgniteSqlQueryStartFinishListenerTest.assertEquals((Object)this.grid(SERVER_NODE_NAME).localNode().id(), (Object)startedInfo2.nodeId());
        IgniteSqlQueryStartFinishListenerTest.assertEquals((boolean)true, (boolean)finishedInfo2.local());
        IgniteSqlQueryStartFinishListenerTest.assertEquals((Object)GridCacheQueryType.TEXT, (Object)finishedInfo2.queryType());
        IgniteSqlQueryStartFinishListenerTest.assertEquals((boolean)false, (boolean)finishedInfo2.failed());
        Assert.assertThat((Object)finishedInfo2.finishTime(), (Matcher)Is.is(IgniteSqlQueryStartFinishListenerTest.greaterOrEqualTo(finishedInfo2.startTime())));
        qryStarted.set(null);
        qryFinished.set(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testListeneresNotBlocksQueryExecution() throws IgniteCheckedException {
        CountDownLatch latch = new CountDownLatch(1);
        AtomicInteger lsnrCalls = new AtomicInteger();
        int quryRuns = 1000;
        int threadCnt = 20;
        this.registerQueryStartedListener(info -> {
            try {
                latch.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            lsnrCalls.incrementAndGet();
        });
        this.registerQueryFinishedListener(info -> {
            try {
                latch.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            lsnrCalls.incrementAndGet();
        });
        IgniteInternalFuture fut = GridTestUtils.runMultiThreadedAsync(() -> {
            for (int i = 0; i < 1000; ++i) {
                this.execSql(QueryUtils.sysSchemaName(), "select * from caches", new Object[0]);
            }
        }, (int)20, (String)"test-async-query-runner");
        try {
            fut.get(15000L);
        }
        finally {
            latch.countDown();
        }
        this.assertWithTimeout(lsnrCalls::get, Is.is((Matcher)IsEqual.equalTo((Object)40000)), 15000L);
    }

    @Test
    public void testFailedListenereNotAffectOthers() throws IgniteCheckedException {
        int lsnrCnt = 3;
        long waitTimeout = 1000L;
        boolean[] startLsnrsNotified = new boolean[3];
        boolean[] finishLsnrsNotified = new boolean[3];
        boolean[] startLsnrShouldFail = new boolean[3];
        boolean[] finishLsnrShouldFail = new boolean[3];
        int i = 0;
        while (i < 3) {
            int lsnNo = i++;
            this.registerQueryStartedListener(info -> {
                if (startLsnrShouldFail[lsnNo]) {
                    startLsnrShouldFail[lsnNo] = false;
                    throw new RuntimeException("Start listener fails");
                }
                startLsnrsNotified[lsnNo] = true;
            });
            this.registerQueryFinishedListener(info -> {
                if (finishLsnrShouldFail[lsnNo]) {
                    finishLsnrShouldFail[lsnNo] = false;
                    throw new RuntimeException("Finish listener fails");
                }
                finishLsnrsNotified[lsnNo] = true;
            });
        }
        startLsnrShouldFail[0] = true;
        finishLsnrShouldFail[1] = true;
        this.execSql(QueryUtils.sysSchemaName(), "select * from caches", new Object[0]);
        this.assertWithTimeout(() -> startLsnrsNotified[0], IgniteSqlQueryStartFinishListenerTest.isFalse(), 1000L);
        this.assertWithTimeout(() -> startLsnrsNotified[1], IgniteSqlQueryStartFinishListenerTest.isTrue(), 1000L);
        this.assertWithTimeout(() -> startLsnrsNotified[2], IgniteSqlQueryStartFinishListenerTest.isTrue(), 1000L);
        this.assertWithTimeout(() -> finishLsnrsNotified[0], IgniteSqlQueryStartFinishListenerTest.isTrue(), 1000L);
        this.assertWithTimeout(() -> finishLsnrsNotified[1], IgniteSqlQueryStartFinishListenerTest.isFalse(), 1000L);
        this.assertWithTimeout(() -> finishLsnrsNotified[2], IgniteSqlQueryStartFinishListenerTest.isTrue(), 1000L);
        this.resetListeners(startLsnrsNotified, finishLsnrsNotified);
        startLsnrShouldFail[1] = true;
        finishLsnrShouldFail[2] = true;
        this.execSql(QueryUtils.sysSchemaName(), "select * from caches", new Object[0]);
        this.assertWithTimeout(() -> startLsnrsNotified[0], IgniteSqlQueryStartFinishListenerTest.isTrue(), 1000L);
        this.assertWithTimeout(() -> startLsnrsNotified[1], IgniteSqlQueryStartFinishListenerTest.isFalse(), 1000L);
        this.assertWithTimeout(() -> startLsnrsNotified[2], IgniteSqlQueryStartFinishListenerTest.isTrue(), 1000L);
        this.assertWithTimeout(() -> finishLsnrsNotified[0], IgniteSqlQueryStartFinishListenerTest.isTrue(), 1000L);
        this.assertWithTimeout(() -> finishLsnrsNotified[1], IgniteSqlQueryStartFinishListenerTest.isTrue(), 1000L);
        this.assertWithTimeout(() -> finishLsnrsNotified[2], IgniteSqlQueryStartFinishListenerTest.isFalse(), 1000L);
        this.resetListeners(startLsnrsNotified, finishLsnrsNotified);
        startLsnrShouldFail[2] = true;
        finishLsnrShouldFail[0] = true;
        this.execSql(QueryUtils.sysSchemaName(), "select * from caches", new Object[0]);
        this.assertWithTimeout(() -> startLsnrsNotified[0], IgniteSqlQueryStartFinishListenerTest.isTrue(), 1000L);
        this.assertWithTimeout(() -> startLsnrsNotified[1], IgniteSqlQueryStartFinishListenerTest.isTrue(), 1000L);
        this.assertWithTimeout(() -> startLsnrsNotified[2], IgniteSqlQueryStartFinishListenerTest.isFalse(), 1000L);
        this.assertWithTimeout(() -> finishLsnrsNotified[0], IgniteSqlQueryStartFinishListenerTest.isFalse(), 1000L);
        this.assertWithTimeout(() -> finishLsnrsNotified[1], IgniteSqlQueryStartFinishListenerTest.isTrue(), 1000L);
        this.assertWithTimeout(() -> finishLsnrsNotified[2], IgniteSqlQueryStartFinishListenerTest.isTrue(), 1000L);
        this.resetListeners(startLsnrsNotified, finishLsnrsNotified);
    }

    private void resetListeners(boolean[] ... arrays) {
        for (boolean[] arr : arrays) {
            Arrays.fill(arr, false);
        }
    }

    private IgniteH2Indexing indexing() {
        return (IgniteH2Indexing)this.grid(SERVER_NODE_NAME).context().query().getIndexing();
    }

    private List<List<?>> execSql(String schema, String sql, Object ... args) {
        return this.grid(SERVER_NODE_NAME).cache("default").query(new SqlFieldsQuery(sql).setSchema(schema).setArgs(args).setLocal(false).setLazy(false)).getAll();
    }

    private List<List<?>> execSqlLocal(String schema, String sql, Object ... args) {
        return this.grid(SERVER_NODE_NAME).cache("default").query(new SqlFieldsQuery(sql).setSchema(schema).setArgs(args).setLocal(true)).getAll();
    }

    private Consumer<GridQueryStartedInfo> registerQueryStartedListener(Consumer<GridQueryStartedInfo> lsnr) {
        this.lsnrs.add(lsnr);
        this.indexing().registerQueryStartedListener(lsnr);
        return lsnr;
    }

    private Consumer<GridQueryFinishedInfo> registerQueryFinishedListener(Consumer<GridQueryFinishedInfo> lsnr) {
        this.lsnrs.add(lsnr);
        this.indexing().registerQueryFinishedListener(lsnr);
        return lsnr;
    }

    private <T> void assertWithTimeout(Supplier<T> actualSupplier, Matcher<? super T> matcher, long timeout) throws IgniteInterruptedCheckedException {
        GridTestUtils.waitForCondition(() -> matcher.matches(actualSupplier.get()), (long)timeout);
        Assert.assertThat(actualSupplier.get(), matcher);
    }

    private static <T extends Comparable<? super T>> Matcher<T> greaterOrEqualTo(final T wanted) {
        return new CustomMatcher<T>("should be greater or equal to " + wanted){

            public boolean matches(Object item) {
                return wanted != null && item instanceof Comparable && ((Comparable)item).compareTo(wanted) >= 0;
            }
        };
    }

    private static Matcher<Boolean> isTrue() {
        return new CustomMatcher<Boolean>("should be true "){

            public boolean matches(Object item) {
                return item instanceof Boolean && (Boolean)item != false;
            }
        };
    }

    private static Matcher<Boolean> isFalse() {
        return new CustomMatcher<Boolean>("should be true "){

            public boolean matches(Object item) {
                return item instanceof Boolean && (Boolean)item == false;
            }
        };
    }
}

