/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2;

import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.cache.configuration.CompleteConfiguration;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.QueryIndex;
import org.apache.ignite.cache.QueryIndexType;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.compute.ComputeTask;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.ComputeTaskInternalFuture;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorTaskArgument;
import org.apache.ignite.internal.visor.verify.VisorValidateIndexesJobResult;
import org.apache.ignite.internal.visor.verify.VisorValidateIndexesTask;
import org.apache.ignite.internal.visor.verify.VisorValidateIndexesTaskArg;
import org.apache.ignite.internal.visor.verify.VisorValidateIndexesTaskResult;
import org.apache.ignite.testframework.ListeningTestLogger;
import org.apache.ignite.testframework.LogListener;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;

public class GridIndexRebuildTest
extends GridCommonAbstractTest {
    public static final String FIRST_CACHE = "cache1";
    public static final String SECOND_CACHE = "cache2";
    private final ListeningTestLogger listeningLog = new ListeningTestLogger(false, log);

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.stopAllGrids();
        this.cleanPersistenceDir();
    }

    protected void afterTest() throws Exception {
        super.afterTest();
        this.stopAllGrids();
        this.cleanPersistenceDir();
    }

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration configuration = super.getConfiguration(igniteInstanceName);
        configuration.setConsistentId((Serializable)((Object)igniteInstanceName));
        DataStorageConfiguration dsCfg = new DataStorageConfiguration();
        dsCfg.setDefaultDataRegionConfiguration(new DataRegionConfiguration().setMaxSize(0x10000000L).setPersistenceEnabled(true));
        dsCfg.setCheckpointFrequency(3000L);
        configuration.setDataStorageConfiguration(dsCfg);
        CacheConfiguration ccfgFirst = new CacheConfiguration();
        LinkedHashMap<String, String> fields = new LinkedHashMap<String, String>();
        fields.put("updateDate", "java.lang.Date");
        fields.put("amount", "java.lang.Long");
        fields.put("name", "java.lang.String");
        Set<QueryIndex> indices = Collections.singleton(new QueryIndex("name", QueryIndexType.SORTED));
        ccfgFirst.setName(FIRST_CACHE).setBackups(2).setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL).setGroupName("group").setCacheMode(CacheMode.PARTITIONED).setQueryEntities(Collections.singletonList(new QueryEntity(Long.class, Account.class).setFields(fields).setIndexes(indices)));
        CacheConfiguration ccfgSecond = new CacheConfiguration((CompleteConfiguration)ccfgFirst).setName(SECOND_CACHE);
        configuration.setCacheConfiguration(new CacheConfiguration[]{ccfgFirst, ccfgSecond});
        configuration.setGridLogger((IgniteLogger)this.listeningLog);
        return configuration;
    }

    @Test
    public void testFullIndexRebuild() throws Exception {
        long i;
        long start = System.currentTimeMillis();
        IgniteEx grid1 = this.startGrids(4);
        grid1.cluster().active(true);
        int accountCnt = 2048;
        try (IgniteDataStreamer streamer = grid1.dataStreamer(FIRST_CACHE);){
            for (i = 0L; i < 2048L; ++i) {
                streamer.addData((Object)i, (Object)new Account(i));
            }
            streamer.flush();
        }
        streamer = grid1.dataStreamer(SECOND_CACHE);
        var6_5 = null;
        try {
            for (i = 0L; i < 2048L; ++i) {
                streamer.addData((Object)i, (Object)new Account(i));
            }
            streamer.flush();
        }
        catch (Throwable i2) {
            var6_5 = i2;
            throw i2;
        }
        finally {
            if (streamer != null) {
                if (var6_5 != null) {
                    try {
                        streamer.close();
                    }
                    catch (Throwable i2) {
                        var6_5.addSuppressed(i2);
                    }
                } else {
                    streamer.close();
                }
            }
        }
        final AtomicBoolean stop = new AtomicBoolean();
        final IgniteCache cache1 = grid1.cache(FIRST_CACHE);
        final IgniteCache cache2 = grid1.cache(SECOND_CACHE);
        new Thread(new Runnable(){

            @Override
            public void run() {
                long i = 0L;
                while (!stop.get()) {
                    try {
                        cache1.put((Object)i, (Object)new Account(i));
                        if (i % 13L == 7L) {
                            cache2.put((Object)i, (Object)new Account2(i));
                        } else {
                            cache2.put((Object)i, (Object)new Account(i));
                        }
                        ++i;
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
            }
        }).start();
        File workDir = U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)"db", (boolean)false);
        long diff = System.currentTimeMillis() - start;
        U.sleep((long)(7500L - diff % 5000L));
        this.stopGrid(3);
        stop.set(true);
        for (File grp : new File(workDir, U.maskForFileName((CharSequence)this.getTestIgniteInstanceName(3))).listFiles()) {
            new File(grp, "index.bin").delete();
        }
        this.startGrid(3);
        this.awaitPartitionMapExchange();
        U.sleep((long)3000L);
        ImmutableSet nodes = ImmutableSet.of((Object)this.grid(2).localNode().id(), (Object)this.grid(3).localNode().id());
        VisorValidateIndexesTaskArg arg = new VisorValidateIndexesTaskArg(null, null, 10000, 1, true, true);
        VisorTaskArgument visorTaskArg = new VisorTaskArgument((Collection)nodes, (Object)arg, true);
        ComputeTaskInternalFuture exec = grid1.context().task().execute((ComputeTask)new VisorValidateIndexesTask(), (Object)visorTaskArg);
        VisorValidateIndexesTaskResult res = (VisorValidateIndexesTaskResult)exec.get();
        Map results = res.results();
        boolean hasIssue = false;
        for (VisorValidateIndexesJobResult jobResult : results.values()) {
            System.err.println(jobResult);
            hasIssue |= jobResult.hasIssues();
        }
        GridIndexRebuildTest.assertFalse((boolean)hasIssue);
    }

    @Test
    public void testPartialIndexRebuild() throws Exception {
        LogListener lsnr = LogListener.matches((String)"B+Tree is corrupted").build();
        this.listeningLog.registerListener(lsnr);
        long start = System.currentTimeMillis();
        IgniteEx grid1 = this.startGrids(4);
        grid1.cluster().active(true);
        int accountCnt = 2048;
        try (IgniteDataStreamer streamer = grid1.dataStreamer(SECOND_CACHE);){
            for (long i = 0L; i < 2048L; ++i) {
                streamer.addData((Object)i, (Object)new Account(i));
            }
            streamer.flush();
        }
        final AtomicBoolean stop = new AtomicBoolean();
        final IgniteCache cache2 = grid1.cache(SECOND_CACHE);
        new Thread(new Runnable(){

            @Override
            public void run() {
                long i = 0L;
                while (!stop.get()) {
                    try {
                        if (i % 13L == 7L) {
                            cache2.put((Object)i, (Object)new Account2(i));
                        } else {
                            cache2.put((Object)i, (Object)new Account(i));
                        }
                        ++i;
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
            }
        }).start();
        long diff = System.currentTimeMillis() - start;
        U.sleep((long)(7500L - diff % 5000L));
        this.stopGrid(3);
        stop.set(true);
        cache2.query(new SqlFieldsQuery("CREATE INDEX idx" + UUID.randomUUID().toString().replaceAll("-", "_") + " on Account (amount)")).getAll();
        this.startGrid(3);
        this.awaitPartitionMapExchange();
        U.sleep((long)3000L);
        ImmutableSet nodes = ImmutableSet.of((Object)this.grid(2).localNode().id(), (Object)this.grid(3).localNode().id());
        VisorValidateIndexesTaskArg arg = new VisorValidateIndexesTaskArg(null, null, 10000, 1, true, true);
        VisorTaskArgument visorTaskArg = new VisorTaskArgument((Collection)nodes, (Object)arg, true);
        ComputeTaskInternalFuture exec = grid1.context().task().execute((ComputeTask)new VisorValidateIndexesTask(), (Object)visorTaskArg);
        VisorValidateIndexesTaskResult res = (VisorValidateIndexesTaskResult)exec.get();
        Map results = res.results();
        boolean hasIssue = false;
        for (VisorValidateIndexesJobResult jobResult : results.values()) {
            System.err.println(jobResult);
            hasIssue |= jobResult.hasIssues();
        }
        GridIndexRebuildTest.assertFalse((boolean)hasIssue);
        GridIndexRebuildTest.assertFalse((String)"B+Tree is corrupted.", (boolean)lsnr.check());
    }

    private void cleanPersistenceFiles(String igName) throws Exception {
        String ig1DbPath = Paths.get("db", igName).toString();
        File igDbDir = U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)ig1DbPath, (boolean)false);
        U.delete((File)igDbDir);
        Files.createDirectory(igDbDir.toPath(), new FileAttribute[0]);
        String ig1DbWalPath = Paths.get("db", "wal", igName).toString();
        U.delete((File)U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)ig1DbWalPath, (boolean)false));
        ig1DbWalPath = Paths.get("db", "wal", "archive", igName).toString();
        U.delete((File)U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)ig1DbWalPath, (boolean)false));
    }

    public static class Account2 {
        private Long id;
        private String name2;
        private Long Wamount2;
        private Date updateDate2;

        public Account2(Long id) {
            this.id = id;
            this.name2 = "Account" + id;
            this.Wamount2 = id * 1000L;
            this.updateDate2 = new Date();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Account account = (Account)o;
            return Objects.equals(this.id, account.id);
        }

        public int hashCode() {
            return Objects.hash(this.id);
        }
    }

    public static class Account {
        private Long id;
        private String name;
        private Long amount;
        private Date updateDate;

        public Account(Long id) {
            this.id = id;
            this.name = "Account" + id;
            this.amount = id * 1000L;
            this.updateDate = new Date();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Account account = (Account)o;
            return Objects.equals(this.id, account.id);
        }

        public int hashCode() {
            return Objects.hash(this.id);
        }
    }
}

