/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import javax.cache.CacheException;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.Ignition;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.QueryIndex;
import org.apache.ignite.client.ClientCache;
import org.apache.ignite.client.ClientCacheConfiguration;
import org.apache.ignite.client.ClientException;
import org.apache.ignite.client.ClientTransaction;
import org.apache.ignite.client.IgniteClient;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.ClientConfiguration;
import org.apache.ignite.failure.FailureContext;
import org.apache.ignite.failure.FailureHandler;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.apache.ignite.transactions.Transaction;
import org.apache.ignite.transactions.TransactionConcurrency;
import org.apache.ignite.transactions.TransactionIsolation;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class WrongQueryEntityFieldTypeTest
extends GridCommonAbstractTest {
    @Parameterized.Parameter
    public CacheAtomicityMode mode;
    @Parameterized.Parameter(value=1)
    public int backups;
    @Parameterized.Parameter(value=2)
    public Supplier<?> val;
    @Parameterized.Parameter(value=3)
    public String idxFld;
    @Parameterized.Parameter(value=4)
    public Class<?> idxFldType;
    @Parameterized.Parameter(value=5)
    public int gridCnt;
    private volatile boolean sysThreadFail;

    @Parameterized.Parameters(name="cacheMode={0},backups={1},idxFld={3},idxFldType={4},gridCnt={5}")
    public static Collection<Object[]> parameters() {
        Supplier<Object> person = WrongQueryEntityFieldTypeTest::personInside;
        Supplier<Object> floatInsteadLong = WrongQueryEntityFieldTypeTest::floatInside;
        Supplier<Object> organization = WrongQueryEntityFieldTypeTest::personInsideOrganization;
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (CacheAtomicityMode cacheMode : CacheAtomicityMode.values()) {
            if (cacheMode == CacheAtomicityMode.TRANSACTIONAL_SNAPSHOT) continue;
            for (int backups = 0; backups < 4; ++backups) {
                for (int gridCnt = 1; gridCnt < 4; ++gridCnt) {
                    params.add(new Object[]{cacheMode, backups, person, "field", String.class, gridCnt});
                    params.add(new Object[]{cacheMode, backups, floatInsteadLong, "field", Long.class, gridCnt});
                    params.add(new Object[]{cacheMode, backups, organization, "head", String.class, gridCnt});
                }
            }
        }
        return params;
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
    }

    protected FailureHandler getFailureHandler(String igniteInstanceName) {
        return new FailureHandler(){

            public boolean onFailure(Ignite ignite, FailureContext failureCtx) {
                WrongQueryEntityFieldTypeTest.this.sysThreadFail = true;
                return false;
            }
        };
    }

    @Test
    public void testPutFromThinClient() throws Exception {
        this.withThinClient((cli, cache) -> {
            GridTestUtils.assertThrowsWithCause(() -> cache.put((Object)1, this.val.get()), ClientException.class);
            WrongQueryEntityFieldTypeTest.assertNull((Object)cache.withKeepBinary().get((Object)1));
        });
    }

    @Test
    public void testPut() throws Exception {
        this.withNode((ign, cache) -> {
            GridTestUtils.assertThrowsWithCause(() -> cache.put((Object)1, this.val.get()), CacheException.class);
            WrongQueryEntityFieldTypeTest.assertNull((Object)cache.withKeepBinary().get((Object)1));
        });
    }

    @Test
    public void testPutFromThinClientTx() throws Exception {
        if (this.mode == CacheAtomicityMode.ATOMIC) {
            return;
        }
        this.withThinClient((cli, cache) -> {
            for (TransactionConcurrency conc : TransactionConcurrency.values()) {
                for (TransactionIsolation iso : TransactionIsolation.values()) {
                    if (conc == TransactionConcurrency.OPTIMISTIC && this.mode == CacheAtomicityMode.TRANSACTIONAL_SNAPSHOT) continue;
                    GridTestUtils.assertThrowsWithCause(() -> {
                        try (ClientTransaction tx = cli.transactions().txStart(conc, iso);){
                            cache.put((Object)1, this.val.get());
                            tx.commit();
                        }
                    }, ClientException.class);
                    WrongQueryEntityFieldTypeTest.assertNull((Object)cache.withKeepBinary().get((Object)1));
                }
            }
        });
    }

    @Test
    public void testPutTx() throws Exception {
        if (this.mode == CacheAtomicityMode.ATOMIC) {
            return;
        }
        this.withNode((ign, cache) -> {
            for (TransactionConcurrency conc : TransactionConcurrency.values()) {
                for (TransactionIsolation iso : TransactionIsolation.values()) {
                    if (conc == TransactionConcurrency.OPTIMISTIC && this.mode == CacheAtomicityMode.TRANSACTIONAL_SNAPSHOT) continue;
                    GridTestUtils.assertThrowsWithCause(() -> {
                        try (Transaction tx = ign.transactions().txStart(conc, iso);){
                            cache.put((Object)1, this.val.get());
                            tx.commit();
                        }
                    }, this.mode == CacheAtomicityMode.TRANSACTIONAL_SNAPSHOT ? CacheException.class : IgniteSQLException.class);
                    WrongQueryEntityFieldTypeTest.assertNull((Object)cache.withKeepBinary().get((Object)1));
                }
            }
        });
    }

    private void withThinClient(BiConsumer<IgniteClient, ClientCache<Integer, Object>> consumer) throws Exception {
        this.startGrids(this.gridCnt);
        try (IgniteClient cli = Ignition.startClient((ClientConfiguration)new ClientConfiguration().setAddresses(new String[]{"127.0.0.1:10800"}));){
            ClientCache cache = cli.createCache(new ClientCacheConfiguration().setName("TEST").setAtomicityMode(this.mode).setBackups(this.backups).setQueryEntities(new QueryEntity[]{this.queryEntity()}));
            consumer.accept(cli, (ClientCache<Integer, Object>)cache);
            WrongQueryEntityFieldTypeTest.assertFalse((boolean)this.sysThreadFail);
        }
    }

    private void withNode(BiConsumer<Ignite, IgniteCache<Integer, Object>> consumer) throws Exception {
        IgniteEx ign = this.startGrids(this.gridCnt);
        IgniteCache cache = ign.createCache(new CacheConfiguration().setName("TEST").setAtomicityMode(this.mode).setBackups(this.backups).setQueryEntities(Collections.singleton(this.queryEntity())));
        consumer.accept((Ignite)ign, (IgniteCache<Integer, Object>)cache);
        WrongQueryEntityFieldTypeTest.assertFalse((boolean)this.sysThreadFail);
    }

    public static Object personInsideOrganization() {
        try {
            ClassLoader ldr = WrongQueryEntityFieldTypeTest.getExternalClassLoader();
            Class<?> organization = ldr.loadClass("org.apache.ignite.tests.p2p.cache.Organization");
            Class<?> person = ldr.loadClass("org.apache.ignite.tests.p2p.cache.Person");
            Class<?> address = ldr.loadClass("org.apache.ignite.tests.p2p.cache.Address");
            Object p = person.getConstructor(String.class).newInstance("test");
            return organization.getConstructor(String.class, person, address).newInstance("org", p, null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Object personInside() {
        try {
            ClassLoader ldr = WrongQueryEntityFieldTypeTest.getExternalClassLoader();
            Class<?> container = ldr.loadClass("org.apache.ignite.tests.p2p.cache.Container");
            Class<?> personCls = ldr.loadClass("org.apache.ignite.tests.p2p.cache.Person");
            Object person = personCls.getConstructor(new Class[0]).newInstance(new Object[0]);
            return container.getConstructor(Object.class).newInstance(person);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Object floatInside() {
        try {
            ClassLoader ldr = WrongQueryEntityFieldTypeTest.getExternalClassLoader();
            Class<?> container = ldr.loadClass("org.apache.ignite.tests.p2p.cache.Container");
            return container.getConstructor(Object.class).newInstance(Float.valueOf(1.0f));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private QueryEntity queryEntity() {
        LinkedHashMap<String, String> fields = new LinkedHashMap<String, String>();
        fields.put(this.idxFld, this.idxFldType.getName());
        return new QueryEntity().setKeyType(Integer.class.getName()).setValueType(this.val.get().getClass().getName()).setFields(fields).setIndexes(Collections.singleton(new QueryIndex(this.idxFld)));
    }
}

