/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.QueryIndex;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.processors.query.QueryUtils;
import org.apache.ignite.internal.util.typedef.G;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.WithSystemProperty;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;

public class SqlIndexesSystemViewStaticCfgTest
extends GridCommonAbstractTest {
    private Ignite driver;
    private boolean client;
    private CacheConfiguration<Object, Object>[] ccfg;

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        return super.getConfiguration(igniteInstanceName).setClientMode(this.client).setCacheConfiguration(this.ccfg).setDataStorageConfiguration(new DataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setPersistenceEnabled(true)));
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
        this.cleanPersistenceDir();
    }

    @Test
    public void testNotActivatedGrid() throws Exception {
        this.ccfg = new CacheConfiguration[]{new CacheConfiguration("cache").setQueryEntities(Collections.singleton(new QueryEntity(Integer.class, TestValue.class).setIndexes(Collections.singleton(new QueryIndex("i")))))};
        this.startGrid(0);
        this.client = true;
        this.startGrid(2);
        for (Ignite ign : G.allGrids()) {
            GridTestUtils.assertThrowsWithCause(() -> SqlIndexesSystemViewStaticCfgTest.execSql(ign, "SELECT * FROM SYS.INDEXES ORDER BY TABLE_NAME, INDEX_NAME"), IgniteException.class);
        }
    }

    @WithSystemProperty(key="IGNITE_SQL_DISABLE_SYSTEM_VIEWS", value="true")
    @Test
    public void testIndexesViewDisabledBySystemProperty() throws Exception {
        this.ccfg = new CacheConfiguration[]{new CacheConfiguration("cache").setQueryEntities(Collections.singleton(new QueryEntity(Integer.class, TestValue.class).setIndexes(Collections.singleton(new QueryIndex("i")))))};
        this.startNodes();
        for (Ignite ign : G.allGrids()) {
            Throwable e = GridTestUtils.assertThrowsWithCause(() -> SqlIndexesSystemViewStaticCfgTest.execSql(ign, "SELECT * FROM SYS.INDEXES ORDER BY TABLE_NAME, INDEX_NAME"), IgniteSQLException.class);
            SqlIndexesSystemViewStaticCfgTest.assertTrue((boolean)e.getMessage().contains("Schema \"SYS\" not found"));
        }
    }

    @Test
    public void testStaticCacheCfg() throws Exception {
        this.ccfg = new CacheConfiguration[]{new CacheConfiguration("cache").setQueryEntities(Collections.singleton(new QueryEntity(Integer.class, TestValue.class).setIndexes(Collections.singleton(new QueryIndex("i")))))};
        this.startNodes();
        List<Object> expCache = Arrays.asList(Arrays.asList(94416770, "cache", 94416770, "cache", "cache", "TESTVALUE", "TESTVALUE_I_ASC_IDX", "BTREE", "\"I\" ASC, \"_KEY\" ASC", false, false, 10), Arrays.asList(94416770, "cache", 94416770, "cache", "cache", "TESTVALUE", "__SCAN_", "SCAN", null, false, false, null), Arrays.asList(94416770, "cache", 94416770, "cache", "cache", "TESTVALUE", "_key_PK", "BTREE", "\"_KEY\" ASC", true, true, 5), Arrays.asList(94416770, "cache", 94416770, "cache", "cache", "TESTVALUE", "_key_PK_hash", "HASH", "\"_KEY\" ASC", false, true, null));
        this.checkIndexes(expCache::equals);
        this.driver.cluster().active(false);
        for (Ignite ign : G.allGrids()) {
            GridTestUtils.assertThrowsWithCause(() -> SqlIndexesSystemViewStaticCfgTest.execSql(ign, "SELECT * FROM IGNITE.INDEXES ORDER BY TABLE_NAME, INDEX_NAME"), IgniteException.class);
        }
        this.driver.cluster().active(true);
        this.checkIndexes(expCache::equals);
        this.driver.destroyCache("cache");
        this.checkIndexes(List::isEmpty);
    }

    @Test
    public void testStaticCacheInGroupCfg() throws Exception {
        this.ccfg = new CacheConfiguration[]{new CacheConfiguration("cache1").setGroupName("group").setQueryEntities(Collections.singleton(new QueryEntity(Integer.class, TestValue.class).setIndexes(Collections.singleton(new QueryIndex("i"))))), new CacheConfiguration("cache2").setGroupName("group").setQueryEntities(Collections.singleton(new QueryEntity(Integer.class, TestValue.class).setIndexes(Collections.singleton(new QueryIndex("i")))))};
        this.startNodes();
        List<Object> expGrpBoth = Arrays.asList(Arrays.asList(98629247, "group", -1368047377, "cache1", "cache1", "TESTVALUE", "TESTVALUE_I_ASC_IDX", "BTREE", "\"I\" ASC, \"_KEY\" ASC", false, false, 10), Arrays.asList(98629247, "group", -1368047377, "cache1", "cache1", "TESTVALUE", "__SCAN_", "SCAN", null, false, false, null), Arrays.asList(98629247, "group", -1368047377, "cache1", "cache1", "TESTVALUE", "_key_PK", "BTREE", "\"_KEY\" ASC", true, true, 5), Arrays.asList(98629247, "group", -1368047377, "cache1", "cache1", "TESTVALUE", "_key_PK_hash", "HASH", "\"_KEY\" ASC", false, true, null), Arrays.asList(98629247, "group", -1368047376, "cache2", "cache2", "TESTVALUE", "TESTVALUE_I_ASC_IDX", "BTREE", "\"I\" ASC, \"_KEY\" ASC", false, false, 10), Arrays.asList(98629247, "group", -1368047376, "cache2", "cache2", "TESTVALUE", "__SCAN_", "SCAN", null, false, false, null), Arrays.asList(98629247, "group", -1368047376, "cache2", "cache2", "TESTVALUE", "_key_PK", "BTREE", "\"_KEY\" ASC", true, true, 5), Arrays.asList(98629247, "group", -1368047376, "cache2", "cache2", "TESTVALUE", "_key_PK_hash", "HASH", "\"_KEY\" ASC", false, true, null));
        List<Object> expGrpSingle = Arrays.asList(Arrays.asList(98629247, "group", -1368047376, "cache2", "cache2", "TESTVALUE", "TESTVALUE_I_ASC_IDX", "BTREE", "\"I\" ASC, \"_KEY\" ASC", false, false, 10), Arrays.asList(98629247, "group", -1368047376, "cache2", "cache2", "TESTVALUE", "__SCAN_", "SCAN", null, false, false, null), Arrays.asList(98629247, "group", -1368047376, "cache2", "cache2", "TESTVALUE", "_key_PK", "BTREE", "\"_KEY\" ASC", true, true, 5), Arrays.asList(98629247, "group", -1368047376, "cache2", "cache2", "TESTVALUE", "_key_PK_hash", "HASH", "\"_KEY\" ASC", false, true, null));
        this.checkIndexes(expGrpBoth::equals);
        this.driver.destroyCache("cache1");
        this.checkIndexes(expGrpSingle::equals);
    }

    private void startNodes() throws Exception {
        this.driver = this.startGrid(0);
        this.driver.cluster().active(true);
        this.driver.cluster().setBaselineTopology(Collections.singleton(this.grid(0).localNode()));
        this.startGrid(1);
        G.setClientMode((boolean)true);
        this.startGrid(3);
    }

    private void checkIndexes(Predicate<List<List<?>>> checker) throws Exception {
        for (Ignite ign : G.allGrids()) {
            SqlIndexesSystemViewStaticCfgTest.assertTrue((boolean)GridTestUtils.waitForCondition(() -> {
                List<List<?>> indexes = SqlIndexesSystemViewStaticCfgTest.execSql(ign, "SELECT * FROM " + QueryUtils.sysSchemaName() + ".INDEXES ORDER BY CACHE_NAME, INDEX_NAME");
                return checker.test(indexes);
            }, (long)1000L));
        }
    }

    private static List<List<?>> execSql(Ignite ign, String sql) {
        return ((IgniteEx)ign).context().query().querySqlFields(new SqlFieldsQuery(sql), false).getAll();
    }

    public static class TestValue {
        @QuerySqlField
        int i;
    }
}

