/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query;

import java.util.HashMap;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.index.AbstractIndexingCommonTest;
import org.junit.Test;

public class SqlIndexConsistencyAfterInterruptAtomicCacheOperationTest
extends AbstractIndexingCommonTest {
    private static final int KEYS = 1000;

    protected void afterTest() throws Exception {
        this.stopAllGrids();
    }

    protected CacheAtomicityMode atomicity() {
        return CacheAtomicityMode.ATOMIC;
    }

    @Test
    public void testPut() throws Exception {
        IgniteEx ign = this.startGrid(0);
        IgniteCache cache = ign.createCache(new CacheConfiguration("default").setAtomicityMode(this.atomicity()).setIndexedTypes(new Class[]{Integer.class, Integer.class}));
        Thread t = new Thread(() -> cache.put((Object)1, (Object)1));
        t.start();
        t.interrupt();
        t.join();
        SqlIndexConsistencyAfterInterruptAtomicCacheOperationTest.assertEquals((int)cache.size(new CachePeekMode[0]), (int)cache.query(new SqlFieldsQuery("select * from Integer")).getAll().size());
    }

    @Test
    public void testPutAll() throws Exception {
        IgniteEx ign = this.startGrid(0);
        IgniteCache cache = ign.createCache(new CacheConfiguration("default").setAtomicityMode(this.atomicity()).setIndexedTypes(new Class[]{Integer.class, Integer.class}));
        HashMap<Integer, Integer> batch = new HashMap<Integer, Integer>();
        for (int i = 0; i < 1000; ++i) {
            batch.put(i, i);
        }
        Thread t = new Thread(() -> cache.putAll(batch));
        t.start();
        t.interrupt();
        t.join();
        SqlIndexConsistencyAfterInterruptAtomicCacheOperationTest.assertEquals((int)cache.size(new CachePeekMode[0]), (int)cache.query(new SqlFieldsQuery("select * from Integer")).getAll().size());
    }

    @Test
    public void testRemove() throws Exception {
        IgniteEx ign = this.startGrid(0);
        IgniteCache cache = ign.createCache(new CacheConfiguration("default").setAtomicityMode(this.atomicity()).setIndexedTypes(new Class[]{Integer.class, Integer.class}));
        cache.put((Object)1, (Object)1);
        Thread t = new Thread(() -> cache.remove((Object)1));
        t.start();
        t.interrupt();
        t.join();
        SqlIndexConsistencyAfterInterruptAtomicCacheOperationTest.assertEquals((int)cache.size(new CachePeekMode[0]), (int)cache.query(new SqlFieldsQuery("select * from Integer")).getAll().size());
    }

    @Test
    public void testRemoveAll() throws Exception {
        IgniteEx ign = this.startGrid(0);
        IgniteCache cache = ign.createCache(new CacheConfiguration("default").setAtomicityMode(this.atomicity()).setIndexedTypes(new Class[]{Integer.class, Integer.class}));
        HashMap<Integer, Integer> batch = new HashMap<Integer, Integer>();
        for (int i = 0; i < 1000; ++i) {
            batch.put(i, i);
        }
        cache.putAll(batch);
        Thread t = new Thread(() -> cache.removeAll(batch.keySet()));
        t.start();
        t.interrupt();
        t.join();
        SqlIndexConsistencyAfterInterruptAtomicCacheOperationTest.assertEquals((int)cache.size(new CachePeekMode[0]), (int)cache.query(new SqlFieldsQuery("select * from Integer")).getAll().size());
    }
}

