/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.ignite.internal.processors.query.AbstractCustomSchemaTest;

public class JdbcSqlCustomSchemaTest
extends AbstractCustomSchemaTest {
    private static final Pattern SELECT_QRY_PATTERN = Pattern.compile("^SELECT .*");
    private Connection conn;

    @Override
    protected void afterTestsStopped() throws Exception {
        if (this.conn != null && !this.conn.isClosed()) {
            this.conn.close();
        }
        super.afterTestsStopped();
    }

    private Connection getOrCreateConnection() throws SQLException {
        if (this.conn == null) {
            this.conn = DriverManager.getConnection("jdbc:ignite:thin://127.0.0.1");
        }
        return this.conn;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected List<List<?>> execSql(String qry) {
        try (Statement stmt = this.getOrCreateConnection().createStatement();){
            if (SELECT_QRY_PATTERN.matcher(qry).matches()) {
                List<List<?>> list = this.resultSetToList(stmt.executeQuery(qry));
                return list;
            }
            stmt.execute(qry);
            List<List<?>> list = Collections.emptyList();
            return list;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private List<List<?>> resultSetToList(ResultSet rs) throws SQLException {
        ArrayList res = new ArrayList();
        while (rs.next()) {
            ArrayList<Object> row = new ArrayList<Object>();
            res.add(row);
            for (int i = 1; i <= rs.getMetaData().getColumnCount(); ++i) {
                row.add(rs.getObject(i));
            }
        }
        return res;
    }
}

