/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.affinity.AffinityKeyMapped;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.index.AbstractIndexingCommonTest;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.processors.query.h2.ConnectionManager;
import org.apache.ignite.internal.processors.query.h2.H2Utils;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.testframework.GridTestUtils;
import org.gridgain.internal.h2.api.AggregateFunction;
import org.gridgain.internal.h2.jdbc.JdbcSQLSyntaxErrorException;
import org.junit.Test;

public class IgniteSqlCustomAggregationTest
extends AbstractIndexingCommonTest {
    private static final String CACHE_NAME = "cache";

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        CacheConfiguration cacheCfg = new CacheConfiguration(CACHE_NAME).setIndexedTypes(new Class[]{PersonKey.class, Person.class}).setCacheMode(CacheMode.PARTITIONED).setBackups(0);
        cfg.setCacheConfiguration(new CacheConfiguration[]{cacheCfg});
        return cfg;
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.startGrids(3);
        this.startClientGrid(3);
    }

    protected void afterTest() throws Exception {
        super.afterTest();
        this.stopAllGrids(false);
    }

    @Test
    public void testAggregateFunctionsCollocated() throws Exception {
        IgniteEx ignite = this.grid(3);
        IgniteCache cache = ignite.cache(CACHE_NAME);
        this.loadCacheWithoutNullValues((IgniteCache<PersonKey, Person>)cache);
        List rows = cache.query(new SqlFieldsQuery("select companyId,FIRSTVALUE(NAME,AGE), LASTVALUE(UPPER(NAME),AGE) from \"cache\".Person group by companyId").setCollocated(true)).getAll();
        IgniteSqlCustomAggregationTest.assertEquals((int)10, (int)rows.size());
        for (List row : rows) {
            Integer companyId = (Integer)row.get(0);
            String youngest = (String)row.get(1);
            String oldest = (String)row.get(2);
            IgniteSqlCustomAggregationTest.assertEquals((String)("name" + companyId), (String)youngest);
            IgniteSqlCustomAggregationTest.assertEquals((String)("name9".toUpperCase() + companyId), (String)oldest);
        }
        rows = cache.query(new SqlFieldsQuery("select FIRSTVALUE(NAME,AGE), LASTVALUE(UPPER(NAME),AGE) from \"cache\".Person where companyId = 1").setCollocated(true)).getAll();
        IgniteSqlCustomAggregationTest.assertEquals((int)1, (int)rows.size());
        List row = (List)rows.get(0);
        IgniteSqlCustomAggregationTest.assertEquals((Object)"name1", row.get(0));
        IgniteSqlCustomAggregationTest.assertEquals((Object)"NAME91", row.get(1));
    }

    @Test
    public void testAggregateFunctionsWithDistinctArgument() throws Exception {
        IgniteEx ignite = this.grid(3);
        for (int i = 0; i < 4; ++i) {
            IgniteH2Indexing indexing = (IgniteH2Indexing)this.grid(i).context().query().getIndexing();
            H2Utils.registerAggregateFunction((IgniteLogger)log, (ConnectionManager)indexing.connections(), (String)"ACCUMULATE", AccumulateFunction.class);
        }
        IgniteCache cache = ignite.cache(CACHE_NAME);
        this.loadCacheWithoutNullValues((IgniteCache<PersonKey, Person>)cache);
        List rows = cache.query(new SqlFieldsQuery("select companyId,ACCUMULATE(DISTINCT companyId) from \"cache\".Person group by companyId").setCollocated(true)).getAll();
        IgniteSqlCustomAggregationTest.assertEquals((int)10, (int)rows.size());
        for (List row : rows) {
            Integer companyId = (Integer)row.get(0);
            List list = (List)row.get(1);
            IgniteSqlCustomAggregationTest.assertEquals((int)1, (int)list.size());
            IgniteSqlCustomAggregationTest.assertEquals((Object)companyId, list.get(0));
        }
    }

    @Test
    public void testAggregateFunctionsWithDistinctResult() throws Exception {
        IgniteEx ignite = this.grid(3);
        IgniteCache cache = ignite.cache(CACHE_NAME);
        this.loadCacheWithoutNullValues((IgniteCache<PersonKey, Person>)cache);
        List rows = cache.query(new SqlFieldsQuery("select DISTINCT departmentId,FIRSTVALUE(departmentId, companyId) from \"cache\".Person group by departmentId").setCollocated(true)).getAll();
        IgniteSqlCustomAggregationTest.assertEquals((int)5, (int)rows.stream().map(r -> r.get(0)).collect(Collectors.toSet()).size());
        for (List row : rows) {
            IgniteSqlCustomAggregationTest.assertEquals((Object)((Integer)row.get(0)), (Object)((Integer)row.get(1)));
        }
    }

    @Test
    public void testAggregateFunctionsNotCollocated() throws Exception {
        IgniteEx ignite = this.grid(3);
        final IgniteCache cache = ignite.cache(CACHE_NAME);
        this.loadCacheWithoutNullValues((IgniteCache<PersonKey, Person>)cache);
        GridTestUtils.assertThrowsAnyCause((IgniteLogger)log, (Callable)new Callable<Object>(){

            @Override
            public Object call() {
                cache.query(new SqlFieldsQuery("select companyId,FIRSTVALUE(NAME,AGE), LASTVALUE(NAME,AGE) from \"cache\".Person group by companyId")).getAll();
                return null;
            }
        }, IgniteSQLException.class, (String)"Custom aggregation function is not supported for not collocated data");
    }

    @Test
    public void testParsingAggregateFunctions() throws Exception {
        IgniteEx ignite = this.grid(3);
        final IgniteCache cache = ignite.cache(CACHE_NAME);
        GridTestUtils.assertThrowsAnyCause((IgniteLogger)log, (Callable)new Callable<Object>(){

            @Override
            public Object call() {
                cache.query(new SqlFieldsQuery("select companyId, FIRSTVALUE(), LASTVALUE() from \"cache\".Person group by companyId").setCollocated(true)).getAll();
                return null;
            }
        }, JdbcSQLSyntaxErrorException.class, null);
        GridTestUtils.assertThrowsAnyCause((IgniteLogger)log, (Callable)new Callable<Object>(){

            @Override
            public Object call() {
                cache.query(new SqlFieldsQuery("select companyId,FIRSTVALUE(name, DISTINCT age), LASTVALUE(name, DISTINCT age) from \"cache\".Person group by companyId").setCollocated(true)).getAll();
                return null;
            }
        }, JdbcSQLSyntaxErrorException.class, null);
        GridTestUtils.assertThrowsAnyCause((IgniteLogger)log, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws IgniteCheckedException {
                for (int i = 0; i < 4; ++i) {
                    IgniteH2Indexing indexing = (IgniteH2Indexing)IgniteSqlCustomAggregationTest.this.grid(i).context().query().getIndexing();
                    H2Utils.registerAggregateFunction((IgniteLogger)log, (ConnectionManager)indexing.connections(), (String)"ACCUMULATE%", AccumulateFunction.class);
                }
                return null;
            }
        }, IgniteCheckedException.class, null);
    }

    @Test
    public void testAggregateFunctionsForNullValues() throws Exception {
        IgniteEx ignite = this.grid(3);
        IgniteCache cache = ignite.cache(CACHE_NAME);
        List rows = cache.query(new SqlFieldsQuery("select companyId,FIRSTVALUE(NAME,AGE), LASTVALUE(NAME,AGE) from \"cache\".Person group by companyId").setCollocated(true)).getAll();
        IgniteSqlCustomAggregationTest.assertEquals((int)0, (int)rows.size());
        this.loadCacheWithNullValues((IgniteCache<PersonKey, Person>)cache);
        rows = cache.query(new SqlFieldsQuery("select companyId,FIRSTVALUE(NAME,AGE), LASTVALUE(NAME,AGE) from \"cache\".Person group by companyId order by companyId").setCollocated(true)).getAll();
        List first = (List)rows.get(0);
        IgniteSqlCustomAggregationTest.assertEquals((Object)1, first.get(0));
        IgniteSqlCustomAggregationTest.assertEquals((Object)"name10", first.get(1));
        IgniteSqlCustomAggregationTest.assertEquals((Object)"name11", first.get(2));
        List second = (List)rows.get(1);
        IgniteSqlCustomAggregationTest.assertEquals((Object)2, second.get(0));
        IgniteSqlCustomAggregationTest.assertNull(second.get(1));
        IgniteSqlCustomAggregationTest.assertEquals((Object)"name11", second.get(2));
    }

    private IgniteCache<PersonKey, Person> loadCacheWithoutNullValues(IgniteCache<PersonKey, Person> cache) {
        for (int i = 0; i < 100; ++i) {
            cache.put((Object)new PersonKey(i, i % 10), (Object)new Person("name" + i, i, i % 5));
        }
        return cache;
    }

    private IgniteCache<PersonKey, Person> loadCacheWithNullValues(IgniteCache<PersonKey, Person> cache) {
        cache.put((Object)new PersonKey(10, 1), (Object)new Person("name10", 1, null));
        cache.put((Object)new PersonKey(11, 1), (Object)new Person("name11", null, null));
        cache.put((Object)new PersonKey(12, 1), (Object)new Person("name12", 3, null));
        cache.put((Object)new PersonKey(20, 2), (Object)new Person(null, 1, null));
        cache.put((Object)new PersonKey(21, 2), (Object)new Person("name11", 2, null));
        return cache;
    }

    public static class AccumulateFunction
    implements AggregateFunction {
        private List<Object> res = new ArrayList<Object>();

        public void init(Connection conn) throws SQLException {
        }

        public int getType(int[] inputTypes) throws SQLException {
            return 0;
        }

        public void add(Object value) throws SQLException {
            if (value instanceof Object[]) {
                this.res.add(((Object[])value)[0]);
            } else {
                this.res.add(value);
            }
        }

        public Object getResult() throws SQLException {
            return this.res;
        }
    }

    static class Person {
        @QuerySqlField
        String name;
        @QuerySqlField
        Integer age;
        @QuerySqlField
        Integer departmentId;

        Person(String name, Integer age, Integer departmentId) {
            this.name = name;
            this.age = age;
            this.departmentId = departmentId;
        }
    }

    static class PersonKey {
        @QuerySqlField
        int id;
        @QuerySqlField
        @AffinityKeyMapped
        int companyId;

        PersonKey(int id, int companyId) {
            this.id = id;
            this.companyId = companyId;
        }
    }
}

