/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.processors.cache.index.AbstractIndexingCommonTest;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.transactions.TransactionDuplicateKeyException;
import org.junit.Test;

public class IgniteInsertNullableDuplicatesSqlTest
extends AbstractIndexingCommonTest {
    @Override
    protected void afterTestsStopped() throws Exception {
        this.stopAllGrids();
        super.afterTestsStopped();
    }

    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        this.startGrids(1);
    }

    protected void afterTest() throws Exception {
        super.afterTest();
        for (String cacheName : this.grid(0).cacheNames()) {
            this.grid(0).cache(cacheName).destroy();
        }
    }

    @Test
    public void testInsertKeyWithNullKeyParts() {
        this.sql("CREATE TABLE test (id1 INT, id2 INT, val INT, CONSTRAINT PK PRIMARY KEY(id1, id2))", new Object[0]);
        this.sql("insert into test (id1, id2, val) values (1, null, 1);", new Object[0]);
        GridTestUtils.assertThrows((IgniteLogger)log, () -> this.sql("insert into test (id1, id2, val) values (1, null, 1);", new Object[0]), TransactionDuplicateKeyException.class, (String)"Duplicate key during INSERT");
        GridTestUtils.assertThrows((IgniteLogger)log, () -> this.sql("insert into test (id1, val) values (1, 1);", new Object[0]), TransactionDuplicateKeyException.class, (String)"Duplicate key during INSERT");
        IgniteInsertNullableDuplicatesSqlTest.assertEquals((int)this.sql("SELECT * FROM test", new Object[0]).getAll().size(), (int)1);
    }

    @Test
    public void testInsertKeyWithNullKeys() {
        this.sql("CREATE TABLE test (id1 INT, id2 INT, val INT, CONSTRAINT PK PRIMARY KEY(id1, id2))", new Object[0]);
        this.sql("insert into test (id1, id2, val) values (null, null, 1);", new Object[0]);
        GridTestUtils.assertThrows((IgniteLogger)log, () -> this.sql("insert into test (id1, val) values (null, 1);", new Object[0]), TransactionDuplicateKeyException.class, (String)"Duplicate key during INSERT");
        GridTestUtils.assertThrows((IgniteLogger)log, () -> this.sql("insert into test (id2, val) values (null, 1);", new Object[0]), TransactionDuplicateKeyException.class, (String)"Duplicate key during INSERT");
        GridTestUtils.assertThrows((IgniteLogger)log, () -> this.sql("insert into test (id2, id1, val) values (null, null, 1);", new Object[0]), TransactionDuplicateKeyException.class, (String)"Duplicate key during INSERT");
        IgniteInsertNullableDuplicatesSqlTest.assertEquals((int)this.sql("SELECT * FROM test", new Object[0]).getAll().size(), (int)1);
    }

    @Test
    public void testInsertKeyWhenKeyIsNotSet() {
        this.sql("CREATE TABLE test (id1 INT, id2 INT, val INT, CONSTRAINT PK PRIMARY KEY(id1, id2))", new Object[0]);
        this.sql("insert into test (val) values (1);", new Object[0]);
        GridTestUtils.assertThrows((IgniteLogger)log, () -> this.sql("insert into test (val) values (1);", new Object[0]), TransactionDuplicateKeyException.class, (String)"Duplicate key during INSERT");
    }

    @Test
    public void testInsertKeyWithNullKeyPartsDefault() {
        this.sql("CREATE TABLE test (id1 INT, id2 INT DEFAULT 20, val INT, CONSTRAINT PK PRIMARY KEY(id1, id2))", new Object[0]);
        this.sql("insert into test (id1, val) values (0, 1);", new Object[0]);
        this.sql("insert into test (val) values (2);", new Object[0]);
        GridTestUtils.assertThrows((IgniteLogger)log, () -> this.sql("insert into test (id1, val) values (0, 1);", new Object[0]), TransactionDuplicateKeyException.class, (String)"Duplicate key during INSERT");
        GridTestUtils.assertThrows((IgniteLogger)log, () -> this.sql("insert into test (val) values (2);", new Object[0]), TransactionDuplicateKeyException.class, (String)"Duplicate key during INSERT");
        List sql = this.sql("select * from test order by val asc;", new Object[0]).getAll();
        IgniteInsertNullableDuplicatesSqlTest.assertEquals((int)sql.size(), (int)2);
        IgniteInsertNullableDuplicatesSqlTest.assertEquals(((List)sql.get(0)).get(0), (Object)0);
        IgniteInsertNullableDuplicatesSqlTest.assertEquals(((List)sql.get(0)).get(1), (Object)20);
        IgniteInsertNullableDuplicatesSqlTest.assertEquals(((List)sql.get(0)).get(2), (Object)1);
        IgniteInsertNullableDuplicatesSqlTest.assertNull(((List)sql.get(1)).get(0));
        IgniteInsertNullableDuplicatesSqlTest.assertEquals(((List)sql.get(1)).get(1), (Object)20);
        IgniteInsertNullableDuplicatesSqlTest.assertEquals(((List)sql.get(1)).get(2), (Object)2);
    }

    @Test
    public void testInsertKeyWithNullKeyPartsDefaultCacheApi() {
        LinkedHashSet<String> keyFields = new LinkedHashSet<String>();
        keyFields.add("ID1");
        keyFields.add("ID2");
        HashMap<String, Integer> defsFK2 = new HashMap<String, Integer>();
        defsFK2.put("ID2", 20);
        this.grid(0).getOrCreateCache(new CacheConfiguration("test").setSqlSchema("PUBLIC").setQueryEntities((Collection)F.asList((Object)new QueryEntity("MY_KEY_TYPE", "MY_VALUE_TYPE").setTableName("TEST").addQueryField("ID1", Integer.class.getName(), "ID1").addQueryField("ID2", Integer.class.getName(), "ID2").addQueryField("VAL", Integer.class.getName(), "VAL").setKeyFields(keyFields).setDefaultFieldValues(defsFK2))));
        this.sql("insert into test (id1, val) values (0, 1);", new Object[0]);
        this.sql("insert into test (val) values (2);", new Object[0]);
        GridTestUtils.assertThrows((IgniteLogger)log, () -> this.sql("insert into test (id1, val) values (0, 1);", new Object[0]), TransactionDuplicateKeyException.class, (String)"Duplicate key during INSERT");
        GridTestUtils.assertThrows((IgniteLogger)log, () -> this.sql("insert into test (val) values (2);", new Object[0]), TransactionDuplicateKeyException.class, (String)"Duplicate key during INSERT");
        List sql = this.sql("select * from test order by val asc;", new Object[0]).getAll();
        IgniteInsertNullableDuplicatesSqlTest.assertEquals((int)sql.size(), (int)2);
        IgniteInsertNullableDuplicatesSqlTest.assertEquals(((List)sql.get(0)).get(0), (Object)0);
        IgniteInsertNullableDuplicatesSqlTest.assertEquals(((List)sql.get(0)).get(1), (Object)20);
        IgniteInsertNullableDuplicatesSqlTest.assertEquals(((List)sql.get(0)).get(2), (Object)1);
        IgniteInsertNullableDuplicatesSqlTest.assertNull(((List)sql.get(1)).get(0));
        IgniteInsertNullableDuplicatesSqlTest.assertEquals(((List)sql.get(1)).get(1), (Object)20);
        IgniteInsertNullableDuplicatesSqlTest.assertEquals(((List)sql.get(1)).get(2), (Object)2);
    }

    @Test
    public void testInsertKeyWithNullKeyParts2() {
        LinkedHashSet<String> keyFields = new LinkedHashSet<String>();
        keyFields.add("ID1");
        keyFields.add("ID2");
        this.grid(0).getOrCreateCache(new CacheConfiguration("test").setSqlSchema("PUBLIC").setQueryEntities((Collection)F.asList((Object)new QueryEntity().setTableName("TEST").setKeyType("MY_KEY_TYPE").setValueType("MY_VALUE_TYPE").addQueryField("ID1", Integer.class.getName(), "ID1").addQueryField("ID2", Integer.class.getName(), "ID2").addQueryField("VAL", Integer.class.getName(), "VAL").setKeyFields(keyFields))));
        this.sql("insert into test (id1, id2, val) values (1, null, 1);", new Object[0]);
        GridTestUtils.assertThrows((IgniteLogger)log, () -> this.sql("insert into test (id1, id2, val) values (1, null, 1);", new Object[0]), TransactionDuplicateKeyException.class, (String)"Duplicate key during INSERT");
        GridTestUtils.assertThrows((IgniteLogger)log, () -> this.sql("insert into test (id1, val) values (1, 1);", new Object[0]), TransactionDuplicateKeyException.class, (String)"Duplicate key during INSERT");
        IgniteInsertNullableDuplicatesSqlTest.assertEquals((int)this.sql("SELECT * FROM test", new Object[0]).getAll().size(), (int)1);
    }

    private FieldsQueryCursor<List<?>> sql(String sql, Object ... args) {
        return this.grid(0).context().query().querySqlFields(new SqlFieldsQuery(sql).setArgs(args), false);
    }
}

