/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query;

import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.persistence.GridCacheDatabaseSharedManager;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;

public class CleanupIndexTreeCheckpointFailoverTest
extends GridCommonAbstractTest {
    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        DataStorageConfiguration dsCfg = new DataStorageConfiguration();
        dsCfg.setDefaultDataRegionConfiguration(new DataRegionConfiguration().setPersistenceEnabled(true));
        cfg.setDataStorageConfiguration(dsCfg);
        return cfg;
    }

    @Test
    public void testCorruptedTree() throws Exception {
        int i;
        this.cleanPersistenceDir();
        IgniteEx ig = this.startGrid(0);
        ig.cluster().state(ClusterState.ACTIVE);
        CacheConfiguration cfg = new CacheConfiguration().setIndexedTypes(new Class[]{Key.class, Value.class}).setName("test");
        IgniteCache cache = ig.getOrCreateCache(cfg);
        cache.query(new SqlFieldsQuery("create index myindex on value (a asc)")).getAll();
        for (int i2 = 0; i2 < 5000; ++i2) {
            cache.put((Object)new Key(i2), (Object)new Value(String.valueOf(i2), "b" + i2));
        }
        ig.context().cache().context().database().wakeupForCheckpoint("test").get();
        cache.query(new SqlFieldsQuery("drop index myindex")).getAll();
        GridCacheDatabaseSharedManager dbMgr = (GridCacheDatabaseSharedManager)ig.context().cache().context().database();
        U.sleep((long)1000L);
        dbMgr.enableCheckpoints(false);
        this.stopGrid(0, true);
        ig = this.startGrid(0);
        cache = ig.cache("test");
        for (i = 0; i < 5000; i += 2) {
            cache.remove((Object)new Key(i));
        }
        cache.query(new SqlFieldsQuery("create index myindex on value (a asc)")).getAll();
        for (i = 0; i < 5000; ++i) {
            cache.put((Object)new Key(i), (Object)new Value(String.valueOf(i), "b" + i));
        }
    }

    private static class Value {
        @QuerySqlField
        String a;
        @QuerySqlField
        String b;

        Value(String a, String b) {
            this.a = a;
            this.b = b;
        }
    }

    private static class Key {
        int id;

        Key(int id) {
            this.id = id;
        }
    }
}

