/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query;

import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.internal.processors.cache.index.AbstractIndexingCommonTest;
import org.junit.Test;

public class BasicSqlTest
extends AbstractIndexingCommonTest {
    @Override
    protected void afterTestsStopped() throws Exception {
        this.stopAllGrids();
        super.afterTestsStopped();
    }

    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        this.startGrids(2);
    }

    protected void afterTest() throws Exception {
        super.afterTest();
        for (String cacheName : this.grid(0).cacheNames()) {
            this.grid(0).cache(cacheName).destroy();
        }
    }

    @Test
    public void testSplitCastFunctionInSortExpression() {
        this.sql("CREATE TABLE Person (ID INTEGER PRIMARY KEY, NAME VARCHAR(100))", new Object[0]);
        this.sql("INSERT INTO Person (ID, NAME) VALUES (3, 'Emma'), (2, 'Ann'), (1, 'Ed')", new Object[0]);
        List res = this.sql("SELECT NAME, ID FROM Person ORDER BY CAST(ID AS LONG)", new Object[0]).getAll();
        BasicSqlTest.assertEquals((int)3, (int)res.size());
        BasicSqlTest.assertEquals((Object)"Ed", ((List)res.get(0)).get(0));
        BasicSqlTest.assertEquals((Object)"Ann", ((List)res.get(1)).get(0));
        BasicSqlTest.assertEquals((Object)"Emma", ((List)res.get(2)).get(0));
    }

    @Test
    public void testChooseCorrectIndexByOrderByExpression() {
        this.sql("CREATE TABLE TEST (ID INT PRIMARY KEY, VAL0 INT, VAL1 INT, VAL2 VARCHAR)", new Object[0]);
        this.sql("CREATE INDEX IDX_VAL0 ON TEST(VAL0)", new Object[0]);
        this.sql("CREATE INDEX IDX_VAL0_VAL1 ON TEST(VAL0, VAL1)", new Object[0]);
        String plan = null;
        plan = (String)((List)this.execute(new SqlFieldsQuery("EXPLAIN SELECT VAL0, VAL1, VAL2 FROM TEST WHERE VAL0 = 0 ORDER BY VAL0, VAL1").setLocal(true)).getAll().get(0)).get(0);
        BasicSqlTest.assertTrue((String)("Unexpected plan: " + plan), (boolean)plan.contains("IDX_VAL0_VAL1"));
        plan = (String)((List)this.execute(new SqlFieldsQuery("EXPLAIN SELECT VAL0, VAL1, VAL2 FROM TEST WHERE VAL0 = 0 ORDER BY 1, 2").setLocal(true)).getAll().get(0)).get(0);
        BasicSqlTest.assertTrue((String)("Unexpected plan: " + plan), (boolean)plan.contains("IDX_VAL0_VAL1"));
        plan = (String)((List)this.execute(new SqlFieldsQuery("EXPLAIN SELECT VAL0, VAL1, VAL2 FROM TEST WHERE VAL0 = 0 ORDER BY VAL0, VAL1")).getAll().get(0)).get(0);
        BasicSqlTest.assertTrue((String)("Unexpected plan: " + plan), (boolean)plan.contains("IDX_VAL0_VAL1"));
    }

    @Test
    public void testIntervalOperation() {
        this.sql("CREATE TABLE TEST (ID INT PRIMARY KEY, VAL_INT INT, VAL_TS INT)", new Object[0]);
        this.sql("CREATE INDEX IDX_VAL_TS ON TEST(VAL_TS)", new Object[0]);
        int rows = 10;
        for (int i = 0; i < rows; ++i) {
            this.sql("INSERT INTO TEST (ID, VAL_INT, VAL_TS) VALUES (?, ?, TRUNCATE(TIMESTAMP '2015-12-31 23:59:59') - CAST(TRUNC(?) AS TIMESTAMP))", i, i, new Date(115, 11, 31 - i, 12, i, i));
        }
        List res = this.sql("SELECT ID, VAL_TS FROM TEST", new Object[0]).getAll();
        BasicSqlTest.assertEquals((int)rows, (int)res.size());
        for (List r : res) {
            BasicSqlTest.assertEquals(r.get(0), r.get(1));
        }
    }

    @Test
    public void testSysdate() {
        this.sql("CREATE TABLE TEST (ID INT PRIMARY KEY, VAL_INT INT, VAL_TS TIMESTAMP)", new Object[0]);
        int rows = 100;
        for (int i = 0; i < rows; ++i) {
            this.sql("INSERT INTO TEST VALUES (?, ?, ?)", i, i, new Timestamp(ThreadLocalRandom.current().nextLong()));
        }
        List res0 = this.sql("SELECT ID, SYSDATE, SYSDATE() FROM TEST", new Object[0]).getAll();
        BasicSqlTest.assertEquals((int)rows, (int)res0.size());
        List res1 = this.sql("SELECT VAL_TS - SYSDATE() FROM TEST", new Object[0]).getAll();
        BasicSqlTest.assertEquals((int)rows, (int)res1.size());
        res1.forEach(r -> BasicSqlTest.assertTrue((String)("Invalid result type: " + r.get(0) + ",\n at results: " + res1), (boolean)(r.get(0) instanceof Long)));
        List res2 = this.execute(new SqlFieldsQuery("SELECT VAL_TS - SYSDATE() FROM TEST").setLocal(true)).getAll();
        BasicSqlTest.assertTrue((!res2.isEmpty() ? 1 : 0) != 0);
        res2.forEach(r -> BasicSqlTest.assertTrue((String)("Invalid result type: " + r.get(0) + ",\n at results: " + res2), (boolean)(r.get(0) instanceof Long)));
    }

    @Test
    public void testCastIntToInterval() {
        this.sql("CREATE TABLE TEST (ID INT PRIMARY KEY, VAL_INT INT, VAL_TS TIMESTAMP)", new Object[0]);
        int rows = 100;
        for (int i = 0; i < rows; ++i) {
            this.sql("INSERT INTO TEST VALUES (?, ?, ?)", i, i, new Timestamp(System.currentTimeMillis() + 86400L + (long)(3600 * i)));
        }
        List res0 = this.sql("SELECT CASE WHEN (VAL_TS - SYSDATE) > 0 THEN 'A' END FROM TEST", new Object[0]).getAll();
        BasicSqlTest.assertEquals((int)rows, (int)res0.size());
        res0.forEach(r -> BasicSqlTest.assertEquals((String)("Invalid result type: " + r.get(0) + ",\n at results: " + res0), (Object)"A", r.get(0)));
    }

    @Test
    public void compareDifferentTypesInInlineIndex() {
        this.sql("CREATE TABLE TEST0 (ID0 INT, ID1 INT, VAL INT, PRIMARY KEY(ID0, ID1)) WITH\"AFFINITY_KEY=ID0\"", new Object[0]);
        this.sql("CREATE TABLE TEST1 (ID0 INT, ID1 VARCHAR, VAL INT, PRIMARY KEY(ID0, ID1)) WITH\"AFFINITY_KEY=ID0\"", new Object[0]);
        this.sql("INSERT INTO TEST0 VALUES (1,  1, 0)", new Object[0]);
        this.sql("INSERT INTO TEST1 VALUES (1, '1', 0)", new Object[0]);
        this.sql("INSERT INTO TEST0 VALUES (2,  10000000, 0)", new Object[0]);
        this.sql("INSERT INTO TEST1 VALUES (2, '10000000', 0)", new Object[0]);
        List res = this.sql("SELECT * FROM TEST1 WHERE ID0 = 2 AND ID1 = 10000000", new Object[0]).getAll();
        BasicSqlTest.assertEquals((int)1, (int)res.size());
        res = this.grid(0).context().query().querySqlFields(new SqlFieldsQuery("SELECT * FROM TEST0, TEST1 WHERE TEST0.ID0 = TEST1.ID0 AND TEST0.ID1 = TEST1.ID1").setEnforceJoinOrder(true), false).getAll();
        BasicSqlTest.assertEquals((int)2, (int)res.size());
        res = this.grid(0).context().query().querySqlFields(new SqlFieldsQuery("SELECT * FROM TEST1, TEST0 WHERE TEST0.ID0 = TEST1.ID0 AND TEST0.ID1 = TEST1.ID1").setEnforceJoinOrder(true), false).getAll();
        BasicSqlTest.assertEquals((int)2, (int)res.size());
    }

    private FieldsQueryCursor<List<?>> sql(String sql, Object ... args) {
        return this.grid(0).context().query().querySqlFields(new SqlFieldsQuery(sql).setArgs(args), false);
    }

    private FieldsQueryCursor<List<?>> execute(SqlFieldsQuery qry) {
        return this.grid(0).context().query().querySqlFields(qry, false);
    }
}

