/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.database;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import org.apache.ignite.IgniteBinary;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.binary.BinaryObjectBuilder;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.QueryIndex;
import org.apache.ignite.configuration.BinaryConfiguration;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.WALMode;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.persistence.GridCacheDatabaseSharedManager;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;

public class IgniteDbSingleNodeWithIndexingWalRestoreTest
extends GridCommonAbstractTest {
    private static final String BINARY_TYPE_NAME = "BinaryPerson";
    private static final String BINARY_TYPE_FIELD_NAME = "binaryName";
    private static int ENTRIES_COUNT = 500;

    protected IgniteConfiguration getConfiguration(String gridName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(gridName);
        BinaryConfiguration binCfg = new BinaryConfiguration();
        binCfg.setCompactFooter(true);
        cfg.setBinaryConfiguration(binCfg);
        CacheConfiguration indexedCacheCfg = new CacheConfiguration();
        indexedCacheCfg.setName("indexedCache");
        ArrayList<QueryEntity> qryEntities = new ArrayList<QueryEntity>();
        QueryEntity qryEntity = new QueryEntity();
        qryEntity.setKeyType(Integer.class.getName());
        qryEntity.setValueType(BINARY_TYPE_NAME);
        LinkedHashMap<String, String> fields = new LinkedHashMap<String, String>();
        fields.put(BINARY_TYPE_FIELD_NAME, String.class.getName());
        qryEntity.setFields(fields);
        qryEntity.setIndexes((Collection)F.asList((Object)new QueryIndex(BINARY_TYPE_FIELD_NAME)));
        qryEntities.add(qryEntity);
        qryEntity = new QueryEntity();
        qryEntity.setKeyType(Integer.class.getName());
        qryEntity.setValueType(RegularPerson.class.getName());
        fields = new LinkedHashMap();
        fields.put("regName", String.class.getName());
        qryEntity.setFields(fields);
        qryEntity.setIndexes((Collection)F.asList((Object)new QueryIndex("regName")));
        qryEntities.add(qryEntity);
        indexedCacheCfg.setQueryEntities(qryEntities);
        cfg.setCacheConfiguration(new CacheConfiguration[]{indexedCacheCfg});
        DataStorageConfiguration memCfg = new DataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setMaxSize(0x6400000L).setPersistenceEnabled(true)).setWalMode(WALMode.LOG_ONLY);
        cfg.setDataStorageConfiguration(memCfg);
        cfg.setConsistentId((Serializable)((Object)gridName));
        return cfg;
    }

    @Test
    public void testClasslessBinaryValuesRestored() throws Exception {
        int i;
        IgniteEx ig = this.startGrid(0);
        ig.active(true);
        GridCacheDatabaseSharedManager dbMgr = (GridCacheDatabaseSharedManager)ig.context().cache().context().database();
        dbMgr.enableCheckpoints(false).get();
        IgniteCache cache = ig.cache("indexedCache").withKeepBinary();
        IgniteBinary bin = ig.binary();
        for (i = 0; i < ENTRIES_COUNT; ++i) {
            BinaryObjectBuilder bldr = bin.builder(BINARY_TYPE_NAME);
            bldr.setField(BINARY_TYPE_FIELD_NAME, (Object)("Peter" + i));
            cache.put((Object)i, (Object)bldr.build());
        }
        this.stopGrid(0, true);
        ig = this.startGrid(0);
        ig.active(true);
        cache = ig.cache("indexedCache").withKeepBinary();
        for (i = 0; i < ENTRIES_COUNT; ++i) {
            IgniteDbSingleNodeWithIndexingWalRestoreTest.assertEquals((String)("Peter" + i), (String)((String)((BinaryObject)cache.get((Object)i)).field(BINARY_TYPE_FIELD_NAME)));
        }
    }

    @Test
    public void testRegularClassesRestored() throws Exception {
        int i;
        IgniteEx ig = this.startGrid(0);
        ig.active(true);
        GridCacheDatabaseSharedManager dbMgr = (GridCacheDatabaseSharedManager)ig.context().cache().context().database();
        dbMgr.enableCheckpoints(false).get();
        IgniteCache cache = ig.cache("indexedCache");
        for (i = 0; i < ENTRIES_COUNT; ++i) {
            cache.put((Object)i, (Object)new RegularPerson("RegularPeter" + i));
        }
        this.stopGrid(0, true);
        ig = this.startGrid(0);
        ig.active(true);
        cache = ig.cache("indexedCache");
        for (i = 0; i < ENTRIES_COUNT; ++i) {
            IgniteDbSingleNodeWithIndexingWalRestoreTest.assertEquals((String)("RegularPeter" + i), (String)((RegularPerson)cache.get((Object)i)).regName);
        }
    }

    protected void beforeTest() throws Exception {
        this.cleanPersistenceDir();
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
        this.cleanPersistenceDir();
    }

    private static class RegularPerson {
        private String regName;

        public RegularPerson(String regName) {
            this.regName = regName;
        }
    }
}

