/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.db;

import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.BiFunction;
import javax.cache.Cache;
import javax.cache.configuration.Factory;
import javax.cache.integration.CacheLoaderException;
import javax.cache.integration.CacheWriterException;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.QueryIndex;
import org.apache.ignite.cache.QueryIndexType;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.cache.store.CacheStore;
import org.apache.ignite.cache.store.CacheStoreAdapter;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.ConnectorConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorTaskArgument;
import org.apache.ignite.internal.visor.cache.VisorFindAndDeleteGarbageInPersistenceJobResult;
import org.apache.ignite.internal.visor.cache.VisorFindAndDeleteGarbageInPersistenceTask;
import org.apache.ignite.internal.visor.cache.VisorFindAndDeleteGarbageInPersistenceTaskArg;
import org.apache.ignite.internal.visor.cache.VisorFindAndDeleteGarbageInPersistenceTaskResult;
import org.apache.ignite.testframework.junits.WithSystemProperty;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

@WithSystemProperty(key="IGNITE_PDS_SKIP_CHECKPOINT_ON_NODE_STOP", value="true")
public class IgniteCacheGroupsWithRestartsTest
extends GridCommonAbstractTest {
    public static final String GROUP = "group";
    public static final String PERSISTENT_REGION_NAME = "persistent-region";
    private volatile boolean startExtraStaticCache;

    protected IgniteConfiguration getConfiguration(String gridName) throws Exception {
        IgniteConfiguration configuration = super.getConfiguration(gridName);
        configuration.setConsistentId((Serializable)((Object)gridName));
        configuration.setConnectorConfiguration(new ConnectorConfiguration());
        DataStorageConfiguration cfg = new DataStorageConfiguration();
        cfg.setDefaultDataRegionConfiguration(new DataRegionConfiguration().setName(PERSISTENT_REGION_NAME).setPersistenceEnabled(true).setMaxSize(0x10000000L));
        cfg.setDataRegionConfigurations(new DataRegionConfiguration[]{new DataRegionConfiguration().setName("non-persistent-rgion").setPersistenceEnabled(false).setMaxSize(0x10000000L)});
        configuration.setDataStorageConfiguration(cfg);
        if (this.startExtraStaticCache) {
            configuration.setCacheConfiguration(new CacheConfiguration[]{this.getCacheConfiguration(3)});
        }
        return configuration;
    }

    protected CacheConfiguration<Object, Object> getCacheConfiguration(int i) {
        CacheConfiguration ccfg = new CacheConfiguration();
        LinkedHashMap<String, String> fields = new LinkedHashMap<String, String>();
        fields.put("updateDate", "java.lang.Date");
        fields.put("amount", "java.lang.Long");
        fields.put("name", "java.lang.String");
        Set<QueryIndex> indices = Collections.singleton(new QueryIndex("name", QueryIndexType.SORTED));
        ccfg.setName(this.getCacheName(i)).setGroupName(GROUP).setDataRegionName(PERSISTENT_REGION_NAME).setQueryEntities(Collections.singletonList(new QueryEntity(Long.class, Account.class).setFields(fields).setIndexes(indices))).setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 64));
        return ccfg;
    }

    private String getCacheName(int i) {
        return "cache-" + i;
    }

    protected void beforeTest() throws Exception {
        this.afterTest();
    }

    protected void afterTest() throws Exception {
        super.afterTest();
        this.stopAllGrids();
        this.cleanPersistenceDir();
    }

    @Ignore(value="https://issues.apache.org/jira/browse/IGNITE-8717")
    @Test
    public void testNodeRestartRightAfterCacheStop() throws Exception {
        IgniteEx ex = this.startGrids(3);
        this.prepareCachesAndData(ex);
        ex.destroyCache(this.getCacheName(0));
        IgniteCacheGroupsWithRestartsTest.assertNull((Object)ex.cachex(this.getCacheName(0)));
        this.stopGrid(2, true);
        this.startGrid(2);
        IgniteCacheGroupsWithRestartsTest.assertNull((Object)ex.cachex(this.getCacheName(0)));
        IgniteCache cache = ex.createCache(this.getCacheConfiguration(0));
        this.awaitPartitionMapExchange();
        IgniteCacheGroupsWithRestartsTest.assertEquals((int)0, (int)cache.size(new CachePeekMode[0]));
    }

    @Test
    @WithSystemProperty(key="IGNITE_DISABLE_MAINTENANCE_CLEAR_FOLDER_TASK", value="true")
    public void testNodeRestartBetweenCacheStop() throws Exception {
        IgniteEx ex = this.startGrids(3);
        this.prepareCachesAndData(ex);
        this.stopGrid(2, true);
        ex.destroyCache(this.getCacheName(0));
        IgniteCacheGroupsWithRestartsTest.assertNull((Object)ex.cachex(this.getCacheName(0)));
        try {
            this.startGrid(2);
            IgniteCacheGroupsWithRestartsTest.fail();
        }
        catch (Exception e) {
            List list = X.getThrowableList((Throwable)e);
            IgniteCacheGroupsWithRestartsTest.assertTrue((boolean)list.stream().anyMatch(x -> x.getMessage().contains("Joining node has caches with data which are not presented on cluster")));
        }
        this.removeCacheDir(this.getTestIgniteInstanceName(2), "cacheGroup-group");
        IgniteEx node2 = this.startGrid(2);
        IgniteCacheGroupsWithRestartsTest.assertEquals((int)3, (int)node2.cluster().nodes().size());
    }

    private void removeCacheDir(String instanceName, String cacheGroup) throws IgniteCheckedException {
        String dn2DirName = instanceName.replace(".", "_");
        U.delete((File)U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)("db/" + dn2DirName + "/" + cacheGroup), (boolean)true));
    }

    @Ignore(value="https://ggsystems.atlassian.net/browse/GG-21755")
    @Test
    public void testNodeRestartWithNewStaticallyConfiguredCache() throws Exception {
        IgniteEx node2;
        IgniteEx ex = this.startGrids(3);
        this.prepareCachesAndData(ex);
        this.stopGrid(2, true);
        IgniteCacheGroupsWithRestartsTest.assertNull((Object)ex.cachex(this.getCacheName(3)));
        this.startExtraStaticCache = true;
        try {
            node2 = this.startGrid(2);
        }
        finally {
            this.startExtraStaticCache = false;
        }
        IgniteCacheGroupsWithRestartsTest.assertNotNull((Object)ex.cachex(this.getCacheName(3)));
        IgniteCacheGroupsWithRestartsTest.assertNotNull((Object)node2.cachex(this.getCacheName(3)));
        IgniteCache cache = ex.cache(this.getCacheName(3));
        IgniteCacheGroupsWithRestartsTest.assertEquals((int)0, (int)cache.size(new CachePeekMode[0]));
    }

    @Test
    @WithSystemProperty(key="IGNITE_EXECUTE_DURABLE_BACKGROUND_TASKS_ON_NODE_START_OR_ACTIVATE", value="false")
    public void testCleaningGarbageAfterCacheDestroyedAndNodeStop() throws Exception {
        this.testFindAndDeleteGarbage(this::executeTask);
    }

    @Test
    public void testNodeRestartWith3rdPartyCacheStoreAndPersistenceEnabled() throws Exception {
        IgniteEx crd = this.startGrid(0);
        crd.cluster().active(true);
        String cacheName = "test-cache-3rd-party-write-behind-and-ignite-persistence";
        CacheConfiguration ccfg = new CacheConfiguration(cacheName).setWriteBehindEnabled(true).setWriteThrough(true).setReadThrough(true).setCacheStoreFactory((Factory)new StoreFactory());
        IgniteCache cache = crd.getOrCreateCache(ccfg);
        cache.put((Object)12, (Object)42);
        this.stopGrid(0);
        crd = this.startGrid(0);
        crd.cluster().active(true);
        cache = crd.cache(cacheName);
        IgniteCacheGroupsWithRestartsTest.assertEquals((String)"Cache was not properly restored or required key is lost.", (Object)42, (Object)cache.get((Object)12));
    }

    public void testFindAndDeleteGarbage(BiFunction<IgniteEx, Boolean, VisorFindAndDeleteGarbageInPersistenceTaskResult> doFindAndRemove) throws Exception {
        IgniteEx ignite = this.startGrids(3);
        this.prepareCachesAndData(ignite);
        ignite.destroyCache(this.getCacheName(0));
        IgniteCacheGroupsWithRestartsTest.assertNull((Object)ignite.cachex(this.getCacheName(0)));
        Thread.sleep(5000L);
        this.stopGrid(2, true);
        IgniteEx ex1 = this.startGrid(2);
        IgniteCacheGroupsWithRestartsTest.assertNull((Object)ignite.cachex(this.getCacheName(0)));
        ignite.resetLostPartitions(Arrays.asList(this.getCacheName(0), this.getCacheName(1), this.getCacheName(2)));
        this.awaitPartitionMapExchange();
        VisorFindAndDeleteGarbageInPersistenceTaskResult taskResult = doFindAndRemove.apply(ex1, false);
        VisorFindAndDeleteGarbageInPersistenceJobResult result = (VisorFindAndDeleteGarbageInPersistenceJobResult)taskResult.result().get(ex1.localNode().id());
        Assert.assertTrue((boolean)result.hasGarbage());
        Assert.assertTrue(((Long)((Map)result.checkResult().get(CU.cacheId((String)GROUP))).get(CU.cacheId((String)this.getCacheName(0))) > 0L ? 1 : 0) != 0);
        result = (VisorFindAndDeleteGarbageInPersistenceJobResult)doFindAndRemove.apply(ex1, true).result().get(ex1.localNode().id());
        Assert.assertTrue((boolean)result.hasGarbage());
        result = (VisorFindAndDeleteGarbageInPersistenceJobResult)doFindAndRemove.apply(ex1, false).result().get(ex1.localNode().id());
        Assert.assertFalse((boolean)result.hasGarbage());
    }

    private VisorFindAndDeleteGarbageInPersistenceTaskResult executeTask(IgniteEx ignite, boolean deleteFoundGarbage) {
        VisorFindAndDeleteGarbageInPersistenceTaskArg group = new VisorFindAndDeleteGarbageInPersistenceTaskArg(Collections.singleton(GROUP), deleteFoundGarbage, null);
        UUID id = ignite.localNode().id();
        VisorTaskArgument arg = new VisorTaskArgument(id, (Object)group, true);
        VisorFindAndDeleteGarbageInPersistenceTaskResult result = (VisorFindAndDeleteGarbageInPersistenceTaskResult)ignite.compute().execute(VisorFindAndDeleteGarbageInPersistenceTask.class, (Object)arg);
        return result;
    }

    private void prepareCachesAndData(IgniteEx ignite) {
        ignite.cluster().active(true);
        for (int j = 0; j < 3; ++j) {
            for (int i = 0; i < 640; ++i) {
                IgniteCache cache = ignite.getOrCreateCache(this.getCacheConfiguration(j));
                byte[] val = new byte[ThreadLocalRandom.current().nextInt(8148)];
                Arrays.fill(val, (byte)i);
                cache.put((Object)i, (Object)new Account(i));
            }
        }
    }

    private static class TestStore
    extends CacheStoreAdapter {
        private TestStore() {
        }

        public Object load(Object key) throws CacheLoaderException {
            return null;
        }

        public void write(Cache.Entry entry) throws CacheWriterException {
        }

        public void delete(Object key) throws CacheWriterException {
        }
    }

    private static class StoreFactory
    implements Factory<CacheStore> {
        private StoreFactory() {
        }

        public CacheStore create() {
            return new TestStore();
        }
    }

    static class Account {
        private final int val;

        public Account(int val) {
            this.val = val;
        }

        public int value() {
            return this.val;
        }

        public String toString() {
            return S.toString(Account.class, (Object)this);
        }
    }
}

