/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.mvcc;

import java.util.concurrent.Callable;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.mvcc.CacheMvccAbstractTest;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.transactions.Transaction;
import org.apache.ignite.transactions.TransactionConcurrency;
import org.apache.ignite.transactions.TransactionIsolation;
import org.apache.ignite.transactions.TransactionUnsupportedConcurrencyException;
import org.junit.Test;

public class CacheMvccSqlTxModesTest
extends CacheMvccAbstractTest {
    protected CacheMode cacheMode() {
        return CacheMode.PARTITIONED;
    }

    @Test
    public void testSqlTransactionModesNoMvcc() throws Exception {
        IgniteEx node = this.startGrid(0);
        IgniteCache nonMvccCache = node.createCache(new CacheConfiguration("no-mvcc-cache").setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL).setIndexedTypes(new Class[]{Integer.class, Integer.class}));
        nonMvccCache.put((Object)1, (Object)1);
        for (TransactionConcurrency conc : TransactionConcurrency.values()) {
            for (TransactionIsolation iso : TransactionIsolation.values()) {
                try (Transaction tx = node.transactions().txStart(conc, iso);){
                    nonMvccCache.query(new SqlFieldsQuery("SELECT * FROM Integer")).getAll();
                    tx.commit();
                }
                catch (Throwable t) {
                    log.error("Transaction failed: concurrency=" + conc + ", isolation=" + iso, t);
                    throw t;
                }
            }
        }
    }

    @Test
    public void testSqlTransactionModesMvcc() throws Exception {
        final IgniteEx node = this.startGrid(0);
        final IgniteCache mvccCache = node.createCache(new CacheConfiguration("mvcc-cache").setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL_SNAPSHOT).setIndexedTypes(new Class[]{Integer.class, Integer.class}));
        mvccCache.put((Object)1, (Object)1);
        GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try (Transaction tx = node.transactions().txStart(TransactionConcurrency.OPTIMISTIC, TransactionIsolation.READ_COMMITTED);){
                    mvccCache.query(new SqlFieldsQuery("SELECT * FROM Integer")).getAll();
                    tx.commit();
                }
                return null;
            }
        }, TransactionUnsupportedConcurrencyException.class, (String)"Only pessimistic transactions are supported when MVCC is enabled");
        GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try (Transaction tx = node.transactions().txStart(TransactionConcurrency.OPTIMISTIC, TransactionIsolation.REPEATABLE_READ);){
                    mvccCache.query(new SqlFieldsQuery("SELECT * FROM Integer")).getAll();
                    tx.commit();
                }
                return null;
            }
        }, TransactionUnsupportedConcurrencyException.class, (String)"Only pessimistic transactions are supported when MVCC is enabled");
        GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try (Transaction tx = node.transactions().txStart(TransactionConcurrency.OPTIMISTIC, TransactionIsolation.SERIALIZABLE);){
                    mvccCache.query(new SqlFieldsQuery("SELECT * FROM Integer")).getAll();
                    tx.commit();
                }
                return null;
            }
        }, TransactionUnsupportedConcurrencyException.class, (String)"Only pessimistic transactions are supported when MVCC is enabled");
        try (Transaction tx = node.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.READ_COMMITTED);){
            mvccCache.query(new SqlFieldsQuery("SELECT * FROM Integer")).getAll();
            tx.commit();
        }
        tx = node.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);
        var4_4 = null;
        try {
            mvccCache.query(new SqlFieldsQuery("SELECT * FROM Integer")).getAll();
            tx.commit();
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_4 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        tx = node.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.SERIALIZABLE);
        var4_4 = null;
        try {
            mvccCache.query(new SqlFieldsQuery("SELECT * FROM Integer")).getAll();
            tx.commit();
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_4 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void testConsequentMvccNonMvccOperations() throws Exception {
        IgniteEx node = this.startGrid(0);
        IgniteCache mvccCache = node.createCache(new CacheConfiguration("mvcc-cache").setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL_SNAPSHOT).setIndexedTypes(new Class[]{Integer.class, Integer.class}));
        IgniteCache nonMvccCache = node.createCache(new CacheConfiguration("no-mvcc-cache").setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL).setIndexedTypes(new Class[]{Integer.class, Integer.class}));
        nonMvccCache.put((Object)1, (Object)1);
        try (Transaction tx = node.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
            mvccCache.query(new SqlFieldsQuery("INSERT INTO Integer (_key, _val) VALUES (3,3)")).getAll();
            tx.commit();
        }
        tx = node.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);
        var5_5 = null;
        try {
            nonMvccCache.put((Object)2, (Object)2);
            tx.commit();
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var5_5 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var5_5.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        tx = node.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);
        var5_5 = null;
        try {
            mvccCache.query(new SqlFieldsQuery("INSERT INTO Integer (_key, _val) VALUES (5,5)")).getAll();
            tx.commit();
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var5_5 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var5_5.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        nonMvccCache.put((Object)6, (Object)6);
        tx = node.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);
        var5_5 = null;
        try {
            mvccCache.query(new SqlFieldsQuery("INSERT INTO Integer (_key, _val) VALUES (7,7)")).getAll();
            tx.commit();
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var5_5 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var5_5.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void testConsequentMvccNonMvccMixedOperations() throws Exception {
        IgniteEx node = this.startGrid(0);
        IgniteCache mvccCache = node.createCache(new CacheConfiguration("mvcc-cache").setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL_SNAPSHOT).setIndexedTypes(new Class[]{Integer.class, Integer.class}));
        IgniteCache nonMvccCache = node.createCache(new CacheConfiguration("no-mvcc-cache").setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL).setIndexedTypes(new Class[]{Integer.class, Integer.class}));
        nonMvccCache.query(new SqlFieldsQuery("INSERT INTO Integer (_key, _val) VALUES (1,1)")).getAll();
        try (Transaction tx = node.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
            nonMvccCache.query(new SqlFieldsQuery("SELECT * FROM Integer")).getAll();
            mvccCache.put((Object)2, (Object)2);
            tx.commit();
        }
        tx = node.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);
        var5_5 = null;
        try {
            nonMvccCache.query(new SqlFieldsQuery("SELECT * FROM Integer")).getAll();
            mvccCache.query(new SqlFieldsQuery("INSERT INTO Integer (_key, _val) VALUES (3,3)")).getAll();
            tx.commit();
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var5_5 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var5_5.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        tx = node.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);
        var5_5 = null;
        try {
            mvccCache.put((Object)4, (Object)4);
            nonMvccCache.query(new SqlFieldsQuery("SELECT * FROM Integer")).getAll();
            tx.commit();
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var5_5 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var5_5.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        tx = node.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);
        var5_5 = null;
        try {
            mvccCache.query(new SqlFieldsQuery("INSERT INTO Integer (_key, _val) VALUES (5,5)")).getAll();
            nonMvccCache.query(new SqlFieldsQuery("SELECT * FROM Integer")).getAll();
            tx.commit();
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var5_5 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var5_5.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }
}

