/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.metric;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.cache.configuration.Factory;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteJdbcThinDriver;
import org.apache.ignite.Ignition;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.AffinityFunctionContext;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.cache.query.ContinuousQuery;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.cache.query.ScanQuery;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.client.IgniteClient;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.ClientConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.SqlConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.binary.mutabletest.GridBinaryTestClasses;
import org.apache.ignite.internal.metric.AbstractExporterSpiTest;
import org.apache.ignite.internal.metric.SystemViewSelfTest;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.GridCacheUtils;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionState;
import org.apache.ignite.internal.processors.cache.index.AbstractSchemaSelfTest;
import org.apache.ignite.internal.processors.cache.persistence.GridCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.cache.persistence.IgniteCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.metastorage.DistributedMetaStorage;
import org.apache.ignite.internal.processors.metastorage.persistence.DistributedMetaStorageImpl;
import org.apache.ignite.internal.processors.query.QueryUtils;
import org.apache.ignite.internal.processors.service.DummyService;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.StripedExecutor;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.lang.IgniteRunnable;
import org.apache.ignite.services.Service;
import org.apache.ignite.services.ServiceConfiguration;
import org.apache.ignite.spi.systemview.view.SystemView;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.WithSystemProperty;
import org.apache.ignite.transactions.Transaction;
import org.apache.ignite.transactions.TransactionConcurrency;
import org.apache.ignite.transactions.TransactionIsolation;
import org.junit.Test;

@WithSystemProperty(key="IGNITE_EVENT_DRIVEN_SERVICE_PROCESSOR_ENABLED", value="true")
public class SqlViewExporterSpiTest
extends AbstractExporterSpiTest {
    private static IgniteEx ignite0;
    private static IgniteEx ignite1;
    private static final String SCAN_QRY_SELECT;

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        cfg.setConsistentId((Serializable)((Object)igniteInstanceName));
        cfg.setDataStorageConfiguration(new DataStorageConfiguration().setDataRegionConfigurations(new DataRegionConfiguration[]{new DataRegionConfiguration().setName("in-memory").setMaxSize(0x6400000L)}).setDefaultDataRegionConfiguration(new DataRegionConfiguration().setPersistenceEnabled(true)));
        return cfg;
    }

    protected void beforeTestsStarted() throws Exception {
        this.cleanPersistenceDir();
        ignite0 = this.startGrid(0);
        ignite1 = this.startGrid(1);
        ignite0.cluster().baselineAutoAdjustEnabled(false);
        ignite0.cluster().state(ClusterState.ACTIVE);
    }

    protected void afterTest() throws Exception {
        Collection caches = ignite0.cacheNames();
        for (String cache : caches) {
            ignite0.destroyCache(cache);
        }
    }

    protected void afterTestsStopped() throws Exception {
        this.stopAllGrids(true);
        this.cleanPersistenceDir();
    }

    @Test
    public void testEmptyFilter() {
        List<List<?>> res = this.execute((Ignite)ignite0, "SELECT * FROM " + QueryUtils.sysSchemaName() + ".METRICS", new Object[0]);
        SqlViewExporterSpiTest.assertNotNull(res);
        SqlViewExporterSpiTest.assertFalse((boolean)res.isEmpty());
    }

    @Test
    public void testDataRegionMetrics() {
        List<List<?>> res = this.execute((Ignite)ignite0, "SELECT REPLACE(name, 'io.dataregion.default.'), value, description FROM " + QueryUtils.sysSchemaName() + ".METRICS", new Object[0]);
        HashSet<String> names = new HashSet<String>();
        DataRegionConfiguration cfg = ignite0.configuration().getDataStorageConfiguration().getDefaultDataRegionConfiguration();
        for (List<?> row : res) {
            String name = (String)row.get(0);
            String val = (String)row.get(1);
            names.add(name);
            if ("InitialSize".equals(name)) {
                SqlViewExporterSpiTest.assertEquals((String)Long.toString(cfg.getInitialSize()), (String)val);
            } else if ("MaxSize".equals(name)) {
                SqlViewExporterSpiTest.assertEquals((String)Long.toString(cfg.getMaxSize()), (String)val);
            }
            SqlViewExporterSpiTest.assertNotNull((String)("Metric value must be not null [name=" + name + ']'), (Object)val);
        }
        for (String attr : this.EXPECTED_ATTRIBUTES) {
            SqlViewExporterSpiTest.assertTrue((String)(attr + " should be exporterd via SQL view"), (boolean)names.contains(attr));
        }
    }

    @Test
    public void testCachesView() {
        HashSet<String> cacheNames = new HashSet<String>(Arrays.asList("cache-1", "cache-2"));
        for (String name : cacheNames) {
            ignite0.createCache(name);
        }
        List<List<?>> caches = this.execute((Ignite)ignite0, "SELECT CACHE_NAME FROM " + QueryUtils.sysSchemaName() + ".CACHES", new Object[0]);
        SqlViewExporterSpiTest.assertEquals((int)ignite0.context().cache().cacheDescriptors().size(), (int)caches.size());
        for (List<?> row : caches) {
            cacheNames.remove(row.get(0));
        }
        SqlViewExporterSpiTest.assertTrue((String)((Object)cacheNames).toString(), (boolean)cacheNames.isEmpty());
    }

    @Test
    public void testCacheGroupsView() {
        HashSet<String> grpNames = new HashSet<String>(Arrays.asList("grp-1", "grp-2"));
        for (String grpName : grpNames) {
            ignite0.createCache(new CacheConfiguration("cache-" + grpName).setGroupName(grpName));
        }
        List<List<?>> grps = this.execute((Ignite)ignite0, "SELECT CACHE_GROUP_NAME FROM " + QueryUtils.sysSchemaName() + ".CACHE_GROUPS", new Object[0]);
        SqlViewExporterSpiTest.assertEquals((int)ignite0.context().cache().cacheGroupDescriptors().size(), (int)grps.size());
        for (List<?> row : grps) {
            grpNames.remove(row.get(0));
        }
        SqlViewExporterSpiTest.assertTrue((String)((Object)grpNames).toString(), (boolean)grpNames.isEmpty());
    }

    @Test
    public void testComputeBroadcast() throws Exception {
        CyclicBarrier barrier = new CyclicBarrier(6);
        for (int i = 0; i < 5; ++i) {
            ignite0.compute(ignite0.cluster().forLocal()).broadcastAsync((IgniteRunnable & Serializable)() -> {
                try {
                    barrier.await();
                    barrier.await();
                }
                catch (InterruptedException | BrokenBarrierException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        barrier.await();
        List<List<?>> tasks = this.execute((Ignite)ignite0, "SELECT   INTERNAL,   AFFINITY_CACHE_NAME,   AFFINITY_PARTITION_ID,   TASK_CLASS_NAME,   TASK_NAME,   TASK_NODE_ID,   USER_VERSION FROM " + QueryUtils.sysSchemaName() + ".TASKS", new Object[0]);
        SqlViewExporterSpiTest.assertEquals((int)5, (int)tasks.size());
        List<?> t = tasks.get(0);
        SqlViewExporterSpiTest.assertFalse((boolean)((Boolean)t.get(0)));
        SqlViewExporterSpiTest.assertNull(t.get(1));
        SqlViewExporterSpiTest.assertEquals((Object)-1, t.get(2));
        SqlViewExporterSpiTest.assertTrue((boolean)t.get(3).toString().startsWith(((Object)((Object)this)).getClass().getName()));
        SqlViewExporterSpiTest.assertTrue((boolean)t.get(4).toString().startsWith(((Object)((Object)this)).getClass().getName()));
        SqlViewExporterSpiTest.assertEquals((Object)ignite0.localNode().id(), t.get(5));
        SqlViewExporterSpiTest.assertEquals((Object)"0", t.get(6));
        barrier.await();
    }

    @Test
    public void testServices() {
        ServiceConfiguration srvcCfg = new ServiceConfiguration();
        srvcCfg.setName("service");
        srvcCfg.setMaxPerNodeCount(1);
        srvcCfg.setService((Service)new DummyService());
        ignite0.services().deploy(srvcCfg);
        List<List<?>> srvs = this.execute((Ignite)ignite0, "SELECT   NAME,   SERVICE_ID,   SERVICE_CLASS,   TOTAL_COUNT,   MAX_PER_NODE_COUNT,   CACHE_NAME,   AFFINITY_KEY,   NODE_FILTER,   STATICALLY_CONFIGURED,   ORIGIN_NODE_ID FROM " + QueryUtils.sysSchemaName() + ".SERVICES", new Object[0]);
        SqlViewExporterSpiTest.assertEquals((int)ignite0.context().service().serviceDescriptors().size(), (int)srvs.size());
        List<?> sysView = srvs.iterator().next();
        SqlViewExporterSpiTest.assertEquals((Object)srvcCfg.getName(), sysView.get(0));
        SqlViewExporterSpiTest.assertEquals((Object)DummyService.class.getName(), sysView.get(2));
        SqlViewExporterSpiTest.assertEquals((Object)srvcCfg.getMaxPerNodeCount(), sysView.get(4));
    }

    @Test
    public void testClientsConnections() throws Exception {
        String host = ignite0.configuration().getClientConnectorConfiguration().getHost();
        if (host == null) {
            host = ignite0.configuration().getLocalHost();
        }
        int port = ignite0.configuration().getClientConnectorConfiguration().getPort();
        try (IgniteClient client = Ignition.startClient((ClientConfiguration)new ClientConfiguration().setAddresses(new String[]{host + ":" + port}));
             Connection conn = new IgniteJdbcThinDriver().connect("jdbc:ignite:thin://" + host, new Properties());){
            List<List<?>> conns = this.execute((Ignite)ignite0, "SELECT * FROM " + QueryUtils.sysSchemaName() + ".CLIENT_CONNECTIONS", new Object[0]);
            SqlViewExporterSpiTest.assertEquals((int)2, (int)conns.size());
        }
    }

    @Test
    public void testTransactions() throws Exception {
        IgniteCache cache = ignite0.createCache(new CacheConfiguration("c").setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL));
        SqlViewExporterSpiTest.assertTrue((boolean)this.execute((Ignite)ignite0, "SELECT * FROM " + QueryUtils.sysSchemaName() + ".TRANSACTIONS", new Object[0]).isEmpty());
        CountDownLatch latch1 = new CountDownLatch(10);
        CountDownLatch latch2 = new CountDownLatch(1);
        AtomicInteger cntr = new AtomicInteger();
        GridTestUtils.runMultiThreadedAsync(() -> {
            try (Transaction tx = ignite0.transactions().withLabel("test").txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
                cache.put((Object)cntr.incrementAndGet(), (Object)cntr.incrementAndGet());
                cache.put((Object)cntr.incrementAndGet(), (Object)cntr.incrementAndGet());
                latch1.countDown();
                latch2.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }, (int)5, (String)"xxx");
        GridTestUtils.runMultiThreadedAsync(() -> {
            try (Transaction tx = ignite0.transactions().txStart(TransactionConcurrency.OPTIMISTIC, TransactionIsolation.SERIALIZABLE);){
                cache.put((Object)cntr.incrementAndGet(), (Object)cntr.incrementAndGet());
                cache.put((Object)cntr.incrementAndGet(), (Object)cntr.incrementAndGet());
                latch1.countDown();
                latch2.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }, (int)5, (String)"yyy");
        latch1.await(5L, TimeUnit.SECONDS);
        List<List<?>> txs = this.execute((Ignite)ignite0, "SELECT * FROM " + QueryUtils.sysSchemaName() + ".TRANSACTIONS", new Object[0]);
        SqlViewExporterSpiTest.assertEquals((int)10, (int)txs.size());
        latch2.countDown();
        boolean res = GridTestUtils.waitForCondition(() -> this.execute((Ignite)ignite0, "SELECT * FROM " + QueryUtils.sysSchemaName() + ".TRANSACTIONS", new Object[0]).isEmpty(), (long)5000L);
        SqlViewExporterSpiTest.assertTrue((boolean)res);
    }

    @Test
    public void testSchemas() throws Exception {
        try (IgniteEx g = this.startGrid(this.getConfiguration(this.getTestIgniteInstanceName(3)).setSqlConfiguration(new SqlConfiguration().setSqlSchemas(new String[]{"MY_SCHEMA", "ANOTHER_SCHEMA"})));){
            SystemView schemasSysView = g.context().systemView().view("schemas");
            HashSet schemaFromSysView = new HashSet();
            schemasSysView.forEach(v -> schemaFromSysView.add(v.schemaName()));
            HashSet<String> expSchemas = new HashSet<String>(Arrays.asList("MY_SCHEMA", "ANOTHER_SCHEMA", QueryUtils.sysSchemaName(), "PUBLIC"));
            SqlViewExporterSpiTest.assertEquals(schemaFromSysView, expSchemas);
            List<List<?>> schemas = this.execute((Ignite)g, "SELECT * FROM " + QueryUtils.sysSchemaName() + ".SCHEMAS", new Object[0]);
            schemaFromSysView.clear();
            schemas.forEach(s -> schemaFromSysView.add(s.get(0).toString()));
            SqlViewExporterSpiTest.assertEquals(schemaFromSysView, expSchemas);
        }
    }

    @Test
    public void testViews() {
        HashSet<String> expViews = new HashSet<String>(Arrays.asList("METRICS", "SERVICES", "CACHE_GROUPS", "CACHES", "TASKS", "JOBS", "SQL_QUERIES_HISTORY", "NODES", "SCHEMAS", "NODE_METRICS", "CONFIGURATION", "BASELINE_NODES", "BASELINE_NODE_ATTRIBUTES", "INDEXES", "LOCAL_CACHE_GROUPS_IO", "SQL_QUERIES", "SCAN_QUERIES", "NODE_ATTRIBUTES", "TABLES", "CLIENT_CONNECTIONS", "CLIENT_CONNECTION_ATTRIBUTES", "VIEWS", "TABLE_COLUMNS", "VIEW_COLUMNS", "TRANSACTIONS", "CONTINUOUS_QUERIES", "STRIPED_THREADPOOL_QUEUE", "DATASTREAM_THREADPOOL_QUEUE", "DATA_REGION_PAGE_LISTS", "CACHE_GROUP_PAGE_LISTS", "STATISTICS_CONFIGURATION", "STATISTICS_PARTITION_DATA", "STATISTICS_LOCAL_DATA", "DS_ATOMICLONGS", "DS_ATOMICREFERENCES", "DS_ATOMICSTAMPED", "DS_ATOMICSEQUENCES", "DS_COUNTDOWNLATCHES", "DS_REENTRANTLOCKS", "DS_SETS", "DS_SEMAPHORES", "DS_QUEUES", "BINARY_METADATA", "METASTORAGE", "DISTRIBUTED_METASTORAGE", "PARTITION_STATES"));
        HashSet<String> actViews = new HashSet<String>();
        List<List<?>> res = this.execute((Ignite)ignite0, "SELECT * FROM " + QueryUtils.sysSchemaName() + ".VIEWS", new Object[0]);
        for (List<?> row : res) {
            actViews.add(row.get(0).toString());
        }
        SqlViewExporterSpiTest.assertEquals(expViews, actViews);
    }

    @Test
    public void testTable() {
        SqlViewExporterSpiTest.assertTrue((boolean)this.execute((Ignite)ignite0, "SELECT * FROM " + QueryUtils.sysSchemaName() + ".TABLES", new Object[0]).isEmpty());
        this.execute((Ignite)ignite0, "CREATE TABLE T1(ID LONG PRIMARY KEY, NAME VARCHAR)", new Object[0]);
        List<List<?>> res = this.execute((Ignite)ignite0, "SELECT * FROM " + QueryUtils.sysSchemaName() + ".TABLES", new Object[0]);
        SqlViewExporterSpiTest.assertEquals((int)1, (int)res.size());
        List<?> tbl = res.get(0);
        int cacheId = GridCacheUtils.cacheId((String)"SQL_PUBLIC_T1");
        String cacheName = "SQL_PUBLIC_T1";
        SqlViewExporterSpiTest.assertEquals((Object)cacheId, tbl.get(0));
        SqlViewExporterSpiTest.assertEquals((Object)cacheName, tbl.get(1));
        SqlViewExporterSpiTest.assertEquals((Object)cacheId, tbl.get(2));
        SqlViewExporterSpiTest.assertEquals((Object)cacheName, tbl.get(3));
        SqlViewExporterSpiTest.assertEquals((Object)"PUBLIC", tbl.get(4));
        SqlViewExporterSpiTest.assertEquals((Object)"T1", tbl.get(5));
        SqlViewExporterSpiTest.assertNull(tbl.get(6));
        SqlViewExporterSpiTest.assertEquals((Object)"ID", tbl.get(7));
        SqlViewExporterSpiTest.assertNull(tbl.get(8));
        SqlViewExporterSpiTest.assertEquals((Object)"java.lang.Long", tbl.get(9));
        SqlViewExporterSpiTest.assertNotNull(tbl.get(10));
        this.execute((Ignite)ignite0, "CREATE TABLE T2(ID LONG PRIMARY KEY, NAME VARCHAR)", new Object[0]);
        SqlViewExporterSpiTest.assertEquals((int)2, (int)this.execute((Ignite)ignite0, "SELECT * FROM " + QueryUtils.sysSchemaName() + ".TABLES", new Object[0]).size());
        this.execute((Ignite)ignite0, "DROP TABLE T1", new Object[0]);
        this.execute((Ignite)ignite0, "DROP TABLE T2", new Object[0]);
        SqlViewExporterSpiTest.assertTrue((boolean)this.execute((Ignite)ignite0, "SELECT * FROM " + QueryUtils.sysSchemaName() + ".TABLES", new Object[0]).isEmpty());
    }

    @Test
    public void testTableColumns() {
        SqlViewExporterSpiTest.assertTrue((boolean)this.execute((Ignite)ignite0, "SELECT * FROM " + QueryUtils.sysSchemaName() + ".TABLE_COLUMNS", new Object[0]).isEmpty());
        this.execute((Ignite)ignite0, "CREATE TABLE T1(ID LONG PRIMARY KEY, NAME VARCHAR(40))", new Object[0]);
        Set actCols = this.execute((Ignite)ignite0, "SELECT * FROM " + QueryUtils.sysSchemaName() + ".TABLE_COLUMNS", new Object[0]).stream().map(l -> l.get(0)).collect(Collectors.toSet());
        SqlViewExporterSpiTest.assertEquals(new HashSet<String>(Arrays.asList("ID", "NAME", "_KEY", "_VAL")), actCols);
        this.execute((Ignite)ignite0, "CREATE TABLE T2(ID LONG PRIMARY KEY, NAME VARCHAR(50))", new Object[0]);
        List<List> expRes = Arrays.asList(Arrays.asList("ID", "T1", "PUBLIC", false, false, "null", true, true, 19, 0, Long.class.getName()), Arrays.asList("NAME", "T1", "PUBLIC", false, false, "null", true, false, 40, 0, String.class.getName()), Arrays.asList("_KEY", "T1", "PUBLIC", true, false, null, false, true, -1, -1, null), Arrays.asList("_VAL", "T1", "PUBLIC", false, false, null, true, false, -1, -1, null), Arrays.asList("ID", "T2", "PUBLIC", false, false, "null", true, true, 19, 0, Long.class.getName()), Arrays.asList("NAME", "T2", "PUBLIC", false, false, "null", true, false, 50, 0, String.class.getName()), Arrays.asList("_KEY", "T2", "PUBLIC", true, false, null, false, true, -1, -1, null), Arrays.asList("_VAL", "T2", "PUBLIC", false, false, null, true, false, -1, -1, null));
        List<List<?>> res = this.execute((Ignite)ignite0, "SELECT * FROM " + QueryUtils.sysSchemaName() + ".TABLE_COLUMNS ORDER BY TABLE_NAME, COLUMN_NAME", new Object[0]);
        SqlViewExporterSpiTest.assertEquals(expRes, res);
        this.execute((Ignite)ignite0, "DROP TABLE T1", new Object[0]);
        this.execute((Ignite)ignite0, "DROP TABLE T2", new Object[0]);
        SqlViewExporterSpiTest.assertTrue((boolean)this.execute((Ignite)ignite0, "SELECT * FROM " + QueryUtils.sysSchemaName() + ".TABLE_COLUMNS", new Object[0]).isEmpty());
    }

    @Test
    public void testViewColumns() {
        this.execute((Ignite)ignite0, "SELECT * FROM " + QueryUtils.sysSchemaName() + ".VIEW_COLUMNS", new Object[0]);
        List<List> expRes = Arrays.asList(Arrays.asList("CONNECTION_ID", "CLIENT_CONNECTIONS", QueryUtils.sysSchemaName(), "null", true, 19L, 0, Long.class.getName()), Arrays.asList("LOCAL_ADDRESS", "CLIENT_CONNECTIONS", QueryUtils.sysSchemaName(), "null", true, Integer.MAX_VALUE, 0, String.class.getName()), Arrays.asList("REMOTE_ADDRESS", "CLIENT_CONNECTIONS", QueryUtils.sysSchemaName(), "null", true, Integer.MAX_VALUE, 0, String.class.getName()), Arrays.asList("TYPE", "CLIENT_CONNECTIONS", QueryUtils.sysSchemaName(), "null", true, Integer.MAX_VALUE, 0, String.class.getName()), Arrays.asList("USER", "CLIENT_CONNECTIONS", QueryUtils.sysSchemaName(), "null", true, Integer.MAX_VALUE, 0, String.class.getName()), Arrays.asList("VERSION", "CLIENT_CONNECTIONS", QueryUtils.sysSchemaName(), "null", true, Integer.MAX_VALUE, 0, String.class.getName()));
        List<List<?>> res = this.execute((Ignite)ignite0, "SELECT * FROM " + QueryUtils.sysSchemaName() + ".VIEW_COLUMNS WHERE VIEW_NAME = 'CLIENT_CONNECTIONS'", new Object[0]);
        SqlViewExporterSpiTest.assertEquals(expRes, res);
    }

    @Test
    public void testContinuousQuery() throws Exception {
        IgniteCache cache = ignite0.createCache("cache-1");
        SqlViewExporterSpiTest.assertTrue((boolean)this.execute((Ignite)ignite0, "SELECT * FROM " + QueryUtils.sysSchemaName() + ".CONTINUOUS_QUERIES", new Object[0]).isEmpty());
        SqlViewExporterSpiTest.assertTrue((boolean)this.execute((Ignite)ignite1, "SELECT * FROM " + QueryUtils.sysSchemaName() + ".CONTINUOUS_QUERIES", new Object[0]).isEmpty());
        try (QueryCursor qry = cache.query((Query)new ContinuousQuery().setInitialQuery((Query)new ScanQuery()).setPageSize(100).setTimeInterval(1000L).setLocalListener(evts -> {}).setRemoteFilterFactory((Factory & Serializable)() -> evt -> true));){
            for (int i = 0; i < 100; ++i) {
                cache.put((Object)i, (Object)i);
            }
            this.checkContinuouQueryView(ignite0, true);
            this.checkContinuouQueryView(ignite1, false);
        }
        SqlViewExporterSpiTest.assertTrue((boolean)this.execute((Ignite)ignite0, "SELECT * FROM " + QueryUtils.sysSchemaName() + ".CONTINUOUS_QUERIES", new Object[0]).isEmpty());
        SqlViewExporterSpiTest.assertTrue((boolean)GridTestUtils.waitForCondition(() -> this.execute((Ignite)ignite1, "SELECT * FROM " + QueryUtils.sysSchemaName() + ".CONTINUOUS_QUERIES", new Object[0]).isEmpty(), (long)this.getTestTimeout()));
    }

    private void checkContinuouQueryView(IgniteEx g, boolean loc) {
        List<List<?>> qrys = this.execute((Ignite)g, "SELECT   CACHE_NAME,   BUFFER_SIZE,   \"INTERVAL\",   NODE_ID,   LOCAL_LISTENER,   REMOTE_FILTER,   LOCAL_TRANSFORMED_LISTENER,   REMOTE_TRANSFORMER FROM " + QueryUtils.sysSchemaName() + ".CONTINUOUS_QUERIES", new Object[0]);
        SqlViewExporterSpiTest.assertEquals((int)1, (int)qrys.size());
        List<?> cq = qrys.iterator().next();
        SqlViewExporterSpiTest.assertEquals((Object)"cache-1", cq.get(0));
        SqlViewExporterSpiTest.assertEquals((Object)100, cq.get(1));
        SqlViewExporterSpiTest.assertEquals((Object)1000L, cq.get(2));
        SqlViewExporterSpiTest.assertEquals((Object)ignite0.localNode().id(), cq.get(3));
        if (loc) {
            SqlViewExporterSpiTest.assertTrue((boolean)cq.get(4).toString().startsWith(((Object)((Object)this)).getClass().getName()));
        } else {
            SqlViewExporterSpiTest.assertNull(cq.get(4));
        }
        SqlViewExporterSpiTest.assertTrue((boolean)cq.get(5).toString().startsWith(((Object)((Object)this)).getClass().getName()));
        SqlViewExporterSpiTest.assertNull(cq.get(6));
    }

    @Test
    public void testLocalScanQuery() throws Exception {
        IgniteCache cache1 = ignite0.createCache(new CacheConfiguration("cache1").setGroupName("group1"));
        int part = ignite0.affinity("cache1").primaryPartitions(ignite0.localNode())[0];
        List partKeys = this.partitionKeys(cache1, part, 11, 0);
        for (Integer key : partKeys) {
            cache1.put((Object)key, (Object)key);
        }
        SqlViewExporterSpiTest.assertEquals((int)0, (int)this.execute((Ignite)ignite0, SCAN_QRY_SELECT, new Object[0]).size());
        QueryCursor qryRes1 = cache1.query((Query)new ScanQuery().setFilter((IgniteBiPredicate)new SystemViewSelfTest.TestPredicate()).setLocal(true).setPartition(Integer.valueOf(part)).setPageSize(10), (IgniteClosure)new SystemViewSelfTest.TestTransformer());
        SqlViewExporterSpiTest.assertTrue((boolean)qryRes1.iterator().hasNext());
        boolean res = GridTestUtils.waitForCondition(() -> !this.execute((Ignite)ignite0, SCAN_QRY_SELECT, new Object[0]).isEmpty(), (long)5000L);
        SqlViewExporterSpiTest.assertTrue((boolean)res);
        List<?> view = this.execute((Ignite)ignite0, SCAN_QRY_SELECT, new Object[0]).get(0);
        SqlViewExporterSpiTest.assertEquals((Object)ignite0.localNode().id(), view.get(0));
        SqlViewExporterSpiTest.assertEquals((Object)0L, view.get(1));
        SqlViewExporterSpiTest.assertEquals((Object)"cache1", view.get(2));
        SqlViewExporterSpiTest.assertEquals((Object)GridCacheUtils.cacheId((String)"cache1"), view.get(3));
        SqlViewExporterSpiTest.assertEquals((Object)GridCacheUtils.cacheGroupId((String)"cache1", (String)"group1"), view.get(4));
        SqlViewExporterSpiTest.assertEquals((Object)"group1", view.get(5));
        SqlViewExporterSpiTest.assertTrue(((Long)view.get(6) <= System.currentTimeMillis() ? 1 : 0) != 0);
        SqlViewExporterSpiTest.assertTrue(((Long)view.get(7) >= 0L ? 1 : 0) != 0);
        SqlViewExporterSpiTest.assertFalse((boolean)((Boolean)view.get(8)));
        SqlViewExporterSpiTest.assertEquals((Object)"TestPredicate", view.get(9));
        SqlViewExporterSpiTest.assertTrue((boolean)((Boolean)view.get(10)));
        SqlViewExporterSpiTest.assertEquals((Object)part, view.get(11));
        SqlViewExporterSpiTest.assertEquals((Object)IgniteUtils.toStringSafe((Object)ignite0.context().discovery().topologyVersionEx()), view.get(12));
        SqlViewExporterSpiTest.assertEquals((Object)"TestTransformer", view.get(13));
        SqlViewExporterSpiTest.assertFalse((boolean)((Boolean)view.get(14)));
        SqlViewExporterSpiTest.assertNull(view.get(15));
        SqlViewExporterSpiTest.assertNull(view.get(16));
        qryRes1.close();
        res = GridTestUtils.waitForCondition(() -> this.execute((Ignite)ignite0, SCAN_QRY_SELECT, new Object[0]).isEmpty(), (long)5000L);
        SqlViewExporterSpiTest.assertTrue((boolean)res);
    }

    @Test
    public void testScanQuery() throws Exception {
        try (IgniteEx client1 = this.startGrid("client-1");
             IgniteEx client2 = this.startGrid("client-2");){
            IgniteCache cache1 = client1.createCache(new CacheConfiguration("cache1").setGroupName("group1"));
            IgniteCache cache2 = client2.createCache("cache2");
            for (int i = 0; i < 100; ++i) {
                cache1.put((Object)i, (Object)i);
                cache2.put((Object)i, (Object)i);
            }
            SqlViewExporterSpiTest.assertEquals((int)0, (int)this.execute((Ignite)ignite0, SCAN_QRY_SELECT, new Object[0]).size());
            SqlViewExporterSpiTest.assertEquals((int)0, (int)this.execute((Ignite)ignite1, SCAN_QRY_SELECT, new Object[0]).size());
            QueryCursor qryRes1 = cache1.query((Query)new ScanQuery().setFilter((IgniteBiPredicate)new SystemViewSelfTest.TestPredicate()).setPageSize(10), (IgniteClosure)new SystemViewSelfTest.TestTransformer());
            QueryCursor qryRes2 = cache2.withKeepBinary().query((Query)new ScanQuery().setPageSize(20));
            SqlViewExporterSpiTest.assertTrue((boolean)qryRes1.iterator().hasNext());
            SqlViewExporterSpiTest.assertTrue((boolean)qryRes2.iterator().hasNext());
            this.checkScanQueryView(client1, client2, ignite0);
            this.checkScanQueryView(client1, client2, ignite1);
            qryRes1.close();
            qryRes2.close();
            boolean res = GridTestUtils.waitForCondition(() -> this.execute((Ignite)ignite0, SCAN_QRY_SELECT, new Object[0]).size() + this.execute((Ignite)ignite1, SCAN_QRY_SELECT, new Object[0]).size() == 0, (long)5000L);
            SqlViewExporterSpiTest.assertTrue((boolean)res);
        }
    }

    private void checkScanQueryView(IgniteEx client1, IgniteEx client2, IgniteEx server) throws Exception {
        boolean res = GridTestUtils.waitForCondition(() -> this.execute((Ignite)server, SCAN_QRY_SELECT, new Object[0]).size() > 1, (long)5000L);
        SqlViewExporterSpiTest.assertTrue((boolean)res);
        Consumer<List> cache1checker = view -> {
            SqlViewExporterSpiTest.assertEquals((Object)client1.localNode().id(), view.get(0));
            SqlViewExporterSpiTest.assertTrue(((Long)view.get(1) != 0L ? 1 : 0) != 0);
            SqlViewExporterSpiTest.assertEquals((Object)"cache1", view.get(2));
            SqlViewExporterSpiTest.assertEquals((Object)GridCacheUtils.cacheId((String)"cache1"), view.get(3));
            SqlViewExporterSpiTest.assertEquals((Object)GridCacheUtils.cacheGroupId((String)"cache1", (String)"group1"), view.get(4));
            SqlViewExporterSpiTest.assertEquals((Object)"group1", view.get(5));
            SqlViewExporterSpiTest.assertTrue(((Long)view.get(6) <= System.currentTimeMillis() ? 1 : 0) != 0);
            SqlViewExporterSpiTest.assertTrue(((Long)view.get(7) >= 0L ? 1 : 0) != 0);
            SqlViewExporterSpiTest.assertFalse((boolean)((Boolean)view.get(8)));
            SqlViewExporterSpiTest.assertEquals((Object)"TestPredicate", view.get(9));
            SqlViewExporterSpiTest.assertFalse((boolean)((Boolean)view.get(10)));
            SqlViewExporterSpiTest.assertEquals((Object)-1, view.get(11));
            SqlViewExporterSpiTest.assertEquals((Object)IgniteUtils.toStringSafe((Object)client1.context().discovery().topologyVersionEx()), view.get(12));
            SqlViewExporterSpiTest.assertEquals((Object)"TestTransformer", view.get(13));
            SqlViewExporterSpiTest.assertFalse((boolean)((Boolean)view.get(14)));
            SqlViewExporterSpiTest.assertNull(view.get(15));
            SqlViewExporterSpiTest.assertNull(view.get(16));
            SqlViewExporterSpiTest.assertEquals((Object)10, view.get(17));
        };
        Consumer<List> cache2checker = view -> {
            SqlViewExporterSpiTest.assertEquals((Object)client2.localNode().id(), view.get(0));
            SqlViewExporterSpiTest.assertTrue(((Long)view.get(1) != 0L ? 1 : 0) != 0);
            SqlViewExporterSpiTest.assertEquals((Object)"cache2", view.get(2));
            SqlViewExporterSpiTest.assertEquals((Object)GridCacheUtils.cacheId((String)"cache2"), view.get(3));
            SqlViewExporterSpiTest.assertEquals((Object)GridCacheUtils.cacheGroupId((String)"cache2", null), view.get(4));
            SqlViewExporterSpiTest.assertEquals((Object)"cache2", view.get(5));
            SqlViewExporterSpiTest.assertTrue(((Long)view.get(6) <= System.currentTimeMillis() ? 1 : 0) != 0);
            SqlViewExporterSpiTest.assertTrue(((Long)view.get(7) >= 0L ? 1 : 0) != 0);
            SqlViewExporterSpiTest.assertFalse((boolean)((Boolean)view.get(8)));
            SqlViewExporterSpiTest.assertNull(view.get(9));
            SqlViewExporterSpiTest.assertFalse((boolean)((Boolean)view.get(10)));
            SqlViewExporterSpiTest.assertEquals((Object)-1, view.get(11));
            SqlViewExporterSpiTest.assertEquals((Object)IgniteUtils.toStringSafe((Object)client2.context().discovery().topologyVersionEx()), view.get(12));
            SqlViewExporterSpiTest.assertNull(view.get(13));
            SqlViewExporterSpiTest.assertTrue((boolean)((Boolean)view.get(14)));
            SqlViewExporterSpiTest.assertNull(view.get(15));
            SqlViewExporterSpiTest.assertNull(view.get(16));
            SqlViewExporterSpiTest.assertEquals((Object)20, view.get(17));
        };
        boolean found1 = false;
        boolean found2 = false;
        for (List<?> view2 : this.execute((Ignite)server, SCAN_QRY_SELECT, new Object[0])) {
            if ("cache2".equals(view2.get(2))) {
                cache2checker.accept(view2);
                found1 = true;
                continue;
            }
            cache1checker.accept(view2);
            found2 = true;
        }
        SqlViewExporterSpiTest.assertTrue((found1 && found2 ? 1 : 0) != 0);
    }

    @Test
    public void testStripedExecutor() throws Exception {
        this.checkStripeExecutorView(ignite0.context().pools().getStripedExecutorService(), "STRIPED_THREADPOOL_QUEUE", "sys");
    }

    @Test
    public void testStreamerExecutor() throws Exception {
        this.checkStripeExecutorView(ignite0.context().pools().getDataStreamerExecutorService(), "DATASTREAM_THREADPOOL_QUEUE", "data-streamer");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkStripeExecutorView(StripedExecutor execSvc, String view, String poolName) throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        execSvc.execute(0, (Runnable)new SystemViewSelfTest.TestRunnable(latch, 0));
        execSvc.execute(0, (Runnable)new SystemViewSelfTest.TestRunnable(latch, 1));
        execSvc.execute(1, (Runnable)new SystemViewSelfTest.TestRunnable(latch, 2));
        execSvc.execute(1, (Runnable)new SystemViewSelfTest.TestRunnable(latch, 3));
        try {
            boolean res = GridTestUtils.waitForCondition(() -> this.execute((Ignite)ignite0, "SELECT * FROM " + QueryUtils.sysSchemaName() + '.' + view, new Object[0]).size() == 2, (long)5000L);
            SqlViewExporterSpiTest.assertTrue((boolean)res);
            List<List<?>> stripedQueue = this.execute((Ignite)ignite0, "SELECT * FROM " + QueryUtils.sysSchemaName() + '.' + view, new Object[0]);
            List<?> row0 = stripedQueue.get(0);
            SqlViewExporterSpiTest.assertEquals((Object)0, row0.get(0));
            SqlViewExporterSpiTest.assertEquals((Object)(SystemViewSelfTest.TestRunnable.class.getSimpleName() + '1'), row0.get(1));
            SqlViewExporterSpiTest.assertEquals((Object)(poolName + "-stripe-0"), row0.get(2));
            SqlViewExporterSpiTest.assertEquals((Object)SystemViewSelfTest.TestRunnable.class.getName(), row0.get(3));
            List<?> row1 = stripedQueue.get(1);
            SqlViewExporterSpiTest.assertEquals((Object)1, row1.get(0));
            SqlViewExporterSpiTest.assertEquals((Object)(SystemViewSelfTest.TestRunnable.class.getSimpleName() + '3'), row1.get(1));
            SqlViewExporterSpiTest.assertEquals((Object)(poolName + "-stripe-1"), row1.get(2));
            SqlViewExporterSpiTest.assertEquals((Object)SystemViewSelfTest.TestRunnable.class.getName(), row1.get(3));
        }
        finally {
            latch.countDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPagesList() throws Exception {
        String cacheName = "cacheFL";
        IgniteCache cache = ignite0.getOrCreateCache(new CacheConfiguration().setName(cacheName).setAffinity((AffinityFunction)new RendezvousAffinityFunction().setPartitions(1)));
        GridCacheDatabaseSharedManager dbMgr = (GridCacheDatabaseSharedManager)ignite0.context().cache().context().database();
        int pageSize = dbMgr.pageSize();
        try {
            int j;
            dbMgr.enableCheckpoints(false).get();
            int key = 0;
            for (j = 0; j < pageSize / 2; ++j) {
                cache.put((Object)key++, (Object)new byte[j + 1]);
            }
            for (j = 0; j < 1000; ++j) {
                cache.put((Object)key++, (Object)new byte[pageSize / 2]);
            }
            SqlViewExporterSpiTest.assertFalse((boolean)this.execute((Ignite)ignite0, "SELECT * FROM " + QueryUtils.sysSchemaName() + ".CACHE_GROUP_PAGE_LISTS WHERE BUCKET_NUMBER = 0 AND PARTITION_ID = 0 AND CACHE_GROUP_ID = ?", GridCacheUtils.cacheId((String)cacheName)).isEmpty());
            SqlViewExporterSpiTest.assertTrue((boolean)this.execute((Ignite)ignite0, "SELECT * FROM " + QueryUtils.sysSchemaName() + ".CACHE_GROUP_PAGE_LISTS WHERE CACHE_GROUP_ID = ?", -1).isEmpty());
            SqlViewExporterSpiTest.assertTrue((boolean)this.execute((Ignite)ignite0, "SELECT * FROM " + QueryUtils.sysSchemaName() + ".CACHE_GROUP_PAGE_LISTS WHERE PARTITION_ID = ?", -1).isEmpty());
            SqlViewExporterSpiTest.assertTrue((boolean)this.execute((Ignite)ignite0, "SELECT * FROM " + QueryUtils.sysSchemaName() + ".CACHE_GROUP_PAGE_LISTS WHERE BUCKET_NUMBER = -1", new Object[0]).isEmpty());
            SqlViewExporterSpiTest.assertFalse((boolean)this.execute((Ignite)ignite0, "SELECT * FROM " + QueryUtils.sysSchemaName() + ".CACHE_GROUP_PAGE_LISTS WHERE BUCKET_SIZE > 0 AND CACHE_GROUP_ID = ?", GridCacheUtils.cacheId((String)cacheName)).isEmpty());
            SqlViewExporterSpiTest.assertFalse((boolean)this.execute((Ignite)ignite0, "SELECT * FROM " + QueryUtils.sysSchemaName() + ".CACHE_GROUP_PAGE_LISTS WHERE STRIPES_COUNT > 0 AND CACHE_GROUP_ID = ?", GridCacheUtils.cacheId((String)cacheName)).isEmpty());
            SqlViewExporterSpiTest.assertFalse((boolean)this.execute((Ignite)ignite0, "SELECT * FROM " + QueryUtils.sysSchemaName() + ".CACHE_GROUP_PAGE_LISTS WHERE CACHED_PAGES_COUNT > 0 AND CACHE_GROUP_ID = ?", GridCacheUtils.cacheId((String)cacheName)).isEmpty());
            SqlViewExporterSpiTest.assertFalse((boolean)this.execute((Ignite)ignite0, "SELECT * FROM " + QueryUtils.sysSchemaName() + ".DATA_REGION_PAGE_LISTS WHERE NAME LIKE 'in-memory%'", new Object[0]).isEmpty());
            SqlViewExporterSpiTest.assertEquals((Object)0L, this.execute((Ignite)ignite0, "SELECT COUNT(*) FROM " + QueryUtils.sysSchemaName() + ".DATA_REGION_PAGE_LISTS WHERE NAME LIKE 'in-memory%' AND BUCKET_SIZE > 0", new Object[0]).get(0).get(0));
        }
        finally {
            dbMgr.enableCheckpoints(true).get();
        }
        ignite0.cluster().active(false);
        ignite0.cluster().active(true);
        IgniteCache cacheInMemory = ignite0.getOrCreateCache(new CacheConfiguration().setName("cacheFLInMemory").setDataRegionName("in-memory"));
        cacheInMemory.put((Object)0, (Object)0);
        SqlViewExporterSpiTest.assertFalse((boolean)this.execute((Ignite)ignite0, "SELECT * FROM " + QueryUtils.sysSchemaName() + ".DATA_REGION_PAGE_LISTS WHERE NAME LIKE 'in-memory%' AND BUCKET_SIZE > 0", new Object[0]).isEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPartitionStates() throws Exception {
        String nodeName0 = this.getTestIgniteInstanceName(0);
        String nodeName1 = this.getTestIgniteInstanceName(1);
        String nodeName2 = this.getTestIgniteInstanceName(2);
        IgniteCache cache1 = ignite0.createCache(new CacheConfiguration().setName("cache1").setCacheMode(CacheMode.PARTITIONED).setAffinity((AffinityFunction)new TestAffinityFunction(new String[][]{{nodeName0, nodeName1}, {nodeName1, nodeName2}, {nodeName2, nodeName0}})));
        IgniteCache cache2 = ignite0.createCache(new CacheConfiguration().setName("cache2").setCacheMode(CacheMode.PARTITIONED).setAffinity((AffinityFunction)new TestAffinityFunction(new String[][]{{nodeName0, nodeName1, nodeName2}, {nodeName1}})));
        for (int i = 0; i < 100; ++i) {
            cache1.put((Object)i, (Object)i);
            cache2.put((Object)i, (Object)i);
        }
        try (IgniteEx ignite2 = this.startGrid(nodeName2);){
            ignite2.rebalanceEnabled(false);
            ignite0.cluster().setBaselineTopology(ignite0.cluster().topologyVersion());
            String partStateSql = "SELECT STATE FROM SYS.PARTITION_STATES WHERE CACHE_GROUP_ID = ? AND NODE_ID = ? AND PARTITION_ID = ?";
            UUID nodeId0 = ignite0.cluster().localNode().id();
            UUID nodeId1 = ignite1.cluster().localNode().id();
            UUID nodeId2 = ignite2.cluster().localNode().id();
            Integer cacheGrpId1 = ignite0.cachex("cache1").context().groupId();
            Integer cacheGrpId2 = ignite0.cachex("cache2").context().groupId();
            String owningState = GridDhtPartitionState.OWNING.name();
            String movingState = GridDhtPartitionState.MOVING.name();
            for (Ignite ignite : Arrays.asList(ignite0, ignite1, ignite2)) {
                SqlViewExporterSpiTest.assertEquals((Object)owningState, this.execute(ignite, partStateSql, cacheGrpId1, nodeId0, 0).get(0).get(0));
                SqlViewExporterSpiTest.assertEquals((Object)owningState, this.execute(ignite, partStateSql, cacheGrpId1, nodeId1, 0).get(0).get(0));
                SqlViewExporterSpiTest.assertEquals((Object)owningState, this.execute(ignite, partStateSql, cacheGrpId1, nodeId1, 1).get(0).get(0));
                SqlViewExporterSpiTest.assertEquals((Object)movingState, this.execute(ignite, partStateSql, cacheGrpId1, nodeId2, 1).get(0).get(0));
                SqlViewExporterSpiTest.assertEquals((Object)owningState, this.execute(ignite, partStateSql, cacheGrpId1, nodeId0, 2).get(0).get(0));
                SqlViewExporterSpiTest.assertEquals((Object)movingState, this.execute(ignite, partStateSql, cacheGrpId1, nodeId2, 2).get(0).get(0));
                SqlViewExporterSpiTest.assertEquals((Object)owningState, this.execute(ignite, partStateSql, cacheGrpId2, nodeId0, 0).get(0).get(0));
                SqlViewExporterSpiTest.assertEquals((Object)owningState, this.execute(ignite, partStateSql, cacheGrpId2, nodeId1, 0).get(0).get(0));
                SqlViewExporterSpiTest.assertEquals((Object)movingState, this.execute(ignite, partStateSql, cacheGrpId2, nodeId2, 0).get(0).get(0));
                SqlViewExporterSpiTest.assertEquals((Object)owningState, this.execute(ignite, partStateSql, cacheGrpId2, nodeId1, 1).get(0).get(0));
            }
            String partPrimarySql = "SELECT IS_PRIMARY FROM SYS.PARTITION_STATES WHERE CACHE_GROUP_ID = ? AND NODE_ID = ? AND PARTITION_ID = ?";
            for (Ignite ignite : Arrays.asList(ignite0, ignite1, ignite2)) {
                SqlViewExporterSpiTest.assertEquals((Object)true, this.execute(ignite, partPrimarySql, cacheGrpId1, nodeId0, 0).get(0).get(0));
                SqlViewExporterSpiTest.assertEquals((Object)false, this.execute(ignite, partPrimarySql, cacheGrpId1, nodeId1, 0).get(0).get(0));
                SqlViewExporterSpiTest.assertEquals((Object)true, this.execute(ignite, partPrimarySql, cacheGrpId1, nodeId1, 1).get(0).get(0));
                SqlViewExporterSpiTest.assertEquals((Object)false, this.execute(ignite, partPrimarySql, cacheGrpId1, nodeId2, 1).get(0).get(0));
                SqlViewExporterSpiTest.assertEquals((Object)true, this.execute(ignite, partPrimarySql, cacheGrpId1, nodeId0, 2).get(0).get(0));
                SqlViewExporterSpiTest.assertEquals((Object)false, this.execute(ignite, partPrimarySql, cacheGrpId1, nodeId2, 2).get(0).get(0));
                SqlViewExporterSpiTest.assertEquals((Object)true, this.execute(ignite, partPrimarySql, cacheGrpId2, nodeId0, 0).get(0).get(0));
                SqlViewExporterSpiTest.assertEquals((Object)false, this.execute(ignite, partPrimarySql, cacheGrpId2, nodeId1, 0).get(0).get(0));
                SqlViewExporterSpiTest.assertEquals((Object)false, this.execute(ignite, partPrimarySql, cacheGrpId2, nodeId2, 0).get(0).get(0));
                SqlViewExporterSpiTest.assertEquals((Object)true, this.execute(ignite, partPrimarySql, cacheGrpId2, nodeId1, 1).get(0).get(0));
            }
            SqlViewExporterSpiTest.assertEquals((Object)owningState, this.execute((Ignite)ignite0, "SELECT p.STATE FROM SYS.PARTITION_STATES p JOIN SYS.CACHE_GROUPS g ON p.CACHE_GROUP_ID = g.CACHE_GROUP_ID JOIN SYS.NODES n ON p.NODE_ID = n.NODE_ID WHERE g.CACHE_GROUP_NAME = 'cache2' AND n.CONSISTENT_ID = ? AND p.PARTITION_ID = 1", nodeName1).get(0).get(0));
            SqlViewExporterSpiTest.assertEquals((int)0, (int)this.execute((Ignite)ignite0, "SELECT * FROM SYS.PARTITION_STATES WHERE PARTITION_ID = ?", Integer.MAX_VALUE).size());
            SqlViewExporterSpiTest.assertEquals((int)0, (int)this.execute((Ignite)ignite0, "SELECT * FROM SYS.PARTITION_STATES WHERE PARTITION_ID = -1", new Object[0]).size());
            SqlViewExporterSpiTest.assertEquals((int)0, (int)this.execute((Ignite)ignite0, "SELECT * FROM SYS.PARTITION_STATES WHERE NODE_ID = '123'", new Object[0]).size());
            SqlViewExporterSpiTest.assertEquals((int)0, (int)this.execute((Ignite)ignite0, "SELECT * FROM SYS.PARTITION_STATES WHERE NODE_ID = ?", UUID.randomUUID()).size());
            SqlViewExporterSpiTest.assertEquals((int)0, (int)this.execute((Ignite)ignite0, "SELECT * FROM SYS.PARTITION_STATES WHERE CACHE_GROUP_ID = 0", new Object[0]).size());
            AffinityTopologyVersion affinityTopologyVersion = ignite0.context().discovery().topologyVersionEx();
            ignite2.rebalanceEnabled(true);
            SqlViewExporterSpiTest.assertTrue((boolean)GridTestUtils.waitForCondition(() -> ignite0.context().discovery().topologyVersionEx().compareTo(topVer) > 0, (long)5000L));
            String string = "SELECT COUNT(*) FROM SYS.PARTITION_STATES WHERE CACHE_GROUP_ID IN (?, ?) AND STATE = ?";
            for (Ignite ignite : Arrays.asList(ignite0, ignite1, ignite2)) {
                SqlViewExporterSpiTest.assertEquals((Object)10L, this.execute(ignite, string, cacheGrpId1, cacheGrpId2, owningState).get(0).get(0));
                SqlViewExporterSpiTest.assertEquals((Object)0L, this.execute(ignite, string, cacheGrpId1, cacheGrpId2, movingState).get(0).get(0));
            }
            for (Ignite ignite : Arrays.asList(ignite0, ignite1, ignite2)) {
                SqlViewExporterSpiTest.assertEquals((Object)false, this.execute(ignite, partPrimarySql, cacheGrpId1, nodeId0, 2).get(0).get(0));
                SqlViewExporterSpiTest.assertEquals((Object)true, this.execute(ignite, partPrimarySql, cacheGrpId1, nodeId2, 2).get(0).get(0));
            }
        }
        finally {
            ignite0.cluster().setBaselineTopology(ignite0.cluster().topologyVersion());
        }
    }

    @Test
    public void testBinaryMeta() {
        IgniteCache c1 = ignite0.createCache("test-cache");
        IgniteCache c2 = ignite0.createCache("test-enum-cache");
        this.execute((Ignite)ignite0, "CREATE TABLE T1(ID LONG PRIMARY KEY, NAME VARCHAR(40), ACCOUNT BIGINT)", new Object[0]);
        this.execute((Ignite)ignite0, "INSERT INTO T1(ID, NAME, ACCOUNT) VALUES(1, 'test', 1)", new Object[0]);
        c1.put((Object)1, (Object)new GridBinaryTestClasses.TestObjectAllTypes());
        c2.put((Object)1, (Object)GridBinaryTestClasses.TestObjectEnum.A);
        List<List<?>> view = this.execute((Ignite)ignite0, "SELECT TYPE_NAME, FIELDS_COUNT, FIELDS, IS_ENUM FROM SYS.BINARY_METADATA", new Object[0]);
        SqlViewExporterSpiTest.assertNotNull(view);
        SqlViewExporterSpiTest.assertEquals((int)3, (int)view.size());
        for (List<?> meta : view) {
            if (Objects.equals(GridBinaryTestClasses.TestObjectEnum.class.getName(), meta.get(0))) {
                SqlViewExporterSpiTest.assertTrue((boolean)((Boolean)meta.get(3)));
                SqlViewExporterSpiTest.assertEquals((Object)0, meta.get(1));
                continue;
            }
            if (Objects.equals(GridBinaryTestClasses.TestObjectAllTypes.class.getName(), meta.get(0))) {
                SqlViewExporterSpiTest.assertFalse((boolean)((Boolean)meta.get(3)));
                Field[] fields = GridBinaryTestClasses.TestObjectAllTypes.class.getDeclaredFields();
                SqlViewExporterSpiTest.assertEquals((Object)fields.length, meta.get(1));
                for (Field field : fields) {
                    SqlViewExporterSpiTest.assertTrue((boolean)meta.get(2).toString().contains(field.getName()));
                }
                continue;
            }
            SqlViewExporterSpiTest.assertFalse((boolean)((Boolean)meta.get(3)));
            SqlViewExporterSpiTest.assertEquals((Object)2, meta.get(1));
            SqlViewExporterSpiTest.assertTrue((boolean)meta.get(2).toString().contains("NAME"));
            SqlViewExporterSpiTest.assertTrue((boolean)meta.get(2).toString().contains("ACCOUNT"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMetastorage() throws Exception {
        IgniteCacheDatabaseSharedManager db = ignite0.context().cache().context().database();
        SystemView metaStoreView = ignite0.context().systemView().view("metastorage");
        SqlViewExporterSpiTest.assertNotNull((Object)metaStoreView);
        String name = "test-key";
        String val = "test-value";
        db.checkpointReadLock();
        try {
            db.metaStorage().write(name, (Serializable)((Object)val));
        }
        finally {
            db.checkpointReadUnlock();
        }
        SqlViewExporterSpiTest.assertEquals((int)1, (int)this.execute((Ignite)ignite0, "SELECT * FROM SYS.METASTORAGE WHERE name = ? AND value = ?", name, val).size());
    }

    @Test
    public void testDistributedMetastorage() throws Exception {
        DistributedMetaStorage dms = ignite0.context().distributedMetastorage();
        SystemView distributedMetaStoreView = ignite0.context().systemView().view(DistributedMetaStorageImpl.DISTRIBUTED_METASTORE_VIEW);
        SqlViewExporterSpiTest.assertNotNull((Object)distributedMetaStoreView);
        String name = "test-distributed-key";
        String val = "test-distributed-value";
        dms.write(name, (Serializable)((Object)val));
        SqlViewExporterSpiTest.assertEquals((int)1, (int)this.execute((Ignite)ignite0, "SELECT * FROM SYS.DISTRIBUTED_METASTORAGE WHERE name = ? AND value = ?", name, val).size());
        SqlViewExporterSpiTest.assertTrue((boolean)GridTestUtils.waitForCondition(() -> this.execute((Ignite)ignite1, "SELECT * FROM SYS.DISTRIBUTED_METASTORAGE WHERE name = ? AND value = ?", name, val).size() == 1, (long)this.getTestTimeout()));
    }

    private List<List<?>> execute(Ignite node, String sql, Object ... args) {
        SqlFieldsQuery qry = new SqlFieldsQuery(sql).setArgs(args).setSchema("PUBLIC");
        return AbstractSchemaSelfTest.queryProcessor(node).querySqlFields(qry, true).getAll();
    }

    static {
        SCAN_QRY_SELECT = "SELECT  ORIGIN_NODE_ID, QUERY_ID, CACHE_NAME, CACHE_ID, CACHE_GROUP_ID, CACHE_GROUP_NAME, START_TIME, DURATION, CANCELED, FILTER, LOCAL, PARTITION, TOPOLOGY, TRANSFORMER, KEEP_BINARY, SUBJECT_ID, TASK_NAME,  PAGE_SIZE FROM " + QueryUtils.sysSchemaName() + " .SCAN_QUERIES";
    }

    private static class TestAffinityFunction
    implements AffinityFunction {
        private final String[][] partMap;

        private TestAffinityFunction(String[][] partMap) {
            this.partMap = partMap;
        }

        public void reset() {
        }

        public int partitions() {
            return this.partMap.length;
        }

        public int partition(Object key) {
            return key.hashCode() % this.partitions();
        }

        public List<List<ClusterNode>> assignPartitions(AffinityFunctionContext affCtx) {
            ArrayList<List<ClusterNode>> parts = new ArrayList<List<ClusterNode>>(this.partMap.length);
            for (String[] nodes : this.partMap) {
                ArrayList<ClusterNode> nodesList = new ArrayList<ClusterNode>();
                for (String nodeConsistentId : nodes) {
                    ClusterNode affNode = (ClusterNode)F.find((Iterable)affCtx.currentTopologySnapshot(), null, (IgnitePredicate[])new IgnitePredicate[]{(IgnitePredicate & Serializable)node -> node.consistentId().equals(nodeConsistentId)});
                    if (affNode == null) continue;
                    nodesList.add(affNode);
                }
                parts.add(nodesList);
            }
            return parts;
        }

        public void removeNode(UUID nodeId) {
        }
    }
}

