/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.index;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.Ignition;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.processors.cache.index.DynamicColumnsAbstractTest;
import org.apache.ignite.internal.processors.query.QueryField;
import org.apache.ignite.internal.processors.query.QueryUtils;
import org.apache.ignite.testframework.config.GridTestProperties;
import org.apache.ignite.testframework.junits.GridAbstractTest;
import org.gridgain.internal.h2.jdbc.JdbcSQLSyntaxErrorException;
import org.junit.Assert;
import org.junit.Test;

public abstract class H2DynamicColumnsAbstractBasicSelfTest
extends DynamicColumnsAbstractTest {
    static final int SRV_CRD_IDX = 0;
    static final int SRV_IDX = 1;
    static final int CLI_IDX = 2;

    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        for (IgniteConfiguration cfg : this.configurations()) {
            Ignition.start((IgniteConfiguration)cfg);
        }
    }

    private IgniteConfiguration[] configurations() throws Exception {
        return new IgniteConfiguration[]{this.commonConfiguration(0), this.commonConfiguration(1), this.clientConfiguration(2)};
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.run("CREATE TABLE IF NOT EXISTS Person (id int primary key, name varchar)");
    }

    protected void afterTest() throws Exception {
        this.run("DROP TABLE Person");
        super.afterTest();
    }

    private int checkTableState(String schemaName, String tblName, QueryField ... cols) throws SQLException {
        return H2DynamicColumnsAbstractBasicSelfTest.checkTableState(this.grid(this.nodeIndex()), schemaName, tblName, cols);
    }

    @Test
    public void testAddColumnSimple() throws SQLException {
        this.run("ALTER TABLE Person ADD COLUMN age int");
        H2DynamicColumnsAbstractBasicSelfTest.doSleep((long)500L);
        QueryField c = H2DynamicColumnsAbstractBasicSelfTest.c("AGE", Integer.class.getName());
        this.checkTableState("PUBLIC", "PERSON", c);
    }

    @Test
    public void testAddFewColumnsSimple() throws SQLException {
        this.run("ALTER TABLE Person ADD COLUMN (age int, \"city\" varchar)");
        H2DynamicColumnsAbstractBasicSelfTest.doSleep((long)500L);
        this.checkTableState("PUBLIC", "PERSON", H2DynamicColumnsAbstractBasicSelfTest.c("AGE", Integer.class.getName()), H2DynamicColumnsAbstractBasicSelfTest.c("city", String.class.getName()));
    }

    @Test
    public void testIfTableExists() {
        this.run("ALTER TABLE if exists City ADD COLUMN population int");
    }

    @Test
    public void testIfColumnNotExists() {
        this.run("ALTER TABLE Person ADD COLUMN if not exists name varchar");
    }

    @Test
    public void testDuplicateColumnName() {
        this.assertThrows("ALTER TABLE Person ADD COLUMN name varchar", "Column already exists: NAME");
    }

    @Test
    public void testMissingTable() {
        this.assertThrows("ALTER TABLE City ADD COLUMN name varchar", "Table doesn't exist: CITY");
    }

    @Test
    public void testComplexOperations() {
        IgniteCache cache = this.ignite(this.nodeIndex()).cache(QueryUtils.createTableCacheName((String)"PUBLIC", (String)"PERSON"));
        this.run(cache, "ALTER TABLE Person ADD COLUMN city varchar", new Object[0]);
        this.run(cache, "INSERT INTO Person (id, name, city) values (1, 'John Doe', 'New York')", new Object[0]);
        this.run(cache, "INSERT INTO Person (id, name, city) values (2, 'Mike Watts', 'Denver')", new Object[0]);
        this.run(cache, "INSERT INTO Person (id, name, city) values (3, 'Ann Pierce', 'New York')", new Object[0]);
        this.run(cache, "CREATE INDEX pidx1 ON Person(name, city desc)", new Object[0]);
        CacheConfiguration ccfg = GridAbstractTest.defaultCacheConfiguration().setName("City").setIndexedTypes(new Class[]{Integer.class, City.class}).setSqlSchema("PUBLIC");
        ((QueryEntity)ccfg.getQueryEntities().iterator().next()).setKeyFieldName("id");
        this.ignite(this.nodeIndex()).getOrCreateCache(ccfg);
        this.run(cache, "ALTER TABLE City ADD COLUMN population int", new Object[0]);
        this.run(cache, "CREATE INDEX cidx1 ON City(population)", new Object[0]);
        this.run(cache, "CREATE INDEX cidx2 ON City(name)", new Object[0]);
        this.run(cache, "INSERT INTO City(id, name, population, state_name) values (5, 'New York', 15000000, 'New York'),(7, 'Denver', 3000000, 'Colorado')", new Object[0]);
        this.run(cache, "ALTER TABLE City DROP COLUMN state_name", new Object[0]);
        List<List<?>> res1 = this.run(cache, "SELECT * from City c WHERE c.population > 5000000", new Object[0]);
        H2DynamicColumnsAbstractBasicSelfTest.assertEquals((int)res1.get(0).size(), (int)3);
        List<List<?>> res = this.run(cache, "SELECT p.name from Person p join City c on p.city = c.name where c.population > 5000000 order by p.name", new Object[0]);
        H2DynamicColumnsAbstractBasicSelfTest.assertEquals((int)2, (int)res.size());
        H2DynamicColumnsAbstractBasicSelfTest.assertEquals(Collections.singletonList("Ann Pierce"), res.get(0));
        H2DynamicColumnsAbstractBasicSelfTest.assertEquals(Collections.singletonList("John Doe"), res.get(1));
        this.run(cache, "ALTER TABLE Person ADD COLUMN age int", new Object[0]);
        this.run(cache, "UPDATE Person SET age = (5 - id) * 10", new Object[0]);
        res = this.run(cache, "SELECT p.name from Person p join City c on p.city = c.name where c.population > 5000000 and age < 40", new Object[0]);
        H2DynamicColumnsAbstractBasicSelfTest.assertEquals((int)1, (int)res.size());
        H2DynamicColumnsAbstractBasicSelfTest.assertEquals(Collections.singletonList("Ann Pierce"), res.get(0));
        this.run(cache, "CREATE INDEX pidx2 on Person(age desc)", new Object[0]);
        this.run(cache, "DROP INDEX pidx2", new Object[0]);
        this.run(cache, "DROP INDEX pidx1", new Object[0]);
        this.run(cache, "DROP INDEX cidx2", new Object[0]);
        this.run(cache, "DROP INDEX cidx1", new Object[0]);
        this.run(cache, "DELETE FROM Person where age > 10", new Object[0]);
        H2DynamicColumnsAbstractBasicSelfTest.assertEquals((int)0, (int)cache.size(new CachePeekMode[0]));
        this.ignite(this.nodeIndex()).destroyCache("City");
    }

    @Test
    public void testAddColumnToNonDynamicCache() throws SQLException {
        this.run("ALTER TABLE \"idx\".PERSON ADD COLUMN CITY varchar");
        H2DynamicColumnsAbstractBasicSelfTest.doSleep((long)500L);
        QueryField c = H2DynamicColumnsAbstractBasicSelfTest.c("CITY", String.class.getName());
        this.checkTableState("idx", "PERSON", c);
    }

    @Test
    public void testAddColumnToNonDynamicCacheWithRealValueType() throws SQLException {
        CacheConfiguration ccfg = GridAbstractTest.defaultCacheConfiguration().setName("City").setIndexedTypes(new Class[]{Integer.class, City.class});
        IgniteCache cache = this.ignite(this.nodeIndex()).getOrCreateCache(ccfg);
        this.run(cache, "ALTER TABLE \"City\".City ADD COLUMN population int", new Object[0]);
        H2DynamicColumnsAbstractBasicSelfTest.doSleep((long)500L);
        QueryField c = H2DynamicColumnsAbstractBasicSelfTest.c("POPULATION", Integer.class.getName());
        this.checkTableState("City", "CITY", c);
        this.run(cache, "INSERT INTO \"City\".City (_key, id, name, state_name, population) values (1, 1, 'Washington', 'DC', 2500000)", new Object[0]);
        List<List<?>> res = this.run(cache, "select _key, id, name, state_name, population from \"City\".City", new Object[0]);
        H2DynamicColumnsAbstractBasicSelfTest.assertEquals(Collections.singletonList(Arrays.asList(1, 1, "Washington", "DC", 2500000)), res);
        if (!Boolean.valueOf(GridTestProperties.getProperty((String)"binary.marshaller.use.simple.name.mapper")).booleanValue()) {
            City city = (City)cache.get((Object)1);
            H2DynamicColumnsAbstractBasicSelfTest.assertEquals((int)1, (int)city.id());
            H2DynamicColumnsAbstractBasicSelfTest.assertEquals((String)"Washington", (String)city.name());
            H2DynamicColumnsAbstractBasicSelfTest.assertEquals((String)"DC", (String)city.state());
        } else {
            BinaryObject city = (BinaryObject)cache.withKeepBinary().get((Object)1);
            H2DynamicColumnsAbstractBasicSelfTest.assertEquals((int)1, (int)((Integer)city.field("id")));
            H2DynamicColumnsAbstractBasicSelfTest.assertEquals((String)"Washington", (String)((String)city.field("name")));
            H2DynamicColumnsAbstractBasicSelfTest.assertEquals((String)"DC", (String)((String)city.field("state")));
            H2DynamicColumnsAbstractBasicSelfTest.assertEquals((int)2500000, (int)((Integer)city.field("population")));
        }
        cache.destroy();
    }

    @Test
    public void testAddColumnUUID() throws SQLException {
        CacheConfiguration ccfg = GridAbstractTest.defaultCacheConfiguration().setName("GuidTest").setIndexedTypes(new Class[]{Integer.class, GuidTest.class});
        Random rnd = new Random();
        IgniteCache cache = this.ignite(this.nodeIndex()).getOrCreateCache(ccfg);
        this.run(cache, "ALTER TABLE \"GuidTest\".GuidTest ADD COLUMN GUID UUID", new Object[0]);
        this.run(cache, "ALTER TABLE \"GuidTest\".GuidTest ADD COLUMN DATA BINARY(128)", new Object[0]);
        H2DynamicColumnsAbstractBasicSelfTest.doSleep((long)500L);
        QueryField c1 = H2DynamicColumnsAbstractBasicSelfTest.c("GUID", Object.class.getName());
        QueryField c2 = H2DynamicColumnsAbstractBasicSelfTest.c("DATA", byte[].class.getName());
        this.checkTableState("GuidTest", "GUIDTEST", c1, c2);
        UUID guid1 = UUID.randomUUID();
        UUID guid2 = UUID.randomUUID();
        byte[] data1 = new byte[128];
        rnd.nextBytes(data1);
        byte[] data2 = new byte[128];
        rnd.nextBytes(data2);
        this.run(cache, "INSERT INTO \"GuidTest\".GuidTest (_key, id, guid, data) values (1, 1, ?, ?)", guid1.toString(), data1);
        cache.put((Object)2, (Object)new GuidTest(2, guid2, data2));
        List<List<?>> res = this.run(cache, "select _key, id, guid from \"GuidTest\".GuidTest order by id", new Object[0]);
        H2DynamicColumnsAbstractBasicSelfTest.assertEquals(Arrays.asList(Arrays.asList(1, 1, guid1), Arrays.asList(2, 2, guid2)), res);
        res = this.run(cache, "select data from \"GuidTest\".GuidTest order by id", new Object[0]);
        H2DynamicColumnsAbstractBasicSelfTest.assertTrue((boolean)Arrays.equals(data1, (byte[])res.get(0).get(0)));
        H2DynamicColumnsAbstractBasicSelfTest.assertTrue((boolean)Arrays.equals(data2, (byte[])res.get(1).get(0)));
        if (!Boolean.valueOf(GridTestProperties.getProperty((String)"binary.marshaller.use.simple.name.mapper")).booleanValue()) {
            GuidTest val1 = (GuidTest)cache.get((Object)1);
            GuidTest val2 = (GuidTest)cache.get((Object)2);
            H2DynamicColumnsAbstractBasicSelfTest.assertEquals((Object)guid1, (Object)val1.guid());
            H2DynamicColumnsAbstractBasicSelfTest.assertEquals((Object)guid2, (Object)val2.guid());
            H2DynamicColumnsAbstractBasicSelfTest.assertTrue((boolean)Arrays.equals(data1, val1.data()));
            H2DynamicColumnsAbstractBasicSelfTest.assertTrue((boolean)Arrays.equals(data2, val2.data()));
        } else {
            BinaryObject val1 = (BinaryObject)cache.withKeepBinary().get((Object)1);
            BinaryObject val2 = (BinaryObject)cache.withKeepBinary().get((Object)2);
            H2DynamicColumnsAbstractBasicSelfTest.assertEquals((Object)guid1, (Object)val1.field("guid"));
            H2DynamicColumnsAbstractBasicSelfTest.assertEquals((Object)guid2, (Object)val2.field("guid"));
            H2DynamicColumnsAbstractBasicSelfTest.assertTrue((boolean)Arrays.equals(data1, (byte[])val1.field("data")));
            H2DynamicColumnsAbstractBasicSelfTest.assertTrue((boolean)Arrays.equals(data2, (byte[])val2.field("data")));
        }
        cache.destroy();
    }

    @Test
    public void testAddNotNullColumn() throws SQLException {
        this.run("ALTER TABLE Person ADD COLUMN age int NOT NULL");
        H2DynamicColumnsAbstractBasicSelfTest.doSleep((long)500L);
        QueryField c = new QueryField("AGE", Integer.class.getName(), false);
        this.checkTableState("PUBLIC", "PERSON", c);
    }

    @Test
    public void testAddNullColumn() throws SQLException {
        this.run("ALTER TABLE Person ADD COLUMN age int NULL");
        H2DynamicColumnsAbstractBasicSelfTest.doSleep((long)500L);
        QueryField c = new QueryField("AGE", Integer.class.getName(), true);
        this.checkTableState("PUBLIC", "PERSON", c);
    }

    @Test
    public void testTestAlterTableOnFlatValueNonDynamicTable() {
        CacheConfiguration c = new CacheConfiguration("ints").setIndexedTypes(new Class[]{Integer.class, Integer.class}).setSqlSchema("PUBLIC");
        try {
            this.grid(this.nodeIndex()).getOrCreateCache(c);
            this.doTestAlterTableOnFlatValue("INTEGER");
        }
        finally {
            this.grid(this.nodeIndex()).destroyCache("ints");
        }
    }

    @Test
    public void testTestAlterTableOnFlatValueDynamicTable() {
        try {
            this.run("CREATE TABLE TEST (id int primary key, x varchar) with \"wrap_value=false\"");
            this.doTestAlterTableOnFlatValue("TEST");
        }
        finally {
            this.run("DROP TABLE TEST");
        }
    }

    @Test
    public void testDropColumn() throws Exception {
        try {
            this.run("CREATE TABLE test (id INT PRIMARY KEY, a INT, b CHAR)");
            H2DynamicColumnsAbstractBasicSelfTest.assertEquals((int)0, (int)this.checkTableState("PUBLIC", "TEST", new QueryField("ID", Integer.class.getName(), true), new QueryField("A", Integer.class.getName(), true), new QueryField("B", String.class.getName(), true)));
            this.run("ALTER TABLE PUBLIC.test DROP COLUMN a");
            H2DynamicColumnsAbstractBasicSelfTest.assertEquals((int)0, (int)this.checkTableState("PUBLIC", "TEST", new QueryField("ID", Integer.class.getName(), true), new QueryField("B", String.class.getName(), true)));
            this.run("ALTER TABLE test DROP COLUMN IF EXISTS a");
            this.assertThrowsAnyCause("ALTER TABLE test DROP COLUMN a", JdbcSQLSyntaxErrorException.class, "Column \"A\" not found");
        }
        finally {
            this.run("DROP TABLE IF EXISTS test");
        }
    }

    @Test
    public void testDroppedColumnMeta() throws Exception {
        try {
            this.run("CREATE TABLE test (id INT PRIMARY KEY, a INT, b CHAR)");
            QueryField fld = H2DynamicColumnsAbstractBasicSelfTest.getColumnMeta(this.grid(this.nodeIndex()), "PUBLIC", "TEST", "A");
            H2DynamicColumnsAbstractBasicSelfTest.assertEquals((String)"A", (String)fld.name());
            H2DynamicColumnsAbstractBasicSelfTest.assertEquals((String)Integer.class.getName(), (String)fld.typeName());
            this.run("ALTER TABLE test DROP COLUMN a");
            H2DynamicColumnsAbstractBasicSelfTest.assertNull((Object)H2DynamicColumnsAbstractBasicSelfTest.getColumnMeta(this.grid(this.nodeIndex()), "PUBLIC", "TEST", "A"));
        }
        finally {
            this.run("DROP TABLE IF EXISTS test");
        }
    }

    @Test
    public void testDropMultipleColumns() throws Exception {
        try {
            this.run("CREATE TABLE test (id INT PRIMARY KEY, a INT, b CHAR, c INT)");
            H2DynamicColumnsAbstractBasicSelfTest.assertEquals((int)0, (int)this.checkTableState("PUBLIC", "TEST", new QueryField("ID", Integer.class.getName(), true), new QueryField("A", Integer.class.getName(), true), new QueryField("B", String.class.getName(), true), new QueryField("C", Integer.class.getName(), true)));
            this.run("ALTER TABLE test DROP COLUMN a, c");
            H2DynamicColumnsAbstractBasicSelfTest.assertEquals((int)0, (int)this.checkTableState("PUBLIC", "TEST", new QueryField("ID", Integer.class.getName(), true), new QueryField("B", String.class.getName(), true)));
        }
        finally {
            this.run("DROP TABLE IF EXISTS test");
        }
    }

    @Test
    public void testDropNonExistingColumn() throws Exception {
        try {
            this.run("CREATE TABLE test (id INT PRIMARY KEY, a INT)");
            this.assertThrowsAnyCause("ALTER TABLE test DROP COLUMN b", JdbcSQLSyntaxErrorException.class, "Column \"B\" not found");
        }
        finally {
            this.run("DROP TABLE IF EXISTS test");
        }
    }

    @Test
    public void testDropColumnNonExistingTable() throws Exception {
        this.assertThrowsAnyCause("ALTER TABLE nosuchtable DROP COLUMN a", JdbcSQLSyntaxErrorException.class, "Table \"NOSUCHTABLE\" not found");
    }

    @Test
    public void testDropColumnIfTableExists() throws Exception {
        try {
            this.run("CREATE TABLE test (id INT PRIMARY KEY, a INT, b CHAR)");
            this.run("ALTER TABLE IF EXISTS test DROP COLUMN a");
            H2DynamicColumnsAbstractBasicSelfTest.assertEquals((int)0, (int)this.checkTableState("PUBLIC", "TEST", new QueryField("ID", Integer.class.getName(), true), new QueryField("B", String.class.getName(), true)));
        }
        finally {
            this.run("DROP TABLE IF EXISTS test");
        }
    }

    @Test
    public void testDropColumnIfExists() throws Exception {
        try {
            this.run("CREATE TABLE test (id INT PRIMARY KEY, a INT)");
            this.run("ALTER TABLE IF EXISTS test DROP COLUMN IF EXISTS a");
            this.run("ALTER TABLE IF EXISTS test DROP COLUMN IF EXISTS b");
            H2DynamicColumnsAbstractBasicSelfTest.assertEquals((int)0, (int)this.checkTableState("PUBLIC", "TEST", new QueryField("ID", Integer.class.getName(), true)));
        }
        finally {
            this.run("DROP TABLE IF EXISTS test");
        }
    }

    @Test
    public void testDropColumnIndexPresent() throws Exception {
        try {
            this.run("CREATE TABLE test (id INT PRIMARY KEY, a INT, b INT)");
            this.run("CREATE INDEX b_index ON test(b)");
            this.assertThrows("ALTER TABLE test DROP COLUMN b", "Cannot drop column \"B\" because an index exists (\"B_INDEX\") that uses the column.");
            this.run("DROP INDEX b_index");
            this.run("ALTER TABLE test DROP COLUMN b");
            H2DynamicColumnsAbstractBasicSelfTest.assertEquals((int)0, (int)this.checkTableState("PUBLIC", "TEST", new QueryField("ID", Integer.class.getName(), true), new QueryField("A", Integer.class.getName(), true)));
        }
        finally {
            this.run("DROP TABLE IF EXISTS test");
        }
    }

    @Test
    public void testDropColumnOnRealClassValuedTable() throws Exception {
        try {
            this.run("CREATE TABLE test (id INT PRIMARY KEY, x VARCHAR) with \"wrap_value=false\"");
            this.assertThrows("ALTER TABLE test DROP COLUMN x", "Cannot drop column(s) because table was created with WRAP_VALUE=false option.");
        }
        finally {
            this.run("DROP TABLE IF EXISTS test");
        }
    }

    @Test
    public void testDropColumnThatIsPartOfKey() throws Exception {
        try {
            this.run("CREATE TABLE test(id INT, a INT, b CHAR, PRIMARY KEY(id, a))");
            this.assertThrows("ALTER TABLE test DROP COLUMN a", "Cannot drop column \"A\" because it is a part of a cache key");
        }
        finally {
            this.run("DROP TABLE IF EXISTS test");
        }
    }

    @Test
    public void testDropColumnThatIsKey() throws Exception {
        try {
            this.run("CREATE TABLE test(id INT PRIMARY KEY, a INT, b CHAR)");
            this.assertThrows("ALTER TABLE test DROP COLUMN id", "Cannot drop column \"ID\" because it represents an entire cache key");
        }
        finally {
            this.run("DROP TABLE IF EXISTS test");
        }
    }

    @Test
    public void testDropColumnThatIsValue() throws Exception {
        try {
            this.run("CREATE TABLE test(id INT PRIMARY KEY, a INT, b CHAR)");
            this.assertThrows("ALTER TABLE test DROP COLUMN _val", "Cannot drop column \"_VAL\" because it represents an entire cache value");
        }
        finally {
            this.run("DROP TABLE IF EXISTS test");
        }
    }

    @Test
    public void testDropColumnFromNonDynamicCacheWithRealValueType() throws SQLException {
        CacheConfiguration ccfg = GridAbstractTest.defaultCacheConfiguration().setName("City").setIndexedTypes(new Class[]{Integer.class, City.class});
        IgniteCache cache = this.ignite(this.nodeIndex()).getOrCreateCache(ccfg);
        this.run(cache, "INSERT INTO \"City\".City (_key, id, name, state_name) VALUES (1, 1, 'Washington', 'DC')", new Object[0]);
        this.run(cache, "ALTER TABLE \"City\".City DROP COLUMN state_name", new Object[0]);
        H2DynamicColumnsAbstractBasicSelfTest.doSleep((long)500L);
        QueryField c = H2DynamicColumnsAbstractBasicSelfTest.c("NAME", String.class.getName());
        this.checkTableState("City", "CITY", c);
        this.run(cache, "INSERT INTO \"City\".City (_key, id, name) VALUES (2, 2, 'New York')", new Object[0]);
        this.assertThrowsAnyCause("SELECT state_name FROM \"City\".City", JdbcSQLSyntaxErrorException.class, "Column \"STATE_NAME\" not found");
        List<List<?>> res = this.run(cache, "SELECT _key, id, name FROM \"City\".City WHERE id = 1", new Object[0]);
        H2DynamicColumnsAbstractBasicSelfTest.assertEquals(Collections.singletonList(Arrays.asList(1, 1, "Washington")), res);
        res = this.run(cache, "SELECT * FROM \"City\".City WHERE id = 2", new Object[0]);
        H2DynamicColumnsAbstractBasicSelfTest.assertEquals(Collections.singletonList(Arrays.asList(2, "New York")), res);
        if (!Boolean.valueOf(GridTestProperties.getProperty((String)"binary.marshaller.use.simple.name.mapper")).booleanValue()) {
            City city = (City)cache.get((Object)1);
            H2DynamicColumnsAbstractBasicSelfTest.assertEquals((int)1, (int)city.id());
            H2DynamicColumnsAbstractBasicSelfTest.assertEquals((String)"Washington", (String)city.name());
            H2DynamicColumnsAbstractBasicSelfTest.assertEquals((String)"DC", (String)city.state());
            city = (City)cache.get((Object)2);
            H2DynamicColumnsAbstractBasicSelfTest.assertEquals((int)2, (int)city.id());
            H2DynamicColumnsAbstractBasicSelfTest.assertEquals((String)"New York", (String)city.name());
            H2DynamicColumnsAbstractBasicSelfTest.assertEquals(null, (String)city.state());
        } else {
            BinaryObject city = (BinaryObject)cache.withKeepBinary().get((Object)1);
            H2DynamicColumnsAbstractBasicSelfTest.assertEquals((int)1, (int)((Integer)city.field("id")));
            H2DynamicColumnsAbstractBasicSelfTest.assertEquals((String)"Washington", (String)((String)city.field("name")));
            H2DynamicColumnsAbstractBasicSelfTest.assertEquals((String)"DC", (String)((String)city.field("state")));
            city = (BinaryObject)cache.withKeepBinary().get((Object)2);
            H2DynamicColumnsAbstractBasicSelfTest.assertEquals((int)2, (int)((Integer)city.field("id")));
            H2DynamicColumnsAbstractBasicSelfTest.assertEquals((String)"New York", (String)((String)city.field("name")));
            H2DynamicColumnsAbstractBasicSelfTest.assertEquals(null, (String)((String)city.field("state")));
        }
        cache.destroy();
    }

    @Test
    public void testDropColumnPriorToIndexedColumn() throws Exception {
        try {
            this.run("CREATE TABLE test(id INT PRIMARY KEY, a CHAR, b INT)");
            this.run("CREATE INDEX idxB ON test(b)");
            this.run("INSERT INTO test VALUES(1, 'one', 11), (2, 'two', 22), (3, 'three', 33)");
            List<List<?>> res = this.run("SELECT * FROM test WHERE b > 0 ORDER BY b");
            H2DynamicColumnsAbstractBasicSelfTest.assertEquals((int)3, (int)res.size());
            H2DynamicColumnsAbstractBasicSelfTest.assertEquals((int)3, (int)res.get(0).size());
            this.run("ALTER TABLE test DROP COLUMN a");
            res = this.run("SELECT * FROM test WHERE b > 0 ORDER BY b");
            H2DynamicColumnsAbstractBasicSelfTest.assertEquals((int)3, (int)res.size());
            H2DynamicColumnsAbstractBasicSelfTest.assertEquals((int)2, (int)res.get(0).size());
            H2DynamicColumnsAbstractBasicSelfTest.assertEquals((Object)1, res.get(0).get(0));
            H2DynamicColumnsAbstractBasicSelfTest.assertEquals((Object)11, res.get(0).get(1));
        }
        finally {
            this.run("DROP TABLE IF EXISTS test");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDropColumnPriorToCompoundPkIndex() throws Exception {
        try {
            this.run("CREATE TABLE test (a INT, b INT, id1 INT, id2 INT, PRIMARY KEY (id1, id2))");
            this.run("INSERT INTO test (a, b, id1, id2) VALUES (1, 2, 3, 4)");
            String qry = "SELECT a, id1, id2 FROM test WHERE id1 = 3 AND id2 = 4";
            List<List<?>> resBefore = this.run(qry);
            Assert.assertEquals((long)1L, (long)resBefore.size());
            this.run("ALTER TABLE test DROP COLUMN b");
            this.run("SELECT * FROM test WHERE id1 = 3 AND id2 = 4");
            List<List<?>> resAfter = this.run(qry);
            Assert.assertEquals((long)1L, (long)resAfter.size());
            Assert.assertEquals(resBefore, resAfter);
            String plan = (String)this.run("EXPLAIN SELECT * FROM test WHERE id1 = 3 AND id2 = 4").get(0).get(0);
            String pkIdxName = "PUBLIC._key_PK";
            Assert.assertTrue((String)("Query plan does not contain index '" + pkIdxName + "': plan=" + plan), (boolean)plan.contains(pkIdxName));
        }
        finally {
            this.run("DROP TABLE IF EXISTS test");
        }
    }

    private void doTestAlterTableOnFlatValue(String tblName) {
        this.assertThrows("ALTER TABLE " + tblName + " ADD COLUMN y varchar", "Cannot add column(s) because table was created with WRAP_VALUE=false option.");
    }

    protected abstract int nodeIndex();

    protected void assertThrows(String sql, String msg) {
        this.assertThrows((Ignite)this.grid(this.nodeIndex()), sql, msg);
    }

    protected void assertThrowsAnyCause(String sql, Class<? extends Throwable> cls, String msg) {
        this.assertThrowsAnyCause((Ignite)this.grid(this.nodeIndex()), sql, cls, msg);
    }

    protected List<List<?>> run(String sql) {
        return this.run((Ignite)this.grid(this.nodeIndex()), sql);
    }

    private static final class GuidTest {
        @QuerySqlField
        private int id;
        private UUID guid;
        private byte[] data;

        public GuidTest(int id, UUID guid, byte[] data) {
            this.id = id;
            this.guid = guid;
            this.data = data;
        }

        public int id() {
            return this.id;
        }

        public UUID guid() {
            return this.guid;
        }

        public byte[] data() {
            return this.data;
        }
    }

    private static final class City {
        @QuerySqlField
        private int id;
        @QuerySqlField
        private String name;
        @QuerySqlField(name="state_name")
        private String state;

        private City() {
        }

        public int id() {
            return this.id;
        }

        public void id(int id) {
            this.id = id;
        }

        public String name() {
            return this.name;
        }

        public void name(String name) {
            this.name = name;
        }

        public String state() {
            return this.state;
        }

        public void state(String state) {
            this.state = state;
        }
    }
}

