/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.index;

import java.util.List;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.AffinityKeyMapped;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.client.Person;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.cache.index.AbstractRebuildIndexTest;
import org.apache.ignite.internal.processors.cache.index.IgniteH2IndexingEx;
import org.apache.ignite.internal.processors.query.h2.database.H2TreeIndex;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.testframework.GridTestUtils;
import org.gridgain.internal.h2.message.DbException;
import org.jetbrains.annotations.Nullable;
import org.junit.Ignore;
import org.junit.Test;

public class AffinityIndexShadowingTest
extends AbstractRebuildIndexTest {
    @Override
    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        return super.getConfiguration(igniteInstanceName).setCacheConfiguration(new CacheConfiguration[]{this.cacheConfig("default"), this.cacheConfig("default2")});
    }

    private CacheConfiguration<Object, Object> cacheConfig(String cacheName) {
        return new CacheConfiguration(cacheName).setGroupName("GRP").setIndexedTypes(new Class[]{PersonKey.class, Person.class}).setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 1));
    }

    @Ignore(value="https://ggsystems.atlassian.net/browse/GG-34628")
    @Test
    public void testAffinityIndexShadowing() throws Exception {
        String cacheName = "default";
        int cacheSize = 1000;
        IgniteH2IndexingEx.prepareBeforeNodeStart();
        IgniteEx n = this.startGrid(0);
        this.populateCache((IgniteCache<PersonKey, Person>)n.cache("default"), 1000);
        AffinityIndexShadowingTest.assertNotNull((Object)this.index(n, (IgniteCache<Integer, Person>)n.cache("default"), "AFFINITY_KEY"));
        String idxName = "IDX0";
        this.createIdxAsync((IgniteCache<Integer, Person>)n.cache("default"), idxName).get();
        AffinityIndexShadowingTest.assertNotNull((Object)this.index(n, (IgniteCache<Integer, Person>)n.cache("default"), "AFFINITY_KEY"));
        AffinityIndexShadowingTest.assertNotNull((Object)this.index(n, (IgniteCache<Integer, Person>)n.cache("default"), idxName));
        AffinityIndexShadowingTest.assertEquals((int)1000, (int)this.selectPersonByName((IgniteCache<Integer, Person>)n.cache("default")).size());
        this.stopGrid(0);
        n = this.startGrid(0);
        n.cache("default").clear();
        this.populateCache((IgniteCache<PersonKey, Person>)n.cache("default"), 1000);
        AffinityIndexShadowingTest.assertNull((Object)this.index(n, (IgniteCache<Integer, Person>)n.cache("default"), "AFFINITY_KEY"));
        AffinityIndexShadowingTest.assertNotNull((Object)this.index(n, (IgniteCache<Integer, Person>)n.cache("default"), idxName));
        this.dropIdx((IgniteCache<Integer, Person>)n.cache("default"), idxName);
        AffinityIndexShadowingTest.assertNull((Object)this.index(n, (IgniteCache<Integer, Person>)n.cache("default"), "AFFINITY_KEY"));
        AffinityIndexShadowingTest.assertNull((Object)this.index(n, (IgniteCache<Integer, Person>)n.cache("default"), idxName));
        AffinityIndexShadowingTest.assertEquals((int)1000, (int)this.selectPersonByName((IgniteCache<Integer, Person>)n.cache("default")).size());
        this.stopGrid(0);
        n = this.startGrid(0);
        IgniteInternalFuture fut = this.indexRebuildFuture(n, CU.cacheId((String)"default"));
        if (fut != null) {
            fut.get(this.getTestTimeout());
        }
        AffinityIndexShadowingTest.assertNull((Object)this.index(n, (IgniteCache<Integer, Person>)n.cache("default"), idxName));
        AffinityIndexShadowingTest.assertNotNull((Object)this.index(n, (IgniteCache<Integer, Person>)n.cache("default"), "AFFINITY_KEY"));
        AffinityIndexShadowingTest.assertEquals((int)1000, (int)this.selectPersonByName((IgniteCache<Integer, Person>)n.cache("default")).size());
    }

    @Test
    public void testAffinityIndexShadowing2() throws Exception {
        String cacheName = "default";
        int cacheSize = 1000;
        IgniteH2IndexingEx.prepareBeforeNodeStart();
        IgniteEx n = this.startGrid(0);
        this.populateCache((IgniteCache<PersonKey, Person>)n.cache("default"), 1000);
        AffinityIndexShadowingTest.assertNotNull((Object)this.index(n, (IgniteCache<Integer, Person>)n.cache("default"), "AFFINITY_KEY"));
        String idxName = "IDX0";
        this.createIdxAsync((IgniteCache<Integer, Person>)n.cache("default"), idxName).get();
        AffinityIndexShadowingTest.assertNotNull((Object)this.index(n, (IgniteCache<Integer, Person>)n.cache("default"), "AFFINITY_KEY"));
        AffinityIndexShadowingTest.assertNotNull((Object)this.index(n, (IgniteCache<Integer, Person>)n.cache("default"), idxName));
        AffinityIndexShadowingTest.assertEquals((int)1000, (int)this.selectPersonByName((IgniteCache<Integer, Person>)n.cache("default")).size());
        this.stopGrid(0);
        n = this.startGrid(0);
        AffinityIndexShadowingTest.assertEquals((int)1000, (int)this.selectPersonByName((IgniteCache<Integer, Person>)n.cache("default")).size());
        this.populateCache((IgniteCache<PersonKey, Person>)n.cache("default"), 1000);
        AffinityIndexShadowingTest.assertNull((Object)this.index(n, (IgniteCache<Integer, Person>)n.cache("default"), "AFFINITY_KEY"));
        AffinityIndexShadowingTest.assertNotNull((Object)this.index(n, (IgniteCache<Integer, Person>)n.cache("default"), idxName));
        n.destroyCache("default");
        n.createCache(this.cacheConfig("default"));
        this.populateCache((IgniteCache<PersonKey, Person>)n.cache("default"), 1000);
        AffinityIndexShadowingTest.assertNull((Object)this.index(n, (IgniteCache<Integer, Person>)n.cache("default"), idxName));
        AffinityIndexShadowingTest.assertNotNull((Object)this.index(n, (IgniteCache<Integer, Person>)n.cache("default"), "AFFINITY_KEY"));
        AffinityIndexShadowingTest.assertEquals((int)1000, (int)this.selectPersonByName((IgniteCache<Integer, Person>)n.cache("default")).size());
    }

    private List<List<?>> selectPersonByName(IgniteCache<Integer, Person> cache) {
        return cache.query(new SqlFieldsQuery("SELECT * FROM Person where affId >= 0;")).getAll();
    }

    private IgniteInternalFuture<List<List<?>>> createIdxAsync(IgniteCache<Integer, Person> cache, String idxName) {
        return GridTestUtils.runAsync(() -> {
            String sql = "CREATE INDEX " + idxName + " ON Person(affId)";
            return cache.query(new SqlFieldsQuery(sql)).getAll();
        });
    }

    private List<List<?>> dropIdx(IgniteCache<Integer, Person> cache, String idxName) {
        return cache.query(new SqlFieldsQuery("DROP INDEX " + idxName)).getAll();
    }

    @Override
    @Nullable
    protected H2TreeIndex index(IgniteEx n, IgniteCache<Integer, Person> cache, String idxName) {
        try {
            return super.index(n, cache, idxName);
        }
        catch (DbException e) {
            return null;
        }
    }

    private void populateCache(IgniteCache<PersonKey, Person> cache, int cnt) {
        for (int i = 0; i < cnt; ++i) {
            cache.put((Object)new PersonKey(i * 2, i), (Object)new Person(Integer.valueOf(i), "name_" + i));
        }
    }

    static class PersonKey {
        @QuerySqlField
        long keyId;
        @AffinityKeyMapped
        @QuerySqlField
        long affId;

        PersonKey(long keyId, long affId) {
            this.keyId = keyId;
            this.affId = affId;
        }
    }
}

