/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.failure.FailureHandler;
import org.apache.ignite.failure.FailureType;
import org.apache.ignite.failure.TestFailureHandler;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;
import org.mockito.Mockito;

public class ReservationsOnDoneAfterTopologyUnlockFailTest
extends GridCommonAbstractTest {
    @Test
    public void testFailureHandlerTriggeredOnTopologyUnlockError() throws Exception {
        TestFailureHandler hnd = new TestFailureHandler(false);
        IgniteEx grid0 = this.startGrid(this.getConfiguration(this.testNodeName(0)).setFailureHandler((FailureHandler)hnd));
        ExecutorService mockMgmtExecSvc = (ExecutorService)Mockito.spy((Object)grid0.context().pools().getManagementExecutorService());
        ((ExecutorService)Mockito.doAnswer(invocationOnMock -> {
            Arrays.stream(Thread.currentThread().getStackTrace()).map(StackTraceElement::getMethodName).filter("onDoneAfterTopologyUnlock"::equals).findAny().ifPresent(m -> {
                throw new OutOfMemoryError();
            });
            return invocationOnMock.callRealMethod();
        }).when((Object)mockMgmtExecSvc)).execute((Runnable)Mockito.any(Runnable.class));
        GridTestUtils.setFieldValue((Object)this.grid(0).context().pools(), (String)"mgmtExecSvc", (Object)mockMgmtExecSvc);
        grid0.getOrCreateCache(new CacheConfiguration().setName("default")).put((Object)1, (Object)1);
        this.startGrid(this.getConfiguration(this.testNodeName(1)).setFailureHandler((FailureHandler)hnd));
        hnd.awaitFailure(3000L);
        ReservationsOnDoneAfterTopologyUnlockFailTest.assertNotNull((String)"Failure handler hasn't been triggered.", (Object)hnd.failureContext());
        ReservationsOnDoneAfterTopologyUnlockFailTest.assertEquals((String)"Failure type must be CRITICAL_ERROR", (Object)hnd.failureContext().type(), (Object)FailureType.CRITICAL_ERROR);
        ReservationsOnDoneAfterTopologyUnlockFailTest.assertTrue((boolean)(hnd.failureContext().error() instanceof OutOfMemoryError));
    }
}

